/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001M\u0011QDU3m)&lW-\u00138eS\u000e\fGo\u001c:D_:4XM\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\ruKN$8+[7qY\u0016l\u0015\r^3sS\u0006d\u0017N_1uS>tG#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u0011\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0003UKN$\b\"\u0002\u001f\u0001\t\u0003I\u0013!\u0004;fgR\u001cV\r\\3di\u0006cG\u000e\u000b\u0002<c!)q\b\u0001C\u0001S\u00051B/Z:u\r&dG/\u001a:j]\u001e|eNU8xi&lW\r\u000b\u0002?c!)!\t\u0001C\u0001S\u0005)B/Z:u\u000fJ|W\u000f]5oO>s'k\\<uS6,\u0007FA!2\u0011\u0015)\u0005\u0001\"\u0001*\u0003a!Xm\u001d;BO\u001e\u0014XmZ1uS>twJ\u001c*poRLW.\u001a\u0015\u0003\tFBQ\u0001\u0013\u0001\u0005\u0002%\na\u0003^3ti\u001e\u0013x.\u001e9j]\u001e|e\u000e\u0015:pGRLW.\u001a\u0015\u0003\u000fFBQa\u0013\u0001\u0005\u0002%\n\u0011\u0004^3ti\u0006;wM]3hCRLwN\\(o!J|7\r^5nK\"\u0012!*\r\u0005\u0006\u001d\u0002!\t!K\u0001\u0012i\u0016\u001cH\u000fV1cY\u00164UO\\2uS>t\u0007FA'2\u0011\u0015\t\u0006\u0001\"\u0001*\u0003%!Xm\u001d;V]&|g\u000e\u000b\u0002Qc!)A\u000b\u0001C\u0001S\u0005QA/Z:u/&tGm\\<)\u0005M\u000b\u0004\"B,\u0001\t\u0003I\u0013a\u0003;fgR<\u0016N\u001c3poJB#AV\u0019\t\u000bi\u0003A\u0011A\u0015\u0002\u001fQ,7\u000f^'vYRLw+\u001b8e_^D#!W\u0019\t\u000bu\u0003A\u0011A\u0015\u0002EQ,7\u000f^,j]\u0012|woV5uQ\u0006;wM]3hCRLwN\\(o%><H/[7fQ\ta\u0016\u0007C\u0003a\u0001\u0011\u0005\u0011&\u0001\u0017uKN$x+\u001b8e_^<\u0016\u000e\u001e5BO\u001e\u0014XmZ1uS>twJ\u001c*poRLW.Z,ji\"D\u0015M^5oO\"\u0012q,\r\u0005\u0006G\u0002!\t!K\u0001-i\u0016\u001cHoS3faB\u0013xnY3tgRKW.Z!uiJ\fe\r^3s'V\u0014wI]1qQ>\u0003H/[7ju\u0016D#AY\u0019\b\u000b\u0019\u0014\u0001\u0012A4\u0002;I+G\u000eV5nK&sG-[2bi>\u00148i\u001c8wKJ$XM\u001d+fgR\u0004\"A\b5\u0007\u000b\u0005\u0011\u0001\u0012A5\u0014\u0005!T\u0007CA\u0016l\u0013\taGF\u0001\u0004B]f\u0014VM\u001a\u0005\u00067!$\tA\u001c\u000b\u0002O\u001a!\u0001\u000f\u001b\u0001r\u0005%!\u0016M\u00197f\rVt7m\u0005\u0002peB\u00191O\u001e=\u000e\u0003QT!!\u001e\u0006\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018BA<u\u00055!\u0016M\u00197f\rVt7\r^5p]B\u0019\u00110!\u0001\u000f\u0005it\bCA>-\u001b\u0005a(BA?\u0013\u0003\u0019a$o\\8u}%\u0011q\u0010L\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}d\u0003BB\u000ep\t\u0003\tI\u0001\u0006\u0002\u0002\fA\u0019\u0011QB8\u000e\u0003!D\u0011\"!\u0005p\u0005\u0004%\t!a\u0005\u0002\u0003Q,\"!!\u0006\u0011\t\u0005]\u0011qD\u0007\u0003\u00033Q1aAA\u000e\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u00033\u0011\u0011\u0002V5nKN$\u0018-\u001c9\t\u0011\u0005\u0015r\u000e)A\u0005\u0003+\t!\u0001\u001e\u0011\t\u000f\u0005%r\u000e\"\u0001\u0002,\u0005!QM^1m)\u001dQ\u0013QFA\u001f\u0003\u0003B\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\u0006i&lW-\r\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0006\u0002\t\u0011\fG/Y\u0005\u0005\u0003w\t)DA\u0007US6,7\u000f^1na\u0012\u000bG/\u0019\u0005\t\u0003\u007f\t9\u00031\u0001\u0002\u0016\u0005)A/[7fe!9\u00111IA\u0014\u0001\u0004A\u0018AB:ue&tw\r\u000b\u0005\u0002(\u0005\u001d\u00131KA+!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u00131\n\u0002\r\rVt7\r^5p]\"Kg\u000e^\u0001\u0006S:\u0004X\u000f\u001e\u0017\u0007\u0003/\nI'!\u001d,\u0015\u0005e\u0013qLA1\u0003K\n9\u0007\u0005\u0003\u0002J\u0005m\u0013\u0002BA/\u0003\u0017\u0012A\u0002R1uCRK\b/\u001a%j]R\fQA^1mk\u0016\f#!a\u0019\u0002\u0019QKU*R*U\u00036\u0003\u0006fM\u0015\u0002\u0013\t\u0014\u0018\u000eZ4fIR{7EAA\u0019W)\tI&a\u0018\u0002l\u0005\u0015\u0014qN\u0011\u0003\u0003[\n\u0001\u0003V%N\u000bN#\u0016)\u0014)`\u0019RS\u0006fM\u0015$\u0005\u0005U1FBA-\u0003?\n\u0019(\t\u0002\u0002v\u000511\u000b\u0016*J\u001d\u001e\u0003")
public class RelTimeIndicatorConverterTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSimpleMaterialization() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime FROM\n        |    (SELECT FLOOR(rowtime TO DAY) AS rowtime, long FROM MyTable WHERE long > 0) t\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSelectAll() {
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testFilteringOnRowtime() {
        String sqlQuery = "SELECT rowtime FROM MyTable1 WHERE rowtime > CAST('1990-12-02 12:11:11' AS TIMESTAMP(3))";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingOnRowtime() {
        this.util().verifyExecPlan("SELECT COUNT(long) FROM MyTable GROUP BY rowtime");
    }

    @Test
    public void testAggregationOnRowtime() {
        this.util().verifyExecPlan("SELECT MIN(rowtime) FROM MyTable1 GROUP BY long");
    }

    @Test
    public void testGroupingOnProctime() {
        this.util().verifyExecPlan("SELECT COUNT(long) FROM MyTable2 GROUP BY proctime");
    }

    @Test
    public void testAggregationOnProctime() {
        this.util().verifyExecPlan("SELECT MIN(proctime) FROM MyTable2 GROUP BY long");
    }

    @Test
    public void testTableFunction() {
        this.util().addTemporarySystemFunction("tableFunc", (UserDefinedFunction)new TableFunc());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, proctime, s\n        |FROM MyTable, LATERAL TABLE(tableFunc(rowtime, proctime, '')) AS T(s)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testUnion() {
        this.util().verifyExecPlan("SELECT rowtime FROM MyTable1 UNION ALL SELECT rowtime FROM MyTable1");
    }

    @Test
    public void testWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '10' SECOND),\n        |    long,\n        |    SUM(`int`)\n        |FROM MyTable1\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '10' SECOND), long\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindow2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.1' SECOND) AS `rowtime`,\n        |    `long`,\n        |   SUM(`int`)\n        |FROM MyTable1\n        |   GROUP BY `long`, TUMBLE(rowtime, INTERVAL '0.1' SECOND)\n        |\n        ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(newrowtime, INTERVAL '30' SECOND), long, sum(`int`) FROM (\n        |    SELECT\n        |        TUMBLE_ROWTIME(rowtime, INTERVAL '10' SECOND) AS newrowtime,\n        |        long,\n        |        sum(`int`) as `int`\n        |    FROM MyTable1\n        |        GROUP BY TUMBLE(rowtime, INTERVAL '10' SECOND), long\n        |) t GROUP BY TUMBLE(newrowtime, INTERVAL '30' SECOND), long\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWithAggregationOnRowtime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(rowtime), long FROM MyTable1\n        |GROUP BY long, TUMBLE(rowtime, INTERVAL '0.1' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWithAggregationOnRowtimeWithHaving() {
        String result = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(rowtime), long FROM MyTable1\n        |GROUP BY long, TUMBLE(rowtime, INTERVAL '1' SECOND)\n        |HAVING QUARTER(TUMBLE_END(rowtime, INTERVAL '1' SECOND)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(result);
    }

    @Test
    public void testKeepProcessTimeAttrAfterSubGraphOptimize() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    long,\n        |    SUM(`int`)\n        |FROM MyTable2\n        |    GROUP BY TUMBLE(proctime, INTERVAL '10' SECOND), long\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sql);
        AppendStreamTableSink<Row> appendSink1 = this.util().createAppendTableSink((String[])((Object[])new String[]{"long", "sum"}), (LogicalType[])((Object[])new LogicalType[]{new BigIntType(), new BigIntType()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink1", appendSink1);
        stmtSet.addInsert("appendSink1", table);
        AppendStreamTableSink<Row> appendSink2 = this.util().createAppendTableSink((String[])((Object[])new String[]{"long", "sum"}), (LogicalType[])((Object[])new LogicalType[]{new BigIntType(), new BigIntType()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink2", appendSink2);
        stmtSet.addInsert("appendSink2", table);
        this.util().verifyExecPlan(stmtSet);
    }

    public RelTimeIndicatorConverterTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJI.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    public static class TableFunc
    extends TableFunction<String> {
        private final Timestamp t = new Timestamp(0L);

        public Timestamp t() {
            return this.t;
        }

        @FunctionHint(input={@DataTypeHint(value="TIMESTAMP(3)", bridgedTo=TimestampData.class), @DataTypeHint(value="TIMESTAMP_LTZ(3)", bridgedTo=Timestamp.class), @DataTypeHint(value="STRING")})
        public void eval(TimestampData time1, Timestamp time2, String string) {
            this.collect(new StringBuilder(0).append(time1.toString()).append(time2.after(this.t())).append(string).toString());
        }
    }
}

