/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001M\u0011Q\u0002V1cY\u0016\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQ\u0005^3ti&s7/\u001a:u/&$\b\u000eV1sO\u0016$8i\u001c7v[:\u001c\u0018I\u001c3Tc2D\u0015N\u001c;\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eej\u0011a\r\u0006\u0003iU\n1!\u00199j\u0015\t1t'A\u0004kkBLG/\u001a:\u000b\u0005a\u0002\u0012!\u00026v]&$\u0018B\u0001\u001e4\u0005\u0011!Vm\u001d;\t\u000bq\u0002A\u0011A\u0015\u0002EQ,7\u000f^%og\u0016\u0014H/T5t[\u0006$8\r\u001b+za\u00164uN]#naRL8\t[1sQ\tY\u0014\u0007C\u0003@\u0001\u0011\u0005\u0011&\u0001\u000euKN$X\t_2faRLwN\u001c$pe\u0006\u0003\b/\u001a8e'&t7\u000e\u000b\u0002?c!)!\t\u0001C\u0001S\u0005iB/Z:u\u000bb\u001cW\r\u001d;j_:4uN](wKJ\fum\u001a:fO\u0006$X\r\u000b\u0002Bc!)Q\t\u0001C\u0001S\u0005qA/Z:u\u0003B\u0004XM\u001c3TS:\\\u0007F\u0001#2\u0011\u0015A\u0005\u0001\"\u0001*\u0003A!Xm\u001d;SKR\u0014\u0018m\u0019;TS:\\\u0017\u0007\u000b\u0002Hc!)1\n\u0001C\u0001S\u0005\u0001B/Z:u%\u0016$(/Y2u'&t7N\r\u0015\u0003\u0015FBQA\u0014\u0001\u0005\u0002%\na\u0002^3tiV\u00038/\u001a:u'&t7\u000e\u000b\u0002Nc!)\u0011\u000b\u0001C\u0001S\u0005AB/Z:u+B\u001cXM\u001d;TS:\\w+\u001b;i\r&dG/\u001a:)\u0005A\u000b\u0004\"\u0002+\u0001\t\u0003I\u0013\u0001\u0007;fgR\u0014V\r\u001e:bGR\fe\u000eZ+qg\u0016\u0014HoU5oW\"\u00121+\r\u0005\u0006/\u0002!\t!K\u0001\u001fi\u0016\u001cH/\u00119qK:$W\u000b]:feR\fe\u000e\u001a*fiJ\f7\r^*j].D#AV\u0019\t\u000bi\u0003A\u0011A\u0015\u0002YQ,7\u000f^#yG\u0016\u0004H/[8o\r>\u0014xK]5uS:<g+\u001b:uk\u0006dW*\u001a;bI\u0006$\u0018mQ8mk6t\u0007FA-2\u0011\u0015i\u0006\u0001\"\u0001*\u00031\"Xm\u001d;Fq\u000e,\u0007\u000f^5p]\u001a{'o\u0016:ji&tw-\u00138wC2LG-T3uC\u0012\fG/Y\"pYVlg\u000e\u000b\u0002]c!)\u0001\r\u0001C\u0001S\u0005\u0011B/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G.^7oQ\ty\u0016\u0007C\u0003d\u0001\u0011\u0005\u0011&A\u0019uKN$X*\u001a;bI\u0006$\u0018mQ8mk6tG\u000b[1u\u0007>tg\r\\5diN<\u0016\u000e\u001e5QQf\u001c\u0018nY1m\u0007>dW/\u001c8)\u0005\t\f\u0004\"\u00024\u0001\t\u0003I\u0013!\t;fgR\u001c\u0016N\\6ESN|'\u000fZ3s\u0007\"\fgnZ3M_\u001e<\u0016\u000e\u001e5K_&t\u0007FA32\u0011\u0015I\u0007\u0001\"\u0001*\u0003\u0005\"Xm\u001d;TS:\\G)[:pe\u0012,'o\u00115b]\u001e,Gj\\4XSRD'+\u00198lQ\tA\u0017\u0007C\u0003m\u0001\u0011\u0005\u0011&A\u0013uKN$\u0018\t\u001d9f]\u0012\u001cFO]3b[R{7+\u001b8l/&$\b\u000eU6BkR|7*Z=Cs\"\u00121.\r\u0005\u0006_\u0002!\t!K\u0001$i\u0016\u001cH/\u00119qK:$7\u000b\u001e:fC6$vnU5oW^KG\u000f\u001b)l\u001d>\\U-\u001f\"zQ\tq\u0017\u0007C\u0003s\u0001\u0011\u0005\u0011&\u0001\u0014uKN$\u0018\t\u001d9f]\u0012\u001cFO]3b[R{7+\u001b8l/&$\b\u000eU6G_J\u001cWmS3z\u0005fD#!]\u0019\t\u000bU\u0004A\u0011A\u0015\u0002oQ,7\u000f^*j]\u001edW\rU1sC2dW\r\\5t[\u0006\u0003\b/\u001a8e'R\u0014X-Y7U_NKgn[,ji\"\u00046NR8sG\u0016\\U-\u001f\"zQ\t!\u0018\u0007C\u0003y\u0001\u0011\u0005\u0011&A\u0015uKN$\u0018\t\u001d9f]\u0012\u001cFO]3b[R{7+\u001b8l/&$\bn\\;u!.4uN]2f\u0017\u0016L()\u001f\u0015\u0003oFBQa\u001f\u0001\u0005\u0002%\n!\b^3ti\u0006\u0003\b/\u001a8e'R\u0014X-Y7U_NKgn[,ji\"|W\u000f\u001e)l\r>\u00148-Z&fs\nK8+\u001b8hY\u0016\u0004\u0016M]1mY\u0016d\u0017n]7)\u0005i\f\u0004\"\u0002@\u0001\t\u0003I\u0013a\r;fgR\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lGk\\*j].<\u0016\u000e\u001e5QW\u0012KgMZ3sK:$\b+\u0019:bY2,G.[:nQ\ti\u0018\u0007\u0003\u0004\u0002\u0004\u0001!\t!K\u00011i\u0016\u001cHo\u00115b]\u001e,Gn\\4TiJ,\u0017-\u001c+p'&t7nV5uQB[7+\u001b8hY\u0016\u0004\u0016M]1mY\u0016d\u0017n]7)\u0007\u0005\u0005\u0011\u0007\u0003\u0004\u0002\n\u0001!\t!K\u0001-i\u0016\u001cH/T1oC\u001e,G\rV1cY\u0016\u001c\u0016N\\6XSRDG)[:bE2,7\t[3dWB|\u0017N\u001c;j]\u001eD3!a\u00022\u0011\u0019\ty\u0001\u0001C\u0001S\u0005YC/Z:u\u001b\u0006t\u0017mZ3e)\u0006\u0014G.Z*j].<\u0016\u000e\u001e5F]\u0006\u0014G.Z\"iK\u000e\\\u0007o\\5oi&tw\rK\u0002\u0002\u000eEBa!!\u0006\u0001\t\u0003I\u0013\u0001\u0006;fgRLen]3siB\u000b'\u000f^\"pYVlg\u000eK\u0002\u0002\u0014EBa!a\u0007\u0001\t\u0003I\u0013a\u0006;fgR\u001c%/Z1uKR\u000b'\r\\3BgN+G.Z2uQ\r\tI\"\r")
public class TableSinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testInsertWithTargetColumnsAndSqlHint() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT,\n                     |  `b` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink /*+ OPTIONS('sink.parallelism' = '1') */(a, b) SELECT a + b, c FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInsertMismatchTypeForEmptyChar() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE my_sink (\n                     |  name STRING,\n                     |  email STRING,\n                     |  message_offset BIGINT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlanInsert("INSERT INTO my_sink SELECT a, '', '' FROM MyTable")).hasMessageContaining("Query schema: [a: INT, EXPR$1: CHAR(0) NOT NULL, EXPR$2: CHAR(0) NOT NULL]\nSink schema:  [name: STRING, email: STRING, message_offset: BIGINT]") instanceof ValidationException;
    }

    @Test
    public void testExceptionForAppendSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).hasMessageContaining("Table sink 'default_catalog.default_database.appendSink' doesn't support consuming update changes which is produced by node GroupAggregate(groupBy=[a], select=[a, COUNT(*) AS cnt])") instanceof TableException;
    }

    @Test
    public void testExceptionForOverAggregate() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink1 (\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink2 (\n                     |  `cnt` BIGINT,\n                     |  `total` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink1 SELECT * FROM TempTable");
        stmtSet.addInsertSql("INSERT INTO retractSink2 SELECT cnt, SUM(cnt) OVER (ORDER BY PROCTIME()) FROM TempTable");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).hasMessageContaining("OverAggregate doesn't support consuming update changes which is produced by node Calc(select=[cnt])") instanceof TableException;
    }

    @Test
    public void testAppendSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT,\n                     |  `b` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT a + b, c FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink1() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink2() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `cnt` BIGINT,\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO retractSink\n        |SELECT cnt, COUNT(a) AS a FROM (\n        |    SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a) t\n        |GROUP BY cnt\n      ")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(dml);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSinkWithFilter() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO upsertSink\n        |SELECT *\n        |FROM (SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a)\n        |WHERE cnt < 10\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractAndUpsertSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `b` BIGINT,\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `b` BIGINT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (b) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT b, COUNT(a) AS cnt FROM MyTable GROUP BY b");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT b, cnt FROM TempTable WHERE b < 4");
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT b, cnt FROM TempTable WHERE b >= 4 AND b < 6");
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT cnt, COUNT(b) AS frequency FROM TempTable WHERE b < 4 GROUP BY cnt");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testAppendUpsertAndRetractSink() {
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT a, b FROM MyTable UNION ALL SELECT d, e FROM MyTable2");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT * FROM TempTable");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `total_sum` INT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a, b FROM TempTable UNION ALL SELECT i, j FROM MyTable3");
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT SUM(a) AS total_sum FROM TempTable1");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `total_min` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT a, MIN(b) AS total_min FROM TempTable1 GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testExceptionForWritingVirtualMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MetadataTable (\n         |  `a` INT,\n         |  `m_3` INT METADATA FROM 'metadata_3' VIRTUAL,\n         |  `m_2` INT METADATA FROM 'metadata_2',\n         |  `b` BIGINT,\n         |  `c` INT,\n         |  `metadata_1` STRING METADATA\n         |) WITH (\n         |  'connector' = 'values',\n         |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT, metadata_3:BIGINT',\n         |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n         |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT *\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet)).hasMessageContaining("Query schema: [a: INT, m_3: INT, m_2: INT, b: BIGINT, c: INT, metadata_1: STRING]\nSink schema:  [a: INT, m_2: INT, b: BIGINT, c: INT, metadata_1: STRING]") instanceof ValidationException;
    }

    @Test
    public void testExceptionForWritingInvalidMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE MetadataTable (\n                     |  `a` INT,\n                     |  `metadata_1` TIMESTAMP(3) METADATA\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'writable-metadata' = 'metadata_1:BOOLEAN'\n                     |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT TIMESTAMP '1990-10-14 06:00:00.000'\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet)).hasMessageContaining("Invalid data type for metadata column 'metadata_1' of table 'default_catalog.default_database.MetadataTable'. The column cannot be declared as 'TIMESTAMP(3)' because the type must be castable to metadata type 'BOOLEAN'.") instanceof ValidationException;
    }

    @Test
    public void testMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MetadataTable (\n         |  `a` INT,\n         |  `m_3` INT METADATA FROM 'metadata_3' VIRTUAL,\n         |  `m_2` INT METADATA FROM 'metadata_2',\n         |  `b` BIGINT,\n         |  `c` INT,\n         |  `metadata_1` STRING METADATA\n         |) WITH (\n         |  'connector' = 'values',\n         |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT, metadata_3:BIGINT',\n         |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n         |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT `a`, `m_2`, `b`, `c`, `metadata_1`\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testMetadataColumnThatConflictsWithPhysicalColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE MetadataTable (\n                     |  `metadata_1` DOUBLE,\n                     |  `m_1` STRING METADATA FROM 'metadata_1' VIRTUAL,\n                     |  `m_2` BIGINT METADATA FROM 'metadata_2',\n                     |  `metadata_2` DOUBLE,\n                     |  `other` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT',\n                     |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n                     |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT `metadata_1`, `m_2`, `metadata_2`, `other`\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testSinkDisorderChangeLogWithJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE SinkJoinChangeLog (\n                               |  person STRING, votes BIGINT, prize DOUBLE,\n                               |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                               |  'connector' = 'values',\n                               |  'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkJoinChangeLog\n        |SELECT T.person, T.sum_votes, award.prize FROM\n        |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T, award\n        |   WHERE T.sum_votes = award.votes\n        |")).stripMargin());
    }

    @Test
    public void testSinkDisorderChangeLogWithRank() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE SinkRankChangeLog (\n                               |  person STRING, votes BIGINT,\n                               |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                               |  'connector' = 'values',\n                               |  'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkRankChangeLog\n        |SELECT person, sum_votes FROM\n        | (SELECT person, sum_votes,\n        |   ROW_NUMBER() OVER (PARTITION BY vote_section ORDER BY sum_votes DESC) AS rank_number\n        |   FROM (SELECT person, SUM(votes) AS sum_votes, SUM(votes) / 2 AS vote_section FROM src\n        |      GROUP BY person))\n        |   WHERE rank_number < 10\n        |")).stripMargin());
    }

    @Test
    public void testAppendStreamToSinkWithPkAutoKeyBy() {
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '9'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithPkNoKeyBy() {
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.NONE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '9'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '4'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testSingleParallelismAppendStreamToSinkWithPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(1);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithoutPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '4'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithoutPkForceKeyBySingleParallelism() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testChangelogStreamToSinkWithPkDifferentParallelism() {
        this.util().getStreamEnv().setParallelism(1);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.AUTO);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I,UB,UA,D'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '2'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testChangelogStreamToSinkWithPkSingleParallelism() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar,\n                      | ts bigint\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | ts bigint,\n                      | rn bigint,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                            |insert into sink\n                            |select * from (\n                            |  select *, row_number() over (partition by id order by ts desc) rn\n                            |  from source\n                            |) where rn=1")).stripMargin());
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testManagedTableSinkWithDisableCheckpointing() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT,\n                     |  `c` STRING\n                     |) WITH(\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT * FROM MyTable");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyAstPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).hasMessageContaining(new StringBuilder(193).append("You should enable the checkpointing for sinking to managed table ").append("'default_catalog.default_database.sink', ").append("managed table relies on checkpoint to commit and ").append("the data is visible only after commit.").toString()) instanceof TableException;
    }

    @Test
    public void testManagedTableSinkWithEnableCheckpointing() {
        this.util().getStreamEnv().enableCheckpointing(10L);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT,\n                     |  `c` STRING\n                     |) WITH(\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT * FROM MyTable");
        this.util().verifyAstPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInsertPartColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE zm_test (\n                     |  `a` BIGINT,\n                     |  `m1` MAP<STRING, BIGINT>,\n                     |  `m2` MAP<STRING NOT NULL, BIGINT>,\n                     |  `m3` MAP<STRING, BIGINT NOT NULL>,\n                     |  `m4` MAP<STRING NOT NULL, BIGINT NOT NULL>\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO zm_test(`a`) SELECT `a` FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testCreateTableAsSelect() {
        Assertions.assertThatThrownBy(() -> this.util().tableEnv().explainSql("CREATE TABLE zm_ctas_test AS SELECT * FROM MyTable", new ExplainDetail[0])).hasMessageContaining("Unsupported ModifyOperation: org.apache.flink.table.operations.CreateTableASOperation");
    }

    public TableSinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE src (person String, votes BIGINT) WITH(\n                             |  'connector' = 'values'\n                             |)\n                             |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n      |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n      |  'connector' = 'values'\n      |)\n      |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n      |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n      |  'connector' = 'values'\n      |)\n      |")).stripMargin());
    }
}

