/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001'\tyA+\u00192mKN{WO]2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013\u0001\u000b;fgR$\u0016M\u00197f'>,(oY3XSRDG+[7fgR\fW\u000e\u001d*poRKW.\u001a$jK2$G#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u0011\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0003UKN$\b\"\u0002\u001f\u0001\t\u0003I\u0013a\t;fgR$\u0016M\u00197f'>,(oY3XSRD7k\\;sG\u0016<\u0016\r^3s[\u0006\u00148n\u001d\u0015\u0003wEBQa\u0010\u0001\u0005\u0002%\n\u0011\u0005^3tiJ{w\u000fV5nKR\u000b'\r\\3T_V\u00148-Z$s_V\u0004x+\u001b8e_^D#AP\u0019\t\u000b\t\u0003A\u0011A\u0015\u00027Q,7\u000f\u001e)s_\u000e$\u0018.\\3P]^\u000bG/\u001a:nCJ\\7\u000b]3dQ\t\t\u0015\u0007C\u0003F\u0001\u0011\u0005\u0011&A\ruKN$\bK]8kK\u000e$x+\u001b;i_V$(k\\<uS6,\u0007F\u0001#2\u0011\u0015A\u0005\u0001\"\u0001*\u0003i!Xm\u001d;Qe>TWm\u0019;XSRDw.\u001e;Qe>\u001cG/[7fQ\t9\u0015\u0007C\u0003L\u0001\u0011\u0005\u0011&\u0001\fuKN$\bK]8kK\u000e$xJ\u001c7z%><H/[7fQ\tQ\u0015\u0007C\u0003O\u0001\u0011\u0005\u0011&A\tuKN$h*Z:uK\u0012\u0004&o\u001c6fGRD#!T\u0019\t\u000bE\u0003A\u0011A\u0015\u00025Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f^%oaV$(+\u001a4)\u0005A\u000b\u0004\"\u0002+\u0001\t\u0003I\u0013!\b;fgRtUm\u001d;fIB\u0013xN[3di^KG\u000f['fi\u0006$\u0017\r^1)\u0005M\u000b\u0004\"B,\u0001\t\u0003I\u0013a\b;fgRtuNT3ti\u0016$\u0007K]8kK\u000e$x+\u001b;i\u001b\u0016$\u0018\rZ1uC\"\u0012a+\r\u0005\u00065\u0002!IaW\u0001\"i\u0016\u001cHOT3ti\u0016$\u0007K]8kK\u000e$x+\u001b;i\u001b\u0016$\u0018\rZ1uC\n\u000b7/\u001a\u000b\u0003UqCQ!X-A\u0002y\u000b\u0001e];qa>\u0014Ho\u001d(fgR,G\r\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]B\u00111fX\u0005\u0003A2\u0012qAQ8pY\u0016\fg\u000eC\u0003c\u0001\u0011\u0005\u0011&A\ruKN$h*Z:uK\u0012\u0004&o\u001c6fGR<\u0016\u000e\u001e5Ji\u0016l\u0007FA12\u0011\u0015)\u0007\u0001\"\u0003g\u0003\u0011\u0002(/\u001a9be\u0016$E\r\\,ji\"\u0004Vo\u001d5Qe>TWm\u0019;B]\u0012lU\r^1ECR\fGc\u0001\u0016hS\")\u0001\u000e\u001aa\u0001=\u0006\u0011\u0002O]8kK\u000e$\u0018n\u001c8QkNDGi\\<o\u0011\u0015QG\r1\u0001_\u0003%\u0011X-\u00193t\u001b\u0016$\u0018\rC\u0003m\u0001\u0011\u0005\u0011&A\u0012uKN$(+Z1eg6+G/\u0019#bi\u0006<\u0016\u000e\u001e5ES\u001a4WM]3oi>\u0013H-\u001a:)\u0005-\f\u0004\"B8\u0001\t\u0003I\u0013A\u000b;fgR\u0014V-\u00193t\u001b\u0016$\u0018\rR1uC^KG\u000f[8viB\u0013xN[3di&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003]FBQA\u001d\u0001\u0005\u0002%\n\u0001\u0007^3tiJ+\u0017\rZ:D_6\u0004X\u000f^3e\u0007>dW/\u001c8XSRDw.\u001e;Qe>TWm\u0019;j_:\u0004Vo\u001d5E_^t\u0007FA92\u0011\u0015)\b\u0001\"\u0001*\u00035\"Xm\u001d;SK\u0006$7oQ8naV$X\rZ\"pYVlgnV5uQB\u0013xN[3di&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003iFBQ\u0001\u001f\u0001\u0005\u0002%\nq\u0005^3tiJ+\u0017\rZ:NKR\fG)\u0019;b/&$\b\u000e\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]\"\u0012q/\r\u0005\u0006w\u0002!\t!K\u0001\u001bi\u0016\u001cH\u000f\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]>sG.\u001f\u0015\u0003uF\u0002")
public class TableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testTableSourceWithSourceWatermarks() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id INT,\n         |  rowtime TIMESTAMP(3),\n         |  val BIGINT,\n         |  name VARCHAR(32),\n         |  WATERMARK FOR rowtime AS SOURCE_WATERMARK()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true',\n         |  'enable-watermark-push-down' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT name,\n        |    TUMBLE_END(rowtime, INTERVAL '10' MINUTE),\n        |    AVG(val)\n        |FROM rowTimeT WHERE val > 100\n        |   GROUP BY name, TUMBLE(rowtime, INTERVAL '10' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProctimeOnWatermarkSpec() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE procTimeT (\n         |  id int,\n         |  val bigint,\n         |  name varchar(32),\n         |  pTime as PROCTIME(),\n         |  watermark for pTime as pTime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> {
            this.util().tableEnv().executeSql(ddl);
            this.util().verifyExecPlan("SELECT pTime, id, name, val FROM procTimeT");
        }).hasMessageContaining("A watermark can not be defined for a processing-time attribute.") instanceof ValidationException;
    }

    @Test
    public void testProjectWithoutRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT ptime, name, val, id FROM T");
    }

    @Test
    public void testProjectWithoutProctime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("select name, val, rtime, id from T");
    }

    @Test
    public void testProjectOnlyRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rtime FROM T");
    }

    @Test
    public void testNestedProject() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProjectWithoutInputRef() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  name varchar(32)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT COUNT(1) FROM T");
    }

    @Test
    public void testNestedProjectWithMetadata() {
        this.testNestedProjectWithMetadataBase(true);
    }

    @Test
    public void testNoNestedProjectWithMetadata() {
        this.testNestedProjectWithMetadataBase(false);
    }

    private void testNestedProjectWithMetadataBase(boolean supportsNestedProjectionPushDown) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(487).append("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |    nested2 row<num int, flag boolean>>,\n         |  metadata_1 int metadata,\n         |  metadata_2 string metadata\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = '").append(supportsNestedProjectionPushDown).append("',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT'\n         |)\n         |").toString())).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |       deepNested.nested1 AS nested1,\n        |       deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\n        |FROM T\n        |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedProjectWithItem() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE NestedItemTable (\n         |  `id` INT,\n         |  `name` STRING,\n         |  `result` ROW<\n         |     `data_arr` ROW<`value` BIGINT> ARRAY,\n         |     `data_map` MAP<STRING, ROW<`value` BIGINT>>>,\n         |  `extra` STRING\n         |  ) WITH (\n         |    'connector' = 'values',\n         |    'nested-projection-supported' = 'true',\n         |    'bounded' = 'true'\n         |)\n         |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  `result`.`data_arr`[`id`].`value`,\n         |  `result`.`data_map`['item'].`value`\n         |FROM NestedItemTable\n         |")).stripMargin());
    }

    private void prepareDdlWithPushProjectAndMetaData(boolean projectionPushDown, boolean readsMeta) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n         |CREATE TABLE src (\n         |  id int,\n         |  name varchar,\n         |  tags varchar ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  op varchar ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  ts timestamp(3) ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  ts1 as ts + interval '10' second\n         |) WITH (\n         |  'connector' = 'values',\n         |  ").append((Object)(readsMeta ? "'readable-metadata'='tags:varchar,op:varchar,ts:timestamp(3)'," : "")).append("\n         |  'enable-projection-push-down' = '").append(projectionPushDown).append("'\n         |)").toString())).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testReadsMetaDataWithDifferentOrder() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT ts, id, name, tags, op FROM src");
    }

    @Test
    public void testReadsMetaDataWithoutProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT id, ts, tags FROM src");
    }

    @Test
    public void testReadsComputedColumnWithoutProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT id, ts1, op FROM src");
    }

    @Test
    public void testReadsComputedColumnWithProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(true, true);
        this.util().verifyExecPlan("SELECT id, ts1, op FROM src");
    }

    @Test
    public void testReadsMetaDataWithProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(true, true);
        this.util().verifyExecPlan("SELECT id, ts, tags FROM src");
    }

    @Test
    public void testProjectionPushDownOnly() {
        this.prepareDdlWithPushProjectAndMetaData(true, false);
        this.util().verifyExecPlan("SELECT id, ts1, tags FROM src");
    }
}

