/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001'\t)r+\u001b8e_^$U\rZ;qY&\u001c\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nq\u0003^3ti>sw+\u001b8e_^$fKR,ji\"\u001c\u0015\r\\2\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eej\u0011a\r\u0006\u0003iU\n1!\u00199j\u0015\t1t'A\u0004kkBLG/\u001a:\u000b\u0005a\u0002\u0012!\u00026v]&$\u0018B\u0001\u001e4\u0005\u0011!Vm\u001d;\t\u000bq\u0002A\u0011A\u0015\u0002\u001fQ,7\u000f^(o/&tGm\\<U-\u001aC#aO\u0019\t\u000b}\u0002A\u0011A\u0015\u0002CQ,7\u000f^(o/&tGm\\<U-\u001a;\u0016\u000e\u001e5WC2LGmQ8oI&$\u0018n\u001c8)\u0005y\n\u0004\"\u0002\"\u0001\t\u0003I\u0013!\f;fgR4\u0015\r\u001c7cC\u000e\\Gk\\,j]\u0012|w\u000fV8q\u001d\u001a{'/\u00168nCR\u001c\u0007.\u001a3D_:$\u0017\u000e^5p]\"\u0012\u0011)\r\u0005\u0006\u000b\u0002!\t!K\u0001-i\u0016\u001cHOR1mY\n\f7m\u001b+p/&tGm\\<U_Btei\u001c:V]6\fGo\u00195fI>\u0013H-\u001a:LKfD#\u0001R\u0019\t\u000b!\u0003A\u0011A\u0015\u00027Q,7\u000f^(o/&tGm\\<U-\u001a[U-\u001a9GSJ\u001cHOU8xQ\t9\u0015\u0007C\u0003L\u0001\u0011\u0005\u0011&\u0001\u0012uKN$XK\\:vaB|'\u000f^3e/&tGm\\<U-\u001a{e\u000e\u0015:pGRLW.\u001a\u0015\u0003\u0015FBQA\u0014\u0001\u0005\u0002%\na\u0006^3tiVs7/\u001e9q_J$X\rZ,j]\u0012|w\u000f\u0016,G\u001f:\u0004&o\\2uS6,7*Z3q\r&\u00148\u000f\u001e*po\"\u0012Q*\r\u0005\u0006#\u0002!\t!K\u0001/i\u0016\u001cH\u000fV5nK\u0006#HO]5ckR,\u0007K]8qC\u001e\fG/\u001a$pe^Kg\u000eZ8x\t\u0016$W\u000f\u001d7jG\u0006$X\r\u000b\u0002Qc\u0001")
public class WindowDeduplicateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testOnWindowTVFWithCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |   ORDER BY rowtime DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnWindowTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |   ORDER BY rowtime DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnWindowTVFWithValidCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |    ORDER BY rowtime DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum < 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testFallbackToWindowTopNForUnmatchedCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |    ORDER BY rowtime DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum < 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testFallbackToWindowTopNForUnmatchedOrderKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |    ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnWindowTVFKeepFirstRow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |   ORDER BY rowtime ASC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVFOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |   ORDER BY proctime DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window Deduplication is not supported yet.") instanceof TableException;
    }

    @Test
    public void testUnsupportedWindowTVFOnProctimeKeepFirstRow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |   ORDER BY proctime) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window Deduplication is not supported yet.") instanceof TableException;
    }

    @Test
    public void testTimeAttributePropagateForWindowDeduplicate() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp AS\n        |SELECT window_time as rowtime, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end\n        |   ORDER BY rowtime DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 1\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE tmp, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public WindowDeduplicateTest() {
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable (\n                              |  a INT,\n                              |  b BIGINT,\n                              |  c STRING NOT NULL,\n                              |  d DECIMAL(10, 3),\n                              |  e BIGINT,\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
    }
}

