/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001'\t9r+\u001b8e_^$\u0016M\u00197f\rVt7\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0007uKN$H+^7cY\u0016$fK\u0012\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0005Y:\u0014a\u00026va&$XM\u001d\u0006\u0003qA\tQA[;oSRL!AO\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006y\u0001!\t!K\u0001\u0016i\u0016\u001cH\u000fV;nE2,GK\u0016$Qe>\u001cG/[7fQ\tY\u0014\u0007C\u0003@\u0001\u0011\u0005\u0011&\u0001\u0006uKN$\bj\u001c9U-\u001aC#AP\u0019\t\u000b\t\u0003A\u0011A\u0015\u0002%Q,7\u000f\u001e%paR3f\t\u0015:pGRLW.\u001a\u0015\u0003\u0003FBQ!\u0012\u0001\u0005\u0002%\nq\u0002^3ti\u000e+X.\u001e7bi\u0016$fK\u0012\u0015\u0003\tFBQ\u0001\u0013\u0001\u0005\u0002%\nq\u0003^3ti\u000e+X.\u001e7bi\u0016$fK\u0012)s_\u000e$\u0018.\\3)\u0005\u001d\u000b\u0004\"B&\u0001\t\u0003I\u0013\u0001\b;fgR<\u0016N\u001c3po>sgj\u001c8US6,\u0017\t\u001e;sS\n,H/\u001a\u0015\u0003\u0015FBQA\u0014\u0001\u0005\u0002%\n\u0011\u0004^3ti\u000e{gN\u001a7jGRLgn\u001a$jK2$g*Y7fg\"\u0012Q*\r\u0005\u0006#\u0002!\t!K\u0001\u0018i\u0016\u001cH\u000fV;nE2,GK\u0016$XSRDwJ\u001a4tKRD#\u0001U\u0019\t\u000bQ\u0003A\u0011A\u0015\u0002?Q,7\u000f\u001e+v[\ndW\r\u0016,G/&$\bNT3hCRLg/Z(gMN,G\u000f\u000b\u0002Tc!)q\u000b\u0001C\u0001S\u0005aB/Z:u)Vl'\r\\3U-\u001a;\u0016\u000e\u001e5OC6,G\rU1sC6\u001c\bF\u0001,2\u0011\u0015Q\u0006\u0001\"\u0001*\u0003Q!Xm\u001d;I_B$fKR,ji\"|eMZ:fi\"\u0012\u0011,\r\u0005\u0006;\u0002!\t!K\u0001\u001di\u0016\u001cH\u000fS8q)Z3u+\u001b;i\u001d\u0016<\u0017\r^5wK>3gm]3uQ\ta\u0016\u0007C\u0003a\u0001\u0011\u0005\u0011&A\ruKN$\bj\u001c9U-\u001a;\u0016\u000e\u001e5OC6,G\rU1sC6\u001c\bFA02\u0011\u0015\u0019\u0007\u0001\"\u0001*\u0003e!Xm\u001d;Dk6,H.\u0019;f)Z3u+\u001b;i\u001f\u001a47/\u001a;)\u0005\t\f\u0004\"\u00024\u0001\t\u0003I\u0013!\t;fgR\u001cU/\\;mCR,GK\u0016$XSRDg*Z4bi&4Xm\u00144gg\u0016$\bFA32\u0011\u0015I\u0007\u0001\"\u0001*\u00039!Xm\u001d;TKN\u001c\u0018n\u001c8U-\u001aC#\u0001[\u0019\t\u000b1\u0004A\u0011A\u0015\u0002-Q,7\u000f^*fgNLwN\u001c+W\rB\u0013xn\u0019;j[\u0016D#a[\u0019\t\u000b=\u0004A\u0011A\u0015\u0002?Q,7\u000f^*fgNLwN\u001c+W\r^KG\u000f\u001b)beRLG/[8o\u0017\u0016L8\u000f\u000b\u0002oc!)!\u000f\u0001C\u0001S\u0005iB/Z:u'\u0016\u001c8/[8o)Z3u+\u001b;i\u001d\u0006lW\r\u001a)be\u0006l7\u000f\u000b\u0002rc!)Q\u000f\u0001C\u0001S\u00059C/Z:u/&tGm\\<U-\u001a;\u0016\u000e\u001e5OC6,G\rU1sC6\u001cxJ\u001d3fe\u000eC\u0017M\\4fQ\t!\u0018\u0007")
public class WindowTableFunctionTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTumbleTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowOnNonTimeAttribute() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT *, LOCALTIMESTAMP AS cur_time\n                               |FROM MyTable\n                               |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(cur_time), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sql)).hasCause((Throwable)new ValidationException("The window function requires the timecol is a time attribute type, but is TIMESTAMP(3)."));
    }

    @Test
    public void testConflictingFieldNames() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT *, rowtime AS window_start\n                               |FROM MyTable\n                               |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sql)).hasMessageContaining("Column 'window_start' is ambiguous") instanceof ValidationException;
    }

    @Test
    public void testTumbleTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithNamedParams() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   DATA => TABLE MyTable,\n        |   TIMECOL => DESCRIPTOR(rowtime),\n        |   SIZE => INTERVAL '15' MINUTE,\n        |   `OFFSET` => INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithNamedParams() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   DATA => TABLE MyTable,\n        |   TIMECOL => DESCRIPTOR(rowtime),\n        |   SIZE => INTERVAL '15' MINUTE,\n        |   `OFFSET` => INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(SESSION(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(SESSION(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVFWithPartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(SESSION(TABLE MyTable PARTITION BY (b, a), DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVFWithNamedParams() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |     SESSION(\n        |         DATA => TABLE MyTable PARTITION BY (b, a),\n        |         TIMECOL => DESCRIPTOR(rowtime),\n        |         GAP => INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowTVFWithNamedParamsOrderChange() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |     SESSION(\n        |         DATA => TABLE MyTable PARTITION BY (b, a),\n        |         GAP => INTERVAL '15' MINUTE,\n        |         TIMECOL => DESCRIPTOR(rowtime)))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sql)).hasMessage("fieldList must not be null, type = INTERVAL MINUTE") instanceof AssertionError;
    }

    public WindowTableFunctionTest() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable (\n                              |  a INT,\n                              |  b BIGINT,\n                              |  c STRING,\n                              |  d DECIMAL(10, 3),\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
    }
}

