/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001U\u0011Q\"Q4he\u0016<\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0003$\u0003\u0011)H/\u001b7\u0016\u0003\u0011\u0002\"aF\u0013\n\u0005\u0019B\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0015\u0001A\u0003%A%A\u0003vi&d\u0007\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0010uKN$xI]8va&twm\u00148O_:,\u00050[:uK:$h)[3mIR\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bFA\u00154!\t!4(D\u00016\u0015\t1t'A\u0002ba&T!\u0001O\u001d\u0002\u000f),\b/\u001b;fe*\u0011!HE\u0001\u0006UVt\u0017\u000e^\u0005\u0003yU\u0012A\u0001V3ti\")a\b\u0001C\u0001W\u0005aB/Z:u\u000fJ|W\u000f]5oO&sg/\u00197jIN+G.Z2uS>t\u0007FA\u001f4\u0011\u0015\t\u0005\u0001\"\u0001,\u0003q!Xm\u001d;DC:tw\u000e^\"pk:$xJ\\'vYRLg)[3mIND#\u0001Q\u001a\t\u000b\u0011\u0003A\u0011A\u0016\u0002)Q,7\u000f^!hO^KG\u000f['j]&\u0014\u0015\r^2iQ\t\u00195\u0007C\u0003H\u0001\u0011\u00051&A\u0015uKN$X*\u001b8j\u0005\u0006$8\r[!hO^KG\u000f\u001b(fO\u0006$\u0018N^3NS:L')\u0019;dQNK'0\u001a\u0015\u0003\rNBQA\u0013\u0001\u0005\u0002-\na\u0004^3ti\u0006;w-\u00114uKJ,f.[8o/&$\b.T5oS\n\u000bGo\u00195)\u0005%\u001b\u0004\"B'\u0001\t\u0003Y\u0013\u0001\u0007;fgR<%o\\;q\u0005f<\u0016\u000e\u001e5pkR<\u0016N\u001c3po\"\u0012Aj\r\u0005\u0006!\u0002!\taK\u0001\u001di\u0016\u001cH\u000fT8dC2<En\u001c2bY\u0006;w-\u00114uKJ,f.[8oQ\ty5\u0007C\u0003T\u0001\u0011\u00051&A\fuKN$\u0018iZ4XSRDg)\u001b7uKJ\u001cE.Y;tK\"\u0012!k\r\u0005\u0006-\u0002!\taK\u0001'i\u0016\u001cH/Q4h/&$\bNR5mi\u0016\u00148\t\\1vg\u0016<\u0016\u000e\u001e5M_\u000e\fGn\u00127pE\u0006d\u0007FA+4\u0011\u0015I\u0006\u0001\"\u0001,\u0003]!Xm\u001d;BO\u001e|e\u000eR5gM\u0016\u0014XM\u001c;UsB,7\u000f\u000b\u0002Yg!)A\f\u0001C\u0001W\u00059B/Z:u\u0003Z<wJ\u001c#jM\u001a,'/\u001a8u)f\u0004Xm\u001d\u0015\u00037NBQa\u0018\u0001\u0005\u0002-\n!\u0003^3ti\u00063xmV5uQJ+GO]1di\"\u0012al\r\u0005\u0006E\u0002!\taK\u0001\bi\u0016\u001cHoU;nQ\t\t7\u0007C\u0003f\u0001\u0011\u00051&\u0001\nuKN$8+^7XSRD'+\u001a;sC\u000e$\bF\u000134\u0011\u0015A\u0007\u0001\"\u0001,\u0003]!Xm\u001d;NS:|e\u000eR5gM\u0016\u0014XM\u001c;UsB,7\u000f\u000b\u0002hg!)1\u000e\u0001C\u0001W\u0005\u0011B/Z:u\u001b&tw+\u001b;i%\u0016$(/Y2uQ\tQ7\u0007C\u0003o\u0001\u0011\u00051&A\fuKN$X*\u0019=P]\u0012KgMZ3sK:$H+\u001f9fg\"\u0012Qn\r\u0005\u0006c\u0002!\taK\u0001\u0013i\u0016\u001cH/T1y/&$\bNU3ue\u0006\u001cG\u000f\u000b\u0002qg!)A\u000f\u0001C\u0001W\u0005QB/Z:u\u000fJ|W\u000f\u001d\"z/&$\bnQ8ogR\fg\u000e^&fs\"\u00121o\r\u0005\u0006o\u0002!\taK\u0001\u001di\u0016\u001cHoQ8mk6t\u0017J\u001c;feZ\fGNV1mS\u0012\fG/[8oQ\t18\u0007C\u0003{\u0001\u0011\u00051&\u0001\u0013uKN$h)\u001b7uKJ,GmQ8mk6t\u0017J\u001c;feZ\fGNV1mS\u0012\fG/[8oQ\tI8\u0007C\u0003~\u0001\u0011\u00051&\u0001\u000euKN$xI]8va.+\u0017PT8u\u001b\u0006$8\r[*j].\u00046\u000e\u000b\u0002}g!1\u0011\u0011\u0001\u0001\u0005\u0002-\nA\u0003^3ti\u001e\u0013x.\u001e9LKfLenU5oWB[\u0007FA@4\u0011\u0019\t9\u0001\u0001C\u0001W\u00051C/Z:u\u000fJ|W\u000f\u001d*fgVdG\u000fT8tiV\u00038/\u001a:u\u0017\u0016Lx+\u001b;i'&t7\u000eU6)\u0007\u0005\u00151\u0007\u0003\u0004\u0002\u000e\u0001!\taK\u0001\u001di\u0016\u001cH/\u00119qe>D\u0018.\\1uK\u000e{WO\u001c;ESN$\u0018N\\2uQ\r\tYa\r\u0005\u0007\u0003'\u0001A\u0011A\u0016\u0002\u001dQ,7\u000f^\"pk:$8\u000b^1si\"\u001a\u0011\u0011C\u001a\t\r\u0005e\u0001\u0001\"\u0001,\u0003i!Xm\u001d;D_VtGo\u0015;beR<\u0016\u000e\u001e5NKR\fG-\u0019;bQ\r\t9b\r\u0005\u0007\u0003?\u0001A\u0011A\u0016\u0002=Q,7\u000f^\"pk:$8\u000b^1si^KG\u000f['fi\u0006$\u0017\r^1P]2L\bfAA\u000fg!1\u0011Q\u0005\u0001\u0005\u0002-\n1\u0004^3ti\u000e{WO\u001c;Ti\u0006\u0014HoV5uQ:+7\u000f^3e%><\bfAA\u0012g\u0001")
public class AggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingOnNonExistentField() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable GROUP BY foo"));
    }

    @Test
    public void testGroupingInvalidSelection() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT b FROM MyTable GROUP BY a"));
    }

    @Test
    public void testCannotCountOnMultiFields() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT COUNT(a, c) FROM MyTable GROUP BY b")).hasMessageContaining("We now only support the count of one field") instanceof TableException;
    }

    @Test
    public void testAggWithMiniBatch() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)5000L));
        this.util().verifyExplain("SELECT b, COUNT(DISTINCT a), MAX(b), SUM(c) FROM MyTable GROUP BY b");
    }

    @Test
    public void testMiniBatchAggWithNegativeMiniBatchSize() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = "SELECT b, COUNT(DISTINCT a), MAX(b), SUM(c) FROM MyTable GROUP BY b";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)-500L));
        boolean cfr_ignored_1 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
    }

    @Test
    public void testAggAfterUnionWithMiniBatch() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, sum(b), count(distinct c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(query);
    }

    @Test
    public void testGroupByWithoutWindow() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testLocalGlobalAggAfterUnion() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b), COUNT(DISTINCT c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClause() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClauseWithLocalGlobal() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  COUNT(DISTINCT c) FILTER (WHERE b = 1),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggOnDifferentTypes() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(CAST(1 as INT)),\n        |  SUM(CAST(2 as BIGINT)),\n        |  SUM(CAST(3 as TINYINT)),\n        |  SUM(CAST(4 as SMALLINT)),\n        |  SUM(CAST(5 as FLOAT)),\n        |  SUM(CAST(6 as DECIMAL)),\n        |  SUM(CAST(7 as DOUBLE))\n        |FROM T GROUP BY a\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sql);
    }

    @Test
    public void testAvgOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT AVG(`byte`),\n                                 |       AVG(`short`),\n                                 |       AVG(`int`),\n                                 |       AVG(`long`),\n                                 |       AVG(`float`),\n                                 |       AVG(`double`),\n                                 |       AVG(`decimal3020`),\n                                 |       AVG(`decimal105`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testAvgWithRetract() {
        this.util().verifyRelPlan("SELECT AVG(a) FROM (SELECT AVG(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSum() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT SUM(`byte`),\n                                 |       SUM(`short`),\n                                 |       SUM(`int`),\n                                 |       SUM(`long`),\n                                 |       SUM(`float`),\n                                 |       SUM(`double`),\n                                 |       SUM(`decimal3020`),\n                                 |       SUM(`decimal105`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testSumWithRetract() {
        this.util().verifyRelPlan("SELECT SUM(a) FROM (SELECT SUM(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MIN(`byte`),\n                                 |       MIN(`short`),\n                                 |       MIN(`int`),\n                                 |       MIN(`long`),\n                                 |       MIN(`float`),\n                                 |       MIN(`double`),\n                                 |       MIN(`decimal3020`),\n                                 |       MIN(`decimal105`),\n                                 |       MIN(`boolean`),\n                                 |       MIN(`date`),\n                                 |       MIN(`time`),\n                                 |       MIN(`timestamp`),\n                                 |       MIN(`string`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMinWithRetract() {
        this.util().verifyRelPlan("SELECT MIN(a) FROM (SELECT MIN(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMaxOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MAX(`byte`),\n                                 |       MAX(`short`),\n                                 |       MAX(`int`),\n                                 |       MAX(`long`),\n                                 |       MAX(`float`),\n                                 |       MAX(`double`),\n                                 |       MAX(`decimal3020`),\n                                 |       MAX(`decimal105`),\n                                 |       MAX(`boolean`),\n                                 |       MAX(`date`),\n                                 |       MAX(`time`),\n                                 |       MAX(`timestamp`),\n                                 |       MAX(`string`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMaxWithRetract() {
        this.util().verifyRelPlan("SELECT MAX(a) FROM (SELECT MAX(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupByWithConstantKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, MAX(b), c FROM (SELECT a, 'test' AS c, b FROM T) t GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testColumnIntervalValidation() {
        this.util().verifyExecPlan("SELECT b, SUM(a) FROM MyTable WHERE a > 0.1 and a < 10 GROUP BY b");
    }

    @Test
    public void testFilteredColumnIntervalValidation() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |SELECT\n                           |  SUM(uv) FILTER (WHERE c = 'all') AS all_uv\n                           |FROM (\n                           |  SELECT\n                           |    c, COUNT(1) AS uv\n                           |  FROM T\n                           |  GROUP BY c\n                           |) t\n                           |")).stripMargin());
    }

    @Test
    public void testGroupKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | id VARCHAR,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (cnt) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT c, COUNT(*) cnt FROM T GROUP BY c\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | a INT,\n                               | b BIGINT,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (a, b) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT a, MAX(b) b, COUNT(*) cnt FROM T GROUP BY a\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupResultLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | id VARCHAR,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (id) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT c, COUNT(*) cnt FROM T GROUP BY a, c\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testApproximateCountDistinct() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT APPROX_COUNT_DISTINCT(b) FROM MyTable"));
    }

    @Test
    public void testCountStart() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithMetadata() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithMetadataOnly() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR METADATA,\n                               | cnt BIGINT METADATA\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING,id:STRING,cnt:BIGINT'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithNestedRow() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | nested row<name string, `value` int>,\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    public AggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (TypeInformation[])((Object[])new TypeInformation[]{Types.BYTE(), Types.SHORT(), Types.INT(), Types.LONG(), Types.FLOAT(), Types.DOUBLE(), Types.BOOLEAN(), Types.STRING(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.LOCAL_DATE_TIME(), DecimalDataTypeInfo.of((int)30, (int)20), DecimalDataTypeInfo.of((int)10, (int)5)}), (String[])((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "string", "date", "time", "timestamp", "decimal3020", "decimal105"}));
    }
}

