/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.rules.physical.stream.IncrementalAggregateRule$;
import org.apache.flink.table.planner.plan.stream.sql.agg.DistinctAggregateTest$;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001U\u0011Q\u0003R5ti&t7\r^!hOJ,w-\u0019;f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011mZ4\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0007gR\u0014X-Y7\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tI\"\"A\u0003vi&d7/\u0003\u0002\u001c1\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0018gBd\u0017\u000e\u001e#jgRLgn\u0019;BO\u001e,e.\u00192mK\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003A\twm\u001a)iCN,WI\u001c4pe\u000e,'\u000f\u0005\u0002\u0018O%\u0011\u0001\u0006\u0007\u0002\u0017\u0003\u001e<'/Z4bi\u0016\u0004\u0006.Y:f'R\u0014\u0018\r^3hs\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\u0003\u0011\u0015i\u0012\u00061\u0001\u001f\u0011\u0015)\u0013\u00061\u0001'\u0011\u001d\t\u0004A1A\u0005\u0012I\nA!\u001e;jYV\t1\u0007\u0005\u0002\u0018i%\u0011Q\u0007\u0007\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007o\u0001\u0001\u000b\u0011B\u001a\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000be\u0002A\u0011\u0001\u001e\u0002\r\t,gm\u001c:f)\u0005Y\u0004CA\u0010=\u0013\ti\u0004E\u0001\u0003V]&$\bF\u0001\u001d@!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0002ba&T!\u0001R#\u0002\u000f),\b/\u001b;fe*\u0011aIE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0011\u0006\u0013!BQ3g_J,W)Y2i\u0011\u0015Q\u0005\u0001\"\u0001;\u0003U!Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001eD#!\u0013'\u0011\u0005\u0001k\u0015B\u0001(B\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u0015\u0001\u0006\u0001\"\u0001;\u0003U!Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hOND#a\u0014'\t\u000bM\u0003A\u0011\u0001\u001e\u00029Q,7\u000f^*j]\u001edW-T1y/&$\b\u000eR5ti&t7\r^!hO\"\u0012!\u000b\u0014\u0005\u0006-\u0002!\tAO\u0001$i\u0016\u001cHoU5oO2,g)\u001b:tiZ\u000bG.^3XSRDG)[:uS:\u001cG/Q4hQ\t)F\nC\u0003Z\u0001\u0011\u0005!(\u0001\u0012uKN$8+\u001b8hY\u0016d\u0015m\u001d;WC2,XmV5uQ\u0012K7\u000f^5oGR\fum\u001a\u0015\u000312CQ\u0001\u0018\u0001\u0005\u0002i\n\u0001\u0005^3tiNKgn\u001a7f\u0019&\u001cH/Q4h/&$\b\u000eR5ti&t7\r^!hO\"\u00121\f\u0014\u0005\u0006?\u0002!\tAO\u0001+i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4h/&$\b.\u00117m\u001d>tG)[:uS:\u001cG/Q4hQ\tqF\nC\u0003c\u0001\u0011\u0005!(\u0001\u0016uKN$Hk^8ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5O_:$\u0015n\u001d;j]\u000e$\u0018iZ4)\u0005\u0005d\u0005\"B3\u0001\t\u0003Q\u0014\u0001\t;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"<%o\\;q\u0005fD#\u0001\u001a'\t\u000b!\u0004A\u0011\u0001\u001e\u0002mQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO^KG\u000f[!oI:{g\u000eR5ti&t7\r^!hO>s7+Y7f\u0007>dW/\u001c8)\u0005\u001dd\u0005\"B6\u0001\t\u0003Q\u0014A\u000b;fgR\u001cv.\\3D_2,XN\\:C_RD\u0017J\u001c#jgRLgn\u0019;BO\u001e\fe\u000eZ$s_V\u0004()\u001f\u0015\u0003U2CQA\u001c\u0001\u0005\u0002i\nq\u0003^3ti\u0006;wmV5uQ\u001aKG\u000e^3s\u00072\fWo]3)\u00055d\u0005\"B9\u0001\t\u0003Q\u0014!\u0005;fgRlU\u000f\u001c;j\u000fJ|W\u000f\u001d\"zg\"\u0012\u0001\u000f\u0014\u0005\u0006i\u0002!\tAO\u0001!i\u0016\u001cHoU5oO2,G)[:uS:\u001cGoV5uQJ+GO]1di&|g\u000e\u000b\u0002t\u0019\")q\u000f\u0001C\u0001u\u0005YC/Z:u'Vl7i\\;oi^KG\u000f[*j]\u001edW\rR5ti&t7\r^!oIJ+GO]1di&|g\u000e\u000b\u0002w\u0019\")!\u0010\u0001C\u0001u\u0005AB/Z:u\u001b&tW*\u0019=XSRD'+\u001a;sC\u000e$\u0018n\u001c8)\u0005ed\u0005\"B?\u0001\t\u0003Q\u0014!\n;fgR4\u0015N]:u-\u0006dW/\u001a'bgR4\u0016\r\\;f/&$\bNU3ue\u0006\u001cG/[8oQ\taH\n\u0003\u0004\u0002\u0002\u0001!\tAO\u0001!i\u0016\u001cH\u000fT5ti\u0006;wmV5uQ\u0012K7\u000f^5oGRlU\u000f\u001c;j\u0003J<7\u000f\u000b\u0002\u0000\u0019\":\u0001!a\u0002\u0002\u0014\u0005U\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055\u0011)A\u0005fqR,gn]5p]&!\u0011\u0011CA\u0006\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003/\u0019#!!\u0007\u0011\t\u0005m\u00111F\u0007\u0003\u0003;QA!a\b\u0002\"\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\t\u0002&\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007\u0019\u000b9CC\u0002\u0002*9\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u00055\u0012Q\u0004\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0004\b\u0003c\u0011\u0001\u0012AA\u001a\u0003U!\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/\u001a+fgR\u00042!LA\u001b\r\u0019\t!\u0001#\u0001\u00028M!\u0011QGA\u001d!\ry\u00121H\u0005\u0004\u0003{\u0001#AB!osJ+g\rC\u0004+\u0003k!\t!!\u0011\u0015\u0005\u0005M\u0002\u0002CA#\u0003k!\t!a\u0012\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002JA1\u00111JA*\u0003/j!!!\u0014\u000b\u0007E\nyE\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t)&!\u0014\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003 \u00033\ni&C\u0002\u0002\\\u0001\u0012Q!\u0011:sCf\u00042aHA0\u0013\r\t\t\u0007\t\u0002\u0004\u0003:L\b\u0006CA\"\u0003K\nY'!\u001c\u0011\t\u0005m\u0011qM\u0005\u0005\u0003S\niB\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012\u0011qN\u00012gBd\u0017\u000e\u001e#jgRLgn\u0019;BO\u001e,e.\u00192mK\u0012l4\u0010M?-A\u0005<w\r\u00155bg\u0016,eNZ8sG\u0016\u0014Xh_\u0019~\u0001")
public class DistinctAggregateTest
extends TableTestBase {
    private final boolean splitDistinctAggEnabled;
    private final AggregatePhaseStrategy aggPhaseEnforcer;
    private final StreamTableTestUtil util;

    @Parameters(name="splitDistinctAggEnabled={0}, aggPhaseEnforcer={1}")
    public static Collection<Object[]> parameters() {
        return DistinctAggregateTest$.MODULE$.parameters();
    }

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggPhaseEnforcer.toString());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.splitDistinctAggEnabled));
        this.util().tableEnv().getConfig().set(IncrementalAggregateRule$.MODULE$.TABLE_OPTIMIZER_INCREMENTAL_AGG_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @TestTemplate
    public void testSingleDistinctAgg() {
        this.util().verifyExecPlan("SELECT COUNT(DISTINCT c) FROM MyTable");
    }

    @TestTemplate
    public void testMultiDistinctAggs() {
        this.util().verifyExecPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable");
    }

    @TestTemplate
    public void testSingleMaxWithDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), MAX(c)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSingleFirstValueWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, FIRST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleLastValueWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, LAST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleListAggWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, LISTAGG(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleDistinctAggWithAllNonDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT c), SUM(b), AVG(b), MAX(b), MIN(b), COUNT(b), COUNT(*)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTwoDistinctAggregateWithNonDistinctAgg() {
        this.util().verifyExecPlan("SELECT c, SUM(DISTINCT a), SUM(a), COUNT(DISTINCT b) FROM MyTable GROUP BY c");
    }

    @TestTemplate
    public void testSingleDistinctAggWithGroupBy() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT b), SUM(b), AVG(b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testAggWithFilterClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  SUM(b) FILTER (WHERE NOT b = 2)\n         |FROM MyTable\n         |GROUP BY a\n       ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testMultiGroupBys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSingleDistinctWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), COUNT(1)\n        |FROM (\n        |  SELECT c, AVG(a) as a, AVG(b) as b\n        |  FROM MyTable\n        |  GROUP BY c\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testSumCountWithSingleDistinctAndRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  b, SUM(b1), COUNT(DISTINCT b1), COUNT(1)\n         |FROM(\n         |   SELECT\n         |     a, COUNT(b) as b, MAX(b) as b1\n         |   FROM MyTable\n         |   GROUP BY a\n         |) GROUP BY b\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testMinMaxWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testFirstValueLastValueWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  b, FIRST_VALUE(c), LAST_VALUE(c), COUNT(DISTINCT c)\n         |FROM(\n         |  SELECT\n         |    a, COUNT(DISTINCT b) as b, MAX(b) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY b\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testListAggWithDistinctMultiArgs() {
        this.util().verifyExecPlan("SELECT a, LISTAGG(DISTINCT c, '#') FROM MyTable GROUP BY a");
    }

    public DistinctAggregateTest(boolean splitDistinctAggEnabled, AggregatePhaseStrategy aggPhaseEnforcer) {
        this.splitDistinctAggEnabled = splitDistinctAggEnabled;
        this.aggPhaseEnforcer = aggPhaseEnforcer;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.DistinctAggregateTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

