/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.GroupWindowTest$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001U\u0011qb\u0012:pkB<\u0016N\u001c3poR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!Y4h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u00021Q,7\u000f\u001e+v[\ndWmV5oI><hj\\(gMN,G\u000fF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\u0005%\u001a\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003\r\t\u0007/\u001b\u0006\u0003qe\nqA[;qSR,'O\u0003\u0002;%\u0005)!.\u001e8ji&\u0011A(\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u00051&A\u000buKN$\bj\u001c9XS:$wn\u001e(p\u001f\u001a47/\u001a;)\u0005u\u001a\u0004\"B!\u0001\t\u0003Y\u0013!\u0007;fgR\u001cVm]:j_:<\u0016N\u001c3po:{wJ\u001a4tKRD#\u0001Q\u001a\t\u000b\u0011\u0003A\u0011A\u0016\u0002-Q,7\u000f\u001e,be&\f'\r\\3XS:$wn^*ju\u0016D#aQ\u001a\t\u000b\u001d\u0003A\u0011A\u0016\u00025Q,7\u000f^,j]\u0012|w/\u00163BO\u001eLeN^1mS\u0012\f%oZ:)\u0005\u0019\u001b\u0004\"\u0002&\u0001\t\u0003Y\u0013A\u0007;fgR<\u0016N\u001c3po\u0006;wmV5uQ\u001e\u0013x.\u001e9TKR\u001c\bFA%4\u0011\u0015i\u0005\u0001\"\u0001,\u0003}!Xm\u001d;XS:$wn^,s_:<w+\u001b8e_^\u0004\u0016M]1nKR,'/\r\u0015\u0003\u0019NBQ\u0001\u0015\u0001\u0005\u0002-\nq\u0004^3ti^Kg\u000eZ8x/J|gnZ,j]\u0012|w\u000fU1sC6,G/\u001a:3Q\ty5\u0007C\u0003T\u0001\u0011\u00051&A\buKN$\u0018J\u001c;feZ\fG\u000eR1zQ\t\u00116\u0007C\u0003W\u0001\u0011\u00051&\u0001\nuKN$H+^7cY\u00164UO\\2uS>t\u0007FA+4\u0011\u0015I\u0006\u0001\"\u0001,\u0003m!Xm\u001d;XS:$wn^$s_V\u0004()_(o\u0007>t7\u000f^1oi\"\u0012\u0001l\r\u0005\u00069\u0002!\taK\u0001\u001fi\u0016\u001cH\u000fV;nE2LgnZ,j]\u0012|woV5uQB\u0013xn\u0019;j[\u0016D#aW\u001a\t\u000b}\u0003A\u0011A\u0016\u0002'Q,7\u000f^'vYRL\u0007j\u001c9XS:$wn^:)\u0005y\u001b\u0004\"\u00022\u0001\t\u0003Y\u0013a\u0006;fgRlU\u000f\u001c;j\u0011>\u0004x+\u001b8e_^\u001c(j\\5oQ\t\t7\u0007C\u0003f\u0001\u0011\u00051&A\nuKN$\bj\u001c9qS:<g)\u001e8di&|g\u000e\u000b\u0002eg!)\u0001\u000e\u0001C\u0001W\u0005IB/Z:u\u0011>\u0004x+\u001b8e_^<\u0016\u000e\u001e5Qe>\u001cG/[7fQ\t97\u0007C\u0003l\u0001\u0011\u00051&A\nuKN$8+Z:tS>tg)\u001e8di&|g\u000e\u000b\u0002kg!)a\u000e\u0001C\u0001W\u0005iB/Z:u'\u0016\u001c8/[8o/&tGm\\<XSRD\u0007K]8di&lW\r\u000b\u0002ng!)\u0011\u000f\u0001C\u0001W\u0005\tC/Z:u\u000bb\u0004(/Z:tS>twJ\\,j]\u0012|w/Q;y\rVt7\r^5p]\"\u0012\u0001o\r\u0005\u0006i\u0002!\taK\u0001\"i\u0016\u001cH/T;mi&<\u0016N\u001c3poN\u000bHnV5uQ\u0006;wM]3hCRLwN\u001c\u0015\u0003gNBQa\u001e\u0001\u0005\u0002-\na\u0003^3tiR+XN\u00197f\rVt\u0017J\\$s_V\u0004()\u001f\u0015\u0003mNBQA\u001f\u0001\u0005\u0002-\n\u0011\u0004^3tiR+XN\u00197f\rVtgj\u001c;J]\u001e\u0013x.\u001e9Cs\"\u0012\u0011p\r\u0005\u0006{\u0002!\taK\u0001'i\u0016\u001cH\u000fV;nE2,g)\u001e8B]\u0012\u0014VmZ;mCJ\fum\u001a$v]&swI]8va\nK\bF\u0001?4\u0011\u0019\t\t\u0001\u0001C\u0001W\u0005)D/Z:u%\u0016<W\u000f\\1s\u0003\u001e<g)\u001e8J]\u001e\u0013x.\u001e9Cs\u0006sG\rV;nE2,g)\u001e8B]\u0012tu\u000e^%o\u000fJ|W\u000f\u001d\"zQ\ty8\u0007\u0003\u0004\u0002\b\u0001!\taK\u0001\u001di\u0016\u001cH\u000fR3d_6\u0004xn]1cY\u0016\fum\u001a$v]\u000e$\u0018n\u001c8tQ\r\t)a\r\u0005\u0007\u0003\u001b\u0001A\u0011A\u0016\u0002IQ,7\u000f^#yaJ,7o]5p]>sw+\u001b8e_^D\u0015M^5oO\u001a+hn\u0019;j_:D3!a\u00034\u0011\u0019\t\u0019\u0002\u0001C\u0001W\u0005\u0019C/Z:u%\u0016$XO\u001d8UsB,\u0017J\u001c4fe\u0016t7-\u001a$pe^Kg\u000eZ8x\u0003\u001e<\u0007fAA\tg!1\u0011\u0011\u0004\u0001\u0005\u0002-\nq\u0005^3ti^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5ES\u001a4WM]3oi^Kg\u000eZ8xg\"\u001a\u0011qC\u001a\t\r\u0005}\u0001\u0001\"\u0001,\u0003}!Xm\u001d;XS:$wn^!hOJ,w-\u0019;f/&$\b\u000eT1uK\u001aK'/\u001a\u0015\u0004\u0003;\u0019\u0004BBA\u0013\u0001\u0011\u00051&\u0001\u0013uKN$x+\u001b8e_^\fum\u001a:fO\u0006$XmV5uQ\u0006cGn\\<MCR,g.Z:tQ\r\t\u0019c\r\u0005\u0007\u0003W\u0001A\u0011A\u0016\u0002WQ,7\u000f^,j]\u0012|w/Q4he\u0016<\u0017\r^3XSRD\u0017J\u001c<bY&$\u0017\t\u001c7po2\u000bG/\u001a8fgND3!!\u000b4\u0011\u0019\t\t\u0004\u0001C\u0001W\u0005AC/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK^KG\u000f[!mY><H*\u0019;f]\u0016\u001c8o\u00148ms\"\u001a\u0011qF\u001a\t\r\u0005]\u0002\u0001\"\u0001,\u0003\t\"Xm\u001d;XS:$wn^!hOJ,w-\u0019;f\u001f:\u0014V\r\u001e:bGR\u001cFO]3b[\"\u001a\u0011QG\u001a\t\r\u0005u\u0002\u0001\"\u0001,\u0003\u0005\"Xm\u001d;XS:$wn^!hOJ,w-\u0019;f\u001f:,\u0006o]3siN{WO]2fQ\r\tYd\r")
public class GroupWindowTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTumbleWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testHopWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY HOP(proctime, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSessionWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY SESSION(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testVariableWindowSize() {
        String sql = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, c * INTERVAL '1' MINUTE)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sql));
    }

    @Test
    public void testWindowUdAggInvalidArgs() {
        String sqlQuery = "SELECT SUM(a) AS sumA, weightedAvg(a, b) AS wAvg FROM MyTable GROUP BY TUMBLE(proctime(), INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testWindowAggWithGroupSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable\n        |    GROUP BY rollup(TUMBLE(rowtime, INTERVAL '15' MINUTE), b)\n    ")).stripMargin();
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TUMBLE(rowtime"})));
    }

    @Test
    public void testWindowWrongWindowParameter1() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '1' MONTH)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).withMessageContaining("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
    }

    @Test
    public void testWindowWrongWindowParameter2() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2-10' YEAR TO MONTH)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).withMessageContaining("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
    }

    @Test
    public void testIntervalDay() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '35' DAY)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumbleFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowGroupByOnConstant() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY 'a', TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumblingWindowWithProctime() {
        String sql = "select sum(a), max(b) from MyTable1 group by TUMBLE(c, INTERVAL '1' SECOND)";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiHopWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR),\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR),\n        |   count(*),\n        |   sum(c)\n        |FROM MyTable\n        |GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR)\n        |UNION ALL\n        |SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY),\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY),\n        |   count(*),\n        |   sum(c)\n        |FROM MyTable\n        |GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiHopWindowsJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        | (SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR) as hs1,\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR) as he1,\n        |   count(*) as c1,\n        |   sum(c) as s1\n        | FROM MyTable\n        | GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR)) t1\n        |JOIN\n        | (SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY) as hs2,\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY) as he2,\n        |   count(*) as c2,\n        |   sum(c) as s2\n        | FROM MyTable\n        | GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY)) t2 ON t1.he1 = t2.he2\n        |WHERE t1.s1 IS NOT NULL\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHoppingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    HOP_START(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR),\n        |    HOP_END(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)\n        |FROM MyTable\n        |    GROUP BY HOP(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHopWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable1\n         |group by HOP(c, INTERVAL '1' SECOND, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*), weightedAvg(c, a) AS wAvg,\n        |    SESSION_START(proctime, INTERVAL '15' MINUTE),\n        |    SESSION_END(proctime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY SESSION(proctime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable1\n         |group by SESSION(c, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testExpressionOnWindowAuxFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiWindowSqlWithAggregation() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  TUMBLE_ROWTIME(zzzzz, INTERVAL '0.004' SECOND),\n        |  TUMBLE_END(zzzzz, INTERVAL '0.004' SECOND),\n        |  COUNT(`a`) AS `a`\n        |FROM (\n        |  SELECT\n        |    COUNT(`a`) AS `a`,\n        |    TUMBLE_ROWTIME(rowtime, INTERVAL '0.002' SECOND) AS `zzzzz`\n        |  FROM MyTable\n        |  GROUP BY TUMBLE(rowtime, INTERVAL '0.002' SECOND)\n        |)\n        |GROUP BY TUMBLE(zzzzz, INTERVAL '0.004' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)\n        |     ) AS t1\n        | GROUP BY b, ping_start\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunNotInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunAndRegularAggFunInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c, count(*) d,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b, d, ping_start\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRegularAggFunInGroupByAndTumbleFunAndNotInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c, count(*) d,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDecomposableAggFunctions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    VAR_POP(c),\n        |    VAR_SAMP(c),\n        |    STDDEV_POP(c),\n        |    STDDEV_SAMP(c),\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testExpressionOnWindowHavingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        | FROM MyTable\n        |     GROUP BY HOP(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |     HAVING SUM(a) > 0 AND\n        |         QUARTER(HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testReturnTypeInferenceForWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  SUM(correct) AS s,\n        |  AVG(correct) AS a,\n        |  TUMBLE_START(rowtime, INTERVAL '15' MINUTE) AS wStart\n        |FROM (\n        |  SELECT CASE a\n        |      WHEN 1 THEN 1\n        |      ELSE 99\n        |    END AS correct, rowtime\n        |  FROM MyTable\n        |)\n        |GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH window_1h AS (\n        |    SELECT 1\n        |    FROM MyTable\n        |    GROUP BY HOP(`rowtime`, INTERVAL '1' HOUR, INTERVAL '1' HOUR)\n        |),\n        |\n        |window_2h AS (\n        |    SELECT 1\n        |    FROM MyTable\n        |    GROUP BY HOP(`rowtime`, INTERVAL '1' HOUR, INTERVAL '2' HOUR)\n        |)\n        |\n        |(SELECT * FROM window_1h)\n        |UNION ALL\n        |(SELECT * FROM window_2h)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithLateFire() {
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().tableConfig().setIdleStateRetention(Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithAllowLateness() {
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithInvalidAllowLateness() {
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).withMessageContaining("Allow-lateness [1000ms] should not be smaller than Late-fire delay [5000ms] when enable late-fire emit strategy.");
    }

    @Test
    public void testWindowAggregateWithAllowLatenessOnly() {
        this.util().tableConfig().setIdleStateRetention(Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateOnRetractStream() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM  (\n        | SELECT a, b, c, rowtime\n        | FROM (\n        |   SELECT *,\n        |   ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rowNum\n        |   FROM MyTable\n        | )\n        | WHERE rowNum = 1\n        |)\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateOnUpsertSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts AS PROCTIME(),\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  PRIMARY KEY (a) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'changelog-mode' = 'UA,D'\n                    |)\n      ")).stripMargin());
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), COUNT(*)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public GroupWindowTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.GroupWindowTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table MyTable1 (\n                              |  a int,\n                              |  b bigint,\n                              |  c as proctime()\n                              |) with (\n                              |  'connector' = 'COLLECTION'\n                              |)\n                              |")).stripMargin());
    }
}

