/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.TwoStageAggregateTest$;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001+\t)Bk^8Ti\u0006<W-Q4he\u0016<\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0003$\u0003\u0011)H/\u001b7\u0016\u0003\u0011\u0002\"aF\u0013\n\u0005\u0019B\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0015\u0001A\u0003%A%A\u0003vi&d\u0007\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004cK\u001a|'/\u001a\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t!QK\\5uQ\tI3\u0007\u0005\u00025w5\tQG\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014a\u00026va&$XM\u001d\u0006\u0003uI\tQA[;oSRL!\u0001P\u001b\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003?\u0001\u0011\u00051&\u0001\u000buKN$8i\\;oi^KG\u000f[$s_V\u0004()\u001f\u0015\u0003{\u0001\u0003\"\u0001N!\n\u0005\t+$\u0001\u0002+fgRDQ\u0001\u0012\u0001\u0005\u0002-\nq\u0003^3ti\u000e{WO\u001c;XSRDw.\u001e;He>,\bOQ=)\u0005\r\u0003\u0005\"B$\u0001\t\u0003Y\u0013A\u0005;fgR\feoZ,ji\"<%o\\;q\u0005fD#A\u0012!\t\u000b)\u0003A\u0011A\u0016\u0002+Q,7\u000f^!wO^KG\u000f[8vi\u001e\u0013x.\u001e9Cs\"\u0012\u0011\n\u0011\u0005\u0006\u001b\u0002!\taK\u0001\u001di\u0016\u001cHo\u0012:pkB\fum\u001a:fO\u0006$XmV5uQ\u001aKG\u000e^3sQ\ta\u0005\tC\u0003Q\u0001\u0011\u00051&\u0001\u0015uKN$xI]8va\u0006;wM]3hCR,w+\u001b;i\u000bb\u0004(/Z:tS>t\u0017J\\*fY\u0016\u001cG\u000f\u000b\u0002P\u0001\")1\u000b\u0001C\u0001W\u0005qB/Z:u\u000fJ|W\u000f]!hOJ,w-\u0019;f/&$\bnQ8ogR\fg\u000e\u001e\u0015\u0003%\u0002\u0003")
public class TwoStageAggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE.toString());
    }

    @Test
    public void testCountWithGroupBy() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testCountWithoutGroupBy() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable");
    }

    @Test
    public void testAvgWithGroupBy() {
        this.util().verifyExecPlan("SELECT AVG(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testAvgWithoutGroupBy() {
        this.util().verifyRelPlanWithType("SELECT AVG(CAST(a AS DOUBLE)) FROM MyTable");
    }

    @Test
    public void testGroupAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT b, SUM(a) FROM MyTable GROUP BY b) WHERE b = 2");
    }

    @Test
    public void testGroupAggregateWithExpressionInSelect() {
        this.util().verifyExecPlan("SELECT MIN(c), AVG(a) FROM (SELECT a, b + 3 AS d, c FROM MyTable) GROUP BY d");
    }

    @Test
    public void testGroupAggregateWithConstant() {
        this.util().verifyExecPlan("SELECT four, SUM(a) FROM (SELECT b, 4 AS four, a FROM MyTable) GROUP BY b, four");
    }

    public TwoStageAggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.TwoStageAggregateTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

