/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.stream.sql.agg.WindowAggregateTest$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u0001\u0003\u0001U\u00111cV5oI><\u0018iZ4sK\u001e\fG/\u001a+fgRT!a\u0001\u0003\u0002\u0007\u0005<wM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011AB:ue\u0016\fWN\u0003\u0002\n\u0015\u0005!\u0001\u000f\\1o\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033)\tQ!\u001e;jYNL!a\u0007\r\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011!i\u0002A!A!\u0002\u0013q\u0012\u0001E1hOBC\u0017m]3F]\u001a|'oY3s!\t9r$\u0003\u0002!1\t1\u0012iZ4sK\u001e\fG/\u001a)iCN,7\u000b\u001e:bi\u0016<\u0017\u0010C\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0019\u0002\"!\n\u0001\u000e\u0003\tAQ!H\u0011A\u0002yAq\u0001\u000b\u0001C\u0002\u0013%\u0011&\u0001\u0003vi&dW#\u0001\u0016\u0011\u0005]Y\u0013B\u0001\u0017\u0019\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019q\u0003\u0001)A\u0005U\u0005)Q\u000f^5mA!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0014AC5t)^|\u0007\u000b[1tKV\t!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DGA\u0004C_>dW-\u00198\t\re\u0002\u0001\u0015!\u00033\u0003-I7\u000fV<p!\"\f7/\u001a\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\r\t,gm\u001c:f)\u0005i\u0004CA\u001a?\u0013\tyDG\u0001\u0003V]&$\bF\u0001\u001eB!\t\u0011\u0015*D\u0001D\u0015\t!U)A\u0002ba&T!AR$\u0002\u000f),\b/\u001b;fe*\u0011\u0001JE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0015\u000e\u0013!BQ3g_J,W)Y2i\u0011\u0015a\u0005\u0001\"\u0001=\u0003Q!Xm\u001d;Uk6\u0014G.Z0P]J{w\u000f^5nK\"\u00121J\u0014\t\u0003\u0005>K!\u0001U\"\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000bI\u0003A\u0011\u0001\u001f\u0002CQ,7\u000f\u001e+v[\ndWmX(o%><H/[7f/&$\bn\u0011#D'>,(oY3)\u0005Es\u0005\"B+\u0001\t\u0003a\u0014!\u0006;fgR$V/\u001c2mK~{e\u000e\u0015:pGRLW.\u001a\u0015\u0003):CQ\u0001\u0017\u0001\u0005\u0002q\n!\u0005^3tiR+XN\u00197f?>s\u0007K]8di&lWmV5uQ\u000e#5iU8ve\u000e,\u0007FA,O\u0011\u0015Y\u0006\u0001\"\u0001=\u0003Q!Xm\u001d;Uk6\u0014G.Z0DC2\u001cwJ\u001c+W\r\"\u0012!L\u0014\u0005\u0006=\u0002!\t\u0001P\u0001\u001ei\u0016\u001cH\u000fV;nE2,wlV5oI><8i\u001c7v[:\u001c\u0018\t^#oI\"\u0012QL\u0014\u0005\u0006C\u0002!\t\u0001P\u0001&i\u0016\u001cH\u000fV;nE2,wl\u0012:pkBlU\u000f\u001c;ja2,w+\u001b8e_^\u001cu\u000e\\;n]ND#\u0001\u0019(\t\u000b\u0011\u0004A\u0011\u0001\u001f\u00029Q,7\u000f\u001e+v[\ndWmX$s_V\u0004X*\u001e7uSBdWmS3zg\"\u00121M\u0014\u0005\u0006O\u0002!\t\u0001P\u0001\"i\u0016\u001cH\u000fV;nE2,wl\u0012:pkB|e\u000e\\=XS:$wn^\"pYVlgn\u001d\u0015\u0003M:CQA\u001b\u0001\u0005\u0002q\na\u0004^3tiR+XN\u00197f?\u001e\u0013x.\u001e9P]2KG/\u001a:bYZ\u000bG.^3)\u0005%t\u0005\"B7\u0001\t\u0003a\u0014!\b;fgR$V/\u001c2mK~\u0003&o\u001c6fGRLwN\u001c)vg\"$un\u001e8)\u00051t\u0005\"\u00029\u0001\t\u0003a\u0014A\u0007;fgR$V/\u001c2mK~\u001b\u0015m]2bI&twmV5oI><\bFA8O\u0011\u0015\u0019\b\u0001\"\u0001=\u0003\u0011\"Xm\u001d;Uk6\u0014G.Z0DCN\u001c\u0017\rZ5oO^Kg\u000eZ8x?J+G.\u0019=G_Jl\u0007F\u0001:O\u0011\u00151\b\u0001\"\u0001=\u0003}!Xm\u001d;Uk6\u0014G.Z0ESN$\u0018N\\2u'Bd\u0017\u000e^#oC\ndW\r\u001a\u0015\u0003k:CQ!\u001f\u0001\u0005\u0002q\n!\u0005^3tiR+XN\u00197f?\u0012K7\u000f^5oGR|enV5oI><8i\u001c7v[:\u001c\bF\u0001=O\u0011\u0015a\b\u0001\"\u0001=\u0003%\"Xm\u001d;Uk6\u0014G.Z0E_:{Go\u00159mSR\u0004&o\\2fgNLgn\u001a+j[\u0016<\u0016N\u001c3po\"\u00121P\u0014\u0005\u0006\u007f\u0002!\t\u0001P\u0001\"i\u0016\u001cH\u000fV;nE2,wLT8u\u001fV$\b/\u001e;XS:$wn^\"pYVlgn\u001d\u0015\u0003}:Ca!!\u0002\u0001\t\u0003a\u0014a\u0007;fgR$V/\u001c2mK~+F-\u00194XSRDw.\u001e;NKJ<W\rK\u0002\u0002\u00049Ca!a\u0003\u0001\t\u0003a\u0014A\u0006;fgR\u001cU/\\;mCR,wl\u00148S_^$\u0018.\\3)\u0007\u0005%a\n\u0003\u0004\u0002\u0012\u0001!\t\u0001P\u0001$i\u0016\u001cHoQ;nk2\fG/Z0P]J{w\u000f^5nK^KG\u000f[\"E\u0007N{WO]2fQ\r\tyA\u0014\u0005\u0007\u0003/\u0001A\u0011\u0001\u001f\u0002/Q,7\u000f^\"v[Vd\u0017\r^3`\u001f:\u0004&o\\2uS6,\u0007fAA\u000b\u001d\"1\u0011Q\u0004\u0001\u0005\u0002q\nA\u0005^3ti\u000e+X.\u001e7bi\u0016|vJ\u001c)s_\u000e$\u0018.\\3XSRD7\tR\"T_V\u00148-\u001a\u0015\u0004\u00037q\u0005BBA\u0012\u0001\u0011\u0005A(A\u0011uKN$8)^7vY\u0006$Xm\u0018#jgRLgn\u0019;Ta2LG/\u00128bE2,G\rK\u0002\u0002\"9Ca!!\u000b\u0001\t\u0003a\u0014!\u0005;fgRDu\u000e]0P]J{w\u000f^5nK\"\u001a\u0011q\u0005(\t\r\u0005=\u0002\u0001\"\u0001=\u0003y!Xm\u001d;I_B|vJ\u001c*poRLW.Z,ji\"\u001cEiQ*pkJ\u001cW\rK\u0002\u0002.9Ca!!\u000e\u0001\t\u0003a\u0014A\u0005;fgRDu\u000e]0P]B\u0013xn\u0019;j[\u0016D3!a\rO\u0011\u0019\tY\u0004\u0001C\u0001y\u0005yB/Z:u\u0011>\u0004xl\u00148Qe>\u001cG/[7f/&$\bn\u0011#D'>,(oY3)\u0007\u0005eb\n\u0003\u0004\u0002B\u0001!\t\u0001P\u0001\u001di\u0016\u001cH\u000fS8q?\u0012K7\u000f^5oGR\u001c\u0006\u000f\\5u\u000b:\f'\r\\3eQ\r\tyD\u0014\u0005\u0007\u0003\u000f\u0002A\u0011\u0001\u001f\u0002IQ,7\u000f^'vYRL\u0007\u000f\\3BO\u001e\u0014XmZ1uK>s7+Y7f/&tGm\\<U-\u001aC3!!\u0012O\u0011\u0019\ti\u0005\u0001C\u0001y\u0005QC/Z:u\u0007\u0006tG/T3sO\u0016<\u0016N\u001c3poR3fi\u0018$jYR,'o\u00148XS:$wn^*uCJ$\bfAA&\u001d\"1\u00111\u000b\u0001\u0005\u0002q\na\u0005^3ti\u000e\u000bg\u000e^'fe\u001e,w+\u001b8e_^$fKR0VIR4wJ\\,j]\u0012|w\u000f\u0016,GQ\r\t\tF\u0014\u0005\u0007\u00033\u0002A\u0011\u0001\u001f\u0002[Q,7\u000f^\"b]R$&/\u00198tY\u0006$X\rV8XS:$wn^!hO~;%o\\;q\u001f:|e\u000e\\=Ti\u0006\u0014H\u000fK\u0002\u0002X9Ca!a\u0018\u0001\t\u0003a\u0014\u0001\r;fgR\u001c\u0015M\u001c;Ue\u0006t7\u000f\\1uKR{w+\u001b8e_^\fumZ0QsRDwN\\!hOJ,w-\u0019;f\u0007\u0006dG\u000eK\u0002\u0002^9Ca!!\u001a\u0001\t\u0003a\u0014A\t;fgR,fn];qa>\u0014H/\u001a3Fq\u000e,\u0007\u000f^5p]~+\u0015M\u001d7z\r&\u0014X\rK\u0002\u0002d9Ca!a\u001b\u0001\t\u0003a\u0014!\t;fgR,fn];qa>\u0014H/\u001a3Fq\u000e,\u0007\u000f^5p]~c\u0015\r^3GSJ,\u0007fAA5\u001d\"1\u0011\u0011\u000f\u0001\u0005\u0002q\nA\u0006^3tiVs7/\u001e9q_J$X\rZ#yG\u0016\u0004H/[8o?\"{\u0007oU5{K:{g\u000eR5wSNL'\r\\3)\u0007\u0005=d\n\u0003\u0004\u0002x\u0001!\t\u0001P\u00012i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fI\u0016C8-\u001a9uS>twlQ;nk2\fG/Z*ju\u0016tuN\u001c#jm&\u001c\u0018N\u00197fQ\r\t)H\u0014\u0005\u0007\u0003{\u0002A\u0011\u0001\u001f\u0002}Q,7\u000f^\"b]R$&/\u00198tY\u0006$X\rV8XS:$wn^!hO~;%o\\;qS:<7+\u001a;t/&$\bn\\;u/&tGm\\<Ti\u0006\u0014H/\u00128eQ\r\tYH\u0014\u0005\u0007\u0003\u0007\u0003A\u0011\u0001\u001f\u0002yQ,7\u000f^\"b]R$&/\u00198tY\u0006$X\rV8XS:$wn^!hO~;%o\\;qS:<7+\u001a;t\u001f:d\u0017pV5uQ^Kg\u000eZ8x'R\f'\u000f\u001e\u0015\u0004\u0003\u0003s\u0005BBAE\u0001\u0011\u0005A(A\fuKN$H+^7cY\u0016|vI]8va&twmU3ug\"\u001a\u0011q\u0011(\t\r\u0005=\u0005\u0001\"\u0001=\u0003a!Xm\u001d;Uk6\u0014G.Z0He>,\b/\u001b8h'\u0016$8/\r\u0015\u0004\u0003\u001bs\u0005BBAK\u0001\u0011\u0005A(A\u0016uKN$H+^7cY\u0016|vI]8va&twmU3ug\u0012K7\u000f^5oGR\u001c\u0006\u000f\\5u\u000b:\f'\r\\3eQ\r\t\u0019J\u0014\u0005\u0007\u00037\u0003A\u0011\u0001\u001f\u0002mQ,7\u000f^\"b]R$&/\u00198tY\u0006$X\rV8XS:$wn^!hO~\u001bUOY3XSRDw.\u001e;XS:$wn^*uCJ$XI\u001c3)\u0007\u0005ee\n\u0003\u0004\u0002\"\u0002!\t\u0001P\u00019i\u0016\u001cHoQ1oiR\u0013\u0018M\\:mCR,Gk\\,j]\u0012|w/Q4h?J{G\u000e\\;q/&$\bn\\;u/&tGm\\<Ti\u0006\u0014H/\u00128eQ\r\tyJ\u0014\u0005\u0007\u0003O\u0003A\u0011\u0001\u001f\u0002#Q,7\u000f\u001e+v[\ndWm\u0018*pY2,\b\u000fK\u0002\u0002&:Ca!!,\u0001\t\u0003a\u0014A\u000f;fgR\u001c\u0015M\u001c;NKJ<WmV5oI><HK\u0016$`\u000fJ|W\u000f]5oON+Go\u001d#jgRLgn\u0019;P]^Kg\u000eZ8x\u0007>dW/\u001c8tQ\r\tYK\u0014\u0005\u0007\u0003g\u0003A\u0011\u0001\u001f\u0002)Q,7\u000f\u001e%pa~;%o\\;qS:<7+\u001a;tQ\r\t\tL\u0014\u0005\u0007\u0003s\u0003A\u0011\u0001\u001f\u0002SQ,7\u000f\u001e%pa~;%o\\;qS:<7+\u001a;t?\u0012K7\u000f^5oGR\u001c\u0006\u000f\\5u\u000b:\f'\r\\3eQ\r\t9L\u0014\u0005\u0007\u0003\u007f\u0003A\u0011\u0001\u001f\u0002\u0019Q,7\u000f\u001e%pa~\u001bUOY3)\u0007\u0005uf\n\u0003\u0004\u0002F\u0002!\t\u0001P\u0001\u000fi\u0016\u001cH\u000fS8q?J{G\u000e\\;qQ\r\t\u0019M\u0014\u0005\u0007\u0003\u0017\u0004A\u0011\u0001\u001f\u00023Q,7\u000f^\"v[Vd\u0017\r^3`\u000fJ|W\u000f]5oON+Go\u001d\u0015\u0004\u0003\u0013t\u0005BBAi\u0001\u0011\u0005A(\u0001\u0018uKN$8)^7vY\u0006$XmX$s_V\u0004\u0018N\\4TKR\u001cx\fR5ti&t7\r^*qY&$XI\\1cY\u0016$\u0007fAAh\u001d\"1\u0011q\u001b\u0001\u0005\u0002q\n\u0011\u0003^3ti\u000e+X.\u001e7bi\u0016|6)\u001e2fQ\r\t)N\u0014\u0005\u0007\u0003;\u0004A\u0011\u0001\u001f\u0002'Q,7\u000f^\"v[Vd\u0017\r^3`%>dG.\u001e9)\u0007\u0005mg\n\u0003\u0004\u0002d\u0002!\t\u0001P\u0001\u0016i\u0016\u001cHOR5fY\u0012t\u0015-\\3D_:4G.[2uQ\r\t\tO\u0014\u0005\u0007\u0003S\u0004A\u0011\u0001\u001f\u00029Q,7\u000f\u001e)s_\u000e$\u0018.\\3XS:$wn^,ji\"4\u0015\u000e\u001c;fe\"\u001a\u0011q\u001d(\t\r\u0005=\b\u0001\"\u0001=\u0003=\"Xm\u001d;Uk6\u0014G.Z0DCN\u001c\u0017\rZ5oO^Kg\u000eZ8x?>s\u0017J\u001c3jm&$W/\u00197Qe>\u001cG/[7fQ\r\tiO\u0014\u0005\u0007\u0003k\u0004A\u0011\u0001\u001f\u0002YQ,7\u000f\u001e+v[\ndWmX\"bg\u000e\fG-\u001b8h/&tGm\\<`\u001f:Le\u000e[3sSR\u0004&o\\2uS6,\u0007fAAz\u001d\"1\u00111 \u0001\u0005\u0002q\n\u0011\u0006^3ti&sg/\u00197jIJ+G.\u0019=G_Jl7)Y:dC\u0012,\u0007K]8di&lWmV5oI><\bfAA}\u001d\"1!\u0011\u0001\u0001\u0005\u0002q\nQ\u0006^3tiR+XN\u00197f?\u000e\u000b7oY1eKB\u0013xn\u0019;j[\u0016<\u0016N\u001c3po~{enV5oI><(+\u00198lQ\r\tyP\u0014\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0003a\u0019'/Z1uKB\u0013xn\u0019;j[\u0016<\u0016N\u001c3poR{\u0007O\u0014\u000b\u0006{\t-!Q\u0005\u0005\t\u0005\u001b\u0011)\u00011\u0001\u0003\u0010\u0005Aa/[3x\u001d\u0006lW\r\u0005\u0003\u0003\u0012\t}a\u0002\u0002B\n\u00057\u00012A!\u00065\u001b\t\u00119BC\u0002\u0003\u001aQ\ta\u0001\u0010:p_Rt\u0014b\u0001B\u000fi\u00051\u0001K]3eK\u001aLAA!\t\u0003$\t11\u000b\u001e:j]\u001eT1A!\b5\u0011!\u00119C!\u0002A\u0002\t%\u0012A\u0002;pa:+X\u000eE\u00024\u0005WI1A!\f5\u0005\rIe\u000e\u001e\u0005\u0007\u0005c\u0001A\u0011\u0001\u001f\u0002mQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fY\u0006Dhi\u001c:n\u0007\u0006\u001c8-\u00193f!J|7\r^5nK^Kg\u000eZ8x?>sw+\u001b8e_^\u0014\u0016M\\6)\u0007\t=b\n\u0003\u0004\u00038\u0001!\t\u0001P\u0001/i\u0016\u001cH\u000fV;nE2,wlQ1tG\u0006$W\r\u0015:pGRLW.Z,j]\u0012|woX(o/&tGm\\<EK\u0012,\b\u000fK\u0002\u000369CaA!\u0010\u0001\t\u0003a\u0014a\u000e;fgRLeN^1mS\u0012\u0014V\r\\1y\r>\u0014XnQ1tG\u0006$W\r\u0015:pGRLW.Z,j]\u0012|woX(o/&tGm\\<EK\u0012,\b\u000fK\u0002\u0003<9CaAa\u0011\u0001\t\u0003a\u0014!\f;fgR$V/\u001c2mK~\u001b\u0015m]2bI\u0016\u0004&o\\2uS6,w+\u001b8e_^|vJ\\,j]\u0012|wOS8j]\"\u001a!\u0011\t(\t\r\t%\u0003\u0001\"\u0003=\u0003A\u0019'/Z1uK^Kg\u000eZ8x\u0015>Lg\u000e\u0003\u0004\u0003N\u0001!\t\u0001P\u00017i\u0016\u001cH/\u00138wC2LGMU3mCb4uN]7DCN\u001c\u0017\rZ3Qe>\u001cG/[7f/&tGm\\<`\u001f:<\u0016N\u001c3po*{\u0017N\u001c\u0015\u0004\u0005\u0017r\u0005B\u0002B*\u0001\u0011\u0005A(A\u000buKN$8+Z:tS>twl\u00148S_^$\u0018.\\3)\u0007\tEc\n\u0003\u0004\u0003Z\u0001!\t\u0001P\u0001\u0017i\u0016\u001cHoU3tg&|gnX(o!J|7\r^5nK\"\u001a!q\u000b(\t\r\t}\u0003\u0001\"\u0001=\u0003\u0001\"Xm\u001d;TKN\u001c\u0018n\u001c8`\t&\u001cH/\u001b8diN\u0003H.\u001b;F]\u0006\u0014G.\u001a3)\u0007\tuc\n\u0003\u0004\u0003f\u0001!\t\u0001P\u0001&i\u0016\u001cHoU3tg&|gnV5oI><x+\u001b;i)^|\u0007+\u0019:uSRLwN\\&fsND3Aa\u0019O\u0011\u0019\u0011Y\u0007\u0001C\u0001y\u0005yC/Z:u\u000fJ|W\u000f]&fs6{'/\u001a+iC:\u0004\u0016M\u001d;ji&|gnS3z\u0013:\u001cVm]:j_:<\u0016N\u001c3po\"\u001a!\u0011\u000e(\t\r\tE\u0004\u0001\"\u0001=\u0003=\"Xm\u001d;He>,\boS3z\u0019\u0016\u001c8\u000f\u00165b]B\u000b'\u000f^5uS>t7*Z=J]N+7o]5p]^Kg\u000eZ8xQ\r\u0011yG\u0014\u0005\u0007\u0005o\u0002A\u0011\u0001\u001f\u0002iQ,7\u000f\u001e#faJ,7-\u0019;fINKh\u000e^1y\u0003\n|W\u000f\u001e)beRLG/[8o\u0017\u0016L\u0018J\\*fgNLwN\\,j]\u0012|w\u000fK\u0002\u0003v9CaA! \u0001\t\u0003a\u0014A\u000b;fgR<%o\\;q\u0017\u0016L8/\u00138eS\u000e,7o\u00115b]\u001e,7/\u00138TKN\u001c\u0018n\u001c8XS:$wn\u001e\u0015\u0004\u0005wr\u0005B\u0002BB\u0001\u0011\u0005A(A\u0019uKN$8+Z:tS>tw+\u001b8e_^$fKR,ji\"\u0004\u0016M\u001d;ji&|gnS3z/\",gnQ1oi6+'oZ3)\u0007\t\u0005e\n\u0003\u0004\u0003\n\u0002!\t\u0001P\u00015i\u0016\u001cHoU3tg&|gnV5oI><HK\u0016$XSRDw.\u001e;QCJ$\u0018\u000e^5p].+\u0017p\u00165f]\u000e\u000bg\u000e^'fe\u001e,\u0007f\u0001BD\u001d\":\u0001Aa$\u0003\u001c\nu\u0005\u0003\u0002BI\u0005/k!Aa%\u000b\u0007\tU5)A\u0005fqR,gn]5p]&!!\u0011\u0014BJ\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0005?\u001b#A!)\u0011\t\t\r&1W\u0007\u0003\u0005KSAAa*\u0003*\u0006i\u0001/\u0019:b[\u0016$XM]5{K\u0012TAAa+\u0003.\u0006QQ\r\u001f;f]NLwN\\:\u000b\u0007!\u0013yKC\u0002\u00032:\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\tU&Q\u0015\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0004\b\u0005s\u0013\u0001\u0012\u0001B^\u0003M9\u0016N\u001c3po\u0006;wM]3hCR,G+Z:u!\r)#Q\u0018\u0004\u0007\u0003\tA\tAa0\u0014\t\tu&\u0011\u0019\t\u0004g\t\r\u0017b\u0001Bci\t1\u0011I\\=SK\u001aDqA\tB_\t\u0003\u0011I\r\u0006\u0002\u0003<\"A!Q\u001aB_\t\u0003\u0011y-\u0001\u0006qCJ\fW.\u001a;feN$\"A!5\u0011\r\tM'1\u001cBp\u001b\t\u0011)NC\u0002)\u0005/T!A!7\u0002\t)\fg/Y\u0005\u0005\u0005;\u0014)N\u0001\u0006D_2dWm\u0019;j_:\u0004Ra\rBq\u0005KL1Aa95\u0005\u0015\t%O]1z!\r\u0019$q]\u0005\u0004\u0005S$$aA!os\"B!1\u001aBw\u0005g\u0014)\u0010\u0005\u0003\u0003$\n=\u0018\u0002\u0002By\u0005K\u0013!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\t]\u0018\u0001F1hOBC\u0017m]3F]\u001a|'oY3s{m\u0004T\u0010")
public class WindowAggregateTest
extends TableTestBase {
    private final AggregatePhaseStrategy aggPhaseEnforcer;
    private final StreamTableTestUtil util;
    private final boolean isTwoPhase;

    @Parameters(name="aggPhaseEnforcer={0}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateTest$.MODULE$.parameters();
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    private boolean isTwoPhase() {
        return this.isTwoPhase;
    }

    @BeforeEach
    public void before() {
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().addTemporarySystemFunction("weightedAvgWithoutMerge", JavaUserDefinedAggFunctions.WeightedAvg.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyCDCTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values',\n                                |  'changelog-mode' = 'I,UA,UB,D'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW proctime_win AS\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start as ws,\n        |   window_end as we,\n        |   window_time as wt,\n        |   proctime() as new_proctime,\n        |   count(*) as cnt,\n        |   sum(d) as sum_d,\n        |   max(d) as max_d\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end, window_time, b\n      ")).stripMargin());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggPhaseEnforcer.toString());
    }

    @TestTemplate
    public void testTumble_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_OnRowtimeWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyCDCTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testTumble_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_OnProctimeWithCDCSource() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyCDCTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testTumble_CalcOnTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE b > 1000\n        |)\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_WindowColumnsAtEnd() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv,\n        |   window_start,\n        |   window_end\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupMultipleWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   ws,\n        |   window_end,\n        |   window_time,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT *, window_start as ws\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |GROUP BY a, window_start, window_end, ws, window_time\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupMultipleKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, a, window_end, b\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupOnlyWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupOnLiteralValue() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY 'literal', window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_ProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d)\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_CascadingWindow() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW window1 AS\n        |SELECT\n        |   a,\n        |   b,\n        |   window_time as rowtime,\n        |   count(*) as cnt,\n        |   sum(d) as sum_d,\n        |   max(d) as max_d\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end, window_time, b\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  sum(cnt),\n        |  sum(sum_d),\n        |  max(max_d)\n        |FROM TABLE(TUMBLE(TABLE window1, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_CascadingWindow_RelaxForm() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |  FROM\n        |  (\n        |    SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    COUNT(DISTINCT c) AS cnt\n        |    FROM TABLE(\n        |      TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '1' DAY, INTERVAL '8' HOUR))\n        |    GROUP BY a, b, window_start, window_end\n        |) GROUP BY a, window_start, window_end\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_DistinctOnWindowColumns() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct window_time) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_DoNotSplitProcessingTimeWindow() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_NotOutputWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_UdafWithoutMerge() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvgWithoutMerge(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_OnRowtimeWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyCDCTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testCumulate_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_OnProctimeWithCDCSource() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyCDCTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testCumulate_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_OnRowtimeWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyCDCTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testHop_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_OnProctimeWithCDCSource() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyCDCTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testHop_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testMultipleAggregateOnSameWindowTVF() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tvf AS\n        |SELECT * FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin());
        StatementSet statementSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE s1 (\n                               |  wstart TIMESTAMP(3),\n                               |  wend TIMESTAMP(3),\n                               |  `result` BIGINT\n                               |) WITH (\n                               |  'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO s1\n                                |SELECT\n                                |   window_start,\n                                |   window_end,\n                                |   weightedAvg(b, e) AS wAvg\n                                |FROM tvf\n                                |GROUP BY window_start, window_end\n                                |")).stripMargin());
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO s1\n                                |SELECT\n                                |   window_start,\n                                |   window_end,\n                                |   count(*)\n                                |FROM tvf\n                                |GROUP BY window_start, window_end\n                                |")).stripMargin());
        this.util().verifyExecPlan(statementSet);
    }

    @TestTemplate
    public void testCantMergeWindowTVF_FilterOnWindowStart() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE window_start >= TIMESTAMP '2021-01-01 10:10:00.000'\n        |)\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantMergeWindowTVF_UdtfOnWindowTVF() {
        this.util().tableEnv().createTemporaryFunction("len_udtf", JavaUserDefinedTableFunctions.JavaTableFunc1.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(len),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE)),\n        |  LATERAL TABLE(len_udtf(c)) AS T(len)\n        |)\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_GroupOnOnlyStart() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_PythonAggregateCall() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        this.util().tableEnv().createTemporaryFunction("python_agg", JavaUserDefinedAggFunctions.TestPythonAggregateFunction.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   python_agg(1, 1)\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testUnsupportedException_EarlyFire() {
        Configuration conf = new Configuration();
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED().key(), "true");
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY().key(), "5s");
        this.util().tableEnv().getConfig().addConfiguration(conf);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Currently, window table function based aggregate doesn't support early-fire and late-fire configuration 'table.exec.emit.early-fire.enabled' and 'table.exec.emit.late-fire.enabled'.") instanceof TableException;
    }

    @TestTemplate
    public void testUnsupportedException_LateFire() {
        Configuration conf = new Configuration();
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED().key(), "true");
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY().key(), "5s");
        this.util().tableEnv().getConfig().addConfiguration(conf);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Currently, window table function based aggregate doesn't support early-fire and late-fire configuration 'table.exec.emit.early-fire.enabled' and 'table.exec.emit.late-fire.enabled'.") instanceof TableException;
    }

    @TestTemplate
    public void testUnsupportedException_HopSizeNonDivisible() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*)\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '4' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("HOP table function based aggregate requires size must be an integral multiple of slide, but got size 600000 ms and slide 240000 ms") instanceof TableException;
    }

    @TestTemplate
    public void testUnsupportedException_CumulateSizeNonDivisible() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*)\n        |FROM TABLE(\n        |   CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '25' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("CUMULATE table function based aggregate requires maxSize must be an integral multiple of step, but got maxSize 3600000 ms and step 1500000 ms") instanceof TableException;
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_GroupingSetsWithoutWindowStartEnd() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (window_start), (window_end))\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_GroupingSetsOnlyWithWindowStart() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a, window_start), (window_start))\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a, window_start, window_end), (b, window_start, window_end))\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupingSets1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupingSetsDistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_CubeWithoutWindowStartEnd() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY CUBE (a, b, window_start, window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_RollupWithoutWindowStartEnd() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY ROLLUP (a, b, window_start, window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY ROLLUP (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantMergeWindowTVF_GroupingSetsDistinctOnWindowColumns() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct window_time) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_GroupingSets_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY CUBE (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY ROLLUP (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '25' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_GroupingSets_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY CUBE (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY ROLLUP (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testFieldNameConflict() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_time,\n        |  MIN(rowtime) as start_time,\n        |  MAX(rowtime) as end_time\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end, window_time\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testProctimeWindowWithFilter() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TEMPORARY TABLE source (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d BIGINT,\n                                |  proctime as PROCTIME()\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TEMPORARY TABLE sink(\n                               |    ws TIMESTAMP,\n                               |    we TIMESTAMP,\n                               |    b bigint,\n                               |    c bigint\n                               |)\n                               |WITH (\n                               |    'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |    select\n        |        window_start,\n        |        window_end,\n        |        b,\n        |        COALESCE(sum(case\n        |            when a = 11\n        |            then 1\n        |        end), 0) c\n        |    from\n        |        TABLE(\n        |            TUMBLE(TABLE source, DESCRIPTOR(proctime), INTERVAL '10' SECONDS)\n        |        )\n        |    where\n        |        a in (1, 5, 7, 9, 11)\n        |    GROUP BY\n        |        window_start, window_end, b\n        |")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadingWindow_OnIndividualProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  sum(cnt),\n        |  count(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_win, DESCRIPTOR(new_proctime), INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n        |")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadingWindow_OnInheritProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  sum(cnt),\n        |  count(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_win, DESCRIPTOR(wt), INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n        |")).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM proctime_win\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadeProctimeWindow_OnWindowRank() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_winrank", 10);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_winrank, DESCRIPTOR(new_proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin());
    }

    private void createProctimeWindowTopN(String viewName, int topNum) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(474).append("\n         |CREATE VIEW ").append(viewName).append(" AS\n         |SELECT *\n         |FROM(\n         | SELECT\n         |    a,\n         |    b,\n         |    window_start as ws,\n         |    window_end as we,\n         |    window_time as wt,\n         |    proctime() as new_proctime,\n         |    ROW_NUMBER() OVER (PARTITION BY window_start, window_end ORDER BY proctime DESC) AS rn\n         | FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n         |) WHERE rn <= ").append(topNum).append("\n     ").toString())).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow_OnWindowRank() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_winrank", 10);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM proctime_winrank\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadeProctimeWindow_OnWindowDedup() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_windedup", 1);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_windedup, DESCRIPTOR(new_proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n  ")).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow_OnWindowDedup() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_windedup", 1);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM proctime_windedup\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadeProctimeWindow_OnWindowJoin() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createWindowJoin();
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM TABLE(TUMBLE(TABLE win_join, DESCRIPTOR(new_proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin());
    }

    private void createWindowJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW proctime_window AS\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start,\n        |   window_end\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n    ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW win_join AS\n        |SELECT\n        |   w1.a as a,\n        |   w1.b as b,\n        |   COALESCE(w1.window_start, w2.window_start) as ws,\n        |   COALESCE(w1.window_end, w2.window_end) as we,\n        |   proctime() as new_proctime\n        |FROM proctime_window w1 join proctime_window w2\n        |ON w1.window_start = w2.window_start AND w1.window_end = w2.window_end\n    ")).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow_OnWindowJoin() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createWindowJoin();
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM win_join\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testSession_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSession_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSession_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, true);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSessionWindowWithTwoPartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY (b, a), DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY b, a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testGroupKeyMoreThanPartitionKeyInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testGroupKeyLessThanPartitionKeyInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY (b, a), DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY b, window_start, window_end\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testDeprecatedSyntaxAboutPartitionKeyInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable, DESCRIPTOR(proctime), DESCRIPTOR(a), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Invalid number of arguments to function 'SESSION'. Was expecting 3 arguments") instanceof ValidationException;
    }

    @TestTemplate
    public void testGroupKeysIndicesChangesInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   a\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable partition by a, DESCRIPTOR(proctime), INTERVAL '10' MINUTE))\n        |GROUP BY window_start, window_end, a\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testSessionWindowTVFWithPartitionKeyWhenCantMerge() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   a,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |  WHERE window_start >= TIMESTAMP '2021-01-01 10:10:00.000'\n        |)\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSessionWindowTVFWithoutPartitionKeyWhenCantMerge() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(SESSION(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |  WHERE window_start >= TIMESTAMP '2021-01-01 10:10:00.000'\n        |)\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public WindowAggregateTest(AggregatePhaseStrategy aggPhaseEnforcer) {
        this.aggPhaseEnforcer = aggPhaseEnforcer;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        AggregatePhaseStrategy aggregatePhaseStrategy = aggPhaseEnforcer;
        AggregatePhaseStrategy aggregatePhaseStrategy2 = AggregatePhaseStrategy.TWO_PHASE;
        this.isTwoPhase = !(aggregatePhaseStrategy != null ? !aggregatePhaseStrategy.equals(aggregatePhaseStrategy2) : aggregatePhaseStrategy2 != null);
    }
}

