/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.nodes.exec.spec.IntervalJoinSpec;
import org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001U\u0011\u0001#\u00138uKJ4\u0018\r\u001c&pS:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T!!\u0003\u0006\u0002\tAd\u0017M\u001c\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"BA\r\u000b\u0003\u0015)H/\u001b7t\u0013\tY\u0002DA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAqA\t\u0001C\u0002\u0013%1%\u0001\u0003vi&dW#\u0001\u0013\u0011\u0005])\u0013B\u0001\u0014\u0019\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019A\u0003\u0001)A\u0005I\u0005)Q\u000f^5mA!)!\u0006\u0001C\u0001W\u0005\u0019C/Z:u\u0013:$XM]1wY*{\u0017N\\*j]\u001edW\rV5nK\u000e{g\u000eZ5uS>tG#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003SM\u0002\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\u0007\u0005\u0004\u0018N\u0003\u00029s\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001e\u0013\u0003\u0015QWO\\5u\u0013\taTG\u0001\u0003UKN$\b\"\u0002 \u0001\t\u0003Y\u0013A\b;fgRLe\u000e^3sCZ\fG\u000eR5gMRKW.Z%oI&\u001c\u0017\r^8sQ\ti4\u0007C\u0003B\u0001\u0011\u00051&A\u0011uKN$\u0018J\u001c;feZ\fGNS8j]>sG)\u001b4g%><H+[7f)f\u0004X\r\u000b\u0002Ag!)A\t\u0001C\u0001W\u0005aB/Z:u\u0013:$XM]1wC2tu\u000e^\"oM\u000e{g\u000eZ5uS>t\u0007FA\"4\u0011\u00159\u0005\u0001\"\u0001,\u0003y!Xm\u001d;O_J{w\u000f^5nK\u0006#HO]5ckR,\u0017J\u001c*fgVdG\u000f\u000b\u0002Gg!)!\n\u0001C\u0001W\u0005\u0001D/Z:u/&tGm\\<PkR,'OS8j]^KG\u000f\u001b)zi\"|gNR;oGRLwN\\%o\u0007>tG-\u001b;j_:D#!S\u001a\t\u000b5\u0003A\u0011A\u0016\u0002OQ,7\u000f\u001e)s_\u000e,7o]5oORKW.Z%o]\u0016\u0014(j\\5o/&$\bn\u00148DY\u0006,8/\u001a\u0015\u0003\u0019NBQ\u0001\u0015\u0001\u0005\u0002-\n!\u0006^3tiB\u0013xnY3tg&tw\rV5nK&sg.\u001a:K_&tw+\u001b;i/\",'/Z\"mCV\u001cX\r\u000b\u0002Pg!)1\u000b\u0001C\u0001W\u0005\u0001D/Z:u!J|7-Z:tS:<G+[7f\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5pkR,\u0015/^1m\u0007>tG-\u001b;j_:D#AU\u001a\t\u000bY\u0003A\u0011A\u0016\u0002AQ,7\u000f\u001e*poRKW.Z%o]\u0016\u0014(j\\5o/&$\bn\u00148DY\u0006,8/\u001a\u0015\u0003+NBQ!\u0017\u0001\u0005\u0002-\nQ\u0005^3ti&sG/\u001a:wC2Tu.\u001b8P]RKW.Z:uC6\u0004H\n\u001e>S_^$\u0018.\\3)\u0005a\u001b\u0004\"\u0002/\u0001\t\u0003Y\u0013!\u000b;fgR\u0014vn\u001e+j[\u0016LeN\\3s\u0015>LgnV5uQ>,H/R9vC2\u001cuN\u001c3ji&|g\u000e\u000b\u0002\\g!)q\f\u0001C\u0001W\u0005\u0019C/Z:u%><H+[7f\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5XQ\u0016\u0014Xm\u00117bkN,\u0007F\u000104\u0011\u0015\u0011\u0007\u0001\"\u0001,\u0003a!Xm\u001d;K_&tw+\u001b;i\u000bF,\u0018\u000e\u0015:pGRKW.\u001a\u0015\u0003CNBQ!\u001a\u0001\u0005\u0002-\nq\u0003^3ti*{\u0017N\\,ji\",\u0015/^5S_^$\u0016.\\3)\u0005\u0011\u001c\u0004\"\u00025\u0001\t\u0003Y\u0013a\u0006;fgRTu.\u001b8XSRDg*\u001e7m\u0019&$XM]1mQ\t97\u0007C\u0003l\u0001\u0011\u00051&A\u0018uKN$(k\\<US6,\u0017J\u001c8fe*{\u0017N\\!oI^Kg\u000eZ8x\u0003\u001e<'/Z4bi&|gn\u00148GSJ\u001cH\u000f\u000b\u0002kg!)a\u000e\u0001C\u0001W\u0005\u0001D/Z:u%><H+[7f\u0013:tWM\u001d&pS:\fe\u000eZ,j]\u0012|w/Q4he\u0016<\u0017\r^5p]>s7+Z2p]\u0012D#!\\\u001a\t\u000bE\u0004A\u0011A\u0016\u00023Q,7\u000f\u001e)s_\u000e$\u0016.\\3MK\u001a$x*\u001e;fe*{\u0017N\u001c\u0015\u0003aNBQ\u0001\u001e\u0001\u0005\u0002-\n\u0001\u0004^3tiJ{w\u000fV5nK2+g\r^(vi\u0016\u0014(j\\5oQ\t\u00198\u0007C\u0003x\u0001\u0011\u00051&\u0001\u000euKN$\bK]8d)&lWMU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002wg!)!\u0010\u0001C\u0001W\u0005IB/Z:u%><H+[7f%&<\u0007\u000e^(vi\u0016\u0014(j\\5oQ\tI8\u0007C\u0003~\u0001\u0011\u00051&A\ruKN$\bK]8d)&lWMR;mY>+H/\u001a:K_&t\u0007F\u0001?4\u0011\u0019\t\t\u0001\u0001C\u0001W\u0005AB/Z:u%><H+[7f\rVdGnT;uKJTu.\u001b8)\u0005}\u001c\u0004BBA\u0004\u0001\u0011\u00051&\u0001\tuKN$x*\u001e;fe*{\u0017N\\(qi\"\u001a\u0011QA\u001a\t\r\u00055\u0001\u0001\"\u0001,\u0003Q!Xm\u001d;K_&tG+[7f\u0005>,h\u000eZ1ss\"\u001a\u00111B\u001a\t\r\u0005M\u0001\u0001\"\u0001,\u0003y!Xm\u001d;K_&t'+Z7bS:\u001cuN\u001c3ji&|gnQ8om\u0016\u0014H\u000fK\u0002\u0002\u0012MBa!!\u0007\u0001\t\u0003Y\u0013!\u0007;fgR4\u0015\r\u001c7cC\u000e\\Gk\u001c*fOVd\u0017M\u001d&pS:D3!a\u00064\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\t!C^3sS\u001aLH+[7f\u0005>,h\u000eZ1ssRIA&a\t\u0002>\u0005\u001d\u00131\n\u0005\t\u0003K\ti\u00021\u0001\u0002(\u0005\u0001B/[7f\u0007>tG-\u001b;j_:\u001c\u0016\u000f\u001c\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017]5\u0011\u0011q\u0006\u0006\u0004\u0003c!\u0012A\u0002\u001fs_>$h(C\u0002\u000269\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001b]!A\u0011qHA\u000f\u0001\u0004\t\t%A\u0006fqBdUM\u001a;TSj,\u0007cA\u0017\u0002D%\u0019\u0011Q\t\u0018\u0003\t1{gn\u001a\u0005\t\u0003\u0013\ni\u00021\u0001\u0002B\u0005aQ\r\u001f9SS\u001eDGoU5{K\"A\u0011QJA\u000f\u0001\u0004\t9#A\u0006fqB$\u0016.\\3UsB,\u0007bBA)\u0001\u0011%\u00111K\u0001\u001dm\u0016\u0014\u0018NZ=SK6\f\u0017N\\\"p]\u0012LG/[8o\u0007>tg/\u001a:u)\u0015a\u0013QKA-\u0011!\t9&a\u0014A\u0002\u0005\u001d\u0012\u0001C:rYF+XM]=\t\u0011\u0005m\u0013q\na\u0001\u0003O\t!#\u001a=qK\u000e$8i\u001c8eSRLwN\\*ue\u0002")
public class IntervalJoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testInteravlJoinSingleTimeCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND t1.proctime > t2.proctime - INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInteravalDiffTimeIndicator() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime > t2.proctime - INTERVAL '5' SECOND AND\n        |  t1.proctime < t2.rowtime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testIntervalJoinOnDiffRowTimeType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable2 t1 JOIN MyTable3 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime > t2.rowtime - INTERVAL '5' SECOND AND\n        |  t1.rowtime < t2.rowtime + INTERVAL '5' SECOND\n      ")).stripMargin();
        Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Interval join with rowtime attribute requires same rowtime types, but the types are TIMESTAMP(3) *ROWTIME* and TIMESTAMP_LTZ(3) *ROWTIME*");
    }

    @Test
    public void testInteravalNotCnfCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  (t1.proctime > t2.proctime - INTERVAL '5' SECOND OR\n        |   t1.proctime < t2.rowtime + INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNoRowtimeAttributeInResult() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND t2.proctime\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sql));
    }

    @Test
    public void testWindowOuterJoinWithPythonFunctionInCondition() {
        this.util().addTemporarySystemFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |    t1.a = t2.a AND pyFunc(t1.a, t2.a) = t1.a + t2.a AND\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sql));
    }

    @Test
    public void testProcessingTimeInnerJoinWithOnClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |    t1.a = t2.a AND\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcessingTimeInnerJoinWithWhereClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |    t1.a = t2.a AND\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcessingTimeInnerJoinWithoutEqualCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinWithOnClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testIntervalJoinOnTimestampLtzRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable3 t1 JOIN MyTable4 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime > t2.rowtime - INTERVAL '5' SECOND AND\n        |  t1.rowtime < t2.rowtime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeInnerJoinWithoutEqualCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinWithWhereClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' MINUTE AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinWithEquiProcTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND t1.proctime = t2.proctime\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinWithEquiRowTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND t1.rowtime = t2.rowtime\n        ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinWithNullLiteral() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (SELECT a, b, c, proctime, CAST(null AS BIGINT) AS nullField FROM MyTable),\n        |     T2 AS (SELECT a, b, c, proctime, CAST(12 AS BIGINT) AS nullField FROM MyTable2)\n        |\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 AS t1\n        |JOIN T2 AS t2 ON t1.a = t2.a AND t1.nullField = t2.nullField AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND\n        |  t2.proctime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinAndWindowAggregationOnFirst() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.b, SUM(t2.a) AS aSum, COUNT(t2.b) AS bCnt\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' MINUTE AND t2.rowtime + INTERVAL '1' HOUR\n        |GROUP BY TUMBLE(t1.rowtime, INTERVAL '6' HOUR), t1.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinAndWindowAggregationOnSecond() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.b, SUM(t1.a) AS aSum, COUNT(t1.b) AS bCnt\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' MINUTE AND t2.rowtime + INTERVAL '1' HOUR\n        |GROUP BY TUMBLE(t2.rowtime, INTERVAL '6' HOUR), t2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 RIGHT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 RIGHT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 Full OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 FULL OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOuterJoinOpt() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 FULL OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n        |  WHERE t1.b LIKE t2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinTimeBoundary() {
        this.verifyTimeBoundary("t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR", -3600000L, 3600000L, "proctime");
        this.verifyTimeBoundary("t1.proctime > t2.proctime - INTERVAL '1' SECOND AND t1.proctime < t2.proctime + INTERVAL '1' SECOND", -999L, 999L, "proctime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime - INTERVAL '1' SECOND AND t1.rowtime <= t2.rowtime + INTERVAL '1' SECOND", -1000L, 1000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime AND t1.rowtime <= t2.rowtime + INTERVAL '1' SECOND", 0L, 1000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime + INTERVAL '1' SECOND AND t1.rowtime <= t2.rowtime + INTERVAL '10' SECOND", 1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t2.rowtime - INTERVAL '1' SECOND <= t1.rowtime AND t2.rowtime + INTERVAL '10' SECOND >= t1.rowtime", -1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime - INTERVAL '2' SECOND >= t2.rowtime + INTERVAL '1' SECOND - INTERVAL '10' SECOND AND t1.rowtime <= t2.rowtime + INTERVAL '10' SECOND", -7000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime - INTERVAL '10' SECOND AND t1.rowtime <= t2.rowtime - INTERVAL '5' SECOND", -10000L, -5000L, "rowtime");
    }

    @Test
    public void testJoinRemainConditionConvert() {
        this.util().addDataStream("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.c FROM MyTable3 AS t1 JOIN MyTable4 AS t2 ON\n        |    t1.a = t2.a AND\n        |    t1.rowtime >= t2.rowtime - INTERVAL '10' SECOND AND\n        |    t1.rowtime <= t2.rowtime - INTERVAL '5' SECOND AND\n        |    t1.c > t2.c\n      ")).stripMargin();
        this.verifyRemainConditionConvert(query, ">($2, $6)");
        String query1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.c FROM MyTable3 as t1 JOIN MyTable4 AS t2 ON\n        |    t1.a = t2.a AND\n        |    t1.rowtime >= t2.rowtime - INTERVAL '10' SECOND AND\n        |    t1.rowtime <= t2.rowtime - INTERVAL '5' SECOND\n      ")).stripMargin();
        this.verifyRemainConditionConvert(query1, "");
        this.util().addDataStream("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable6", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.c FROM MyTable5 AS t1 JOIN MyTable6 AS t2 ON\n        |    t1.a = t2.a AND\n        |    t1.proctime >= t2.proctime - INTERVAL '10' SECOND AND\n        |    t1.proctime <= t2.proctime - INTERVAL '5' SECOND AND\n        |    t1.c > t2.c\n      ")).stripMargin();
        this.verifyRemainConditionConvert(query2, ">($2, $6)");
    }

    @Test
    public void testFallbackToRegularJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a FROM MyTable t1 WHERE t1.a IN (\n        | SELECT t2.a FROM MyTable2 t2\n        |   WHERE t1.b = t2.b AND t1.rowtime between t2.rowtime and t2.rowtime + INTERVAL '5' MINUTE\n        |   GROUP BY t2.a\n        |)\n    ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    private void verifyTimeBoundary(String timeConditionSql, long expLeftSize, long expRightSize, String expTimeType) {
        Option windowBounds;
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n         |SELECT t1.a, t2.b FROM MyTable AS t1 JOIN MyTable2 AS t2 ON\n         |    t1.a = t2.a AND\n         |    ").append(timeConditionSql).append("\n      ").toString())).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(query);
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(table);
        LogicalJoin joinNode = (LogicalJoin)relNode.getInput(0);
        RexNode rexNode = joinNode.getCondition();
        Tuple2 tuple2 = IntervalJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(rexNode, joinNode.getLeft().getRowType().getFieldCount(), joinNode.getRowType(), joinNode.getCluster().getRexBuilder(), this.util().tableEnv().getConfig(), Thread.currentThread().getContextClassLoader());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = windowBounds = (Option)tuple2._1();
        Option windowBounds2 = option;
        String timeTypeStr = ((IntervalJoinSpec.WindowBounds)windowBounds2.get()).isEventTime() ? "rowtime" : "proctime";
        Assertions.assertThat((long)((IntervalJoinSpec.WindowBounds)windowBounds2.get()).getLeftLowerBound()).isEqualTo(expLeftSize);
        Assertions.assertThat((long)((IntervalJoinSpec.WindowBounds)windowBounds2.get()).getLeftUpperBound()).isEqualTo(expRightSize);
        Assertions.assertThat((String)timeTypeStr).isEqualTo(expTimeType);
    }

    private void verifyRemainConditionConvert(String sqlQuery, String expectConditionStr) {
        Option remainCondition;
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(table);
        LogicalJoin joinNode = (LogicalJoin)relNode.getInput(0);
        JoinInfo joinInfo = joinNode.analyzeCondition();
        RexNode rexNode = joinInfo.getRemaining(joinNode.getCluster().getRexBuilder());
        Tuple2 tuple2 = IntervalJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(rexNode, joinNode.getLeft().getRowType().getFieldCount(), joinNode.getRowType(), joinNode.getCluster().getRexBuilder(), this.util().tableEnv().getConfig(), Thread.currentThread().getContextClassLoader());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = remainCondition = (Option)tuple2._2();
        Option remainCondition2 = option;
        String actual = remainCondition2.getOrElse((Function0 & Serializable & scala.Serializable)() -> "").toString();
        Assertions.assertThat((String)actual).isEqualTo(expectConditionStr);
    }

    public IntervalJoinTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable3 (\n                              |  a int,\n                              |  b bigint,\n                              |  c string,\n                              |  rowtime as TO_TIMESTAMP_LTZ(b, 3),\n                              |  watermark for rowtime as rowtime\n                              |) WITH (\n                              |  'connector' = 'values',\n                              |  'bounded' = 'false'\n                              |)\n       ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable4 (\n                              |  a int,\n                              |  b bigint,\n                              |  c string,\n                              |  rowtime as TO_TIMESTAMP_LTZ(b, 3),\n                              |  watermark for rowtime as rowtime\n                              |) WITH (\n                              |  'connector' = 'values',\n                              |  'bounded' = 'false'\n                              |)\n       ")).stripMargin());
    }
}

