/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001U\u0011\u0001BS8j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0002\u0001\u0015!\u0003%\u0003\u0015)H/\u001b7!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003%\"Xm\u001d;EKB,g\u000eZ3oi\u000e{g\u000eZ5uS>tG)\u001a:jm\u0006$\u0018n\u001c8J]:,'OS8j]R\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bFA\u00154!\t!4(D\u00016\u0015\t1t'A\u0002ba&T!\u0001O\u001d\u0002\u000f),\b/\u001b;fe*\u0011!HE\u0001\u0006UVt\u0017\u000e^\u0005\u0003yU\u0012A\u0001V3ti\")a\b\u0001C\u0001W\u0005\tD/Z:u\t\u0016\u0004XM\u001c3f]R\u001cuN\u001c3ji&|g\u000eR3sSZ\fG/[8o\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5UeV,\u0007FA\u001f4\u0011\u0015\t\u0005\u0001\"\u0001,\u0003E\"Xm\u001d;EKB,g\u000eZ3oi\u000e{g\u000eZ5uS>tG)\u001a:jm\u0006$\u0018n\u001c8J]:,'OS8j]^KG\u000f\u001b(vY2D#\u0001Q\u001a\t\u000b\u0011\u0003A\u0011A\u0016\u0002\u001bQ,7\u000f^%o]\u0016\u0014(j\\5oQ\t\u00195\u0007C\u0003H\u0001\u0011\u00051&\u0001\ruKN$\u0018J\u001c8fe*{\u0017N\\,ji\",\u0015/^1m!.D#AR\u001a\t\u000b)\u0003A\u0011A\u0016\u0002'Q,7\u000f^%o]\u0016\u0014(j\\5o/&$\b\u000eU6)\u0005%\u001b\u0004\"B'\u0001\t\u0003Y\u0013a\u0005;fgRdUM\u001a;K_&tgj\u001c8FcVL\u0007F\u0001'4\u0011\u0015\u0001\u0006\u0001\"\u0001,\u0003y!Xm\u001d;MK\u001a$(j\\5o/&$\b.R9vC2\u00046NT8o\u000bF,\u0018\u000e\u000b\u0002Pg!)1\u000b\u0001C\u0001W\u0005\tC/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b*jO\"$hj\u001c;QW:{g.R9vS\"\u0012!k\r\u0005\u0006-\u0002!\taK\u0001\u001ai\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\"\u00046NT8o\u000bF,\u0018\u000e\u000b\u0002Vg!)\u0011\f\u0001C\u0001W\u0005aA/Z:u\u0019\u00164GOS8j]\"\u0012\u0001l\r\u0005\u00069\u0002!\taK\u0001\u0018i\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\",\u0015/^1m!.D#aW\u001a\t\u000b}\u0003A\u0011A\u0016\u00025Q,7\u000f\u001e'fMRTu.\u001b8XSRD'+[4ii:{G\u000fU6)\u0005y\u001b\u0004\"\u00022\u0001\t\u0003Y\u0013A\u0005;fgRdUM\u001a;K_&tw+\u001b;i!.D#!Y\u001a\t\u000b\u0015\u0004A\u0011A\u0016\u0002)Q,7\u000f\u001e*jO\"$(j\\5o\u001d>tW)];jQ\t!7\u0007C\u0003i\u0001\u0011\u00051&A\u0010uKN$(+[4ii*{\u0017N\\,ji\",\u0015/^1m!.tuN\\#rk&D#aZ\u001a\t\u000b-\u0004A\u0011A\u0016\u0002EQ,7\u000f\u001e*jO\"$(j\\5o/&$\bNU5hQRtu\u000e\u001e)l\u001d>tW)];jQ\tQ7\u0007C\u0003o\u0001\u0011\u00051&\u0001\u000euKN$(+[4ii*{\u0017N\\,ji\"\u00046NT8o\u000bF,\u0018\u000e\u000b\u0002ng!)\u0011\u000f\u0001C\u0001W\u0005iA/Z:u%&<\u0007\u000e\u001e&pS:D#\u0001]\u001a\t\u000bQ\u0004A\u0011A\u0016\u00021Q,7\u000f\u001e*jO\"$(j\\5o/&$\b.R9vC2\u00046\u000e\u000b\u0002tg!)q\u000f\u0001C\u0001W\u0005YB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5SS\u001eDGOT8u!.D#A^\u001a\t\u000bi\u0004A\u0011A\u0016\u0002'Q,7\u000f\u001e*jO\"$(j\\5o/&$\b\u000eU6)\u0005e\u001c\u0004\"B?\u0001\t\u0003Y\u0013a\u0005;fgR4U\u000f\u001c7K_&tgj\u001c8FcVL\u0007F\u0001?4\u0011\u0019\t\t\u0001\u0001C\u0001W\u0005qB/Z:u\rVdGNS8j]^KG\u000f[#rk\u0006d\u0007k\u001b(p]\u0016\u000bX/\u001b\u0015\u0003\u007fNBa!a\u0002\u0001\t\u0003Y\u0013\u0001\t;fgR4U\u000f\u001c7K_&tw+\u001b;i\rVdGNT8u!.tuN\\#rk&D3!!\u00024\u0011\u0019\ti\u0001\u0001C\u0001W\u0005IB/Z:u\rVdGNS8j]^KG\u000f\u001b)l\u001d>tW)];jQ\r\tYa\r\u0005\u0007\u0003'\u0001A\u0011A\u0016\u0002\u0019Q,7\u000f\u001e$vY2Tu.\u001b8)\u0007\u0005E1\u0007\u0003\u0004\u0002\u001a\u0001!\taK\u0001\u0018i\u0016\u001cHOR;mY*{\u0017N\\,ji\",\u0015/^1m!.D3!a\u00064\u0011\u0019\ty\u0002\u0001C\u0001W\u0005IB/Z:u\rVdGNS8j]^KG\u000f\u001b$vY2tu\u000e\u001e)lQ\r\tib\r\u0005\u0007\u0003K\u0001A\u0011A\u0016\u0002%Q,7\u000f\u001e$vY2Tu.\u001b8XSRD\u0007k\u001b\u0015\u0004\u0003G\u0019\u0004BBA\u0016\u0001\u0011\u00051&\u0001\tuKN$8+\u001a7g\u0015>Lg\u000e\u00157b]\"\u001a\u0011\u0011F\u001a\t\r\u0005E\u0002\u0001\"\u0001,\u0003A!Xm\u001d;K_&tw+\u001b;i'>\u0014H\u000fK\u0002\u00020MBa!a\u000e\u0001\t\u0003Y\u0013!\u0007;fgRdUM\u001a;PkR,'OS8j]\u0016\u000bX/\u001b)sK\u0012D3!!\u000e4\u0011\u0019\ti\u0004\u0001C\u0001W\u0005\tC/Z:u\u0019\u00164GoT;uKJTu.\u001b8FcVL\u0017I\u001c3M_\u000e\fG\u000e\u0015:fI\"\u001a\u00111H\u001a\t\r\u0005\r\u0003\u0001\"\u0001,\u0003\r\"Xm\u001d;MK\u001a$x*\u001e;fe*{\u0017N\\#rk&\fe\u000e\u001a(p]\u0016\u000bX/\u001b)sK\u0012D3!!\u00114\u0011\u0019\tI\u0005\u0001C\u0001W\u0005QB/Z:u%&<\u0007\u000e^(vi\u0016\u0014(j\\5o\u000bF,\u0018\u000e\u0015:fI\"\u001a\u0011qI\u001a\t\r\u0005=\u0003\u0001\"\u0001,\u0003\t\"Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8FcVL\u0017I\u001c3M_\u000e\fG\u000e\u0015:fI\"\u001a\u0011QJ\u001a\t\r\u0005U\u0003\u0001\"\u0001,\u0003\u0011\"Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8FcVL\u0017I\u001c3O_:,\u0015/^5Qe\u0016$\u0007fAA*g!1\u00111\f\u0001\u0005\u0002-\nQ\u0006^3ti*{\u0017N\\!oIN+G.Z2u\u001f:\u0004\u0016M\u001d;jC2\u001cu.\u001c9pg&$X\r\u0015:j[\u0006\u0014\u0018pS3zQ\r\tIf\r\u0005\u0007\u0003C\u0002A\u0011A\u0016\u00023Q,7\u000f\u001e&pS:$\u0015n]8sI\u0016\u00148\t[1oO\u0016dun\u001a\u0015\u0004\u0003?\u001a\u0004BBA4\u0001\u0011\u00051&A\u0013uKN$(j\\5o\u001fV$\b/\u001e;VaN,'\u000f^&fs:{G/T1uG\"\u001c\u0016N\\6QW\"\u001a\u0011QM\u001a\t\r\u00055\u0004\u0001\"\u0001,\u0003}!Xm\u001d;K_&tw*\u001e;qkR,\u0006o]3si.+\u00170\u00138TS:\\\u0007k\u001b\u0015\u0004\u0003W\u001a\u0004BBA:\u0001\u0011\u00051&A\u0013uKN$(j\\5o\u001fV$\b/\u001e;M_N$X\u000b]:feR\\U-_,ji\"\u001c\u0016N\\6QW\"\u001a\u0011\u0011O\u001a\t\r\u0005e\u0004\u0001\"\u0001,\u0003}!Xm\u001d;J]:,'OS8j]^KG\u000f\u001b$jYR,'\u000fU;tQ\u0012{wO\u001c\u0015\u0004\u0003o\u001a\u0004BBA@\u0001\u0011\u00051&\u0001\u0014uKN$\u0018J\u001c8fe*{\u0017N\\,ji\"Tu.\u001b8D_:$\u0017\u000e^5p]B+8\u000f\u001b#po:D3!! 4\u0011\u0019\t)\t\u0001C\u0001W\u0005qB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b$jYR,'\u000fU;tQ\u0012{wO\u001c\u0015\u0004\u0003\u0007\u001b\u0004BBAF\u0001\u0011\u00051&A\u0013uKN$H*\u001a4u\u0015>LgnV5uQ*{\u0017N\\\"p]\u0012LG/[8o!V\u001c\b\u000eR8x]\"\u001a\u0011\u0011R\u001a\t\r\u0005E\u0005\u0001\"\u0001,\u0003}!Xm\u001d;SS\u001eDGOS8j]^KG\u000f\u001b$jYR,'\u000fU;tQ\u0012{wO\u001c\u0015\u0004\u0003\u001f\u001b\u0004BBAL\u0001\u0011\u00051&\u0001\u0014uKN$(+[4ii*{\u0017N\\,ji\"Tu.\u001b8D_:$\u0017\u000e^5p]B+8\u000f\u001b#po:D3!!&4\u0011\u0019\ti\n\u0001C\u0001W\u0005yB/Z:u\u0015>Lg.\u0016#U\r^KG\u000f[%om\u0006d\u0017\u000e\u001a&pS:D\u0015N\u001c;)\u0007\u0005m5\u0007\u0003\u0004\u0002$\u0002!\taK\u0001/i\u0016\u001cHOS8j]B\u000b'\u000f^5uS>tG+\u00192mK^KG\u000f\u001b(p]\u0016C\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000eK\u0002\u0002\"NBa!!+\u0001\t\u0003Y\u0013a\u000b;fgRTu.\u001b8BG\u000e,7o]*pkJ\u001cW\rU6XSRDW*\u001b8j\u0005\u0006$8\r[!tg&<g.\u001a:)\u0007\u0005\u001d6\u0007\u0003\u0004\u00020\u0002!\taK\u0001+i\u0016\u001cH/T5oS\n\u000bGo\u00195K_&tw+\u001b;i\u001d\u0016<\u0017\r^5wK6Kg.\u001b\"bi\u000eD7+\u001b>fQ\r\tik\r")
public class JoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testDependentConditionDerivationInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND b2 = 2)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithTrue() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND true)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithNull() {
        this.util().verifyExecPlan("SELECT * FROM t JOIN s ON (a = 1 AND x = 1) OR (a = 2 AND y is null)");
    }

    @Test
    public void testInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON a1 = b1");
    }

    @Test
    public void testInnerJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(40).append("SELECT a1, b1 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(48).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(58).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(66).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(46).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B group by b1";
        String query = new StringBuilder(54).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoin() {
        String query = "SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSelfJoinPlan() {
        this.util().addTableSource("src", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM (\n         |  SELECT * FROM src WHERE key = 0) src1\n         |LEFT OUTER JOIN (\n         |  SELECT * FROM src WHERE key = 0) src2\n         |ON (src1.key = src2.key AND src2.key > 10)\n       ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinWithSort() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  MyTable3 FULL JOIN\n        |  (SELECT * FROM MyTable4 ORDER BY MyTable4.i DESC, MyTable4.k ASC) MyTable4\n        |  ON MyTable3.i = MyTable4.i and MyTable3.i = MyTable4.k\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLeftOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z");
    }

    @Test
    public void testLeftOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < 2");
    }

    @Test
    public void testLeftOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testRightOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z");
    }

    @Test
    public void testRightOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, x FROM t RIGHT OUTER JOIN s ON a = z AND x < 2");
    }

    @Test
    public void testRightOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testJoinAndSelectOnPartialCompositePrimaryKey() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE tableWithCompositePk (\n                               |  pk1 INT,\n                               |  pk2 BIGINT,\n                               |  PRIMARY KEY (pk1, pk2) NOT ENFORCED\n                               |) WITH (\n                               |  'connector'='values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT A.a1 FROM A LEFT JOIN tableWithCompositePk T ON A.a1 = T.pk1");
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (person String, votes BIGINT) WITH(\n                               |  'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n                          | (SELECT T.person, T.sum_votes, award.prize FROM\n                          |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n                          |   award\n                          |   WHERE T.sum_votes = award.votes) T1, people T2\n                          | WHERE T1.person = T2.person\n                          |")).stripMargin());
    }

    @Test
    public void testJoinOutputUpsertKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputUpsertKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_id, city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a1, count(a2) as a2 from A group by a1)\n                          |   join\n                          |   (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testInnerJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2 and a2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   left join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and b2 = a2 and a1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   left join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on a1 = b1 and a2 = b2 and a1 = 2 and b2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   right join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          | (select a1, count(a2) as a2 from A group by a1)\n                          |   right join\n                          | (select b1, count(b2) as b2 from B group by b1)\n                          |   on a1 = b1 and a2 = b2 and b1 = 2 and a2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testJoinUDTFWithInvalidJoinHint() {
        this.util().addTemporarySystemFunction("TableFunc1", (UserDefinedFunction)new TableFunc1());
        this.util().verifyExpectdException("SELECT /*+ LOOKUP('table'='D') */ T.a FROM t AS T CROSS JOIN LATERAL TABLE(TableFunc1(c)) AS D(c1)", "The options of following hints cannot match the name of input tables or views: \n`D` in `LOOKUP`", this.util().verifyExpectdException$default$3());
    }

    @Test
    public void testJoinPartitionTableWithNonExistentPartition() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table leftPartitionTable (\n                               | a1 varchar,\n                               | b1 int)\n                               | partitioned by (b1) \n                               | with (\n                               | 'connector' = 'values',\n                               | 'bounded' = 'false',\n                               | 'partition-list' = 'b1:1'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table rightPartitionTable (\n                               | a2 varchar,\n                               | b2 int)\n                               | partitioned by (b2) \n                               | with (\n                               | 'connector' = 'values',\n                               | 'bounded' = 'false',\n                               | 'partition-list' = 'b2:2'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM leftPartitionTable, rightPartitionTable WHERE b1 = 1 AND b2 = 3 AND a1 = a2\n        |")).stripMargin());
    }

    @Test
    public void testJoinAccessSourcePkWithMiniBatchAssigner() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table left_table (\n                               | a varchar primary key not enforced,\n                               | b int\n                               |) with (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table right_table (\n                               | c varchar primary key not enforced,\n                               | d int\n                               |) with (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | e varchar primary key not enforced,\n                               | f int,\n                               | g int\n                               |) with (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L));
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)5000L));
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select left_table.a, left_table.b, right_table.d\n        | from left_table\n        | join right_table on left_table.a = right_table.c\n        |")).stripMargin());
    }

    @Test
    public void testMiniBatchJoinWithNegativeMiniBatchSize() {
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L));
        String sql = "SELECT * FROM A JOIN B ON a1 = b1";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)-500L));
        boolean cfr_ignored_1 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
    }

    public JoinTest() {
        this.util().addTableSource("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

