/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestInvalidTemporalTable$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestTemporalTable$;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionResultType;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u0001\u0003\u0001U\u0011a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003EaWmZ1dsR\u000b'\r\\3T_V\u00148-\u001a\t\u0003;\u0015J!A\n\u0010\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000b\r:\u0003\u0019\u0001\u0013\t\u000f9\u0002!\u0019!C\u0005_\u0005!Q\u000f^5m+\u0005\u0001\u0004CA\f2\u0013\t\u0011\u0004DA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u00045\u0001\u0001\u0006I\u0001M\u0001\u0006kRLG\u000e\t\u0005\u0006m\u0001!\taN\u0001\u0007E\u00164wN]3\u0015\u0003a\u0002\"!H\u001d\n\u0005ir\"\u0001B+oSRD#!\u000e\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015aA1qS*\u0011\u0011IQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019%#A\u0003kk:LG/\u0003\u0002F}\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b\u001d\u0003A\u0011A\u001c\u0002AQ,7\u000f\u001e&pS:LeN^1mS\u0012Tu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0003\r&\u0003\"!\u0010&\n\u0005-s$\u0001\u0004+fgR$V-\u001c9mCR,\u0007\"B'\u0001\t\u00039\u0014A\t;fgRtu\u000e\u001e#jgRLgn\u0019;Ge>l\u0017J\u001c&pS:\u001cuN\u001c3ji&|g\u000e\u000b\u0002M\u0013\")\u0001\u000b\u0001C\u0001o\u0005qB/Z:u\u0013:4\u0018\r\\5e\u0019>|7.\u001e9UC\ndWMR;oGRLwN\u001c\u0015\u0003\u001f&CQa\u0015\u0001\u0005\u0002]\n1\u0004^3ti*{\u0017N\\(o\t&4g-\u001a:f]R\\U-\u001f+za\u0016\u001c\bF\u0001*J\u0011\u00151\u0006\u0001\"\u00018\u0003U!Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016D#!V%\t\u000be\u0003A\u0011A\u001c\u00023Q,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u00031&CQ\u0001\u0018\u0001\u0005\u0002]\nA\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ:+7\u000f^3e#V,'/\u001f\u0015\u00037&CQa\u0018\u0001\u0005\u0002]\n1\u0006^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQB\u0013xN[3di&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003=&CQA\u0019\u0001\u0005\u0002]\nq\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u0012\u0011-\u0013\u0005\u0006K\u0002!\taN\u0001&i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bnQ1mGB+8\u000f\u001b#po:D#\u0001Z%\t\u000b!\u0004A\u0011A\u001c\u0002SQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f['vYRL\u0017J\u001c3fq\u000e{G.^7oQ\t9\u0017\nC\u0003l\u0001\u0011\u0005q'\u0001\u000euKN$\u0018I^8jI\u0006;wM]3hCR,\u0007+^:i\t><h\u000e\u000b\u0002k\u0013\")a\u000e\u0001C\u0001o\u00051C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i)J,XmQ8oI&$\u0018n\u001c8)\u00055L\u0005\"B9\u0001\t\u00039\u0014!\u000e;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"4UO\\2uS>t\u0017I\u001c3D_:\u001cH/\u00198u\u0007>tG-\u001b;j_:D#\u0001]%\t\u000bQ\u0004A\u0011A\u001c\u0002uQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f['vYRLg)\u001e8di&|g.\u00118e\u0007>t7\u000f^1oi\u000e{g\u000eZ5uS>t\u0007FA:J\u0011\u00159\b\u0001\"\u00018\u0003Y\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Gk:\u001cG/[8o\u0003:$'+\u001a4fe\u0016t7-Z\"p]\u0012LG/[8oQ\t1\u0018\nC\u0003{\u0001\u0011\u0005q'A\u0014uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDW\u000b\u001a4FcV\fGNR5mi\u0016\u0014\bFA=J\u0011\u0015i\b\u0001\"\u00018\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8)\u0005qL\u0005BBA\u0001\u0001\u0011\u0005q'\u0001\u001auKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0017I\u001c3QkNDGi\\<oQ\ty\u0018\n\u0003\u0004\u0002\b\u0001!\taN\u00016i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b.T;mi&\u001cuN\u001c3ji&|gn\u00148TC6,G)[7GS\u0016dG\rK\u0002\u0002\u0006%Ca!!\u0004\u0001\t\u00039\u0014A\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u001c\u0015m\u001d;P]2{wn[;q)\u0006\u0014G.\u001a\u0015\u0004\u0003\u0017I\u0005BBA\n\u0001\u0011\u0005q'A\u001cuKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD\u0017J\u001c;fe>\u0004XM]1cY\u0016\u001c\u0015m\u001d;P]2{wn[;q)\u0006\u0014G.\u001a\u0015\u0004\u0003#I\u0005BBA\r\u0001\u0011\u0005q'\u0001\u000fuKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7\tV#)\u0007\u0005]\u0011\n\u0003\u0004\u0002 \u0001!\taN\u00011i\u0016\u001cH/Q4h\u0003:$\u0017\t\u001c7D_:\u001cH/\u00198u\u0019>|7.\u001e9LKf<\u0016\u000e\u001e5Uef\u0014Vm]8mm\u0016lu\u000eZ3)\u0007\u0005u\u0011\n\u0003\u0004\u0002&\u0001!\taN\u0001\u0014i\u0016\u001cH/\u00138wC2LGMS8j]\"Kg\u000e\u001e\u0015\u0004\u0003GI\u0005BBA\u0016\u0001\u0011\u0005q'\u0001\u000euKN$(j\\5o\u0011&tGoV5uQR\u000b'\r\\3BY&\f7\u000fK\u0002\u0002*%Ca!!\r\u0001\t\u00039\u0014!\b;fgRTu.\u001b8IS:$x+\u001b;i)\u0006\u0014G.\u001a(b[\u0016|e\u000e\\=)\u0007\u0005=\u0012\n\u0003\u0004\u00028\u0001!\taN\u0001'i\u0016\u001cH/T;mi&\u0004H.\u001a&pS:D\u0015N\u001c;t/&$\bnU1nKR\u000b'\r\\3OC6,\u0007fAA\u001b\u0013\"1\u0011Q\b\u0001\u0005\u0002]\nq\u0005^3ti6+H\u000e^5qY\u0016Tu.\u001b8IS:$8oV5uQN\u000bW.\u001a+bE2,\u0017\t\\5bg\"\u001a\u00111H%\t\r\u0005\r\u0003\u0001\"\u00018\u0003-\"Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0015>Lg\u000eS5oiN<\u0016\u000e\u001e5ES\u001a4WM]3oiR\u000b'\r\\3OC6,\u0007fAA!\u0013\"1\u0011\u0011\n\u0001\u0005\u0002]\nA\u0006^3ti6+H\u000e^5qY\u0016Tu.\u001b8IS:$8oV5uQ\u0012KgMZ3sK:$H+\u00192mK\u0006c\u0017.Y:)\u0007\u0005\u001d\u0013\n\u0003\u0004\u0002P\u0001!\taN\u0001\u001fi\u0016\u001cHOS8j]NKhn\u0019+bE2,w+\u001b;i\u0003NLhn\u0019%j]RD3!!\u0014J\u0011\u0019\t)\u0006\u0001C\u0001o\u0005yB/Z:u\u0015>Lg.Q:z]\u000e$\u0016M\u00197f/&$\b.Q:z]\u000eD\u0015N\u001c;)\u0007\u0005M\u0013\n\u0003\u0004\u0002\\\u0001!\taN\u0001\u001fi\u0016\u001cHOS8j]\u0006\u001b\u0018P\\2UC\ndWmV5uQNKhn\u0019%j]RD3!!\u0017J\u0011\u0019\t\t\u0007\u0001C\u0001o\u0005\u0001C/Z:u\u0003\u001e<\u0017I\u001c3MK\u001a$(j\\5o\u00032dwn^+o_J$WM]3eQ\r\ty&\u0013\u0005\u0007\u0003O\u0002A\u0011A\u001c\u0002IQ,7\u000f^!hO\u0006sG\rT3gi*{\u0017N\\,ji\"$&/\u001f*fg>dg/Z'pI\u0016Da!a\u001b\u0001\t\u00039\u0014A\b;fgR\f5/\u001f8d\u0015>LgnV5uQ\u0012+g-Y;miB\u000b'/Y7tQ\r\tI'\u0013\u0005\u0007\u0003c\u0002A\u0011A\u001c\u0002+Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Bgft7\rS5oi\"\u001a\u0011qN%\t\r\u0005]\u0004\u0001\"\u00018\u0003U!Xm\u001d;K_&tw+\u001b;i%\u0016$(/\u001f%j]RD3!!\u001eJ\u0011\u0019\ti\b\u0001C\u0001o\u0005iB/Z:u\u0015>LgnV5uQ\u0006\u001b\u0018P\\2B]\u0012\u0014V\r\u001e:z\u0011&tG\u000fK\u0002\u0002|%Ca!a!\u0001\t\u00039\u0014!\b;fgRTu.\u001b8XSRDW*\u001b=fI\u000e\u000b7/\u001a&pS:D\u0015N\u001c;)\u0007\u0005\u0005\u0015\n\u0003\u0004\u0002\n\u0002!\taN\u0001(i\u0016\u001cHOS8j]\"Kg\u000e^,ji\"tu\u000e\u0015:pa\u0006<\u0017\r^5oOR{7+\u001e2Rk\u0016\u0014\u0018\u0010K\u0002\u0002\b&Cq!a$\u0001\t\u0013\t\t*A\tde\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016$R\u0001OAJ\u0003[C\u0001\"!&\u0002\u000e\u0002\u0007\u0011qS\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B!!'\u0002(:!\u00111TAR!\r\tiJH\u0007\u0003\u0003?S1!!)\u0015\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0015\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\tI+a+\u0003\rM#(/\u001b8h\u0015\r\t)K\b\u0005\t\u0003_\u000bi\t1\u0001\u00022\u0006qAn\\8lkB4UO\\2uS>t\u0007\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]F\"A\u0005gk:\u001cG/[8og&!\u00111XA[\u0005M)6/\u001a:EK\u001aLg.\u001a3Gk:\u001cG/[8o\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003\fQ#\u001a=qK\u000e$X\t_2faRLwN\u001c+ie><h\u000eF\u00049\u0003\u0007\f)-!3\t\u000f\u0015\ti\f1\u0001\u0002\u0018\"A\u0011qYA_\u0001\u0004\t9*A\u0004nKN\u001c\u0018mZ3\t\u0015\u0005-\u0017Q\u0018I\u0001\u0002\u0004\ti-A\u0003dY\u0006T(\u0010\r\u0003\u0002P\u0006e\u0007CBAM\u0003#\f).\u0003\u0003\u0002T\u0006-&!B\"mCN\u001c\b\u0003BAl\u00033d\u0001\u0001\u0002\u0007\u0002\\\u0006%\u0017\u0011!A\u0001\u0006\u0003\tiNA\u0002`IE\nB!a8\u0002fB\u0019Q$!9\n\u0007\u0005\rhDA\u0004O_RD\u0017N\\4\u0011\t\u0005\u001d\u0018\u0011\u001f\b\u0005\u0003S\fiO\u0004\u0003\u0002\u001e\u0006-\u0018\"A\u0010\n\u0007\u0005=h$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0018Q\u001f\u0002\n)\"\u0014xn^1cY\u0016T1!a<\u001f\u0011\u001d\tI\u0010\u0001C\u0005\u0003w\f\u0001D^3sS\u001aLHK]1og2\fG/[8o'V\u001c7-Z:t)\rA\u0014Q \u0005\b\u000b\u0005]\b\u0019AAL\u0011%\u0011\t\u0001AI\u0001\n\u0013\u0011\u0019!A\u0010fqB,7\r^#yG\u0016\u0004H/[8o)\"\u0014xn\u001e8%I\u00164\u0017-\u001e7uIM*\"A!\u00021\t\t\u001d!1\u0002\t\u0007\u00033\u000b\tN!\u0003\u0011\t\u0005]'1\u0002\u0003\r\u00037\fy0!A\u0001\u0002\u000b\u0005\u0011Q\u001c\u0015\b\u0001\t=!1\u0004B\u000f!\u0011\u0011\tBa\u0006\u000e\u0005\tM!b\u0001B\u000b}\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u00053\u0011\u0019B\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#Aa\b$\u0005\t\u0005\u0002\u0003\u0002B\u0012\u0005gi!A!\n\u000b\t\t\u001d\"\u0011F\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\t-\"QF\u0001\u000bKb$XM\\:j_:\u001c(bA\"\u00030)\u0019!\u0011\u0007\b\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002\u0002B\u001b\u0005K\u0011!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:<qA!\u000f\u0003\u0011\u0003\u0011Y$\u0001\bM_>\\W\u000f\u001d&pS:$Vm\u001d;\u0011\u0007-\u0012iD\u0002\u0004\u0002\u0005!\u0005!qH\n\u0006\u0005{\u0011\t\u0005\b\t\u0004;\t\r\u0013b\u0001B#=\t1\u0011I\\=SK\u001aDq\u0001\u000bB\u001f\t\u0003\u0011I\u0005\u0006\u0002\u0003<!A!Q\nB\u001f\t\u0003\u0011y%\u0001\u0006qCJ\fW.\u001a;feN$\"A!\u0015\u0011\r\tM#1\fB0\u001b\t\u0011)FC\u0002/\u0005/R!A!\u0017\u0002\t)\fg/Y\u0005\u0005\u0005;\u0012)F\u0001\u0006D_2dWm\u0019;j_:\u0004R!\bB1\u0005KJ1Aa\u0019\u001f\u0005\u0015\t%O]1z!\u0011\u00119G!\u001c\u000e\u0005\t%$\u0002\u0002B6\u0005/\nA\u0001\\1oO&!!q\u000eB5\u0005\u0019y%M[3di\"B!1\nB:\u0005s\u0012Y\b\u0005\u0003\u0003$\tU\u0014\u0002\u0002B<\u0005K\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\tu\u0014!\u0006'fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKvZ\b' \u0005\u000b\u0005\u0003\u0013i$!A\u0005\n\t\r\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001a")
public class LookupJoinTest
extends TableTestBase
implements scala.Serializable {
    private final boolean legacyTableSource;
    private final StreamTableTestUtil util;

    @Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinTest$.MODULE$.parameters();
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        if (this.legacyTableSource) {
            TestTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), "LookupTable", TestTemporalTable$.MODULE$.createTemporaryTable$default$3(), TestTemporalTable$.MODULE$.createTemporaryTable$default$4());
            TableEnvironment x$1 = this.util().tableEnv();
            String x$2 = "AsyncLookupTable";
            boolean x$3 = true;
            boolean x$4 = TestTemporalTable$.MODULE$.createTemporaryTable$default$3();
            TestTemporalTable$.MODULE$.createTemporaryTable(x$1, x$2, x$4, x$3);
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE LookupTable (\n                      |  `id` INT,\n                      |  `name` STRING,\n                      |  `age` INT\n                      |) WITH (\n                      |  'connector' = 'values'\n                      |)\n                      |")).stripMargin());
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE AsyncLookupTable (\n                      |  `id` INT,\n                      |  `name` STRING,\n                      |  `age` INT\n                      |) WITH (\n                      |  'connector' = 'values',\n                      |  'async' = 'true'\n                      |)\n                      |")).stripMargin());
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE LookupTableWithComputedColumn (\n                      |  `id` INT,\n                      |  `name` STRING,\n                      |  `age` INT,\n                      |  `nominal_age` as age + 1\n                      |) WITH (\n                      |  'connector' = 'values',\n                      |  'bounded' = 'true'\n                      |)\n                      |")).stripMargin());
        }
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE Sink1 (\n                    |  a int,\n                    |  name varchar,\n                    |  age int\n                    |) with (\n                    |  'connector' = 'values',\n                    |  'sink-insert-only' = 'false'\n                    |)")).stripMargin());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @TestTemplate
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proctime AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", "Correlate has invalid join type RIGHT", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 2", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
    }

    @TestTemplate
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @TestTemplate
    public void testInvalidLookupTableFunction() {
        if (this.legacyTableSource) {
            return;
        }
        this.util().addDataStream("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.createLookupTable("LookupTable1", (UserDefinedFunction)new InvalidTableFunctionResultType());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "output class can simply be a Row or RowData class", ValidationException.class);
        this.createLookupTable("LookupTable2", (UserDefinedFunction)new InvalidTableFunctionEvalSignature());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature' for function 'default_catalog.default_database.LookupTable2' that matches the following signature:\nvoid eval(java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable3", (UserDefinedFunction)new TableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable4", (UserDefinedFunction)new TableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable4 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable5", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable5 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable6", (UserDefinedFunction)new AsyncTableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable6 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable7", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature1());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable7 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1' for function 'default_catalog.default_database.LookupTable7' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable8", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature2());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable8 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2' for function 'default_catalog.default_database.LookupTable8' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, java.lang.String, java.time.LocalDateTime)", ValidationException.class);
        this.createLookupTable("LookupTable9", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable9 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable10", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature3());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable10 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3' for function 'default_catalog.default_database.LookupTable10' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
    }

    @TestTemplate
    public void testJoinOnDifferentKeyTypes() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id")).hasMessageContaining("implicit type conversion between VARCHAR(2147483647) and INTEGER is not supported on join's condition now") instanceof TableException;
    }

    @TestTemplate
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithCalcPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE cast(D.name as bigint) > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithMultiIndexColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND D.name = 'AAA'\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proc\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proc AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithTrueCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]") instanceof TableException;
    }

    @TestTemplate
    public void testJoinTemporalTableWithFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithMultiFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id + 1 AND T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithFunctionAndReferenceCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND T.b = concat(D.name, '!')\n        |WHERE D.name LIKE 'Jack%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name\n        |FROM\n        |  MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumn() {
        Assumptions.assumeThat((boolean)this.legacyTableSource).isFalse();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assumptions.assumeThat((boolean)this.legacyTableSource).isFalse();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithMultiConditionOnSameDimField() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id and CAST(T.c as INT) = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable2 (\n                    |  `id` decimal(38, 18),\n                    |  `name` STRING,\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.a = CAST(LookupTable2.`id` as INT)\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.verifyTranslationSuccess(sql)).hasMessageContaining("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable2]") instanceof TableException;
    }

    @TestTemplate
    public void testJoinTemporalTableWithInteroperableCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable2 (\n                    |  `id` INT,\n                    |  `name` char(10),\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.b = CAST(LookupTable2.`name` as String)\n        |")).stripMargin();
        this.verifyTranslationSuccess(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithCTE() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH MyLookupTable AS (SELECT * FROM MyTable),\n        |OtherLookupTable AS (SELECT * FROM LookupTable)\n        |SELECT MyLookupTable.b FROM MyLookupTable\n        |JOIN OtherLookupTable FOR SYSTEM_TIME AS OF MyLookupTable.proctime AS D\n        |ON MyLookupTable.a = D.id AND D.age = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAggAndAllConstantLookupKeyWithTryResolveMode() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        | LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON D.id = 100\n      ")).stripMargin();
        String actual = this.util().tableEnv().explainSql(sql, new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        String expected = this.legacyTableSource ? TableTestUtil$.MODULE$.readFromResource("explain/stream/join/lookup/testAggAndAllConstantLookupKeyWithTryResolveMode.out") : TableTestUtil$.MODULE$.readFromResource("explain/stream/join/lookup/testAggAndAllConstantLookupKeyWithTryResolveMode_newSource.out");
        Assertions.assertThat((String)TableTestUtil$.MODULE$.replaceNodeIdInOperator(TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.replaceStageId(actual)))).isEqualTo(TableTestUtil$.MODULE$.replaceNodeIdInOperator(TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.replaceStageId(expected))));
    }

    @TestTemplate
    public void testInvalidJoinHint() {
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('tableName'='LookupTable') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint: incomplete required option(s): [Key: 'table' , default: null (fallback keys: [])]", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='yes') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'yes' for key 'async'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true', 'output-mode'='allow-unordered') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'allow-unordered' for key 'output-mode'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true', 'timeout'='300 si') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '300 si' for key 'timeout'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-strategy'='fixed-delay') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'fixed-delay' for key 'retry-strategy'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'fixed-delay'='100 nano sec') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '100 nano sec' for key 'fixed-delay'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'max-attempts'='100.0') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '100.0' for key 'max-attempts'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'max-attempts'='100') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint: retry options can be both null or all not null", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='exception', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='-3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: unsupported retry-predicate 'exception', only 'lookup_miss' is supported currently", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='-3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: max-attempts value should be positive integer but was -3", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='-10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '-10s' for key 'fixed-delay'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup-miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: unsupported retry-predicate 'lookup-miss', only 'lookup_miss' is supported currently", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed-delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'fixed-delay' for key 'retry-strategy'", AssertionError.class);
    }

    @TestTemplate
    public void testJoinHintWithTableAlias() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinHintWithTableNameOnly() {
        String sql = "SELECT /*+ LOOKUP('table'='LookupTable') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime ON T.a = LookupTable.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testMultipleJoinHintsWithSameTableName() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='AsyncLookupTable', 'output-mode'='ordered') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime\n        | ON T.a = AsyncLookupTable.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testMultipleJoinHintsWithSameTableAlias() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='D', 'output-mode'='ordered') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D \n        | ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testMultipleJoinHintsWithDifferentTableName() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime\n        |  ON T.a = AsyncLookupTable.id\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime\n        |  ON T.a = LookupTable.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testMultipleJoinHintsWithDifferentTableAlias() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='D1', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D \n        |  ON T.a = D.id\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D1 \n        |  ON T.a = D1.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinSyncTableWithAsyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'async'='true') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinAsyncTableWithAsyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'async'='true') */ * FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinAsyncTableWithSyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'async'='false') */ * FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAggAndLeftJoinAllowUnordered() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE, (Object)ExecutionConfigOptions.AsyncOutputMode.ALLOW_UNORDERED);
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        |LEFT JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    public void testAggAndLeftJoinWithTryResolveMode() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        |LEFT JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}))).hasMessageContaining("Required sync lookup function by planner, but table") instanceof TableException;
    }

    @TestTemplate
    public void testAsyncJoinWithDefaultParams() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |INSERT INTO Sink1\n                        |SELECT T.a, D.name, D.age\n                        |FROM MyTable T\n                        |JOIN AsyncLookupTable\n                        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n                        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @TestTemplate
    public void testJoinWithAsyncHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered', 'time-out'='600s', 'capacity'='300') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @TestTemplate
    public void testJoinWithRetryHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='D', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN LookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @TestTemplate
    public void testJoinWithAsyncAndRetryHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered', 'time-out'='600s', 'capacity'='300', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @TestTemplate
    public void testJoinWithMixedCaseJoinHint() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LookuP('table'='D', 'retry-predicate'='lookup_miss',\n        |'retry-strategy'='fixed_delay', 'fixed-delay'='155 ms', 'max-attempts'='10',\n        |'async'='true', 'output-mode'='allow_unordered','capacity'='1000', 'time-out'='300 s')\n        |*/\n        |T.a\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n        |")).stripMargin());
    }

    @TestTemplate
    public void testJoinHintWithNoPropagatingToSubQuery() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='ordered','capacity'='200') */ T1.a\n        |FROM (\n        |   SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered', 'capacity'='1000') */\n        |     T.a a, T.proctime\n        |   FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |     ON T.a = D.id\n        |) T1\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T1.proctime AS D\n        |ON T1.a=D.id\n        |")).stripMargin());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLookupTable(String tableName, UserDefinedFunction lookupFunction) {
        if (this.legacyTableSource) {
            UserDefinedFunction userDefinedFunction = lookupFunction;
            if (userDefinedFunction instanceof TableFunction) {
                TableFunction tableFunction = (TableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, tableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(userDefinedFunction instanceof AsyncTableFunction)) throw new MatchError((Object)userDefinedFunction);
                AsyncTableFunction asyncTableFunction = (AsyncTableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, asyncTableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(387).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` INT,\n                       |  `name` STRING,\n                       |  `age` INT,\n                       |  `ts` TIMESTAMP(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'lookup-function-class' = '").append(lookupFunction.getClass().getName()).append("'\n                       |)\n                       |").toString())).stripMargin());
        }
    }

    private void expectExceptionThrown(String sql, String message, Class<? extends Throwable> clazz) {
        Assertions.assertThatExceptionOfType(clazz).isThrownBy(() -> this.verifyTranslationSuccess(sql)).withMessageContaining(message);
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    private void verifyTranslationSuccess(String sql) {
        this.util().tableEnv().sqlQuery(sql).explain(new ExplainDetail[0]);
    }

    public LookupJoinTest(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

