/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Over;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001%\t)B*Z4bGf$\u0016M\u00197f'>,(oY3UKN$(BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\t\u00191B\u0003\u0002\r\u001b\u0005)a\r\\5oW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005YA\u0011!B;uS2\u001c\u0018B\u0001\r\u0016\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\u0006?\u0001!\t\u0001I\u0001$i\u0016\u001cH\u000fV1cY\u0016\u001cv.\u001e:dK^KG\u000f\u001b'p]\u001e\u0014vn\u001e+j[\u00164\u0015.\u001a7e)\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#\u0001B+oSRD#A\b\u0015\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013aA1qS*\u0011QFL\u0001\bUV\u0004\u0018\u000e^3s\u0015\tys\"A\u0003kk:LG/\u0003\u00022U\t!A+Z:u\u0011\u0015\u0019\u0004\u0001\"\u0001!\u0003!\"Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i)&lWm\u001d;b[B\u0014vn\u001e+j[\u00164\u0015.\u001a7eQ\t\u0011\u0004\u0006C\u00037\u0001\u0011\u0005\u0001%A\u0011uKN$(k\\<US6,G+\u00192mKN{WO]2f\u000fJ|W\u000f],j]\u0012|w\u000f\u000b\u00026Q!)\u0011\b\u0001C\u0001A\u0005iB/Z:u!J|7\rV5nKR\u000b'\r\\3T_V\u00148-Z*j[BdW\r\u000b\u00029Q!)A\b\u0001C\u0001A\u0005\tC/Z:u!J|7\rV5nKR\u000b'\r\\3T_V\u00148-Z(wKJ<\u0016N\u001c3po\"\u00121\b\u000b\u0005\u0006\u007f\u0001!\t\u0001I\u0001\u001fi\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQJ{w\u000f^5nKB\u0013xn\u0019;j[\u0016D#A\u0010\u0015\t\u000b\t\u0003A\u0011\u0001\u0011\u00023Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f\u001e*poRLW.\u001a\u0015\u0003\u0003\"BQ!\u0012\u0001\u0005\u0002\u0001\n!\u0004^3tiB\u0013xN[3di^KG\u000f[8viB\u0013xn\u0019;j[\u0016D#\u0001\u0012\u0015\t\u000b!\u0003A\u0011\u0001\u0011\u0002/Q,7\u000f\u001e)s_*,7\r^(oYf\u0004&o\\2uS6,\u0007FA$)\u0011\u0015Y\u0005\u0001\"\u0001!\u0003Y!Xm\u001d;Qe>TWm\u0019;P]2L(k\\<uS6,\u0007F\u0001&)\u0011\u0015q\u0005\u0001\"\u0001!\u0003Y!Xm\u001d;Qe>TWm\u0019;XSRDW*\u00199qS:<\u0007FA')\u0011\u0015\t\u0006\u0001\"\u0001!\u0003E!Xm\u001d;OKN$X\r\u001a)s_*,7\r\u001e\u0015\u0003!\"\u0002")
public class LegacyTableSourceTest
extends TableTestBase {
    @Test
    public void testTableSourceWithLongRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        Table t = util.tableEnv().from("rowTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        Table t = util.tableEnv().from("rowTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        Table t = util.tableEnv().from("rowTimeT").where(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100))).window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(10).minutes())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).avg()});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProcTimeTableSourceSimple() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "proctime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        boolean x$1 = false;
        TableSchema x$2 = tableSchema;
        RowTypeInfo x$3 = returnType;
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$5 = "proctime";
        String x$6 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        Map<String, String> x$7 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7();
        String x$8 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8();
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("procTimeT", new TestTableSourceWithTime(x$1, x$2, x$3, x$4, x$6, x$5, x$7, x$8));
        Table t = util.tableEnv().from("procTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proctime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProcTimeTableSourceOverWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "proctime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        boolean x$9 = false;
        TableSchema x$10 = tableSchema;
        RowTypeInfo x$11 = returnType;
        Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$13 = "proctime";
        String x$14 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        Map<String, String> x$15 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7();
        String x$16 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8();
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("procTimeT", new TestTableSourceWithTime(x$9, x$10, x$11, x$12, x$14, x$13, x$15, x$16));
        Table t = util.tableEnv().from("procTimeT").window(new OverWindow[]{Over.partitionBy((Expression[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}).orderBy(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime"))).preceding((Expression)package$.MODULE$.LiteralIntExpression(2).hours()).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).sum()).over((Object)package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).as((Symbol)SymbolLiteral.bootstrap("apply", "valSum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).filter(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "valSum")).$greater(package$.MODULE$.int2Literal(100)));
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithRowtimeProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithoutRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithoutProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectOnlyProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime"))});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectOnlyRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithMapping() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", (Map<String, String>)mapping));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val"))});
        util.verifyExecPlan(t);
    }

    @Test
    public void testNestedProject() {
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested1")).get("name")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedName"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nested")).get("value")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedValue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("flag")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedFlag"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("num")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedNum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        util.verifyExecPlan(t);
    }
}

