/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table;

import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Over;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001%\tyA+\u00192mKN{WO]2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)A/\u00192mK*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111a\u0003\u0006\u0003\u00195\tQA\u001a7j].T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\t1\u0002\"A\u0003vi&d7/\u0003\u0002\u0019+\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtD#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0002\t\u000f}\u0001!\u0019!C\u0005A\u0005!Q\u000f^5m+\u0005\t\u0003C\u0001\u000b#\u0013\t\u0019SCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0006kRLG\u000e\t\u0005\u0006O\u0001!\t\u0001K\u0001)i\u0016\u001cH\u000fV1cY\u0016\u001cv.\u001e:dK^KG\u000f\u001b+j[\u0016\u001cH/Y7q%><H+[7f\r&,G\u000e\u001a\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5uQ\t1\u0003\u0007\u0005\u00022q5\t!G\u0003\u00024i\u0005\u0019\u0011\r]5\u000b\u0005U2\u0014a\u00026va&$XM\u001d\u0006\u0003o=\tQA[;oSRL!!\u000f\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006w\u0001!\t\u0001K\u0001\"i\u0016\u001cHOU8x)&lW\rV1cY\u0016\u001cv.\u001e:dK\u001e\u0013x.\u001e9XS:$wn\u001e\u0015\u0003uABQA\u0010\u0001\u0005\u0002!\nq\u0007^3tiJ{w\u000fV5nKR\u000b'\r\\3T_V\u00148-Z$s_V\u0004x+\u001b8e_^<\u0016\u000e\u001e5O_RtU\u000f\u001c7S_^$\u0016.\\3UsB,\u0007FA\u001f1\u0011\u0015\t\u0005\u0001\"\u0001)\u0003\u0005\"Xm\u001d;Qe>\u001cG+[7f)\u0006\u0014G.Z*pkJ\u001cWm\u0014<fe^Kg\u000eZ8xQ\t\u0001\u0005\u0007C\u0003E\u0001\u0011\u0005\u0001&A\ruKN$\bK]8kK\u000e$x+\u001b;i_V$(k\\<uS6,\u0007FA\"1\u0011\u00159\u0005\u0001\"\u0001)\u0003i!Xm\u001d;Qe>TWm\u0019;XSRDw.\u001e;Qe>\u001cG/[7fQ\t1\u0005\u0007C\u0003K\u0001\u0011\u0005\u0001&A\u000euKN$\bK]8di&lWm\u00148XCR,'/\\1sWN\u0003Xm\u0019\u0015\u0003\u0013BBQ!\u0014\u0001\u0005\u0002!\na\u0003^3tiB\u0013xN[3di>sG.\u001f*poRLW.\u001a\u0015\u0003\u0019BBQ\u0001\u0015\u0001\u0005\u0002!\n\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\ty\u0005\u0007")
public class TableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("rowTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("rowTimeT").where(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100))).window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(10).minutes())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).avg()});
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testRowTimeTableSourceGroupWindowWithNotNullRowTimeType() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3) not null,\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime - INTERVAL '5' SECONDS\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("rowTimeT").where(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100))).window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(10).minutes())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).avg()});
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testProcTimeTableSourceOverWindow() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE procTimeT (\n         |  id int,\n         |  val bigint,\n         |  name varchar(32),\n         |  proctime as PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("procTimeT").window(new OverWindow[]{Over.partitionBy((Expression[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}).orderBy(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime"))).preceding((Expression)package$.MODULE$.LiteralIntExpression(2).hours()).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).sum()).over((Object)package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).as((Symbol)SymbolLiteral.bootstrap("apply", "valSum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).filter(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "valSum")).$greater(package$.MODULE$.int2Literal(100)));
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testProjectWithoutRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))});
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testProjectWithoutProctime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))});
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testProctimeOnWatermarkSpec() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for ptime as ptime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> {
            this.util().tableEnv().executeSql(ddl);
            Table t = this.util().tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime"))});
            this.util().verifyExecPlan(t);
        }).hasMessageContaining("A watermark can not be defined for a processing-time attribute.") instanceof ValidationException;
    }

    @Test
    public void testProjectOnlyRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))});
        this.util().verifyExecPlan(t);
    }

    @Test
    public void testNestedProject() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'false',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        Table t = this.util().tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested1")).get("name")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedName"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nested")).get("value")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedValue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("flag")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedFlag"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("num")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedNum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        this.util().verifyExecPlan(t);
    }
}

