/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001)\tyB+Z7q_J\fG\u000eV1cY\u0016Tu.\u001b8WC2LG-\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u0003<bY&$\u0017\r^5p]*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\taa\u001d;sK\u0006l'BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000b5Q!AD\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0015\u0005)Q\u000f^5mg&\u0011!d\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005\u0011\u0001bB\u0011\u0001\u0005\u0004%\tAI\u0001\u0005kRLG.F\u0001$!\t1B%\u0003\u0002&/\tiA+\u00192mKR+7\u000f^+uS2Daa\n\u0001!\u0002\u0013\u0019\u0013!B;uS2\u0004\u0003bB\u0015\u0001\u0005\u0004%\tAK\u0001\u0007_J$WM]:\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0007\u0002\u0007\u0005\u0004\u0018.\u0003\u00021[\t)A+\u00192mK\"1!\u0007\u0001Q\u0001\n-\nqa\u001c:eKJ\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011\u0001\u0016\u0002\u001d=\u0014H-\u001a:t!J|7\r^5nK\"1a\u0007\u0001Q\u0001\n-\nqb\u001c:eKJ\u001c\bK]8di&lW\r\t\u0005\bq\u0001\u0011\r\u0011\"\u0001+\u0003iy'\u000fZ3sg^KG\u000f[8viRKW.Z!uiJL'-\u001e;f\u0011\u0019Q\u0004\u0001)A\u0005W\u0005YrN\u001d3feN<\u0016\u000e\u001e5pkR$\u0016.\\3BiR\u0014\u0018NY;uK\u0002Bq\u0001\u0010\u0001C\u0002\u0013\u0005!&\u0001\u0007sCR,7\u000fS5ti>\u0014\u0018\u0010\u0003\u0004?\u0001\u0001\u0006IaK\u0001\u000ee\u0006$Xm\u001d%jgR|'/\u001f\u0011\t\u000f\u0001\u0003!\u0019!C\u0001U\u0005\u0001#/\u0019;fg\"K7\u000f^8ss^KG\u000f[8viRKW.Z!uiJL'-\u001e;f\u0011\u0019\u0011\u0005\u0001)A\u0005W\u0005\t#/\u0019;fg\"K7\u000f^8ss^KG\u000f[8viRKW.Z!uiJL'-\u001e;fA!)A\t\u0001C\u0001\u000b\u0006IB/Z:u\u0013:4\u0018\r\\5e\r&,G\u000e\u001a*fM\u0016\u0014XM\\2f)\u00051\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%\u0001B+oSRD#aQ'\u0011\u00059#V\"A(\u000b\u00059\u0002&BA)S\u0003\u001dQW\u000f]5uKJT!aU\t\u0002\u000b),h.\u001b;\n\u0005U{%\u0001\u0002+fgRDQa\u0016\u0001\u0005\u0002\u0015\u000bq\u0004^3ti&sg/\u00197jIN#(/\u001b8h\r&,G\u000e\u001a*fM\u0016\u0014XM\\2fQ\t1V\nC\u0003[\u0001\u0011\u0005Q)A\u0010uKN$hj\u001c8US6,\u0017J\u001c3jG\u0006$xN](o%&<\u0007\u000e^*jI\u0016D#!W'\t\u000bu\u0003A\u0011A#\u0002=Q,7\u000f\u001e(p]RKW.Z%oI&\u001c\u0017\r^8s\u001f:dUM\u001a;TS\u0012,\u0007F\u0001/N\u0011\u0015\u0001\u0007\u0001\"\u0001F\u0003]!Xm\u001d;NSb,G\rV5nK&sG-[2bi>\u00148\u000f\u000b\u0002`\u001b\u0002")
public class TemporalTableJoinValidationTest
extends TableTestBase {
    private final TableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private final Table orders = this.util().addDataStream("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            return this.createSerializer(executionConfig.getSerializerConfig());
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table ordersProctime = this.util().addDataStream("OrdersProctime", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")).proctime()}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                public Tuple2<Object, String> createInstance(Object[] fields) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
            return this.createSerializer(executionConfig.getSerializerConfig());
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table ordersWithoutTimeAttribute = this.util().addDataStream("OrdersWithoutTimeAttribute", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            return this.createSerializer(executionConfig.getSerializerConfig());
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table ratesHistory = this.util().addDataStream("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            return this.createSerializer(executionConfig.getSerializerConfig());
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table ratesHistoryWithoutTimeAttribute = this.util().addDataStream("ratesHistoryWithoutTimeAttribute", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            return this.createSerializer(executionConfig.getSerializerConfig());
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });

    public TableTestUtil util() {
        return this.util;
    }

    public Table orders() {
        return this.orders;
    }

    public Table ordersProctime() {
        return this.ordersProctime;
    }

    public Table ordersWithoutTimeAttribute() {
        return this.ordersWithoutTimeAttribute;
    }

    public Table ratesHistory() {
        return this.ratesHistory;
    }

    public Table ratesHistoryWithoutTimeAttribute() {
        return this.ratesHistoryWithoutTimeAttribute;
    }

    @Test
    public void testInvalidFieldReference() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "foobar")))).hasMessageContaining("Cannot resolve field [foobar]") instanceof ValidationException;
    }

    @Test
    public void testInvalidStringFieldReference() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.ratesHistory().createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foobar"}))).$((Seq)Nil$.MODULE$))).hasMessageContaining("Cannot resolve field [foobar]") instanceof ValidationException;
    }

    @Test
    public void testNonTimeIndicatorOnRightSide() {
        TemporalTableFunction rates = this.ratesHistoryWithoutTimeAttribute().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        Table result = this.orders().joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)rates).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")))).select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o_amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate"}))).$((Seq)Nil$.MODULE$))}).as("rate", new String[0]);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(result)).hasMessageContaining("Non rowtime timeAttribute [TIMESTAMP(3)] used to create TemporalTableFunction") instanceof ValidationException;
    }

    @Test
    public void testNonTimeIndicatorOnLeftSide() {
        TemporalTableFunction rates = this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        Table result = this.ordersWithoutTimeAttribute().joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)rates).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")))).select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o_amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate"}))).$((Seq)Nil$.MODULE$))}).as("rate", new String[0]);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(result)).hasMessageContaining("Non rowtime timeAttribute [TIMESTAMP(3)] passed as the argument to TemporalTableFunction") instanceof ValidationException;
    }

    @Test
    public void testMixedTimeIndicators() {
        TemporalTableFunction rates = this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        Table result = this.ordersProctime().joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)rates).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")))).select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o_amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate"}))).$((Seq)Nil$.MODULE$))}).as("rate", new String[0]);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(result)).hasMessageContaining("Non rowtime timeAttribute [TIMESTAMP_LTZ(3) *PROCTIME*] passed as the argument to TemporalTableFunction") instanceof ValidationException;
    }
}

