/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.trait;

import java.util.Collection;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001#\tAb\t\\5oWJ+G\u000eR5tiJL'-\u001e;j_:$Vm\u001d;\u000b\u0005\r!\u0011!\u0002;sC&$(BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\t1\u0002^3tiN\u000bG/[:gsR\t\u0001\u0005\u0005\u0002\u0014C%\u0011!\u0005\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u001eIA\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\u0004CBL'BA\u0015+\u0003\u001dQW\u000f]5uKJT!a\u000b\b\u0002\u000b),h.\u001b;\n\u000552#\u0001\u0002+fgRDQa\f\u0001\u0005\u0002}\t\u0011\u0002^3ti\u0006\u0003\b\u000f\\=)\u00059\"\u0003")
public class FlinkRelDistributionTest {
    @Test
    public void testSatisfy() {
        FlinkRelDistribution hash1 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{1}), false);
        FlinkRelDistribution hash2 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{2}), false);
        FlinkRelDistribution hash12 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{1, 2}), false);
        FlinkRelDistribution hash21 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{2, 1}), false);
        FlinkRelDistribution strictHash21 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{2, 1}), FlinkRelDistribution$.MODULE$.hash$default$2());
        Assertions.assertTrue((boolean)hash1.satisfies((RelTrait)hash1));
        Assertions.assertFalse((boolean)hash1.satisfies((RelTrait)hash2));
        Assertions.assertTrue((boolean)hash1.satisfies((RelTrait)hash12));
        Assertions.assertFalse((boolean)hash12.satisfies((RelTrait)hash1));
        Assertions.assertFalse((boolean)hash12.satisfies((RelTrait)hash2));
        Assertions.assertTrue((boolean)hash12.satisfies((RelTrait)hash12));
        Assertions.assertTrue((boolean)hash12.satisfies((RelTrait)hash21));
        Assertions.assertTrue((boolean)hash21.satisfies((RelTrait)hash12));
        Assertions.assertTrue((boolean)strictHash21.satisfies((RelTrait)hash21));
        Assertions.assertTrue((boolean)strictHash21.satisfies((RelTrait)hash12));
        Assertions.assertFalse((boolean)hash21.satisfies((RelTrait)strictHash21));
        Assertions.assertFalse((boolean)hash12.satisfies((RelTrait)strictHash21));
        FlinkRelDistribution rangeAsc1 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1, RelFieldCollation.Direction.ASCENDING)}));
        FlinkRelDistribution rangeDesc1 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1, RelFieldCollation.Direction.DESCENDING)}));
        FlinkRelDistribution range12 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1), new RelFieldCollation(2)}));
        FlinkRelDistribution range21 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(2), new RelFieldCollation(1)}));
        FlinkRelDistribution range123 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1), new RelFieldCollation(2), new RelFieldCollation(3)}));
        Assertions.assertFalse((boolean)rangeAsc1.satisfies((RelTrait)rangeDesc1));
        Assertions.assertTrue((boolean)rangeAsc1.satisfies((RelTrait)rangeAsc1));
        Assertions.assertTrue((boolean)rangeDesc1.satisfies((RelTrait)rangeDesc1));
        Assertions.assertFalse((boolean)range12.satisfies((RelTrait)range21));
        Assertions.assertFalse((boolean)range21.satisfies((RelTrait)range12));
        Assertions.assertTrue((boolean)range12.satisfies((RelTrait)range123));
        Assertions.assertFalse((boolean)range12.satisfies((RelTrait)rangeAsc1));
        FlinkRelDistribution hash = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{0}), false);
        FlinkRelDistribution range = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(0)}));
        RelDistribution random = FlinkRelDistribution$.MODULE$.RANDOM_DISTRIBUTED();
        RelDistribution roundrobin = FlinkRelDistribution$.MODULE$.ROUND_ROBIN_DISTRIBUTED();
        FlinkRelDistribution broadcast = FlinkRelDistribution$.MODULE$.BROADCAST_DISTRIBUTED();
        FlinkRelDistribution singleton = FlinkRelDistribution$.MODULE$.SINGLETON();
        FlinkRelDistribution any = FlinkRelDistribution$.MODULE$.ANY();
        Assertions.assertTrue((boolean)hash.satisfies((RelTrait)hash));
        Assertions.assertFalse((boolean)hash.satisfies((RelTrait)range));
        Assertions.assertTrue((boolean)hash.satisfies((RelTrait)random));
        Assertions.assertFalse((boolean)hash.satisfies((RelTrait)roundrobin));
        Assertions.assertFalse((boolean)hash.satisfies((RelTrait)broadcast));
        Assertions.assertFalse((boolean)hash.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)hash.satisfies((RelTrait)any));
        Assertions.assertFalse((boolean)range.satisfies((RelTrait)hash));
        Assertions.assertTrue((boolean)range.satisfies((RelTrait)range));
        Assertions.assertTrue((boolean)range.satisfies((RelTrait)random));
        Assertions.assertFalse((boolean)range.satisfies((RelTrait)roundrobin));
        Assertions.assertFalse((boolean)range.satisfies((RelTrait)broadcast));
        Assertions.assertFalse((boolean)range.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)range.satisfies((RelTrait)any));
        Assertions.assertFalse((boolean)random.satisfies((RelTrait)hash));
        Assertions.assertFalse((boolean)random.satisfies((RelTrait)range));
        Assertions.assertTrue((boolean)random.satisfies((RelTrait)random));
        Assertions.assertFalse((boolean)random.satisfies((RelTrait)roundrobin));
        Assertions.assertFalse((boolean)random.satisfies((RelTrait)broadcast));
        Assertions.assertFalse((boolean)random.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)random.satisfies((RelTrait)any));
        Assertions.assertFalse((boolean)roundrobin.satisfies((RelTrait)hash));
        Assertions.assertFalse((boolean)roundrobin.satisfies((RelTrait)range));
        Assertions.assertTrue((boolean)roundrobin.satisfies((RelTrait)random));
        Assertions.assertTrue((boolean)roundrobin.satisfies((RelTrait)roundrobin));
        Assertions.assertFalse((boolean)roundrobin.satisfies((RelTrait)broadcast));
        Assertions.assertFalse((boolean)roundrobin.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)roundrobin.satisfies((RelTrait)any));
        Assertions.assertFalse((boolean)broadcast.satisfies((RelTrait)hash));
        Assertions.assertFalse((boolean)broadcast.satisfies((RelTrait)range));
        Assertions.assertFalse((boolean)broadcast.satisfies((RelTrait)random));
        Assertions.assertFalse((boolean)broadcast.satisfies((RelTrait)roundrobin));
        Assertions.assertTrue((boolean)broadcast.satisfies((RelTrait)broadcast));
        Assertions.assertFalse((boolean)broadcast.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)broadcast.satisfies((RelTrait)any));
        Assertions.assertFalse((boolean)singleton.satisfies((RelTrait)hash));
        Assertions.assertFalse((boolean)singleton.satisfies((RelTrait)range));
        Assertions.assertFalse((boolean)singleton.satisfies((RelTrait)random));
        Assertions.assertFalse((boolean)singleton.satisfies((RelTrait)roundrobin));
        Assertions.assertFalse((boolean)singleton.satisfies((RelTrait)broadcast));
        Assertions.assertTrue((boolean)singleton.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)singleton.satisfies((RelTrait)any));
        Assertions.assertFalse((boolean)any.satisfies((RelTrait)hash));
        Assertions.assertFalse((boolean)any.satisfies((RelTrait)range));
        Assertions.assertFalse((boolean)any.satisfies((RelTrait)random));
        Assertions.assertFalse((boolean)any.satisfies((RelTrait)roundrobin));
        Assertions.assertFalse((boolean)any.satisfies((RelTrait)broadcast));
        Assertions.assertFalse((boolean)any.satisfies((RelTrait)singleton));
        Assertions.assertTrue((boolean)any.satisfies((RelTrait)any));
    }

    @Test
    public void testApply() {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)7, (int)2);
        mapping.set(6, 0);
        mapping.set(2, 1);
        Mapping finalMapping = mapping.inverse();
        FlinkRelDistribution hash1 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{1}), false);
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{2}), false), (Object)hash1.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution hash2 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{2}), false);
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.ANY(), (Object)hash2.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution hash12 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{1, 2}), false);
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.ANY(), (Object)hash12.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution hash01 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{0, 1}), false);
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{6, 2}), false), (Object)hash01.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution strictHash01 = FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{0, 1}), FlinkRelDistribution$.MODULE$.hash$default$2());
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.hash((Collection)ImmutableIntList.of((int[])new int[]{6, 2}), FlinkRelDistribution$.MODULE$.hash$default$2()), (Object)strictHash01.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution rangeAsc1 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1, RelFieldCollation.Direction.ASCENDING)}));
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(2)})), (Object)rangeAsc1.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution rangeDesc1 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1, RelFieldCollation.Direction.DESCENDING)}));
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(2, RelFieldCollation.Direction.DESCENDING)})), (Object)rangeDesc1.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution range12 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(1), new RelFieldCollation(2)}));
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.ANY(), (Object)range12.apply((Mappings.TargetMapping)finalMapping));
        FlinkRelDistribution range01 = FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(0), new RelFieldCollation(1)}));
        Assertions.assertEquals((Object)FlinkRelDistribution$.MODULE$.range((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelFieldCollation[]{new RelFieldCollation(6), new RelFieldCollation(2)})), (Object)range01.apply((Mappings.TargetMapping)finalMapping));
    }
}

