/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.stats.EmptyValueInterval$;
import org.apache.flink.table.planner.plan.stats.LeftSemiInfiniteValueInterval$;
import org.apache.flink.table.planner.plan.stats.RightSemiInfiniteValueInterval$;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval$;
import org.apache.flink.table.planner.plan.utils.ColumnIntervalUtil$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001#\t12i\u001c7v[:Le\u000e^3sm\u0006dW\u000b^5m)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u0003e!Xm\u001d;D_:4XM\u001d;Ok6\u0014WM\u001d+p'R\u0014\u0018N\\4\u0015\u0003\u0001\u0002\"aE\u0011\n\u0005\t\"\"\u0001B+oSRD#!\b\u0013\u0011\u0005\u0015bS\"\u0001\u0014\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYc\"A\u0003kk:LG/\u0003\u0002.M\t!A+Z:u\u0011\u0015y\u0003\u0001\"\u0001 \u0003e!Xm\u001d;OK\u001e\fG/\u001b<f-\u0006dW/Z%oi\u0016\u0014h/\u00197)\u00059\"\u0003\"\u0002\u001a\u0001\t\u0003y\u0012A\u0007;fgR<U\r\u001e,bYV,\u0017J\u001c;feZ\fGn\u00144QYV\u001c\bFA\u0019%\u0011\u0015)\u0004\u0001\"\u0001 \u0003y!Xm\u001d;HKR4\u0016\r\\;f\u0013:$XM\u001d<bY>3W*\u001e7uSBd\u0017\u0010\u000b\u00025I!)\u0001\b\u0001C\u0001?\u0005yB/Z:u\u000f\u0016$8i\u001c7v[:Le\u000e^3sm\u0006dw+\u001b;i\r&dG/\u001a:)\u0005]\"\u0003")
public class ColumnIntervalUtilTest {
    @Test
    public void testConvertNumberToString() {
        Assertions.assertEquals((Object)new Some((Object)"1"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)BoxesRunTime.boxToInteger((int)1)));
        Assertions.assertEquals((Object)new Some((Object)"1"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new Integer(1)));
        Assertions.assertEquals((Object)new Some((Object)"1"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((Object)new Some((Object)"1"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new Long(1L)));
        Assertions.assertEquals((Object)new Some((Object)"1.11"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)BoxesRunTime.boxToFloat((float)1.11f)));
        Assertions.assertEquals((Object)new Some((Object)"1.11"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new Float(1.11f)));
        Assertions.assertEquals((Object)new Some((Object)"1.11"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)BoxesRunTime.boxToDouble((double)1.11)));
        Assertions.assertEquals((Object)new Some((Object)"1.11"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new Double(1.11)));
        Assertions.assertEquals((Object)new Some((Object)"1"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new BigInt(new BigInteger("1"))));
        Assertions.assertEquals((Object)new Some((Object)"1"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new BigInteger("1")));
        Assertions.assertEquals((Object)new Some((Object)"1.11"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new scala.math.BigDecimal(new BigDecimal("1.11"))));
        Assertions.assertEquals((Object)new Some((Object)"1.11"), (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new BigDecimal("1.11")));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)"123"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ColumnIntervalUtil$.MODULE$.convertNumberToString((Object)new Date()));
    }

    @Test
    public void testNegativeValueInterval() {
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), true, true)), (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), true, true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), true, false)), (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), false, true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval((ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(-2), true)), (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval((ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(2), true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval((ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(2), true)), (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval((ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(-2), true)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval(ValueInterval$.MODULE$.apply((Object)"1", (Object)"2", true, true)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval(ValueInterval$.MODULE$.apply((Object)new Date(), (Object)new Date(), true, true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)-2.2f), (Object)BoxesRunTime.boxToFloat((float)-1.1f), true, true)), (Object)ColumnIntervalUtil$.MODULE$.getNegativeOfValueInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.1f), (Object)BoxesRunTime.boxToFloat((float)2.2f), true, true)));
    }

    @Test
    public void testGetValueIntervalOfPlus() {
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)6), true, false)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)2), true, false), ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), true, true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval((ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(5), false)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)2), true, false), (ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval((ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(2), true)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus((ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(-1), true), (ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), true)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval((ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(2), false)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)2), true, false), (ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), false)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval((ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(6), false)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus((ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), true), (ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), false)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus((ValueInterval)EmptyValueInterval$.MODULE$, ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)2), true, false)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus((ValueInterval)EmptyValueInterval$.MODULE$, (ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), true)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfPlus((ValueInterval)EmptyValueInterval$.MODULE$, (ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(3), false)));
    }

    @Test
    public void testGetValueIntervalOfMultiply() {
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-4), (Object)BoxesRunTime.boxToInteger((int)2), false, true)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)2), true, false), ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)1), true, false)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)4), false, false)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)2), true, true), ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), true, false)));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4), false, false)), (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), false, false), ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), false, false)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), false, false), (ValueInterval)EmptyValueInterval$.MODULE$));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), false, false), (ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(1), false)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2), (Object)BoxesRunTime.boxToInteger((int)-1), false, false), (ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(1), false)));
        Assertions.assertEquals(null, (Object)ColumnIntervalUtil$.MODULE$.getValueIntervalOfMultiply((ValueInterval)LeftSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(1), false), (ValueInterval)RightSemiInfiniteValueInterval$.MODULE$.apply((Comparable)Predef$.MODULE$.int2Integer(1), false)));
    }

    @Test
    public void testGetColumnIntervalWithFilter() {
        FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), FlinkTypeFactory$.MODULE$.$lessinit$greater$default$2());
        FlinkRexBuilder rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)typeFactory);
        RexNode predicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{rexBuilder.makeInputRef(typeFactory.createSqlType(SqlTypeName.BIGINT), 1), rexBuilder.makeBigintLiteral(BigDecimal.valueOf(1L))}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{rexBuilder.makeInputRef(typeFactory.createSqlType(SqlTypeName.BIGINT), 1), rexBuilder.makeBigintLiteral(BigDecimal.valueOf(10L))})}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(typeFactory.createSqlType(SqlTypeName.BIGINT), 1), rexBuilder.makeBigintLiteral(BigDecimal.valueOf(5L))})})});
        Object x$1 = null;
        long x$2 = 10L;
        boolean x$3 = false;
        boolean x$4 = ValueInterval$.MODULE$.apply$default$3();
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply(null, (Object)BoxesRunTime.boxToLong((long)x$2), x$4, x$3)), (Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)None$.MODULE$, predicate, 1, (RexBuilder)rexBuilder));
        Assertions.assertEquals((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToLong((long)8L), false, false)), (Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)new Some((Object)ColumnIntervalUtil$.MODULE$.toBigDecimalInterval(ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToLong((long)8L), false, false))), predicate, 1, (RexBuilder)rexBuilder));
        Assertions.assertEquals((Object)ValueInterval$.MODULE$.empty(), (Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)None$.MODULE$, (RexNode)rexBuilder.makeLiteral(false), 0, (RexBuilder)rexBuilder));
        Assertions.assertEquals((Object)ValueInterval$.MODULE$.empty(), (Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)new Some((Object)ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)10L), ValueInterval$.MODULE$.apply$default$3(), ValueInterval$.MODULE$.apply$default$4())), (RexNode)rexBuilder.makeLiteral(false), 0, (RexBuilder)rexBuilder));
        Assertions.assertNull((Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)None$.MODULE$, (RexNode)rexBuilder.makeLiteral(true), 0, (RexBuilder)rexBuilder));
        Assertions.assertEquals((Object)ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)10L), ValueInterval$.MODULE$.apply$default$3(), ValueInterval$.MODULE$.apply$default$4()), (Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)new Some((Object)ValueInterval$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)10L), ValueInterval$.MODULE$.apply$default$3(), ValueInterval$.MODULE$.apply$default$4())), (RexNode)rexBuilder.makeLiteral(true), 0, (RexBuilder)rexBuilder));
        Assertions.assertNull((Object)ColumnIntervalUtil$.MODULE$.getColumnIntervalWithFilter((Option)None$.MODULE$, (RexNode)rexBuilder.makeBigintLiteral(BigDecimal.ONE), 0, (RexBuilder)rexBuilder));
    }
}

