/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class ExecNodeMetadataUtilTest {
    private static final ConfigOption<Integer> OPTION_1 = ConfigOptions.key((String)"option1").intType().defaultValue((Object)-1).withDescription("option1");
    private static final ConfigOption<Integer> OPTION_2 = ConfigOptions.key((String)"option2").intType().defaultValue((Object)-1).withDescription("option2");
    private static final ConfigOption<Integer> OPTION_3 = ConfigOptions.key((String)"option3").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"option3-deprecated"}).withDescription("option3");
    private static final ConfigOption<Integer> OPTION_4 = ConfigOptions.key((String)"option4").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"option4-fallback"}).withDescription("option4");
    private static final ConfigOption<Integer> OPTION_5 = ConfigOptions.key((String)"option5").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"option5-fallback"}).withDeprecatedKeys(new String[]{"option5-deprecated"}).withDescription("option5");
    private static final ConfigOption<Integer> OPTION_6 = ConfigOptions.key((String)"option6").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"option6-deprecated"}).withFallbackKeys(new String[]{"option6-fallback"}).withDescription("option6");

    ExecNodeMetadataUtilTest() {
    }

    @Test
    void testNoJsonCreator() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeMetadataUtil.addTestNode(DummyNodeNoJsonCreator.class)).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeNoJsonCreator does not implement @JsonCreator annotation on constructor.");
    }

    @Test
    void testNoAnnotation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeMetadataUtil.addTestNode(DummyNodeNoAnnotation.class)).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeNoAnnotation is missing ExecNodeMetadata annotation.");
    }

    @Test
    void testBothAnnotations() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeMetadataUtil.addTestNode(DummyNodeBothAnnotations.class)).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeBothAnnotations is annotated both with interface org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata and interface org.apache.flink.table.planner.plan.nodes.exec.MultipleExecNodeMetadata. Please use only interface org.apache.flink.table.planner.plan.nodes.exec.MultipleExecNodeMetadata or multiple interface org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata");
    }

    @Test
    void testMultipleAnnotations() {
        ExecNodeMetadataUtil.addTestNode(DummyNode.class);
        Assertions.assertThat((Class)ExecNodeMetadataUtil.retrieveExecNode((String)"dummy-node", (int)1)).isSameAs(DummyNode.class);
        Assertions.assertThat((Class)ExecNodeMetadataUtil.retrieveExecNode((String)"dummy-node", (int)2)).isSameAs(DummyNode.class);
        Assertions.assertThat((Class)ExecNodeMetadataUtil.retrieveExecNode((String)"dummy-node", (int)3)).isSameAs(DummyNode.class);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ExecNodeMetadataUtil.latestAnnotation(DummyNode.class)).has(new Condition(m -> m.version() == 3, "version", new Object[0]))).has(new Condition(m -> m.minPlanVersion() == FlinkVersion.v1_15, "minPlanVersion", new Object[0]))).has(new Condition(m -> m.minPlanVersion() == FlinkVersion.v1_15, "minStateVersion", new Object[0]));
        Configuration config = new Configuration();
        config.set(OPTION_1, (Object)1);
        config.set(OPTION_2, (Object)2);
        config.set(OPTION_3, (Object)3);
        config.set(OPTION_4, (Object)4);
        config.set(OPTION_5, (Object)5);
        config.set(OPTION_6, (Object)6);
        ReadableConfig persistedConfig = ExecNodeMetadataUtil.newPersistedConfig(DummyNode.class, (ReadableConfig)config, Stream.of(OPTION_1, OPTION_2, OPTION_3, OPTION_4, OPTION_5, OPTION_6));
        Assertions.assertThat((Integer)((Integer)persistedConfig.get(OPTION_1))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)persistedConfig.get(OPTION_2))).isEqualTo(OPTION_2.defaultValue());
        Assertions.assertThat((Integer)((Integer)persistedConfig.get(OPTION_3))).isEqualTo(3);
        Assertions.assertThat((Integer)((Integer)persistedConfig.get(OPTION_4))).isEqualTo(4);
        Assertions.assertThat((Integer)((Integer)persistedConfig.get(OPTION_5))).isEqualTo(5);
        Assertions.assertThat((Integer)((Integer)persistedConfig.get(OPTION_6))).isEqualTo(OPTION_6.defaultValue());
        ExecNodeMetadataUtil.addTestNode(DummyNodeMultipleAnnotations.class);
        Assertions.assertThat((Class)ExecNodeMetadataUtil.retrieveExecNode((String)"dummy-node-multiple-annotations", (int)1)).isSameAs(DummyNodeMultipleAnnotations.class);
        Assertions.assertThat((Class)ExecNodeMetadataUtil.retrieveExecNode((String)"dummy-node-multiple-annotations", (int)2)).isSameAs(DummyNodeMultipleAnnotations.class);
        Assertions.assertThat((Class)ExecNodeMetadataUtil.retrieveExecNode((String)"dummy-node-multiple-annotations", (int)3)).isSameAs(DummyNodeMultipleAnnotations.class);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ExecNodeMetadataUtil.latestAnnotation(DummyNodeMultipleAnnotations.class)).has(new Condition(m -> m.version() == 3, "version", new Object[0]))).has(new Condition(m -> m.minPlanVersion() == FlinkVersion.v1_15, "minPlanVersion", new Object[0]))).has(new Condition(m -> m.minPlanVersion() == FlinkVersion.v1_15, "minStateVersion", new Object[0]));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeContext.newPersistedConfig(DummyNodeMultipleAnnotations.class, (ReadableConfig)config)).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeMultipleAnnotations, consumedOption: option111 not listed in [TableConfigOptions, ExecutionConfigOptions].");
    }

    @Test
    void testDuplicateConsumedOptions() {
        ExecNodeMetadataUtil.addTestNode(DummyNodeDuplicateConsumedOptions.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeMetadataUtil.newPersistedConfig(DummyNodeDuplicateConsumedOptions.class, (ReadableConfig)new Configuration(), Stream.of(OPTION_1, OPTION_2, OPTION_3))).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeDuplicateConsumedOptions, consumedOption: option2 is listed multiple times in consumedOptions, potentially also with fallback/deprecated key.");
    }

    @Test
    void testDuplicateDeprecatedKeysConsumedOptions() {
        ExecNodeMetadataUtil.addTestNode(DummyNodeDuplicateDeprecatedKeysConsumedOptions.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeMetadataUtil.newPersistedConfig(DummyNodeDuplicateDeprecatedKeysConsumedOptions.class, (ReadableConfig)new Configuration(), Stream.of(OPTION_1, OPTION_2, OPTION_3))).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeDuplicateDeprecatedKeysConsumedOptions, consumedOption: option3-deprecated is listed multiple times in consumedOptions, potentially also with fallback/deprecated key.");
    }

    @Test
    void testDuplicateFallbackKeysConsumedOptions() {
        ExecNodeMetadataUtil.addTestNode(DummyNodeDuplicateFallbackKeysConsumedOptions.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeMetadataUtil.newPersistedConfig(DummyNodeDuplicateFallbackKeysConsumedOptions.class, (ReadableConfig)new Configuration(), Stream.of(OPTION_1, OPTION_2, OPTION_4))).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeDuplicateFallbackKeysConsumedOptions, consumedOption: option4-fallback is listed multiple times in consumedOptions, potentially also with fallback/deprecated key.");
    }

    @Test
    void testNewContext() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeContext.newContext(DummyNodeNoAnnotation.class)).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNodeNoAnnotation is not listed in the unsupported classes and it is not annotated with: ExecNodeMetadata.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExecNodeContext.newContext(DummyNode.class)).isInstanceOf(IllegalStateException.class)).hasMessage("ExecNode: org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtilTest.DummyNode is not listed in the supported classes and yet is annotated with: ExecNodeMetadata.");
    }

    @Test
    void testStreamExecNodeJsonSerdeCoverage() {
        Set subClasses = ExecNodeMetadataUtil.execNodes();
        ArrayList<Class> classesWithoutJsonCreator = new ArrayList<Class>();
        ArrayList<Class> classesWithJsonCreatorInUnsupportedList = new ArrayList<Class>();
        for (Class clazz : subClasses) {
            boolean hasJsonCreator = ExecNodeMetadataUtil.hasJsonCreatorAnnotation((Class)clazz);
            if (hasJsonCreator && ExecNodeMetadataUtil.UNSUPPORTED_JSON_SERDE_CLASSES.contains(clazz)) {
                classesWithJsonCreatorInUnsupportedList.add(clazz);
            }
            if (hasJsonCreator || ExecNodeMetadataUtil.UNSUPPORTED_JSON_SERDE_CLASSES.contains(clazz)) continue;
            classesWithoutJsonCreator.add(clazz);
        }
        ((ListAssert)Assertions.assertThat(classesWithoutJsonCreator).as("%s do not support json serialization/deserialization, please refer the implementation of the other StreamExecNodes.", new Object[]{classesWithoutJsonCreator.stream().map(Class::getSimpleName).collect(Collectors.joining(","))})).isEmpty();
        ((ListAssert)Assertions.assertThat(classesWithJsonCreatorInUnsupportedList).as("%s have support for json serialization/deserialization, but still in UNSUPPORTED_JSON_SERDE_CLASSES list. please move them from UNSUPPORTED_JSON_SERDE_CLASSES.", new Object[]{classesWithJsonCreatorInUnsupportedList.stream().map(Class::getSimpleName).collect(Collectors.joining(","))})).isEmpty();
    }

    private static class AbstractDummyNode
    extends ExecNodeBase<RowData> {
        protected AbstractDummyNode(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(10, context, persistedConfig, properties, outputType, description);
        }

        protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
            return null;
        }
    }

    @ExecNodeMetadata(name="dummy-node-duplicate-fallback-keys-consumedOptions", version=3, consumedOptions={"option1", "option2", "option4", "option4-fallback"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
    private static class DummyNodeDuplicateFallbackKeysConsumedOptions
    extends AbstractDummyNode {
        @JsonCreator
        protected DummyNodeDuplicateFallbackKeysConsumedOptions(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    @ExecNodeMetadata(name="dummy-node-duplicate-deprecated-keys-consumedOptions", version=3, consumedOptions={"option1", "option2", "option3", "option3-deprecated"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
    private static class DummyNodeDuplicateDeprecatedKeysConsumedOptions
    extends AbstractDummyNode {
        @JsonCreator
        protected DummyNodeDuplicateDeprecatedKeysConsumedOptions(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    @ExecNodeMetadata(name="dummy-node-duplicate-consumedOptions", version=3, consumedOptions={"option1", "option2", "option3", "option2"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
    private static class DummyNodeDuplicateConsumedOptions
    extends AbstractDummyNode {
        @JsonCreator
        protected DummyNodeDuplicateConsumedOptions(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    @MultipleExecNodeMetadata(value={@ExecNodeMetadata(name="dummy-node", version=1, minPlanVersion=FlinkVersion.v1_14, minStateVersion=FlinkVersion.v1_14), @ExecNodeMetadata(name="dummy-node", version=2, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)})
    @ExecNodeMetadata(name="dummy-node", version=3, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
    private static class DummyNodeBothAnnotations
    extends AbstractDummyNode {
        @JsonCreator
        protected DummyNodeBothAnnotations(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    private static class DummyNodeNoAnnotation
    extends AbstractDummyNode
    implements StreamExecNode<RowData> {
        @JsonCreator
        protected DummyNodeNoAnnotation(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    private static class DummyNodeNoJsonCreator
    extends AbstractDummyNode {
        protected DummyNodeNoJsonCreator(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    @MultipleExecNodeMetadata(value={@ExecNodeMetadata(name="dummy-node-multiple-annotations", version=1, consumedOptions={"option1", "option2"}, minPlanVersion=FlinkVersion.v1_13, minStateVersion=FlinkVersion.v1_13), @ExecNodeMetadata(name="dummy-node-multiple-annotations", version=2, consumedOptions={"option11", "option22"}, minPlanVersion=FlinkVersion.v1_14, minStateVersion=FlinkVersion.v1_14), @ExecNodeMetadata(name="dummy-node-multiple-annotations", version=3, consumedOptions={"option111", "option222"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)})
    private static class DummyNodeMultipleAnnotations
    extends AbstractDummyNode {
        @JsonCreator
        protected DummyNodeMultipleAnnotations(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }

    @MultipleExecNodeMetadata(value={@ExecNodeMetadata(name="dummy-node", version=1, consumedOptions={"option1", "option3-deprecated", "option5-deprecated"}, minPlanVersion=FlinkVersion.v1_13, minStateVersion=FlinkVersion.v1_13), @ExecNodeMetadata(name="dummy-node", version=2, consumedOptions={"option2", "option3-deprecated", "option5", "option6-fallback"}, minPlanVersion=FlinkVersion.v1_14, minStateVersion=FlinkVersion.v1_14), @ExecNodeMetadata(name="dummy-node", version=3, consumedOptions={"option1", "option3", "option4-fallback", "option5-deprecated"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)})
    private static class DummyNode
    extends AbstractDummyNode {
        @JsonCreator
        protected DummyNode(ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> properties, LogicalType outputType, String description) {
            super(context, persistedConfig, properties, outputType, description);
        }
    }
}

