/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.ExpressionReducer;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001#\t\u0001b\t\\5oWJ+\u00070\u0016;jYR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u001e;jYNT!!\u0002\u0004\u0002\tAd\u0017M\u001c\u0006\u0003\u000f!\tq\u0001\u001d7b]:,'O\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001b\u0001\n\u0013y\u0012a\u0003;za\u00164\u0015m\u0019;pef,\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0019\tqaY1mG&$X-\u0003\u0002&E\t\u0001b\t\\5oWRK\b/\u001a$bGR|'/\u001f\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0019QL\b/\u001a$bGR|'/\u001f\u0011\t\u000f%\u0002!\u0019!C\u0005U\u0005Q!/\u001a=Ck&dG-\u001a:\u0016\u0003-\u0002\"!\t\u0017\n\u00055\u0012#a\u0004$mS:\\'+\u001a=Ck&dG-\u001a:\t\r=\u0002\u0001\u0015!\u0003,\u0003-\u0011X\r\u001f\"vS2$WM\u001d\u0011\t\u000fE\u0002!\u0019!C\u0005e\u0005Ya/\u0019:dQ\u0006\u0014H+\u001f9f+\u0005\u0019\u0004C\u0001\u001b;\u001b\u0005)$B\u0001\u001c8\u0003\u0011!\u0018\u0010]3\u000b\u0005aJ\u0014a\u0001:fY*\u00111\u0005D\u0005\u0003wU\u00121BU3m\t\u0006$\u0018\rV=qK\"1Q\b\u0001Q\u0001\nM\nAB^1sG\"\f'\u000fV=qK\u0002Bqa\u0010\u0001C\u0002\u0013%!'A\u0004j]R$\u0016\u0010]3\t\r\u0005\u0003\u0001\u0015!\u00034\u0003!Ig\u000e\u001e+za\u0016\u0004\u0003\"B\"\u0001\t\u0003!\u0015A\u0007;fgR$vn\u00118g?\u000e{W\u000e\u001d7fqB\u0013X\rZ5dCR,G#A#\u0011\u0005M1\u0015BA$\u0015\u0005\u0011)f.\u001b;)\u0005\tK\u0005C\u0001&R\u001b\u0005Y%B\u0001'N\u0003\r\t\u0007/\u001b\u0006\u0003\u001d>\u000bqA[;qSR,'O\u0003\u0002Q\u001d\u0005)!.\u001e8ji&\u0011!k\u0013\u0002\u0005)\u0016\u001cH\u000fC\u0003U\u0001\u0011\u0005A)A\ruKN$Hk\\\"oM~\u001b\u0016.\u001c9mKB\u0013X\rZ5dCR,\u0007FA*J\u0011\u00159\u0006\u0001\"\u0001E\u00031!Xm\u001d;TS6\u0004H.\u001b4zQ\t1\u0016\nC\u0003[\u0001\u0011\u00051,\u0001\u0006j]Rd\u0015\u000e^3sC2$\"\u0001\u00182\u0011\u0005u\u0003W\"\u00010\u000b\u0005}K\u0014a\u0001:fq&\u0011\u0011M\u0018\u0002\u000b%\u0016DH*\u001b;fe\u0006d\u0007\"B2Z\u0001\u0004!\u0017!\u0001=\u0011\u0005M)\u0017B\u00014\u0015\u0005\rIe\u000e\u001e\u0005\u0006Q\u0002!\t![\u0001\tg&l\u0007\u000f\\5gsR\u0019!.\\9\u0011\u0005u[\u0017B\u00017_\u0005\u001d\u0011V\r\u001f(pI\u0016DQ!K4A\u00029\u0004\"!X8\n\u0005At&A\u0003*fq\n+\u0018\u000e\u001c3fe\")!o\u001aa\u0001U\u0006!Q\r\u001f9s\u0011\u0015!\b\u0001\"\u0003v\u0003Ei\u0017m[3U_\n{w\u000e\\3b]\u000e\u000b7\u000f\u001e\u000b\u0003UZDQa^:A\u0002)\f\u0001B\u001a:p[\u0012\u000bG/\u0019")
public class FlinkRexUtilTest {
    private final FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), FlinkTypeFactory$.MODULE$.$lessinit$greater$default$2());
    private final FlinkRexBuilder rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
    private final RelDataType varcharType = this.typeFactory().createSqlType(SqlTypeName.VARCHAR);
    private final RelDataType intType = this.typeFactory().createSqlType(SqlTypeName.INTEGER);

    private FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    private FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    private RelDataType varcharType() {
        return this.varcharType;
    }

    private RelDataType intType() {
        return this.intType;
    }

    @Test
    public void testToCnf_ComplexPredicate() {
        RexInputRef i_manufact = this.rexBuilder().makeInputRef(this.varcharType(), 0);
        RexInputRef i_category = this.rexBuilder().makeInputRef(this.varcharType(), 1);
        RexInputRef i_color = this.rexBuilder().makeInputRef(this.varcharType(), 2);
        RexInputRef i_units = this.rexBuilder().makeInputRef(this.varcharType(), 3);
        RexInputRef i_size = this.rexBuilder().makeInputRef(this.varcharType(), 4);
        RexNode predicate = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_manufact, this.rexBuilder().makeLiteral("able")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Women")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("powder")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("khaki")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Ounce")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Oz")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("medium")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("extra large")})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Women")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("brown")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("honeydew")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Bunch")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Ton")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("N/A")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("small")})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Men")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("floral")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("deep")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("N/A")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Dozen")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("petite")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("large")})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Men")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("light")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("cornflower")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Box")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Pound")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("medium")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("extra large")})})})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_manufact, this.rexBuilder().makeLiteral("able")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Women")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("midnight")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("snow")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Pallet")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Gross")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("medium")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("extra large")})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Women")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("cyan")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("papaya")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Cup")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Dram")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("N/A")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("small")})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Men")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("orange")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("frosted")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Each")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Tbl")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("petite")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("large")})})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_category, this.rexBuilder().makeLiteral("Men")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("forest")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_color, this.rexBuilder().makeLiteral("ghost")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Lb")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_units, this.rexBuilder().makeLiteral("Bundle")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("medium")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i_size, this.rexBuilder().makeLiteral("extra large")})})})})})});
        RexNode newPredicate1 = FlinkRexUtil$.MODULE$.toCnf((RexBuilder)this.rexBuilder(), -1, predicate);
        Assertions.assertEquals((Object)predicate.toString(), (Object)newPredicate1.toString());
        RexNode newPredicate2 = FlinkRexUtil$.MODULE$.toCnf((RexBuilder)this.rexBuilder(), 200, predicate);
        Assertions.assertEquals((Object)predicate.toString(), (Object)newPredicate2.toString());
        RexNode newPredicate3 = FlinkRexUtil$.MODULE$.toCnf((RexBuilder)this.rexBuilder(), 2103039, predicate);
        Assertions.assertEquals((Object)RexUtil.toCnf((RexBuilder)this.rexBuilder(), (RexNode)predicate).toString(), (Object)newPredicate3.toString());
        RexNode newPredicate4 = FlinkRexUtil$.MODULE$.toCnf((RexBuilder)this.rexBuilder(), Integer.MAX_VALUE, predicate);
        Assertions.assertFalse((boolean)predicate.equals((Object)newPredicate4));
        Assertions.assertEquals((Object)RexUtil.toCnf((RexBuilder)this.rexBuilder(), (RexNode)predicate).toString(), (Object)newPredicate4.toString());
    }

    @Test
    public void testToCnf_SimplePredicate() {
        RexInputRef a = this.rexBuilder().makeInputRef(this.varcharType(), 0);
        RexInputRef b = this.rexBuilder().makeInputRef(this.varcharType(), 1);
        RexInputRef c = this.rexBuilder().makeInputRef(this.varcharType(), 2);
        RexNode predicate = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, this.rexBuilder().makeLiteral("1")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, this.rexBuilder().makeLiteral("2")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.rexBuilder().makeLiteral("3")})});
        RexNode expected = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, this.rexBuilder().makeLiteral("1")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.rexBuilder().makeLiteral("3")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, this.rexBuilder().makeLiteral("2")}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.rexBuilder().makeLiteral("3")})})});
        RexNode newPredicate1 = FlinkRexUtil$.MODULE$.toCnf((RexBuilder)this.rexBuilder(), -1, predicate);
        Assertions.assertEquals((Object)expected.toString(), (Object)newPredicate1.toString());
        Assertions.assertEquals((Object)expected.toString(), (Object)RexUtil.toCnf((RexBuilder)this.rexBuilder(), (RexNode)predicate).toString());
        RexNode newPredicate2 = FlinkRexUtil$.MODULE$.toCnf((RexBuilder)this.rexBuilder(), 0, predicate);
        Assertions.assertEquals((Object)predicate.toString(), (Object)newPredicate2.toString());
    }

    @Test
    public void testSimplify() {
        RexInputRef a = this.rexBuilder().makeInputRef(this.varcharType(), 0);
        RexInputRef b = this.rexBuilder().makeInputRef(this.varcharType(), 1);
        RexInputRef c = this.rexBuilder().makeInputRef(this.intType(), 2);
        RexInputRef d = this.rexBuilder().makeInputRef(this.intType(), 3);
        RexNode predicate0 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b})});
        RexNode newPredicate0 = this.simplify((RexBuilder)this.rexBuilder(), predicate0);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}).toString(), (Object)newPredicate0.toString());
        RexNode predicate1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, a})});
        RexNode newPredicate1 = this.simplify((RexBuilder)this.rexBuilder(), predicate1);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}).toString(), (Object)newPredicate1.toString());
        RexNode predicate2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, a})});
        RexNode newPredicate2 = this.simplify((RexBuilder)this.rexBuilder(), predicate2);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}).toString(), (Object)newPredicate2.toString());
        RexNode predicate3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, a}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{d, c})});
        RexNode newPredicate3 = this.simplify((RexBuilder)this.rexBuilder(), predicate3);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d})}).toString(), (Object)newPredicate3.toString());
        RexNode predicate4 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{this.rexBuilder().makeCast(this.typeFactory().createSqlType(SqlTypeName.INTEGER), (RexNode)a), c}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{c, this.rexBuilder().makeCast(this.typeFactory().createSqlType(SqlTypeName.INTEGER), (RexNode)a)})});
        RexNode newPredicate4 = this.simplify((RexBuilder)this.rexBuilder(), predicate4);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{this.rexBuilder().makeCast(this.typeFactory().createSqlType(SqlTypeName.INTEGER), (RexNode)a), c}).toString(), (Object)newPredicate4.toString());
        RexNode aSubstring13 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{a, this.rexBuilder().makeBigintLiteral(BigDecimal.ONE), this.rexBuilder().makeBigintLiteral(BigDecimal.valueOf(3L))});
        RexNode dPlus1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{d, this.rexBuilder().makeBigintLiteral(BigDecimal.ONE)});
        RexNode predicate5 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{aSubstring13, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{c, dPlus1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{dPlus1, c})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, aSubstring13}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{dPlus1, c}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{c, dPlus1})})});
        RexNode newPredicate5 = this.simplify((RexBuilder)this.rexBuilder(), predicate5);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{aSubstring13, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{c, dPlus1})}).toString(), (Object)newPredicate5.toString());
        RexNode predicate6 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{a, this.rexBuilder().makeLiteral("l")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, a}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{d, c}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{b, this.rexBuilder().makeLiteral("k")})})});
        RexNode newPredicate6 = this.simplify((RexBuilder)this.rexBuilder(), predicate6);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{a, this.rexBuilder().makeLiteral("l")})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{b, this.rexBuilder().makeLiteral("k")})})}).toString(), (Object)newPredicate6.toString());
        RexNode predicate7 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d})}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b, a})});
        RexNode newPredicate7 = this.simplify((RexBuilder)this.rexBuilder(), predicate7);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, d})}).toString(), (Object)newPredicate7.toString());
        RexNode predicate8 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{b, a}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{a, b}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, d})})});
        RexNode newPredicate8 = this.simplify((RexBuilder)this.rexBuilder(), predicate8);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{b, a}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, d})}).toString(), (Object)newPredicate8.toString());
        RexNode predicate9 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeLiteral(true), this.rexBuilder().makeLiteral(true)});
        RexNode newPredicate9 = this.simplify((RexBuilder)this.rexBuilder(), predicate9);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(true).toString(), (Object)newPredicate9.toString());
        RexNode predicate10 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeLiteral(false), this.rexBuilder().makeLiteral(false)});
        RexNode newPredicate10 = this.simplify((RexBuilder)this.rexBuilder(), predicate10);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(false).toString(), (Object)newPredicate10.toString());
        RexNode predicate11 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a, a});
        RexNode newPredicate11 = this.simplify((RexBuilder)this.rexBuilder(), predicate11);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(true).toString(), (Object)newPredicate11.toString());
        RexNode predicate12 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{a, a});
        RexNode newPredicate12 = this.simplify((RexBuilder)this.rexBuilder(), predicate12);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(true).toString(), (Object)newPredicate12.toString());
        RexNode predicate13 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{a, a});
        RexNode newPredicate13 = this.simplify((RexBuilder)this.rexBuilder(), predicate13);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(true).toString(), (Object)newPredicate13.toString());
        RexNode predicate14 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{a, a});
        RexNode newPredicate14 = this.simplify((RexBuilder)this.rexBuilder(), predicate14);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(false).toString(), (Object)newPredicate14.toString());
        RexNode predicate15 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{a, a});
        RexNode newPredicate15 = this.simplify((RexBuilder)this.rexBuilder(), predicate15);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(false).toString(), (Object)newPredicate15.toString());
        RexNode predicate16 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{a, a});
        RexNode newPredicate16 = this.simplify((RexBuilder)this.rexBuilder(), predicate16);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(false).toString(), (Object)newPredicate16.toString());
        RexNode predicate17Equals = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.intLiteral(0)});
        RexNode predicate17 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{predicate17Equals, this.rexBuilder().makeIn((RexNode)c, Arrays.asList((Object[])new RexLiteral[]{this.intLiteral(0), this.intLiteral(1)}))});
        RexNode newPredicate17 = this.simplify((RexBuilder)this.rexBuilder(), predicate17);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.intLiteral(0)}).toString(), (Object)newPredicate17.toString());
        RexNode predicate18Search = this.rexBuilder().makeIn((RexNode)c, Arrays.asList((Object[])new RexLiteral[]{this.intLiteral(0), this.intLiteral(1)}));
        RexNode predicate18 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.intLiteral(0)}), predicate18Search});
        RexNode newPredicate18 = this.simplify((RexBuilder)this.rexBuilder(), predicate18);
        Assertions.assertEquals((Object)predicate18Search.toString(), (Object)newPredicate18.toString());
        RexNode predicate19Layer2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeIn((RexNode)c, Arrays.asList((Object[])new RexLiteral[]{this.intLiteral(1), this.intLiteral(2)})), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{c, this.intLiteral(2)})});
        RexNode predicate19Layer1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeIn((RexNode)c, Arrays.asList((Object[])new RexLiteral[]{this.intLiteral(0), this.intLiteral(1)})), predicate19Layer2});
        RexNode predicate19 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{c, this.intLiteral(0)}), predicate19Layer1});
        RexNode newPredicate19 = this.simplify((RexBuilder)this.rexBuilder(), predicate19);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{c, this.intLiteral(1)}).toString(), (Object)newPredicate19.toString());
        RexNode predicate20 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{c, this.intLiteral(0)}), predicate18Search});
        RexNode newPredicate20 = this.simplify((RexBuilder)this.rexBuilder(), predicate20);
        Assertions.assertEquals((Object)this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{c, this.intLiteral(0)}).toString(), (Object)newPredicate20.toString());
        RexLiteral predicate21CastFromData = this.intLiteral(1);
        RexNode predicate21Cast = this.makeToBooleanCast((RexNode)predicate21CastFromData);
        RexNode newPredicate21 = this.simplify((RexBuilder)this.rexBuilder(), predicate21Cast);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(true).toString(), (Object)newPredicate21.toString());
        RexLiteral predicate22CastFromData = this.intLiteral(0);
        RexNode predicate22Cast = this.makeToBooleanCast((RexNode)predicate22CastFromData);
        RexNode newPredicate22 = this.simplify((RexBuilder)this.rexBuilder(), predicate22Cast);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(false).toString(), (Object)newPredicate22.toString());
        RexLiteral predicate23CastFromData = this.intLiteral(-1);
        RexNode predicate23Cast = this.makeToBooleanCast((RexNode)predicate23CastFromData);
        RexNode newPredicate23 = this.simplify((RexBuilder)this.rexBuilder(), predicate23Cast);
        Assertions.assertEquals((Object)this.rexBuilder().makeLiteral(true).toString(), (Object)newPredicate23.toString());
    }

    public RexLiteral intLiteral(int x) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(x));
    }

    public RexNode simplify(RexBuilder rexBuilder, RexNode expr) {
        ExpressionReducer expressionReducer = new ExpressionReducer(TableConfig.getDefault(), Thread.currentThread().getContextClassLoader(), false);
        return FlinkRexUtil$.MODULE$.simplify(rexBuilder, expr, (RexExecutor)expressionReducer);
    }

    private RexNode makeToBooleanCast(RexNode fromData) {
        BasicSqlType booleanType = new BasicSqlType(this.typeFactory().getTypeSystem(), SqlTypeName.BOOLEAN);
        return this.rexBuilder().makeCall((RelDataType)booleanType, (SqlOperator)SqlStdOperatorTable.CAST, Collections.singletonList(fromData));
    }
}

