/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.FileSystemITCaseBase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005daB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0015\r&dWmU=ti\u0016l\u0017\nV\"bg\u0016\u0014\u0015m]3\u000b\u0005\r!\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004%S:LG\u000f\n\u000b\u00023A\u0011\u0011CG\u0005\u00037I\u0011A!\u00168ji\"IQ\u0004\u0001a\u0001\u0002\u0004%\tBH\u0001\u000be\u0016\u001cX\u000f\u001c;QCRDW#A\u0010\u0011\u0005\u0001:cBA\u0011&!\t\u0011##D\u0001$\u0015\t!c\"\u0001\u0004=e>|GOP\u0005\u0003MI\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011aE\u0005\u0005\nW\u0001\u0001\r\u00111A\u0005\u00121\naB]3tk2$\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002\u001a[!9aFKA\u0001\u0002\u0004y\u0012a\u0001=%c!I\u0001\u0007\u0001a\u0001\u0002\u0004%\t\"M\u0001\u000fM&dW\rV3na\u001a{G\u000eZ3s+\u0005\u0011\u0004CA\u001a;\u001b\u0005!$BA\u001b7\u0003\u00111\u0017\u000e\\3\u000b\u0005]B\u0014a\u00018j_*\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e5\u0005\u0011\u0001\u0016\r\u001e5)\u0005=j\u0004C\u0001 H\u001b\u0005y$B\u0001!B\u0003\tIwN\u0003\u0002C\u0007\u0006\u0019\u0011\r]5\u000b\u0005\u0011+\u0015a\u00026va&$XM\u001d\u0006\u0003\r2\tQA[;oSRL!\u0001S \u0003\u000fQ+W\u000e\u001d#je\"I!\n\u0001a\u0001\u0002\u0004%\tbS\u0001\u0013M&dW\rV3na\u001a{G\u000eZ3s?\u0012*\u0017\u000f\u0006\u0002\u001a\u0019\"9a&SA\u0001\u0002\u0004\u0011\u0004\"\u0002(\u0001\t\u0003y\u0015\u0001\u00054pe6\fG\u000f\u0015:pa\u0016\u0014H/[3t)\u0005\u0001\u0006cA\tR?%\u0011!K\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006)\u0002!\tAH\u0001\nO\u0016$8k\u00195f[\u0016DQA\u0016\u0001\u0007\u0002]\u000b\u0001\u0002^1cY\u0016,eN^\u000b\u00021B\u0011\u0011lW\u0007\u00025*\u0011!IB\u0005\u00039j\u0013\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\t\u000by\u0003a\u0011A0\u0002\u001d\rDWmY6Qe\u0016$\u0017nY1uKR\u0019\u0011\u0004\u00192\t\u000b\u0005l\u0006\u0019A\u0010\u0002\u0011M\fH.U;fefDQaY/A\u0002\u0011\f\u0011b\u00195fG.4UO\\2\u0011\tE)w-G\u0005\u0003MJ\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005!\\W\"A5\u000b\u0005)D\u0011!\u0002;za\u0016\u001c\u0018B\u00017j\u0005\r\u0011vn\u001e\u0005\u0006]\u00021\ta\\\u0001\u0006G\",7m\u001b\u000b\u00043A\f\b\"B1n\u0001\u0004y\u0002\"\u0002:n\u0001\u0004\u0019\u0018AD3ya\u0016\u001cG/\u001a3SKN,H\u000e\u001e\t\u0004i^<W\"A;\u000b\u0005Y\u0014\u0012AC2pY2,7\r^5p]&\u0011\u00010\u001e\u0002\u0004'\u0016\f\b\"\u00028\u0001\t\u0003QHcA\r|y\")\u0011-\u001fa\u0001?!)!/\u001fa\u0001{B!a0a\u0001h\u001b\u0005y(bAA\u0001q\u0005!Q\u000f^5m\u0013\r\t)a \u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002\n\u0001!\t!a\u0003\u0002/M,\b\u000f]8siN\u0014V-\u00193j]\u001elU\r^1eCR\fWCAA\u0007!\r\t\u0012qB\u0005\u0004\u0003#\u0011\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003+\u0001A\u0011\u0001\r\u0002\t=\u0004XM\u001c\u0005\u0007\u00033\u0001A\u0011\u0001\r\u0002mQ,7\u000f^*fY\u0016\u001cG\u000fR3dS6\fGnV5uQB\u0013XmY5tS>tG+\u001a8B]\u0012TVM]8Ge>lg)\u001b7f'f\u001cH/Z7)\t\u0005]\u0011Q\u0004\t\u0005\u0003?\t\t#D\u0001B\u0013\r\t\u0019#\u0011\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0007\u0003O\u0001A\u0011\u0001\r\u0002oQ,7\u000f^*fY\u0016\u001cG\u000fR3dS6\fGnV5uQB\u0013XmY5tS>tG\u000b\u001b:fK\u0006sG\rV<p\rJ|WNR5mKNK8\u000f^3nQ\u0011\t)#!\b\t\r\u00055\u0002\u0001\"\u0001\u0019\u0003a!Xm\u001d;BY2\u001cF/\u0019;jGB\u000b'\u000f^5uS>t7/\r\u0015\u0005\u0003W\ti\u0002\u0003\u0004\u00024\u0001!\t\u0001G\u0001\u0019i\u0016\u001cH/\u00117m'R\fG/[2QCJ$\u0018\u000e^5p]N\u0014\u0004\u0006BA\u0019\u0003;Aa!!\u000f\u0001\t\u0003A\u0012a\t;fgR\fE\u000e\\*uCRL7\rU1si&$\u0018n\u001c8t/&$\b.T3uC\u0012\fG/\u0019\u0015\u0005\u0003o\ti\u0002\u0003\u0004\u0002@\u0001!\t\u0001G\u0001\u001ci\u0016\u001cH\u000fU1si&\fG\u000eR=oC6L7\rU1si&$\u0018n\u001c8)\t\u0005u\u0012Q\u0004\u0005\u0007\u0003\u000b\u0002A\u0011\u0001\r\u0002)Q,7\u000f\u001e#z]\u0006l\u0017n\u0019)beRLG/[8oQ\u0011\t\u0019%!\b\t\r\u0005-\u0003\u0001\"\u0001\u0019\u0003m!Xm\u001d;QCJ$\u0018\u000e^5p]^KG\u000f\u001b%jI\u0012,gNR5mK\"\"\u0011\u0011JA\u000f\u0011\u0019\t\t\u0006\u0001C\u00011\u0005\u0001B/Z:u\u001d>t\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003\u001f\ni\u0002\u0003\u0004\u0002X\u0001!\t\u0001G\u0001\u001di\u0016\u001cHOT8o!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5NKR\fG-\u0019;bQ\u0011\t)&!\b\t\r\u0005u\u0003\u0001\"\u0001\u0019\u0003M!Xm\u001d;SK\u0006$\u0017\t\u001c7NKR\fG-\u0019;bQ\u0011\tY&!\b\t\r\u0005\r\u0004\u0001\"\u0001\u0019\u0003E!Xm\u001d;MS6LG\u000fU;tQ\u0012{wO\u001c\u0015\u0005\u0003C\ni\u0002\u0003\u0004\u0002j\u0001!\t\u0001G\u0001\u0013i\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000e\u000b\u0003\u0002h\u0005u\u0001BBA8\u0001\u0011\u0005\u0001$A\nuKN$\bK]8kK\u000e$\b+^:i\t><h\u000e\u000b\u0003\u0002n\u0005u\u0001BBA;\u0001\u0011\u0005\u0001$\u0001\tuKN$\u0018J\\:feR\f\u0005\u000f]3oI\"\"\u00111OA\u000f\u0011\u0019\tY\b\u0001C\u00011\u0005\u0019B/Z:u\u0013:\u001cXM\u001d;Pm\u0016\u0014xO]5uK\"\"\u0011\u0011PA\u000f\u0011\u0019\t\t\t\u0001C\u00011\u0005yB/Z:u\u0007V\u001cHo\\7QCJ$\u0018\u000e^5p]\u000e{W.\\5u!>d\u0017nY=)\t\u0005}\u0014QD\u0004\b\u0003\u000f\u0013\u0001\u0012AAE\u0003Q1\u0015\u000e\\3TsN$X-\\%U\u0007\u0006\u001cXMQ1tKB!\u00111RAG\u001b\u0005\u0011aAB\u0001\u0003\u0011\u0003\tyiE\u0002\u0002\u000eBA\u0001\"a%\u0002\u000e\u0012\u0005\u0011QS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005%\u0005BCAM\u0003\u001b\u0013\r\u0011\"\u0001\u0002\u001c\u0006Qa-[3mI:\u000bW.Z:\u0016\u0005\u0005u\u0005\u0003B\tR\u0003?\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003KC\u0014\u0001\u00027b]\u001eL1\u0001KAR\u0011%\tY+!$!\u0002\u0013\ti*A\u0006gS\u0016dGMT1nKN\u0004\u0003BCAX\u0003\u001b\u0013\r\u0011\"\u0001\u00022\u0006Qa-[3mIRK\b/Z:\u0016\u0005\u0005M\u0006\u0003B\tR\u0003k\u0003D!a.\u0002NB1\u0011\u0011XAc\u0003\u0013l!!a/\u000b\t\u0005u\u0016qX\u0001\tif\u0004X-\u001b8g_*!\u0011\u0011YAb\u0003\u0019\u0019w.\\7p]*\u0011!\tC\u0005\u0005\u0003\u000f\fYLA\bUsB,\u0017J\u001c4pe6\fG/[8o!\u0011\tY-!4\r\u0001\u0011a\u0011qZAi\u0003\u0003\u0005\tQ!\u0001\u0002V\n\u0019q\fJ\u0019\t\u0013\u0005M\u0017Q\u0012Q\u0001\n\u0005M\u0016a\u00034jK2$G+\u001f9fg\u0002\nB!a6\u0002^B\u0019\u0011#!7\n\u0007\u0005m'CA\u0004O_RD\u0017N\\4\u0011\u0007E\ty.C\u0002\u0002bJ\u00111!\u00118z\u0011)\t)/!$C\u0002\u0013\u0005\u0011q]\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u001e\t\u0005\u0003W\f\u00190\u0004\u0002\u0002n*!\u0011q^Ay\u0003%!\u0018\u0010]3vi&d7OC\u0002:\u0003\u0007LA!!>\u0002n\nY!k\\<UsB,\u0017J\u001c4p\u0011%\tI0!$!\u0002\u0013\tI/A\u0005eCR\fG+\u001f9fA!Q\u0011Q`AG\u0005\u0004%\t!a@\u0002)\u0011\fG/Y0xSRDw\f]1si&$\u0018n\u001c8t+\u0005\u0019\b\u0002\u0003B\u0002\u0003\u001b\u0003\u000b\u0011B:\u0002+\u0011\fG/Y0xSRDw\f]1si&$\u0018n\u001c8tA!Q!qAAG\u0005\u0004%\t!a@\u0002\t\u0011\fG/\u0019\u0005\t\u0005\u0017\ti\t)A\u0005g\u0006)A-\u0019;bA!Q!qBAG\u0005\u0004%\t!a@\u0002%\u0011\fG/Y0qCJ$\u0018\u000e^5p]~\u000bt,\r\u0005\t\u0005'\ti\t)A\u0005g\u0006\u0019B-\u0019;b?B\f'\u000f^5uS>tw,M02A!Q!qCAG\u0005\u0004%\t!a@\u0002%\u0011\fG/Y0qCJ$\u0018\u000e^5p]~\u0013t,\r\u0005\t\u00057\ti\t)A\u0005g\u0006\u0019B-\u0019;b?B\f'\u000f^5uS>twLM02A!Q!qDAG\u0005\u0004%\t!a@\u0002%\u0011\fG/Y0qCJ$\u0018\u000e^5p]~\u000btL\r\u0005\t\u0005G\ti\t)A\u0005g\u0006\u0019B-\u0019;b?B\f'\u000f^5uS>tw,M03A\u00199!qEAG\u0001\t%\"A\u0003+fgR\u0004v\u000e\\5dsN1!Q\u0005B\u0016\u0005c\u0001B!!)\u0003.%!!qFAR\u0005\u0019y%M[3diB!!1\u0007B\u001f\u001b\t\u0011)DC\u0002\b\u0005oQ1!\u000eB\u001d\u0015\r\u0011Y\u0004C\u0001\nG>tg.Z2u_JLAAa\u0010\u00036\t)\u0002+\u0019:uSRLwN\\\"p[6LG\u000fU8mS\u000eL\b\u0002CAJ\u0005K!\tAa\u0011\u0015\u0005\t\u0015\u0003\u0003\u0002B$\u0005Ki!!!$\t\u0011\t-#Q\u0005C!\u0005\u001b\naaY8n[&$HcA\r\u0003P!A!\u0011\u000bB%\u0001\u0004\u0011\u0019&A\u0004d_:$X\r\u001f;\u0011\t\tU#1\f\b\u0005\u0005g\u00119&\u0003\u0003\u0003Z\tU\u0012!\u0006)beRLG/[8o\u0007>lW.\u001b;Q_2L7-_\u0005\u0005\u0005;\u0012yFA\u0004D_:$X\r\u001f;\u000b\t\te#Q\u0007")
public interface FileSystemITCaseBase {
    public static Seq<Row> data_partition_1_2() {
        return FileSystemITCaseBase$.MODULE$.data_partition_1_2();
    }

    public static Seq<Row> data_partition_2_1() {
        return FileSystemITCaseBase$.MODULE$.data_partition_2_1();
    }

    public static Seq<Row> data_partition_1_1() {
        return FileSystemITCaseBase$.MODULE$.data_partition_1_1();
    }

    public static Seq<Row> data() {
        return FileSystemITCaseBase$.MODULE$.data();
    }

    public static Seq<Row> data_with_partitions() {
        return FileSystemITCaseBase$.MODULE$.data_with_partitions();
    }

    public static RowTypeInfo dataType() {
        return FileSystemITCaseBase$.MODULE$.dataType();
    }

    public static TypeInformation<?>[] fieldTypes() {
        return FileSystemITCaseBase$.MODULE$.fieldTypes();
    }

    public static String[] fieldNames() {
        return FileSystemITCaseBase$.MODULE$.fieldNames();
    }

    public String resultPath();

    public void resultPath_$eq(String var1);

    public java.nio.file.Path fileTempFolder();

    public void fileTempFolder_$eq(java.nio.file.Path var1);

    public static /* synthetic */ String[] formatProperties$(FileSystemITCaseBase $this) {
        return $this.formatProperties();
    }

    default public String[] formatProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public static /* synthetic */ String getScheme$(FileSystemITCaseBase $this) {
        return $this.getScheme();
    }

    default public String getScheme() {
        return "file";
    }

    public TableEnvironment tableEnv();

    public void checkPredicate(String var1, Function1<Row, BoxedUnit> var2);

    public void check(String var1, Seq<Row> var2);

    public static /* synthetic */ void check$(FileSystemITCaseBase $this, String sqlQuery, List expectedResult) {
        $this.check(sqlQuery, expectedResult);
    }

    default public void check(String sqlQuery, List<Row> expectedResult) {
        this.check(sqlQuery, (Seq<Row>)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(expectedResult.iterator()).asScala()).toSeq());
    }

    public static /* synthetic */ boolean supportsReadingMetadata$(FileSystemITCaseBase $this) {
        return $this.supportsReadingMetadata();
    }

    default public boolean supportsReadingMetadata() {
        return true;
    }

    public static /* synthetic */ void open$(FileSystemITCaseBase $this) {
        $this.open();
    }

    default public void open() {
        this.resultPath_$eq(TempDirUtils.newFolder((java.nio.file.Path)this.fileTempFolder()).toURI().getPath());
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tableEnv(), "originalT", FileSystemITCaseBase$.MODULE$.data_with_partitions(), FileSystemITCaseBase$.MODULE$.dataType(), "x, y, a, b");
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(289).append("\n         |create table partitionedTable (\n         |  x string,\n         |  y int,\n         |  a int,\n         |  b bigint,\n         |  c as b + 1\n         |) partitioned by (a, b) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        Object object = this.supportsReadingMetadata() ? this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(374).append("\n           |create table partitionedTableWithMetadata (\n           |  x string,\n           |  y int,\n           |  a int,\n           |  b bigint,\n           |  c as b + 1,\n           |  f string metadata from 'file.path'\n           |) partitioned by (a, b) with (\n           |  'connector' = 'filesystem',\n           |  'path' = '").append(this.resultPath()).append("',\n           |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n           |)\n           ").toString())).stripMargin()) : BoxedUnit.UNIT;
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         |create table nonPartitionedTable (\n         |  x string,\n         |  y int,\n         |  a int,\n         |  b bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        Object object2 = this.supportsReadingMetadata() ? this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           |create table nonPartitionedTableWithMetadata (\n           |  x string,\n           |  y int,\n           |  a int,\n           |  f string metadata from 'file.path',\n           |  b bigint\n           |) with (\n           |  'connector' = 'filesystem',\n           |  'path' = '").append(this.resultPath()).append("',\n           |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n           |)\n         ").toString())).stripMargin()) : BoxedUnit.UNIT;
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(225).append("\n         |create table hasDecimalFieldWithPrecisionTenAndZeroTable (\n         |  x decimal(10, 0), y int\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(225).append("\n         |create table hasDecimalFieldWithPrecisionThreeAndTwoTable (\n         |  x decimal(3, 2), y int\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("\n         |create table table_custom_partition_commit_policy (\n         |  x varchar, y int\n         |) PARTITIONED BY (x) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append(",\n         |  'sink.partition-commit.policy.kind' = 'custom',\n         |  'sink.partition-commit.policy.class' = '").append(TestPolicy.class.getName()).append("'\n         |)\n ").toString())).stripMargin());
    }

    public static /* synthetic */ void testSelectDecimalWithPrecisionTenAndZeroFromFileSystem$(FileSystemITCaseBase $this) {
        $this.testSelectDecimalWithPrecisionTenAndZeroFromFileSystem();
    }

    @TestTemplate
    default public void testSelectDecimalWithPrecisionTenAndZeroFromFileSystem() {
        this.tableEnv().executeSql("insert into hasDecimalFieldWithPrecisionTenAndZeroTable(x, y) values(cast(2113554011 as decimal(10, 0)), 1), (cast(2113554022 as decimal(10,0)), 2)").await();
        this.check("select x, y from hasDecimalFieldWithPrecisionTenAndZeroTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2113554011), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2113554022), BoxesRunTime.boxToInteger((int)2)}))}))));
    }

    public static /* synthetic */ void testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem$(FileSystemITCaseBase $this) {
        $this.testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem();
    }

    @TestTemplate
    default public void testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem() {
        this.tableEnv().executeSql("insert into hasDecimalFieldWithPrecisionThreeAndTwoTable(x,y) values(cast(1.32 as decimal(3, 2)), 1), (cast(2.64 as decimal(3, 2)), 2)").await();
        this.check("select x, y from hasDecimalFieldWithPrecisionThreeAndTwoTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.32), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.64), BoxesRunTime.boxToInteger((int)2)}))}))));
    }

    public static /* synthetic */ void testAllStaticPartitions1$(FileSystemITCaseBase $this) {
        $this.testAllStaticPartitions1();
    }

    @TestTemplate
    default public void testAllStaticPartitions1() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        this.check("select x, y from partitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    public static /* synthetic */ void testAllStaticPartitions2$(FileSystemITCaseBase $this) {
        $this.testAllStaticPartitions2();
    }

    @TestTemplate
    default public void testAllStaticPartitions2() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a='2', b='1') select x, y from originalT where a=2 and b=1").await();
        this.check("select x, y from partitionedTable where a=2 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
    }

    public static /* synthetic */ void testAllStaticPartitionsWithMetadata$(FileSystemITCaseBase $this) {
        $this.testAllStaticPartitionsWithMetadata();
    }

    @TestTemplate
    default public void testAllStaticPartitionsWithMetadata() {
        if (!this.supportsReadingMetadata()) {
            return;
        }
        this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        this.checkPredicate("select x, f, y from partitionedTableWithMetadata where a=1 and b=1", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testAllStaticPartitionsWithMetadata$1(this, row);
            return BoxedUnit.UNIT;
        });
        this.checkPredicate("select x, f, y from partitionedTableWithMetadata", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testAllStaticPartitionsWithMetadata$2(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testPartialDynamicPartition$(FileSystemITCaseBase $this) {
        $this.testPartialDynamicPartition();
    }

    @TestTemplate
    default public void testPartialDynamicPartition() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a=3) select x, y, b from originalT where a=3").await();
        this.check("select x, y from partitionedTable where a=2 and b=1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.check("select x, y from partitionedTable where a=3 and b=1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x17", BoxesRunTime.boxToInteger((int)17)}))}))));
        this.check("select x, y from partitionedTable where a=3 and b=2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x18", BoxesRunTime.boxToInteger((int)18)}))}))));
        this.check("select x, y from partitionedTable where a=3 and b=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x19", BoxesRunTime.boxToInteger((int)19)}))}))));
        this.check("select x, y from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x17", BoxesRunTime.boxToInteger((int)17)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x18", BoxesRunTime.boxToInteger((int)18)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x19", BoxesRunTime.boxToInteger((int)19)}))}))));
    }

    public static /* synthetic */ void testDynamicPartition$(FileSystemITCaseBase $this) {
        $this.testDynamicPartition();
    }

    @TestTemplate
    default public void testDynamicPartition() {
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.check("select x, y from partitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
        this.check("select x, y from partitionedTable where a=2 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
        this.check("select x, y, a, b, c from partitionedTable where a=1 and c=2", FileSystemITCaseBase$.MODULE$.data_partition_1_2());
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data());
    }

    public static /* synthetic */ void testPartitionWithHiddenFile$(FileSystemITCaseBase $this) {
        $this.testPartitionWithHiddenFile();
    }

    @TestTemplate
    default public void testPartitionWithHiddenFile() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        Assertions.assertThat((boolean)new File(new Path(new StringBuilder(14).append("file:").append(this.resultPath()).append("/a=1/.b=2").toString()).toUri()).mkdir()).isTrue();
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    public static /* synthetic */ void testNonPartition$(FileSystemITCaseBase $this) {
        $this.testNonPartition();
    }

    @TestTemplate
    default public void testNonPartition() {
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT where a=1 and b=1").await();
        this.check("select x, y from nonPartitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    public static /* synthetic */ void testNonPartitionWithMetadata$(FileSystemITCaseBase $this) {
        $this.testNonPartitionWithMetadata();
    }

    @TestTemplate
    default public void testNonPartitionWithMetadata() {
        if (!this.supportsReadingMetadata()) {
            return;
        }
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT where a=1 and b=1").await();
        this.checkPredicate("select x, f, y from nonPartitionedTableWithMetadata where a=1 and b=1", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testNonPartitionWithMetadata$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testReadAllMetadata$(FileSystemITCaseBase $this) {
        $this.testReadAllMetadata();
    }

    @TestTemplate
    default public void testReadAllMetadata() {
        if (!this.supportsReadingMetadata()) {
            return;
        }
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(366).append("\n         |CREATE TABLE metadataTable (\n         |  x STRING,\n         |  `file.path` STRING METADATA,\n         |  `file.name` STRING METADATA,\n         |  `file.size` BIGINT METADATA,\n         |  `file.modification-time` TIMESTAMP_LTZ(3) METADATA\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n         ").toString())).stripMargin());
        this.tableEnv().executeSql("INSERT INTO nonPartitionedTable (x) SELECT x FROM originalT LIMIT 1").await();
        this.checkPredicate("SELECT * FROM metadataTable", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testReadAllMetadata$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testLimitPushDown$(FileSystemITCaseBase $this) {
        $this.testLimitPushDown();
    }

    @TestTemplate
    default public void testLimitPushDown() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT").await();
        this.check("select x, y from nonPartitionedTable limit 3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x1", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x2", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x3", BoxesRunTime.boxToInteger((int)3)}))}))));
    }

    public static /* synthetic */ void testFilterPushDown$(FileSystemITCaseBase $this) {
        $this.testFilterPushDown();
    }

    @TestTemplate
    default public void testFilterPushDown() {
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT").await();
        this.check("select x, y from nonPartitionedTable where a=10086", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public static /* synthetic */ void testProjectPushDown$(FileSystemITCaseBase $this) {
        $this.testProjectPushDown();
    }

    @TestTemplate
    default public void testProjectPushDown() {
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"}))}))));
    }

    public static /* synthetic */ void testInsertAppend$(FileSystemITCaseBase $this) {
        $this.testInsertAppend();
    }

    @TestTemplate
    default public void testInsertAppend() {
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"}))}))));
    }

    public static /* synthetic */ void testInsertOverwrite$(FileSystemITCaseBase $this) {
        $this.testInsertOverwrite();
    }

    @TestTemplate
    default public void testInsertOverwrite() {
        this.tableEnv().executeSql("insert overwrite partitionedTable select x, y, a, b from originalT").await();
        this.tableEnv().executeSql("insert overwrite partitionedTable select x, y, a, b from originalT").await();
        this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"}))}))));
    }

    public static /* synthetic */ void testCustomPartitionCommitPolicy$(FileSystemITCaseBase $this) {
        $this.testCustomPartitionCommitPolicy();
    }

    @TestTemplate
    default public void testCustomPartitionCommitPolicy() {
        this.tableEnv().executeSql("insert into table_custom_partition_commit_policy values ('p1', 1), ('p1', 2)").await();
        File file = new File(new StringBuilder(20).append(this.resultPath()).append("/x=p1/_custom_commit").toString());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.exists());
    }

    public static /* synthetic */ void $anonfun$testAllStaticPartitionsWithMetadata$1(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)row.getField("f")).isNotNull();
        Assertions.assertThat((Object)row.getField(1)).isNotNull();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(((Object)$this.fileTempFolder().getParent()).toString())).isTrue();
    }

    public static /* synthetic */ void $anonfun$testAllStaticPartitionsWithMetadata$2(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)row.getField("f")).isNotNull();
        Assertions.assertThat((Object)row.getField(1)).isNotNull();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(((Object)$this.fileTempFolder().getRoot()).toString())).isTrue();
    }

    public static /* synthetic */ void $anonfun$testNonPartitionWithMetadata$1(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)row.getField("f")).isNotNull();
        Assertions.assertThat((Object)row.getField(1)).isNotNull();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(((Object)$this.fileTempFolder().getRoot()).toString())).isTrue();
    }

    public static /* synthetic */ void $anonfun$testReadAllMetadata$1(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(5);
        File file = new File(URI.create($this.resultPath()).getPath()).listFiles()[0];
        String filename = ((Object)Paths.get(file.toURI()).getFileName()).toString();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(filename)).isTrue();
        Assertions.assertThat((String)((String)row.getFieldAs(2))).isEqualTo(filename);
        Assertions.assertThat((long)BoxesRunTime.unboxToLong((Object)row.getFieldAs(3))).isEqualTo(file.length());
        Assertions.assertThat((Instant)((Instant)row.getFieldAs(4))).isEqualTo((Object)Instant.ofEpochMilli(file.lastModified()));
    }

    public static void $init$(FileSystemITCaseBase $this) {
    }

    public static class TestPolicy
    implements PartitionCommitPolicy {
        public void commit(PartitionCommitPolicy.Context context) {
            FileSystem fs = context.partitionPath().getFileSystem();
            fs.create(new Path(context.partitionPath(), "_custom_commit"), FileSystem.WriteMode.OVERWRITE).close();
        }
    }
}

