/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.Func18$;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.runtime.batch.sql.MyPojoTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.MyToPojoTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.TableFunctionITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$MyPojoFunc$;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.HierarchyTableFunction;
import org.apache.flink.table.planner.utils.PojoTableFunc;
import org.apache.flink.table.planner.utils.RichTableFunc1;
import org.apache.flink.table.planner.utils.RichTableFuncWithFinish;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableFunc3;
import org.apache.flink.table.planner.utils.VarArgsFunc0;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001'\ty1i\u001c:sK2\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011I\u0011\u0002\r\t,gm\u001c:f)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSRD#aH\u0015\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013aA1qS*\u0011afL\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\u0004#A\u0003kk:LG/\u0003\u00023W\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bQ\u0002A\u0011A\u0011\u0002#Q,7\u000f\u001e+bE2,g)\u001e8di&|g\u000e\u000b\u00024mA\u0011!fN\u0005\u0003q-\u0012A\u0001V3ti\")!\b\u0001C\u0001C\u0005\tB/Z:u\u0019\u00164GoT;uKJTu.\u001b8)\u0005e2\u0004\"B\u001f\u0001\t\u0003\t\u0013A\u0004;fgR<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003yYBQ\u0001\u0011\u0001\u0005\u0002\u0005\n\u0011\u0003^3ti\"KWM]1sG\"LH+\u001f9fQ\tyd\u0007C\u0003D\u0001\u0011\u0005\u0011%\u0001\u0007uKN$\bk\u001c6p)f\u0004X\r\u000b\u0002Cm!)a\t\u0001C\u0001C\u0005qC/Z:u+N,'\u000fR3gS:,G\rV1cY\u00164UO\\2uS>tw+\u001b;i'\u000e\fG.\u0019:Gk:\u001cG/[8oQ\t)e\u0007C\u0003J\u0001\u0011\u0005\u0011%A\u001duKN$Xk]3s\t\u00164\u0017N\\3e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8XSRD7kY1mCJ4UO\\2uS>t\u0017J\\\"p]\u0012LG/[8oQ\tAe\u0007C\u0003M\u0001\u0011\u0005\u0011%\u0001\ruKN$Hj\u001c8h\u0003:$G+Z7q_J\fG\u000eV=qKND#a\u0013\u001c\t\u000b=\u0003A\u0011A\u0011\u0002SQ,7\u000f^+tKJ$UMZ5oK\u0012$\u0016M\u00197f\rVt7\r^5p]^KG\u000f\u001b)be\u0006lW\r^3sQ\tqe\u0007C\u0003S\u0001\u0011\u0005\u0011%\u0001\u001fuKN$Xk]3s\t\u00164\u0017N\\3e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8XSRD7kY1mCJ4UO\\2uS>tw+\u001b;i!\u0006\u0014\u0018-\\3uKJ\u001c\bFA)7\u0011\u0015)\u0006\u0001\"\u0001\"\u0003\u0019\"Xm\u001d;UC\ndWMR;oGRLwN\\\"p]N$(/^2u_J<\u0016\u000e\u001e5QCJ\fWn\u001d\u0015\u0003)ZBQ\u0001\u0017\u0001\u0005\u0002\u0005\na\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o/&$\bNV1sS\u0006\u0014G.Z!sOVlWM\u001c;tQ\t9f\u0007C\u0003\\\u0001\u0011\u0005\u0011%A\u0007uKN$\bk\u001c6p\r&,G\u000e\u001a\u0015\u00035ZBQA\u0018\u0001\u0005\u0002\u0005\n\u0011\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o/&$\bNR5oSNDW*\u001a;i_\u0012D#!\u0018\u001c")
public class CorrelateITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("inputT", (Iterable<Row>)TableFunctionITCase$.MODULE$.testData(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("inputTWithNull", (Iterable<Row>)TableFunctionITCase$.MODULE$.testDataWithNull(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("SmallTable3", (Iterable<Row>)TestData$.MODULE$.smallData3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
    }

    @Test
    public void testTableFunction() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc1());
        this.checkResult("select c, s from inputT, LATERAL TABLE(func(c)) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "22"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "19"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "44"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftOuterJoin() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc2());
        this.checkResult("select c, s, l from inputT LEFT JOIN LATERAL TABLE(func(c)) as T(s, l) ON TRUE", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "22", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John", BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "19", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "44", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testWithFilter() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc0());
        this.checkResult("select c, name, age from inputT, LATERAL TABLE(func(c)) as T(name, age) WHERE T.age > 20", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToInteger((int)44)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testHierarchyType() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new HierarchyTableFunction());
        this.checkResult("select c, name, adult, len from inputT, LATERAL TABLE(func(c)) as T(name, adult, len)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John", BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)19)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)44)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPojoType() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new PojoTableFunc());
        this.checkResult("select c, name, age from inputT, LATERAL TABLE(func(c)) as T(name, age) WHERE T.age > 20", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToInteger((int)44)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunction() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc1());
        this.checkResult("select c, s from inputT, LATERAL TABLE(func(SUBSTRING(c, 2))) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "ack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "22"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "ohn"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "19"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "nna"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "44"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionInCondition() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc0());
        this.tEnv().createTemporarySystemFunction("func18", (UserDefinedFunction)Func18$.MODULE$);
        this.tEnv().createTemporarySystemFunction("func1", (UserDefinedFunction)Func1$.MODULE$);
        this.checkResult("select c, name, age from inputT, LATERAL TABLE(func(c)) as T(name, age) where func18(name, 'J') and func1(a) < 3 and func1(age) > 20", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)22)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLongAndTemporalTypes() {
        this.registerCollection("myT", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDate("1990-10-14"), BoxesRunTime.boxToLong((long)1000L), DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 12:10:10")}))}))), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE, BasicTypeInfo.LONG_TYPE_INFO, LocalTimeTypeInfo.LOCAL_DATE_TIME}), "x, y, z");
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedTableFunctions.JavaTableFunc0());
        this.checkResult("select s from myT, LATERAL TABLE(func(x, y, z)) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1000L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)655906210000L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)7591L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithParameter() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new RichTableFunc1());
        Configuration conf = new Configuration();
        conf.setString("word_separator", "#");
        this.env().getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)conf);
        this.checkResult("select a, s from inputT, LATERAL TABLE(func(c)) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Jack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "22"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "John"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "19"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Anna"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "44"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionWithParameters() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new RichTableFunc1());
        this.tEnv().createTemporarySystemFunction("func2", (UserDefinedFunction)new RichFunc2());
        Configuration conf = new Configuration();
        conf.setString("word_separator", "#");
        conf.setString("string.value", "test");
        this.env().getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)conf);
        this.checkResult("select a, s from SmallTable3, LATERAL TABLE(func(func2(c))) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "test"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "test"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionConstructorWithParams() {
        this.tEnv().createTemporarySystemFunction("func30", (UserDefinedFunction)new TableFunc3(null));
        this.tEnv().createTemporarySystemFunction("func31", (UserDefinedFunction)new TableFunc3("OneConf_"));
        this.tEnv().createTemporarySystemFunction("func32", (UserDefinedFunction)new TableFunc3("TwoConf_"));
        this.checkResult("select c, d, f, h, e, g, i from inputT, LATERAL TABLE(func30(c)) as T0(d, e), LATERAL TABLE(func31(c)) as T1(f, g),LATERAL TABLE(func32(c)) as T2(h, i)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", "OneConf_Anna", "TwoConf_Anna", BoxesRunTime.boxToInteger((int)44), BoxesRunTime.boxToInteger((int)44), BoxesRunTime.boxToInteger((int)44)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", "OneConf_Jack", "TwoConf_Jack", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John", "OneConf_John", "TwoConf_John", BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)19)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionWithVariableArguments() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new VarArgsFunc0());
        this.checkResult("select c, d from inputT, LATERAL TABLE(func('1', '2', c)) as T0(d) where c = 'Jack#22'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack#22"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPojoField() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(5, 105)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(6, 11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(7, 12)}))}));
        this.registerCollection("MyTable", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{TypeExtractor.createTypeInfo(UserDefinedFunctionTestUtils.MyPojo.class)}), "a");
        this.tEnv().createTemporarySystemFunction("pojoTFunc", (UserDefinedFunction)new MyPojoTableFunc());
        this.checkResult("select s from MyTable, LATERAL TABLE(pojoTFunc(a)) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)105)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12)}))}))), this.checkResult$default$3());
        this.tEnv().createTemporarySystemFunction("pojoFunc", (UserDefinedFunction)UserDefinedFunctionTestUtils$MyPojoFunc$.MODULE$);
        this.tEnv().createTemporarySystemFunction("toPojoTFunc", (UserDefinedFunction)new MyToPojoTableFunc());
        this.checkResult("select b from MyTable, LATERAL TABLE(toPojoTFunc(pojoFunc(a))) as T(b, c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)105)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionWithFinishMethod() {
        this.registerTemporarySystemFunction("udtfWithFinish", RichTableFuncWithFinish.class);
        this.checkResult("select s from inputT, LATERAL TABLE(udtfWithFinish(c)) as T(s)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp"}))}))), this.checkResult$default$3());
    }
}

