/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.planner.factories.TestUpdateDeleteTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class DeleteTableITCase
extends BatchTestBase {
    private static final int ROW_NUM = 5;
    private final SupportsRowLevelDelete.RowLevelDeleteMode deleteMode;

    @Parameters(name="deleteMode = {0}")
    private static Collection<SupportsRowLevelDelete.RowLevelDeleteMode> data() {
        return Arrays.asList(SupportsRowLevelDelete.RowLevelDeleteMode.DELETED_ROWS, SupportsRowLevelDelete.RowLevelDeleteMode.REMAINING_ROWS);
    }

    DeleteTableITCase(SupportsRowLevelDelete.RowLevelDeleteMode deleteMode) {
        this.deleteMode = deleteMode;
    }

    @TestTemplate
    void testDeletePushDown() {
        String dataId = this.registerData();
        this.tEnv().executeSql(String.format("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete', 'data-id' = '%s', 'only-accept-equal-predicate' = 'true')", dataId));
        List<Row> rows = this.toRows(this.tEnv().executeSql("DELETE FROM t where a = 1"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[1]]");
        rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0, b_0, 0.0], +I[2, b_2, 4.0], +I[3, b_3, 6.0], +I[4, b_4, 8.0]]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("DELETE FROM t where a > 1")).isInstanceOf(UnsupportedOperationException.class)).hasMessage(String.format("Can't perform delete operation of the table %s because the corresponding dynamic table sink has not yet implemented %s.", "default_catalog.default_database.t", SupportsRowLevelDelete.class.getName()));
    }

    @TestTemplate
    void testRowLevelDelete() throws Exception {
        String dataId = this.registerData();
        this.tEnv().executeSql(String.format("CREATE TABLE t (a int PRIMARY KEY NOT ENFORCED, b string, c double) WITH ('connector' = 'test-update-delete', 'data-id' = '%s', 'delete-mode' = '%s', 'support-delete-push-down' = 'false')", dataId, this.deleteMode));
        this.tEnv().executeSql("DELETE FROM t WHERE a > 1").await();
        List<Row> rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0, b_0, 0.0], +I[1, b_1, 2.0]]");
        this.tEnv().executeSql("DELETE FROM t WHERE a >= (select count(1) from t where c > 1)").await();
        rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0, b_0, 0.0]]");
    }

    @TestTemplate
    void testRowLevelDeleteWithPartitionColumn() throws Exception {
        String dataId = this.registerData();
        this.tEnv().executeSql(String.format("CREATE TABLE t (a int PRIMARY KEY NOT ENFORCED, b string not null, c double not null) WITH ('connector' = 'test-update-delete', 'data-id' = '%s', 'delete-mode' = '%s', 'required-columns-for-delete' = 'a;c', 'support-delete-push-down' = 'false')", dataId, this.deleteMode));
        this.tEnv().executeSql("DELETE FROM t WHERE a > 1").await();
        List<Row> rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0, b_0, 0.0], +I[1, b_1, 2.0]]");
        dataId = this.registerData();
        this.tEnv().executeSql(String.format("CREATE TABLE t1 (a int, b string not null, c double not null, PRIMARY KEY (a, c) NOT ENFORCED) WITH ('connector' = 'test-update-delete', 'data-id' = '%s', 'delete-mode' = '%s', 'required-columns-for-delete' = 'a;b', 'support-delete-push-down' = 'false')", dataId, this.deleteMode));
        this.tEnv().executeSql("DELETE FROM t1 WHERE a > 1").await();
        rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t1"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0, b_0, 0.0], +I[1, b_1, 2.0]]");
    }

    @TestTemplate
    void testMixDelete() throws Exception {
        String dataId = this.registerData();
        this.tEnv().executeSql(String.format("CREATE TABLE t (a int PRIMARY KEY NOT ENFORCED, b string, c double) WITH ('connector' = 'test-update-delete', 'data-id' = '%s', 'mix-delete' = 'true')", dataId));
        this.tEnv().executeSql("DELETE FROM t WHERE a >= (select count(1) from t where c > 2)").await();
        List<Row> rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0, b_0, 0.0], +I[1, b_1, 2.0], +I[2, b_2, 4.0]]");
        rows = this.toRows(this.tEnv().executeSql("DELETE FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[3]]");
        rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat(rows).isEmpty();
    }

    @TestTemplate
    void testStatementSetContainDeleteAndInsert() {
        this.tEnv().executeSql("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete')");
        StatementSet statementSet = this.tEnv().createStatementSet();
        statementSet.addInsertSql("INSERT INTO t VALUES (1, 'v1', 1)");
        statementSet.addInsertSql("DELETE FROM t");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((StatementSet)statementSet).execute()).isInstanceOf(TableException.class)).hasMessage("Unsupported SQL query! Only accept a single SQL statement of type DELETE.");
    }

    @TestTemplate
    void testCompilePlanSql() {
        this.tEnv().executeSql("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().compilePlanSql("DELETE FROM t")).isInstanceOf(TableException.class)).hasMessage("Unsupported SQL query! compilePlanSql() only accepts a single SQL statement of type INSERT");
    }

    @TestTemplate
    void testDeleteWithLegacyTableSink() {
        this.tEnv().executeSql("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'COLLECTION')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("DELETE FROM t")).isInstanceOf(TableException.class)).hasMessage(String.format("Can't perform delete operation of the table %s  because the corresponding table sink is the legacy TableSink, Please implement %s for it.", "`default_catalog`.`default_database`.`t`", DynamicTableSink.class.getName()));
    }

    private String registerData() {
        List<RowData> values = this.createValue();
        return TestUpdateDeleteTableFactory.registerRowData(values);
    }

    private List<RowData> createValue() {
        ArrayList<RowData> values = new ArrayList<RowData>();
        for (int i = 0; i < 5; ++i) {
            values.add((RowData)GenericRowData.of((Object[])new Object[]{i, StringData.fromString((String)("b_" + i)), (double)i * 2.0}));
        }
        return values;
    }

    private List<Row> toRows(TableResult result) {
        return CollectionUtil.iteratorToList((Iterator)result.collect());
    }
}

