/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TestLegacyLimitableTableSource$;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001'\t\tB*Z4bGfd\u0015.\\5u\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C!C\u00051!-\u001a4pe\u0016$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!&M\u0007\u0002W)\u0011A&L\u0001\u0004CBL'B\u0001\u00180\u0003\u001dQW\u000f]5uKJT!\u0001\r\t\u0002\u000b),h.\u001b;\n\u0005IZ#A\u0003\"fM>\u0014X-R1dQ\")A\u0007\u0001C\u0001C\u0005\u0011B/Z:u\u001f\u001a47/\u001a;B]\u00124U\r^2iQ\t\u0019d\u0007\u0005\u0002+o%\u0011\u0001h\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003;\u0001\u0011\u0005\u0011%\u0001\nuKN$xJ\u001a4tKR\fe\u000e\u001a'j[&$\bFA\u001d7\u0011\u0015i\u0004\u0001\"\u0001\"\u0003%!Xm\u001d;GKR\u001c\u0007\u000e\u000b\u0002=m!)\u0001\t\u0001C\u0001C\u00059B/Z:u\r\u0016$8\r[,ji\"d\u0015.\\5u)\u0006\u0014G.\u001a\u0015\u0003\u007fYBQa\u0011\u0001\u0005\u0002\u0005\na\u0002^3ti\u001a+Go\u00195GSJ\u001cH\u000f\u000b\u0002Cm!)a\t\u0001C\u0001C\u0005aB/Z:u\r\u0016$8\r\u001b$jeN$x+\u001b;i\u0019&l\u0017\u000e\u001e+bE2,\u0007FA#7\u0011\u0015I\u0005\u0001\"\u0001\"\u0003%!Xm\u001d;MS6LG\u000f\u000b\u0002Im!)A\n\u0001C\u0001C\u0005AB/Z:u\u0019&l\u0017\u000e\u001e\u0019XSRDG*[7jiR\u000b'\r\\3)\u0005-3\u0004\"B(\u0001\t\u0003\t\u0013a\u0006;fgRd\u0015.\\5u/&$\b\u000eT5nSR$\u0016M\u00197fQ\tqe\u0007C\u0003S\u0001\u0011\u0005\u0011%\u0001\nuKN$H*Z:t)\"\fgn\u00144gg\u0016$\bFA)7\u0011\u0015)\u0006\u0001\"\u0001\"\u0003\u0005\"Xm\u001d;MKN\u001cH\u000b[1o\u001f\u001a47/\u001a;XSRDG*[7jiN{WO]2fQ\t!f\u0007")
public class LegacyLimitITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        TestLegacyLimitableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), TestData$.MODULE$.data3(), new TableSchema((String[])((Object[])new String[]{"a", "b", "c"}), TestData$.MODULE$.type3().getFieldTypes()), "LimitTable");
    }

    @Test
    public void testOffsetAndFetch() {
        this.checkSize("SELECT * FROM Table3 OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", 5);
    }

    @Test
    public void testOffsetAndLimit() {
        this.checkSize("SELECT * FROM Table3 LIMIT 10 OFFSET 2", 10);
    }

    @Test
    public void testFetch() {
        this.checkSize("SELECT * FROM Table3 FETCH NEXT 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable FETCH NEXT 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchFirst() {
        this.checkSize("SELECT * FROM Table3 FETCH FIRST 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchFirstWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable FETCH FIRST 10 ROWS ONLY", 10);
    }

    @Test
    public void testLimit() {
        this.checkSize("SELECT * FROM Table3 LIMIT 5", 5);
    }

    @Test
    public void testLimit0WithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable LIMIT 0", 0);
    }

    @Test
    public void testLimitWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable LIMIT 5", 5);
    }

    @Test
    public void testLessThanOffset() {
        this.checkSize("SELECT * FROM Table3 OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", 19);
    }

    @Test
    public void testLessThanOffsetWithLimitSource() {
        this.checkSize("SELECT * FROM LimitTable OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", 19);
    }
}

