/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestDataTypeTableSource$;
import org.apache.flink.table.planner.utils.TestFileInputFormatTableSource$;
import org.apache.flink.table.planner.utils.TestInputFormatTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001'\t9B*Z4bGf$\u0016M\u00197f'>,(oY3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011QBQ1uG\"$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0011\"\u0003\u0019\u0011WMZ8sKR\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0003V]&$\bFA\u0010*!\tQ\u0013'D\u0001,\u0015\taS&A\u0002ba&T!AL\u0018\u0002\u000f),\b/\u001b;fe*\u0011\u0001\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003e-\u0012!BQ3g_J,W)Y2i\u0011\u0015!\u0004\u0001\"\u0001\"\u0003E!Xm\u001d;TS6\u0004H.\u001a)s_*,7\r\u001e\u0015\u0003gY\u0002\"AK\u001c\n\u0005aZ#\u0001\u0002+fgRDQA\u000f\u0001\u0005\u0002\u0005\n!\u0004^3tiB\u0013xN[3di^KG\u000f[8vi&s\u0007/\u001e;SK\u001aD#!\u000f\u001c\t\u000bu\u0002A\u0011A\u0011\u0002#Q,7\u000f\u001e(fgR,G\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002=m!)\u0001\t\u0001C\u0001C\u0005iB/Z:u)\u0006\u0014G.Z*pkJ\u001cWmV5uQ\u001aKG\u000e^3sC\ndW\r\u000b\u0002@m!)1\t\u0001C\u0001C\u0005)C/Z:u)\u0006\u0014G.Z*pkJ\u001cWmV5uQ\u001a+hn\u0019;j_:4\u0015\u000e\u001c;fe\u0006\u0014G.\u001a\u0015\u0003\u0005ZBQA\u0012\u0001\u0005\u0002\u0005\n\u0001\u0005^3tiR\u000b'\r\\3T_V\u00148-Z,ji\"\u0004\u0016M\u001d;ji&|g.\u00192mK\"\u0012QI\u000e\u0005\u0006\u0013\u0002!\t!I\u0001\u0013i\u0016\u001cHoQ:w)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u0002Im!)A\n\u0001C\u0001C\u0005qB/Z:u\u0019>|7.\u001e9K_&t7i\u001d<UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0003\u0017ZBQa\u0014\u0001\u0005\u0002\u0005\nQ\u0003^3ti&s\u0007/\u001e;G_Jl\u0017\r^*pkJ\u001cW\r\u000b\u0002Om!)!\u000b\u0001C\u0001C\u0005\u0019B/Z:u\u001bVdG/\u001b+za\u0016\u001cv.\u001e:dK\"\u0012\u0011K\u000e\u0005\u0006+\u0002!\t!I\u0001\u000fi\u0016\u001cH/T;mi&\u0004\u0016\r\u001e5tQ\t!f\u0007C\u0003Y\u0001\u0011\u0005\u0011%A\u0007uKN$H+\u00192mK\"Kg\u000e\u001e\u0015\u0003/Z\u0002")
public class LegacyTableSourceITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("MyTable", (TableSource)new TestLegacyProjectableTableSource(true, tableSchema, (TypeInformation<Row>)new RowTypeInfo((TypeInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.getFieldDataTypes())).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class))), tableSchema.getFieldNames()), TestData$.MODULE$.smallData3(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$6(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
    }

    @Test
    public void testSimpleProject() {
        this.checkResult("SELECT a, c FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.checkResult("SELECT COUNT(*) FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Sarah", new Integer(100)}), Row.of((Object[])new Object[]{new Integer(1000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Peter", new Integer(10000)}), "Mary"}), Row.of((Object[])new Object[]{new Long(2L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Rob", new Integer(200)}), Row.of((Object[])new Object[]{new Integer(2000), new Boolean(false)})}), Row.of((Object[])new Object[]{"Lucy", new Integer(20000)}), "Bob"}), Row.of((Object[])new Object[]{new Long(3L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Mike", new Integer(300)}), Row.of((Object[])new Object[]{new Integer(3000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Betty", new Integer(30000)}), "Liz"})}));
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(true, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Sarah", BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)1000)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Rob", BoxesRunTime.boxToInteger((int)20000), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)2000)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike", BoxesRunTime.boxToInteger((int)30000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)3000)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFilterable() {
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), TestLegacyFilterableTableSource$.MODULE$.defaultSchema(), "FilterableTable", true, TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$6());
        this.checkResult("SELECT id, name FROM FilterableTable WHERE amount > 4 AND price < 9", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Record_5"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Record_6"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "Record_7"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Record_8"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFunctionFilterable() {
        TableEnvironment x$1 = this.tEnv();
        TableSchema x$2 = TestLegacyFilterableTableSource$.MODULE$.defaultSchema();
        String x$3 = "FilterableTable";
        boolean x$4 = true;
        Set x$5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount", "name"}));
        List<Row> x$6 = TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5();
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(x$1, x$2, x$3, x$4, x$6, (Set<String>)x$5);
        this.checkResult("SELECT id, name FROM FilterableTable WHERE amount > 4 AND price < 9 AND upper(name) = 'RECORD_5'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Record_5"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithPartitionable() {
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(this.tEnv(), "PartitionableTable", true);
        this.checkResult("SELECT * FROM PartitionableTable WHERE part2 > 1 and id > 2 AND part1 = 'A'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "John", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "nosharp", "A", BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCsvTableSource() {
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "csvTable");
        this.checkResult("SELECT id, `first`, `last`, score FROM csvTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Mike", "Smith", BoxesRunTime.boxToDouble((double)12.3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Bob", "Taylor", BoxesRunTime.boxToDouble((double)45.6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Sam", "Miller", BoxesRunTime.boxToDouble((double)7.89)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Peter", "Smith", BoxesRunTime.boxToDouble((double)0.12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Liz", "Williams", BoxesRunTime.boxToDouble((double)34.5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Sally", "Miller", BoxesRunTime.boxToDouble((double)6.78)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "Alice", "Smith", BoxesRunTime.boxToDouble((double)90.1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Kelly", "Williams", BoxesRunTime.boxToDouble((double)2.34)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLookupJoinCsvTemporalTable() {
        TestTableSourceSinks$.MODULE$.createOrdersCsvTemporaryTable(this.tEnv(), "orders");
        TestTableSourceSinks$.MODULE$.createRatesCsvTemporaryTable(this.tEnv(), "rates");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT o.amount, o.currency, r.rate\n        |FROM (SELECT *, PROCTIME() as proc FROM orders) AS o\n        |JOIN rates FOR SYSTEM_TIME AS OF o.proc AS r\n        |ON o.currency = r.currency\n      ")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Euro", BoxesRunTime.boxToInteger((int)119)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "US Dollar", BoxesRunTime.boxToInteger((int)102)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)50), "Yen", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Euro", BoxesRunTime.boxToInteger((int)119)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "US Dollar", BoxesRunTime.boxToInteger((int)102)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInputFormatSource() {
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();
        TestInputFormatTableSource$.MODULE$.createTemporaryTable(this.tEnv(), tableSchema, TestData$.MODULE$.smallData3(), "MyInputFormatTable");
        this.checkResult("SELECT a, c FROM MyInputFormatTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMultiTypeSource() {
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c", "d", "e", "f"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.DECIMAL((int)5, (int)2), DataTypes.VARCHAR((int)5), DataTypes.CHAR((int)5), DataTypes.TIMESTAMP((int)9), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)})).build();
        List ints = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), null}));
        .colon.colon decimals = new .colon.colon((Object)new BigDecimal(5.1), (List)new .colon.colon((Object)new BigDecimal(6.1), (List)new .colon.colon((Object)new BigDecimal(7.1), (List)new .colon.colon((Object)new BigDecimal(8.123), (List)new .colon.colon(null, (List)Nil$.MODULE$)))));
        .colon.colon varchars = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"12", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"1234", (List)new .colon.colon(null, (List)Nil$.MODULE$)))));
        .colon.colon chars = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"12", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"1234", (List)new .colon.colon(null, (List)Nil$.MODULE$)))));
        .colon.colon datetimes = new .colon.colon((Object)LocalDateTime.of(1969, 1, 1, 0, 0, 0, 123456789), (List)new .colon.colon((Object)LocalDateTime.of(1970, 1, 1, 0, 0, 0, 123456000), (List)new .colon.colon((Object)LocalDateTime.of(1971, 1, 1, 0, 0, 0, 123000000), (List)new .colon.colon((Object)LocalDateTime.of(1972, 1, 1, 0, 0, 0, 0), (List)new .colon.colon(null, (List)Nil$.MODULE$)))));
        MutableList instants = new MutableList();
        datetimes.indices().foreach(arg_0 -> LegacyTableSourceITCase.$anonfun$testMultiTypeSource$1$adapted((List)datetimes, instants, arg_0));
        MutableList data = new MutableList();
        ints.indices().foreach(arg_0 -> LegacyTableSourceITCase.$anonfun$testMultiTypeSource$2$adapted(ints, (List)decimals, (List)varchars, (List)chars, (List)datetimes, instants, data, arg_0));
        TestDataTypeTableSource$.MODULE$.createTemporaryTable(this.tEnv(), tableSchema, "MyInputFormatTable", (Seq<Row>)data.seq());
        this.checkResult("SELECT a, b, c, d, e, f FROM MyInputFormatTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "5.10", "1", "1", "1969-01-01T00:00:00.123456789", "1969-01-01T00:00:00.123456789Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "6.10", "12", "12", "1970-01-01T00:00:00.123456", "1970-01-01T00:00:00.123456Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "7.10", "123", "123", "1971-01-01T00:00:00.123", "1971-01-01T00:00:00.123Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "8.12", "1234", "1234", "1972-01-01T00:00", "1972-01-01T00:00:00Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMultiPaths() {
        File tmpFile1 = BatchAbstractTestBase.createFileInTempFolder("tmpFile1.tmp");
        new FileWriter(tmpFile1).append("t1\n").append("t2\n").close();
        File tmpFile2 = BatchAbstractTestBase.createFileInTempFolder("tmpFile2.tmp");
        new FileWriter(tmpFile2).append("t3\n").append("t4\n").close();
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"a"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING()}));
        String[] paths = (String[])((Object[])new String[]{tmpFile1.getPath(), tmpFile2.getPath()});
        TestFileInputFormatTableSource$.MODULE$.createTemporaryTable(this.tEnv(), schema, "MyMultiPathTable", paths);
        this.checkResult("select * from MyMultiPathTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t2"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t3"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t4"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableHint() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MyTable1 (\n         |  name STRING,\n         |  a bigint,\n         |  b int,\n         |  c double\n         |) with (\n         |  'connector.type' = 'TestFilterableSource',\n         |  'is-bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.tEnv().executeSql(ddl);
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n                       |CREATE TABLE MySink (\n                       |  `a` BIGINT,\n                       |  `b` INT,\n                       |  `c` DOUBLE\n                       |) WITH (\n                       |  'connector' = 'filesystem',\n                       |  'format' = 'testcsv',\n                       |  'path' = '").append(resultPath).append("'\n                       |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable1\n                           |  /*+ OPTIONS('source.num-element-to-skip'='31') */\n                           |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable1\n                           |  /*+ OPTIONS('source.num-element-to-skip'='32') */\n                           |")).stripMargin());
        stmtSet.execute().await();
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"31,31,31.0", "32,32,32.0", "32,32,32.0"}));
        Assertions.assertThat((Object)expected.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(result.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ MutableList $anonfun$testMultiTypeSource$1(List datetimes$1, MutableList instants$1, int i) {
        return datetimes$1.apply(i) == null ? instants$1.$plus$eq(null) : instants$1.$plus$eq((Object)((ChronoLocalDateTime)datetimes$1.apply(i)).toInstant(ZoneId.of("UTC").getRules().getOffset((LocalDateTime)datetimes$1.apply(i))));
    }

    public static final /* synthetic */ MutableList $anonfun$testMultiTypeSource$1$adapted(List datetimes$1, MutableList instants$1, Object i) {
        return LegacyTableSourceITCase.$anonfun$testMultiTypeSource$1(datetimes$1, instants$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ MutableList $anonfun$testMultiTypeSource$2$adapted(List ints$1, List decimals$1, List varchars$1, List chars$1, List datetimes$1, MutableList instants$1, MutableList data$1, Object i) {
        return data$1.$plus$eq((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ints$1.apply(BoxesRunTime.unboxToInt((Object)i)), decimals$1.apply(BoxesRunTime.unboxToInt((Object)i)), varchars$1.apply(BoxesRunTime.unboxToInt((Object)i)), chars$1.apply(BoxesRunTime.unboxToInt((Object)i)), datetimes$1.apply(BoxesRunTime.unboxToInt((Object)i)), instants$1.apply(BoxesRunTime.unboxToInt((Object)i))})));
    }
}

