/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001M\u00111#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0005!\u0001\u0001\u0007\t\u0019!C\u0001C\u0005Y1\u000f[;gM2,Wj\u001c3f+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0019\u0019w.\\7p]*\u0011q\u0005D\u0001\u0004CBL\u0017BA\u0015%\u0005A\u0011\u0015\r^2i'\",hM\u001a7f\u001b>$W\rC\u0005,\u0001\u0001\u0007\t\u0019!C\u0001Y\u0005y1\u000f[;gM2,Wj\u001c3f?\u0012*\u0017\u000f\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u001d!$&!AA\u0002\t\n1\u0001\u001f\u00132\u0011%1\u0004\u00011A\u0001B\u0003&!%\u0001\u0007tQV4g\r\\3N_\u0012,\u0007\u0005\u000b\u00026qA\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\u0005ur\u0014AC3yi\u0016t7/[8og*\u0011q\bQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u00032\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005\rS$!\u0003)be\u0006lW\r^3s\u0011%)\u0005\u00011AA\u0002\u0013\u0005a)A\u0007tG\",G-\u001e7feRK\b/Z\u000b\u0002\u000fB\u0011\u0001\n\u0017\b\u0003\u0013Vs!AS*\u000f\u0005-\u0013fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty%#\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!\u0001\u0016\u0007\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t1v+A\tK_\nl\u0015M\\1hKJ|\u0005\u000f^5p]NT!\u0001\u0016\u0007\n\u0005eS&!D*dQ\u0016$W\u000f\\3s)f\u0004XM\u0003\u0002W/\"IA\f\u0001a\u0001\u0002\u0004%\t!X\u0001\u0012g\u000eDW\rZ;mKJ$\u0016\u0010]3`I\u0015\fHCA\u0017_\u0011\u001d!4,!AA\u0002\u001dC\u0011\u0002\u0019\u0001A\u0002\u0003\u0005\u000b\u0015B$\u0002\u001dM\u001c\u0007.\u001a3vY\u0016\u0014H+\u001f9fA!\"q\f\u000f2d\u0003\u00151\u0018\r\\;f;\u0005\t\u0001\"B3\u0001\t\u00032\u0017A\u00022fM>\u0014X\rF\u0001.Q\t!\u0007\u000e\u0005\u0002j]6\t!N\u0003\u0002(W*\u0011A.\\\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0004#\u0003\u0002pU\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bE\u0004A\u0011\u00014\u0002-Q,7\u000f\u001e\"bg&\u001cW*\u001e7uSBdW-\u00138qkRD#\u0001]:\u0011\u0005%$\u0018BA;k\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u00159\b\u0001\"\u0001g\u0003Y!Xm\u001d;NC:LX*\u001e7uSBdW-\u00138qkR\u001c\bF\u0001<t\u0011\u0015Q\b\u0001\"\u0001g\u0003Y!Xm\u001d;K_&tw+\u001b;i\u0003\u001e<\u0017i\u001d)s_\n,\u0007FA=t\u0011\u0015i\b\u0001\"\u0001g\u0003a!Xm\u001d;O_B\u0013\u0018n\u001c:jif\u001cuN\\:ue\u0006Lg\u000e\u001e\u0015\u0003yNDa!!\u0001\u0001\t\u00031\u0017!\u0005;fgR\u0014V\r\\1uK\u0012Le\u000e];ug\"\u0012qp\u001d\u0005\u0007\u0003\u000f\u0001A\u0011\u00014\u00021Q,7\u000f\u001e*fY\u0006$X\rZ%oaV$8oV5uQ\u0006;w\rK\u0002\u0002\u0006MDa!!\u0004\u0001\t\u00031\u0017A\n;fgR$U-\u00193m_\u000e\\7)Y;tK\u0012\u0014\u00150\u0012=dQ\u0006tw-Z%o\u0003:\u001cWm\u001d;pe\"\u001a\u00111B:\t\r\u0005M\u0001\u0001\"\u0001g\u0003Y!Xm\u001d;NCb\u001cV\u000f\u001d9peR,G-\u00138qkR\u001c\bfAA\tg\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011\u0001G2iK\u000e\\W*\u001e7uSBdW-\u00138qkR\u0014Vm];miR\u0019Q&!\b\t\u000f\r\t9\u00021\u0001\u0002 A!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#!\n\u0011\u00055{\u0013bAA\u0014_\u00051\u0001K]3eK\u001aLA!a\u000b\u0002.\t11\u000b\u001e:j]\u001eT1!a\n0Q\u0019\u0001\u0011\u0011\u00072\u0002>A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028)\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005m\u0012Q\u0007\u0002\u000b\u000bb$XM\u001c3XSRDGFAA G\t\t\t\u0005E\u0002:\u0003\u0007J1!!\u0012;\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u001d\tIE\u0001E\u0001\u0003\u0017\n1#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016\u00042AHA'\r\u0019\t!\u0001#\u0001\u0002PM!\u0011QJA)!\rq\u00131K\u0005\u0004\u0003+z#AB!osJ+g\rC\u0004\u001c\u0003\u001b\"\t!!\u0017\u0015\u0005\u0005-\u0003\u0002CA/\u0003\u001b\"\t!a\u0018\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002bA)a&a\u0019\u0002h%\u0019\u0011QM\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u000b9\n\u0019'!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005!A.\u00198h\u0015\t\t\u0019(\u0001\u0003kCZ\f\u0017\u0002BA<\u0003[\u0012aa\u00142kK\u000e$\b\u0006CA.\u0003w\n\t)a!\u0011\u0007e\ni(C\u0002\u0002\u0000i\u0012!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005\u0015\u0015\u0001J:ik\u001a4G.Z'pI\u0016T\u0004e\u001f\u0019~Y\u0001\u001a8\r[3ek2,'\u000fV=qKj\u000230M?\t\u0011\u0005%\u0015Q\nC\u0001\u0003\u0017\u000b!cZ3oKJ\fG/\u001a*b]\u0012|W\u000eR1uCR\u0011\u0011Q\u0012\t\u0007\u0003\u001f\u000bI*a(\u000f\t\u0005E\u0015Q\u0013\b\u0004\u001b\u0006M\u0015\"\u0001\u0019\n\u0007\u0005]u&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0015Q\u0014\u0002\u0004'\u0016\f(bAAL_A!\u0011\u0011UAT\u001b\t\t\u0019KC\u0002\u0002&2\tQ\u0001^=qKNLA!!+\u0002$\n\u0019!k\\<\t\u0017\u00055\u0016Q\nEC\u0002\u0013\u0005\u0011qV\u0001\be><H+\u001f9f+\t\t\t\f\u0005\u0003\u00024\u0006mVBAA[\u0015\u0011\t9,!/\u0002\u0013QL\b/Z;uS2\u001c(bAA:M%!\u0011QXA[\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u0017\u0005\u0005\u0017Q\nEC\u0002\u0013\u0005\u00111Y\u0001\n]VdG.\u00192mKN,\"!!2\u0011\u000b9\n\u0019'a2\u0011\u00079\nI-C\u0002\u0002L>\u0012qAQ8pY\u0016\fg\u000eC\u0006\u0002P\u00065\u0003R1A\u0005\u0002\u0005E\u0017!\u00023bi\u0006DVCAAG\u0011-\t).!\u0014\t\u0006\u0004%\t!!5\u0002\u000b\u0011\fG/Y-\t\u0017\u0005e\u0017Q\nEC\u0002\u0013\u0005\u0011\u0011[\u0001\u0006I\u0006$\u0018M\u0017\u0005\f\u0003;\fi\u0005#b\u0001\n\u0003\t\t.A\u0003eCR\fG\u000b")
public class MultipleInputITCase
extends BatchTestBase {
    @Parameter
    private BatchShuffleMode shuffleMode;
    @Parameter(value=1)
    private JobManagerOptions.SchedulerType schedulerType;

    public static Seq<Row> dataT() {
        return MultipleInputITCase$.MODULE$.dataT();
    }

    public static Seq<Row> dataZ() {
        return MultipleInputITCase$.MODULE$.dataZ();
    }

    public static Seq<Row> dataY() {
        return MultipleInputITCase$.MODULE$.dataY();
    }

    public static Seq<Row> dataX() {
        return MultipleInputITCase$.MODULE$.dataX();
    }

    public static boolean[] nullables() {
        return MultipleInputITCase$.MODULE$.nullables();
    }

    public static RowTypeInfo rowType() {
        return MultipleInputITCase$.MODULE$.rowType();
    }

    public static Seq<Row> generateRandomData() {
        return MultipleInputITCase$.MODULE$.generateRandomData();
    }

    @Parameters(name="shuffleMode: {0}, schedulerType: {1}")
    public static Object[][] parameters() {
        return MultipleInputITCase$.MODULE$.parameters();
    }

    public BatchShuffleMode shuffleMode() {
        return this.shuffleMode;
    }

    public void shuffleMode_$eq(BatchShuffleMode x$1) {
        this.shuffleMode = x$1;
    }

    public JobManagerOptions.SchedulerType schedulerType() {
        return this.schedulerType;
    }

    public void schedulerType_$eq(JobManagerOptions.SchedulerType x$1) {
        this.schedulerType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        this.tEnv().getConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode());
        this.tEnv().getConfig().set(JobManagerOptions.SCHEDULER, (Object)this.schedulerType());
    }

    @TestTemplate
    public void testBasicMultipleInput() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n                               |SELECT * FROM\n                               |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                               |  INNER JOIN\n                               |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                               |  ON T1.a = T2.d\n                               |")).stripMargin());
    }

    @TestTemplate
    public void testManyMultipleInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testJoinWithAggAsProbe() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testNoPriorityConstraint() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testRelatedInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testRelatedInputsWithAgg() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testDeadlockCausedByExchangeInAncestor() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @TestTemplate
    public void testMaxSupportedInputs() {
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"}))}));
        boolean[] nullables = new boolean[]{true, true};
        this.registerCollection("left_table", data, rowType, "a, b", nullables);
        this.registerCollection("right_table", data, rowType, "c, d", nullables);
        int numJoins = 62;
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT t0.a, t0.b");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(10).append(", t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c, t").append(BoxesRunTime.unboxToInt((Object)i)).append(".d").toString()));
        sql.append(" from left_table as t0");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(53).append(" left join right_table as t").append(BoxesRunTime.unboxToInt((Object)i)).append(" on t0.a = t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c and t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c = 1").toString()));
        this.checkMultipleInputResult(sql.toString());
    }

    public void checkMultipleInputResult(String sql) {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.checkResult(sql, expected, this.checkResult$default$3());
    }
}

