/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.Collection;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenerator$;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.OperatorFusionCodegenITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001M\u00111d\u00149fe\u0006$xN\u001d$vg&|gnQ8eK\u001e,g.\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\u000fI,h\u000e^5nK*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\nA\u0001\u0001\r\u00111A\u0005\u0002\u0005\n\u0001#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3\u0016\u0003\t\u0002\"aI\u001f\u000f\u0005\u0011RdBA\u00139\u001d\t1sG\u0004\u0002(m9\u0011\u0001&\u000e\b\u0003SQr!AK\u001a\u000f\u0005-\u0012dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty##\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0011\u0011HA\u0001\u0005U>Lg.\u0003\u0002<y\u0005A!j\\5o)f\u0004XM\u0003\u0002:\u0005%\u0011ah\u0010\u0002\t\u0015>Lg\u000eV=qK*\u00111\b\u0010\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\u0002\t\u000bA#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3`I\u0015\fHCA\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0011)f.\u001b;\t\u000f)\u0003\u0015\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\u00131\u0003\u0001\u0019!A!B\u0013\u0011\u0013!E3ya\u0016\u001cG/\u001a3K_&tG+\u001f9fA!\u00121J\u0014\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003#J\u000bQ\u0002]1sC6,G/\u001a:ju\u0016$'BA*U\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0003+Z\u000bQA[;oSRT!a\u0016\u0007\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA-Q\u0005%\u0001\u0016M]1nKR,'\u000fC\u0003\\\u0001\u0011\u0005C,\u0001\u0004cK\u001a|'/\u001a\u000b\u0002\u0007\"\u0012!L\u0018\t\u0003?\u0016l\u0011\u0001\u0019\u0006\u0003C\n\f1!\u00199j\u0015\t\u0019G-A\u0004kkBLG/\u001a:\u000b\u0005U\u0003\u0012B\u00014a\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006Q\u0002!\t\u0001X\u0001\u0017i\u0016\u001cHOQ1tS\u000eLeN\\3s\u0011\u0006\u001c\bNS8j]\"\u0012qM\u001b\t\u0003?.L!\u0001\u001c1\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000b9\u0004A\u0011\u0001/\u0002GQ,7\u000f\u001e\"bg&\u001c\u0017J\u001c8fe\"\u000b7\u000f\u001b&pS:<\u0016\u000e\u001e5D_:$\u0017\u000e^5p]\"\u0012QN\u001b\u0005\u0006c\u0002!\t\u0001X\u0001%i\u0016\u001cHOQ1tS\u000eLeN\\3s\u0011\u0006\u001c\bNS8j]^KG\u000f[\"p]\u0012LG/[8oe!\u0012\u0001O\u001b\u0005\u0006i\u0002!\t\u0001X\u0001\u001bi\u0016\u001cH/T1osB\u0013xNY3PkR,'\u000fS1tQ*{\u0017N\u001c\u0015\u0003g*DQa\u001e\u0001\u0005\u0002q\u000bQ\u0005^3tiB\u0013xNY3PkR,'\u000fS1tQ*{\u0017N\\,ji\"|enQ8oI&$\u0018n\u001c8)\u0005YT\u0007\"\u0002>\u0001\t\u0003a\u0016\u0001\u000b;fgR\u0004&o\u001c2f\u001fV$XM\u001d%bg\"Tu.\u001b8XSRDw\u000b[3sK\u000e{g\u000eZ5uS>t\u0007FA=k\u0011\u0015i\b\u0001\"\u0001]\u0003\u0011\"Xm\u001d;ICND'j\\5o/&$\bNT8Qe&|'/\u001b;z\u0007>t7\u000f\u001e:bS:$\bF\u0001?k\u0011\u0019\t\t\u0001\u0001C\u00019\u0006qB/Z:u\u0011\u0006\u001c\bNS8j]^KG\u000f[(oYf\u0004&o\u001c6fGRLwN\u001c\u0015\u0003\u007f*Da!a\u0002\u0001\t\u0003a\u0016A\r;fgRD\u0015m\u001d5K_&tw+\u001b;i\t\u0016\fG\r\\8dW\u000e\u000bWo]3e\u0005f,\u0005p\u00195b]\u001e,\u0017J\\!oG\u0016\u001cHo\u001c:)\u0007\u0005\u0015!\u000e\u0003\u0004\u0002\u000e\u0001!\t\u0001X\u0001\u0015i\u0016\u001cH\u000fT3giN+W.\u001b%bg\"Tu.\u001b8)\u0007\u0005-!\u000e\u0003\u0004\u0002\u0014\u0001!\t\u0001X\u0001\"i\u0016\u001cH\u000fT3giN+W.\u001b%bg\"Tu.\u001b8XSRD7i\u001c8eSRLwN\u001c\u0015\u0004\u0003#Q\u0007BBA\r\u0001\u0011\u0005A,\u0001\u000buKN$H*\u001a4u\u0003:$\u0018\u000eS1tQ*{\u0017N\u001c\u0015\u0004\u0003/Q\u0007BBA\u0010\u0001\u0011\u0005A,\u0001\u000euKN$Hj\\2bY\"\u000b7\u000f[!hO^KG\u000f[8vi.+\u0017\u0010K\u0002\u0002\u001e)Da!!\n\u0001\t\u0003a\u0016a\u000b;fgRdunY1m\u0011\u0006\u001c\b.Q4h/&$\bn\\;u\u0017\u0016L\u0018I\u001c3ICND\u0017iZ4XSRD7*Z=)\u0007\u0005\r\"\u000e\u0003\u0004\u0002,\u0001!\t\u0001X\u0001\u0013i\u0016\u001cH\u000fS1tQ\u0006;wmV5uQ.+\u0017\u0010K\u0002\u0002*)Da!!\r\u0001\t\u0003a\u0016a\u0005;fgRD\u0015m\u001d5BO\u001e<\u0016\u000e\u001e5LKf\u0014\u0004fAA\u0018U\"1\u0011q\u0007\u0001\u0005\u0002q\u000bq\u0003^3ti2{7-\u00197ICND\u0017iZ4XSRD7*Z=)\u0007\u0005U\"\u000e\u0003\u0004\u0002>\u0001!\t\u0001X\u0001\u0019i\u0016\u001cHo\u00127pE\u0006d\u0007*Y:i\u0003\u001e<w+\u001b;i\u0017\u0016L\bfAA\u001eU\"1\u00111\t\u0001\u0005\u0002q\u000b1\u0003^3ti6+H\u000e^5qY\u0016D\u0015m\u001d5BO\u001eD3!!\u0011k\u0011\u0019\tI\u0005\u0001C\u00019\u0006IB/Z:u\u000f2|'-\u00197ICND\u0017iZ4XSRD7*Z=3Q\r\t9E\u001b\u0005\u0007\u0003\u001f\u0002A\u0011\u0001/\u0002kQ,7\u000f\u001e'pG\u0006d\u0017I\u001c3HY>\u0014\u0017\r\u001c%bg\"\fumZ%o)^|7+\u001a9fe\u0006$X\r\u001a$vg&|gn\u00149fe\u0006$xN\u001d\u0015\u0004\u0003\u001bR\u0007BBA+\u0001\u0011\u0005A,\u0001\ruKN$\u0018\tZ1qi&4X\rT8dC2D\u0015m\u001d5BO\u001eD3!a\u0015k\u0011\u0019\tY\u0006\u0001C\u00019\u0006yB/Z:u\u0011\u0006\u001c\b.Q4h/&$\bnS3z\u0003:$g)\u001b7uKJ\f%oZ:)\u0007\u0005e#\u000eC\u0004\u0002b\u0001!\t!a\u0019\u00025\rDWmY6Pa\u001a+8/[8o\u0007>$WmZ3o%\u0016\u001cX\u000f\u001c;\u0015\u0007\r\u000b)\u0007C\u0004\u0004\u0003?\u0002\r!a\u001a\u0011\t\u0005%\u0014\u0011\u000f\b\u0005\u0003W\ni\u0007\u0005\u0002.\u000b&\u0019\u0011qN#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(!\u001e\u0003\rM#(/\u001b8h\u0015\r\ty'\u0012\u0015\b\u0001\u0005e\u0014QQAD!\u0011\tY(!!\u000e\u0005\u0005u$bAA@A\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003\u0007\u000biH\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!!#$\u0005\u0005-\u0005cA(\u0002\u000e&\u0019\u0011q\u0012)\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u0005M%\u0001#\u0001\u0002\u0016\u0006Yr\n]3sCR|'OR;tS>t7i\u001c3fO\u0016t\u0017\nV\"bg\u0016\u00042AHAL\r\u0019\t!\u0001#\u0001\u0002\u001aN!\u0011qSAN!\r!\u0015QT\u0005\u0004\u0003?+%AB!osJ+g\rC\u0004\u001c\u0003/#\t!a)\u0015\u0005\u0005U\u0005\u0002CAT\u0003/#\t!!+\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002,B1\u0011QVA\\\u0003wk!!a,\u000b\t\u0005E\u00161W\u0001\u0005kRLGN\u0003\u0002\u00026\u0006!!.\u0019<b\u0013\u0011\tI,a,\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002E\u0003{K1!a0F\u0005\r\te.\u001f\u0015\t\u0003K\u000b\u0019-!3\u0002LB\u0019q*!2\n\u0007\u0005\u001d\u0007K\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012\u0011QZ\u0001\u0015Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016l4\u0010M?")
public class OperatorFusionCodegenITCase
extends BatchTestBase {
    @Parameter
    private Enumeration.Value expectedJoinType;

    @Parameters(name="expectedJoinType={0}")
    public static Collection<Object> parameters() {
        return OperatorFusionCodegenITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testBasicInnerHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT * FROM\n                                 |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testBasicInnerHashJoinWithCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT * FROM\n                                 |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d, e FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d WHERE T1.b > T2.e\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testBasicInnerHashJoinWithCondition2() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d WHERE CHAR_LENGTH(x.c) > CHAR_LENGTH(y.f)) T1\n        |  INNER JOIN\n        |  (SELECT d, e FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d WHERE T1.b > T2.e\n        |")).stripMargin());
    }

    @TestTemplate
    public void testManyProbeOuterHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProbeOuterHashJoinWithOnCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, ny, nz FROM x\n        |  LEFT JOIN y ON x.a = y.ny\n        |  LEFT JOIN z ON x.a = z.nz AND CHAR_LENGTH(x.c) > CHAR_LENGTH(z.i)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProbeOuterHashJoinWithWhereCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, ny, nz FROM x\n        |  LEFT JOIN y ON x.a = y.ny\n        |  LEFT JOIN z ON x.a = z.nz WHERE CHAR_LENGTH(x.c) > CHAR_LENGTH(y.f)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashJoinWithNoPriorityConstraint() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashJoinWithOnlyProjection() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT * FROM (SELECT a, nx + ny AS nt FROM x\n                                 |  JOIN y ON x.a = y.ny) t\n                                 |JOIN z ON t.a = z.nz WHERE t.nt -10 > z.nz\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testHashJoinWithDeadlockCausedByExchangeInAncestor() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLeftSemiHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM t WHERE t.a IN\n        |(SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLeftSemiHashJoinWithCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM t WHERE t.a IN\n        |(SELECT * FROM (SELECT a FROM x INNER JOIN y ON x.a = y.d) t2 WHERE t.b > t2.a )\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLeftAntiHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x, y WHERE x.a = y.d\n        |AND NOT EXISTS (SELECT * FROM z t1 WHERE x.b = t1.h AND t1.g >= 0)\n        |AND NOT EXISTS (SELECT * FROM z t2 WHERE x.b = t2.h AND t2.h < 100)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLocalHashAggWithoutKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT count(a) as cnt FROM\n                                 |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testLocalHashAggWithoutKeyAndHashAggWithKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT count(distinct d) as cnt FROM\n                                 |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testHashAggWithKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashAggWithKey2() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT a, count(b) as cnt FROM\n                                 |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |  GROUP BY a\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testLocalHashAggWithKey() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT a, count(b) as cnt, avg(b) as pj FROM\n                                 |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |  GROUP BY a\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testGlobalHashAggWithKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT a, SUM(b) AS cnt, AVG(b) AS pj FROM t GROUP BY a) T2\n        |  ON T1.a = T2.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testMultipleHashAgg() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a, SUM(b) as b FROM x group by a) T1\n        |  INNER JOIN\n        |  (SELECT d, SUM(e) as e FROM y group by d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testGlobalHashAggWithKey2() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH agg AS (SELECT a, SUM(b) AS cnt FROM t GROUP BY a)\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN agg ON y.d = agg.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLocalAndGlobalHashAggInTwoSeperatedFusionOperator() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testAdaptiveLocalHashAgg() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
        this.tEnv().getConfig().set(HashAggCodeGenerator$.MODULE$.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)1L));
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashAggWithKeyAndFilterArgs() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, b, c, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(DISTINCT b) AS cnt1, COUNT(DISTINCT c) as cnt2 FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    public void checkOpFusionCodegenResult(String sql) {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.checkResult(sql, expected, this.checkResult$default$3());
    }
}

