/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.LinkedList;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.PartitionableSinkITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Array$;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%h\u0001B\u0001\u0003\u0001M\u0011q\u0003U1si&$\u0018n\u001c8bE2,7+\u001b8l\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013!A0\u0016\u0003\t\u00022a\t\u0015+\u001b\u0005!#BA\u0013'\u0003%!Xm\u001d;vi&d7O\u0003\u0002(\u0019\u0005!1m\u001c:f\u0013\tICEA\nFC\u000eD7)\u00197mE\u0006\u001c7n\u0016:baB,'\u000f\u0005\u0002,[5\tAF\u0003\u0002\u0018\u0015%\u0011a\u0006\f\u0002\u0013\u0019\u0016<\u0017mY=S_^,\u0005\u0010^3og&|g\u000e\u0003\u00041\u0001\u0001\u0006IAI\u0001\u0003?\u0002B#a\f\u001a\u0011\u0005MbT\"\u0001\u001b\u000b\u0005U2\u0014!C3yi\u0016t7/[8o\u0015\t9\u0004(A\u0002ba&T!!\u000f\u001e\u0002\u000f),\b/\u001b;fe*\u00111\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003{Q\u0012\u0011CU3hSN$XM]#yi\u0016t7/[8o\u0011\u0015y\u0004\u0001\"\u0011A\u0003\u0019\u0011WMZ8sKR\t\u0011\t\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15I\u0001\u0003V]&$\bF\u0001 I!\tI%*D\u00017\u0013\tYeG\u0001\u0006CK\u001a|'/Z#bG\"DQ!\u0014\u0001\u0005\u0002\u0001\u000b!\u0005^3ti&s7/\u001a:u/&$\bnT;u!\u0006\u0014H/\u001b;j_:<%o\\;qS:<\u0007F\u0001'P!\tI\u0005+\u0003\u0002Rm\t!A+Z:u\u0011\u0015\u0019\u0006\u0001\"\u0001A\u0003}!Xm\u001d;J]N,'\u000f^,ji\"\u0004\u0016M\u001d;ji&|gn\u0012:pkBLgn\u001a\u0015\u0003%>CQA\u0016\u0001\u0005\u0002\u0001\u000ba\u0004^3ti&s7/\u001a:u/&$\bn\u0015;bi&\u001c\u0007+\u0019:uSRLwN\\:)\u0005U{\u0005\"B-\u0001\t\u0003\u0001\u0015\u0001\u000b;fgRLen]3si^KG\u000f[*uCRL7-\u00118e\tft\u0017-\\5d!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001-P\u0011\u0015a\u0006\u0001\"\u0001A\u0003)\"Xm\u001d;J]N,'\u000f^,ji\"\u001cF/\u0019;jGB\u000b'\u000f^5uS>t\u0017I\u001c3Ti\u0006\u00148k\\;sG\u0016D#aW(\t\u000b}\u0003A\u0011\u0001!\u0002YQ,7\u000f^%og\u0016\u0014HoV5uQN#\u0018\r^5d!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a,bYV,7oU8ve\u000e,\u0007F\u00010P\u0011\u0015\u0011\u0007\u0001\"\u0001A\u0003\u001d\"Xm\u001d;Ti\u0006$\u0018n\u0019)beRLG/[8o\u001d>$\u0018J\u001c)beRLG/[8o\r&,G\u000eZ:)\u0005\u0005|\u0005\"B3\u0001\t\u0003\u0001\u0015!\f;fgRLen]3siN#\u0018\r^5d!\u0006\u0014H/\u001b;j_:|eNT8o!\u0006\u0014H/\u001b;j_:,GmU5oW\"\u0012Am\u0014\u0005\u0006Q\u0002!I![\u0001\u0012e\u0016<\u0017n\u001d;feR\u000b'\r\\3TS:\\GcB!ko\u0006\u0015\u0011q\u0002\u0005\bW\u001e\u0004\n\u00111\u0001m\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0002ni:\u0011aN\u001d\t\u0003_\u000ek\u0011\u0001\u001d\u0006\u0003cJ\ta\u0001\u0010:p_Rt\u0014BA:D\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u001c\u0005b\u0002=h!\u0003\u0005\r!_\u0001\be><H+\u001f9f!\rQ\u0018\u0011A\u0007\u0002w*\u0011A0`\u0001\nif\u0004X-\u001e;jYNT!A`@\u0002\t)\fg/\u0019\u0006\u0003o1I1!a\u0001|\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u0013\u0005\u001dq\r%AA\u0002\u0005%\u0011\u0001C4s_V\u0004\u0018N\\4\u0011\u0007\t\u000bY!C\u0002\u0002\u000e\r\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0012\u001d\u0004\n\u00111\u0001\u0002\u0014\u0005\u0001\u0002/\u0019:uSRLwN\\\"pYVlgn\u001d\t\u0005\u0005\u0006UA.C\u0002\u0002\u0018\r\u0013Q!\u0011:sCfD\u0011\"a\u0007\u0001#\u0003%I!!\b\u00027I,w-[:uKJ$\u0016M\u00197f'&t7\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\tyBK\u0002m\u0003CY#!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[\u0019\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011GA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003k\u0001\u0011\u0013!C\u0005\u0003o\t1D]3hSN$XM\u001d+bE2,7+\u001b8lI\u0011,g-Y;mi\u0012\u0012TCAA\u001dU\rI\u0018\u0011\u0005\u0005\n\u0003{\u0001\u0011\u0013!C\u0005\u0003\u007f\t1D]3hSN$XM\u001d+bE2,7+\u001b8lI\u0011,g-Y;mi\u0012\u001aTCAA!U\u0011\tI!!\t\t\u0013\u0005\u0015\u0003!%A\u0005\n\u0005\u001d\u0013a\u0007:fO&\u001cH/\u001a:UC\ndWmU5oW\u0012\"WMZ1vYR$C'\u0006\u0002\u0002J)\"\u00111CA\u0011\u000f\u001d\tiE\u0001E\u0001\u0003\u001f\nq\u0003U1si&$\u0018n\u001c8bE2,7+\u001b8l\u0013R\u001b\u0015m]3\u0011\u0007y\t\tF\u0002\u0004\u0002\u0005!\u0005\u00111K\n\u0005\u0003#\n)\u0006E\u0002C\u0003/J1!!\u0017D\u0005\u0019\te.\u001f*fM\"91$!\u0015\u0005\u0002\u0005uCCAA(\u0011)\t\t'!\u0015C\u0002\u0013\u0005\u00111M\u0001\u0006if\u0004X\rN\u000b\u0002s\"A\u0011qMA)A\u0003%\u00110\u0001\u0004usB,G\u0007\t\u0005\u000b\u0003W\n\tF1A\u0005\u0002\u0005\r\u0014a\u0004;za\u0016|\u0016N\u001c;`gR\u0014\u0018N\\4\t\u0011\u0005=\u0014\u0011\u000bQ\u0001\ne\f\u0001\u0003^=qK~Kg\u000e^0tiJLgn\u001a\u0011\t\u0015\u0005M\u0014\u0011\u000bb\u0001\n\u0003\t)(A\u0004S\u000bN+F\nV\u0019\u0016\u0005\u0005]\u0004#BA=\u0003\u0003cWBAA>\u0015\u0011\ti(a \u0002\tU$\u0018\u000e\u001c\u0006\u0002}&!\u00111QA>\u0005)a\u0015N\\6fI2K7\u000f\u001e\u0005\n\u0003\u000f\u000b\t\u0006)A\u0005\u0003o\n\u0001BU#T+2#\u0016\u0007\t\u0005\u000b\u0003\u0017\u000b\tF1A\u0005\u0002\u0005U\u0014a\u0002*F'VcEK\r\u0005\n\u0003\u001f\u000b\t\u0006)A\u0005\u0003o\n\u0001BU#T+2#&\u0007\t\u0005\u000b\u0003'\u000b\tF1A\u0005\u0002\u0005U\u0014a\u0002*F'VcEk\r\u0005\n\u0003/\u000b\t\u0006)A\u0005\u0003o\n\u0001BU#T+2#6\u0007\t\u0005\u000b\u00037\u000b\tF1A\u0005\u0002\u0005u\u0015\u0001\u0004*F'VcEkX)V\u000bV+UCAAP!\u0019\tI(!)\u0002x%!\u00111UA>\u0005\u0011a\u0015n\u001d;\t\u0013\u0005\u001d\u0016\u0011\u000bQ\u0001\n\u0005}\u0015!\u0004*F'VcEkX)V\u000bV+\u0005\u0005C\u0004\u0002,\u0006EC\u0011\u0001!\u0002\t%t\u0017\u000e\u001e\u0004\b\u0003_\u000b\t\u0006AAY\u0005a)fn]1gK6+Wn\u001c:z'&t7NR;oGRLwN\\\n\u0005\u0003[\u000b\u0019\f\u0005\u0004\u00026\u0006\u0015\u0017\u0011Z\u0007\u0003\u0003oSA!!/\u0002<\u0006!1/\u001b8l\u0015\u0011\ti,a0\u0002\u0013\u0019,hn\u0019;j_:\u001c(bA\u001c\u0002B*\u0019\u00111\u0019\u0007\u0002\u0013M$(/Z1nS:<\u0017\u0002BAd\u0003o\u0013\u0001CU5dQNKgn\u001b$v]\u000e$\u0018n\u001c8\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4\r\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019.!4\u0003\u0007I{w\u000fC\u0006\u0002X\u00065&\u0011!Q\u0001\n\u0005e\u0017AC8viB,H\u000fV=qKB1\u00111\\As\u0003\u0013l!!!8\u000b\t\u0005}\u0017\u0011]\u0001\tif\u0004X-\u001b8g_*\u0019\u00111]@\u0002\r\r|W.\\8o\u0013\u0011\t9/!8\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:DqaGAW\t\u0003\tY\u000f\u0006\u0003\u0002n\u0006E\b\u0003BAx\u0003[k!!!\u0015\t\u0011\u0005]\u0017\u0011\u001ea\u0001\u00033DA\"!>\u0002.\u0002\u0007\t\u0019!C\u0005\u0003k\n\u0011B]3tk2$8+\u001a;\t\u0019\u0005e\u0018Q\u0016a\u0001\u0002\u0004%I!a?\u0002\u001bI,7/\u001e7u'\u0016$x\fJ3r)\r\t\u0015Q \u0005\u000b\u0003\u007f\f90!AA\u0002\u0005]\u0014a\u0001=%c!a!1AAW\u0001\u0004\u0005\t\u0015)\u0003\u0002x\u0005Q!/Z:vYR\u001cV\r\u001e\u0011\t\u0011\t\u001d\u0011Q\u0016C!\u0005\u0013\tAa\u001c9f]R\u0019\u0011Ia\u0003\t\u0011\t5!Q\u0001a\u0001\u0005\u001f\t1b\u001c9f]\u000e{g\u000e^3yiB!!\u0011\u0003B\u000b\u001b\t\u0011\u0019B\u0003\u0003\u0002>\u0006\u0005\u0018\u0002\u0002B\f\u0005'\u00111b\u00149f]\u000e{g\u000e^3yi\"A!1DAW\t\u0003\u0012i\"\u0001\u0004j]Z|7.\u001a\u000b\u0004\u0003\n}\u0001\u0002\u0003B\u0011\u00053\u0001\r!!3\u0002\u0007I|w\u000f\u000b\u0004\u0003\u001a\t\u0015\"Q\b\t\u0006\u0005\n\u001d\"1F\u0005\u0004\u0005S\u0019%A\u0002;ie><8\u000f\u0005\u0003\u0003.\t]b\u0002\u0002B\u0018\u0005gq1a\u001cB\u0019\u0013\u0005!\u0015b\u0001B\u001b\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u001d\u0005w\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\tU2)\r\u0004\u001fY\n}\"1N\u0019\nG\t\u0005#\u0011\nB1\u0005\u0017*BAa\u0011\u0003FU\tA\u000eB\u0004\u0003HI\u0011\rA!\u0015\u0003\u0003QKAAa\u0013\u0003N\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1Aa\u0014D\u0003\u0019!\bN]8xgF!!1\u000bB-!\r\u0011%QK\u0005\u0004\u0005/\u001a%a\u0002(pi\"Lgn\u001a\t\u0005\u00057\u0012iFD\u0002C\u0005gIAAa\u0018\u0003<\tIA\u000b\u001b:po\u0006\u0014G.Z\u0019\nG\t\r$Q\rB4\u0005\u001fr1A\u0011B3\u0013\r\u0011yeQ\u0019\u0006E\t\u001b%\u0011\u000e\u0002\u0006g\u000e\fG.Y\u0019\u0004M\t-\u0002B\u0003B8\u0003#\u0012\r\u0011\"\u0001\u0003r\u0005Qa-[3mI:\u000bW.Z:\u0016\u0005\tM\u0004#\u0002\"\u0002\u0016\tU\u0004\u0003\u0002B<\u0005{j!A!\u001f\u000b\t\tm\u0014qP\u0001\u0005Y\u0006tw-C\u0002v\u0005sB\u0011B!!\u0002R\u0001\u0006IAa\u001d\u0002\u0017\u0019LW\r\u001c3OC6,7\u000f\t\u0005\u000b\u0005\u000b\u000b\tF1A\u0005\u0002\t\u001d\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\t%\u0005#\u0002\"\u0002\u0016\t-\u0005\u0003\u0002BG\u0005+k!Aa$\u000b\t\tE%1S\u0001\bY><\u0017nY1m\u0015\r\tyMC\u0005\u0005\u0005/\u0013yIA\u0006M_\u001eL7-\u00197UsB,\u0007\"\u0003BN\u0003#\u0002\u000b\u0011\u0002BE\u0003%!\u0017\r^1UsB,\u0007\u0005\u0003\u0006\u0003 \u0006E#\u0019!C\u0001\u0005C\u000bQ\u0002Z1uC:+H\u000e\\1cY\u0016\u001cXC\u0001BR!\u0015\u0011\u0015QCA\u0005\u0011%\u00119+!\u0015!\u0002\u0013\u0011\u0019+\u0001\beCR\fg*\u001e7mC\ndWm\u001d\u0011\t\u0015\t-\u0016\u0011\u000bb\u0001\n\u0003\u0011i+\u0001\u0005uKN$H)\u0019;b+\t\u0011y\u000b\u0005\u0004\u00032\n]\u0016\u0011Z\u0007\u0003\u0005gS1A!.D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005s\u0013\u0019LA\u0002TKFD\u0011B!0\u0002R\u0001\u0006IAa,\u0002\u0013Q,7\u000f\u001e#bi\u0006\u0004\u0003B\u0003Ba\u0003#\u0012\r\u0011\"\u0001\u0003.\u0006IA/Z:u\t\u0006$\u0018-\r\u0005\n\u0005\u000b\f\t\u0006)A\u0005\u0005_\u000b!\u0002^3ti\u0012\u000bG/Y\u0019!\u0011)\u0011I-!\u0015C\u0002\u0013\u0005!QV\u0001\ni\u0016\u001cH\u000fR1uCJB\u0011B!4\u0002R\u0001\u0006IAa,\u0002\u0015Q,7\u000f\u001e#bi\u0006\u0014\u0004\u0005C\u0004i\u0003#\"\tA!5\u0015\u0017\u0005\u0013\u0019N!9\u0003d\n\u0015(q\u001d\u0005\t\u0005+\u0014y\r1\u0001\u0003X\u0006!A/\u00128w!\u0011\u0011IN!8\u000e\u0005\tm'BA\u001c\u000b\u0013\u0011\u0011yNa7\u0003!Q\u000b'\r\\3F]ZL'o\u001c8nK:$\bBB6\u0003P\u0002\u0007A\u000e\u0003\u0004y\u0005\u001f\u0004\r!\u001f\u0005\t\u0003\u000f\u0011y\r1\u0001\u0002\n!A\u0011\u0011\u0003Bh\u0001\u0004\t\u0019\u0002")
public class PartitionableSinkITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    public static Seq<Row> testData2() {
        return PartitionableSinkITCase$.MODULE$.testData2();
    }

    public static Seq<Row> testData1() {
        return PartitionableSinkITCase$.MODULE$.testData1();
    }

    public static Seq<Row> testData() {
        return PartitionableSinkITCase$.MODULE$.testData();
    }

    public static boolean[] dataNullables() {
        return PartitionableSinkITCase$.MODULE$.dataNullables();
    }

    public static LogicalType[] dataType() {
        return PartitionableSinkITCase$.MODULE$.dataType();
    }

    public static String[] fieldNames() {
        return PartitionableSinkITCase$.MODULE$.fieldNames();
    }

    public static void init() {
        PartitionableSinkITCase$.MODULE$.init();
    }

    public static java.util.List<LinkedList<String>> RESULT_QUEUE() {
        return PartitionableSinkITCase$.MODULE$.RESULT_QUEUE();
    }

    public static LinkedList<String> RESULT3() {
        return PartitionableSinkITCase$.MODULE$.RESULT3();
    }

    public static LinkedList<String> RESULT2() {
        return PartitionableSinkITCase$.MODULE$.RESULT2();
    }

    public static LinkedList<String> RESULT1() {
        return PartitionableSinkITCase$.MODULE$.RESULT1();
    }

    public static RowTypeInfo type_int_string() {
        return PartitionableSinkITCase$.MODULE$.type_int_string();
    }

    public static RowTypeInfo type4() {
        return PartitionableSinkITCase$.MODULE$.type4();
    }

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(3);
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)3));
        this.tEnv().getConfig().set(BatchExecutionOptions.ADAPTIVE_AUTO_PARALLELISM_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.registerCollection("nonSortTable", PartitionableSinkITCase$.MODULE$.testData(), TestData$.MODULE$.type3(), "a, b, c", PartitionableSinkITCase$.MODULE$.dataNullables());
        this.registerCollection("sortTable", PartitionableSinkITCase$.MODULE$.testData1(), TestData$.MODULE$.type3(), "a, b, c", PartitionableSinkITCase$.MODULE$.dataNullables());
        this.registerCollection("starTable", PartitionableSinkITCase$.MODULE$.testData2(), PartitionableSinkITCase$.MODULE$.type_int_string(), "b, c", new boolean[]{true, true});
        PartitionableSinkITCase$.MODULE$.init();
    }

    @Test
    public void testInsertWithOutPartitionGrouping() {
        this.registerTableSink(this.registerTableSink$default$1(), this.registerTableSink$default$2(), this.registerTableSink$default$3(), this.registerTableSink$default$4());
        this.tEnv().executeSql("insert into sinkTable select a, max(b), c from nonSortTable group by a, c").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyInAnyOrderElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,5,Hi", (List)new .colon.colon((Object)"1,5,Hi01", (List)new .colon.colon((Object)"1,5,Hi02", (List)Nil$.MODULE$)))));
        Assertions.assertThat((boolean)PartitionableSinkITCase$.MODULE$.RESULT2().isEmpty()).isTrue();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyInAnyOrderElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,1,Hello world01", "2,1,Hello world02", "2,1,Hello world03", "2,1,Hello world04", "2,2,Hello world, how are you?", "3,1,Hello world", "3,2,Hello", "3,2,Hello01", "3,2,Hello02", "3,2,Hello03", "3,2,Hello04"}))));
    }

    @Test
    public void testInsertWithPartitionGrouping() {
        this.registerTableSink(this.registerTableSink$default$1(), this.registerTableSink$default$2(), this.registerTableSink$default$3(), this.registerTableSink$default$4());
        this.tEnv().executeSql("insert into sinkTable select a, b, c from sortTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world", (List)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)Nil$.MODULE$))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba", (List)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", (List)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f", (List)Nil$.MODULE$))))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"2,2,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,3,I'm fine, thank", (List)new .colon.colon((Object)"3,3,I'm fine, thank you", (List)new .colon.colon((Object)"3,3,I'm fine, thank you, and you?", (List)Nil$.MODULE$)))))));
    }

    @Test
    public void testInsertWithStaticPartitions() {
        this.registerTableSink(this.registerTableSink$default$1(), this.registerTableSink$default$2(), this.registerTableSink$default$3(), this.registerTableSink$default$4());
        this.tEnv().executeSql("insert into sinkTable partition(a=1) select b, c from sortTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,Hi", "1,1,Hello world", "1,2,Hello", "1,1,Hello world, how are you?", "1,3,I'm fine, thank", "1,3,I'm fine, thank you", "1,3,I'm fine, thank you, and you?", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f"}))));
        Assertions.assertThat((boolean)PartitionableSinkITCase$.MODULE$.RESULT2().isEmpty()).isTrue();
        Assertions.assertThat((boolean)PartitionableSinkITCase$.MODULE$.RESULT3().isEmpty()).isTrue();
    }

    @Test
    public void testInsertWithStaticAndDynamicPartitions() {
        String[] x$1 = (String[])((Object[])new String[]{"a", "b"});
        String x$2 = this.registerTableSink$default$1();
        RowTypeInfo x$3 = this.registerTableSink$default$2();
        boolean x$4 = this.registerTableSink$default$3();
        this.registerTableSink(x$2, x$3, x$4, x$1);
        this.tEnv().executeSql("insert into sinkTable partition(a=1) select b, c from sortTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world", (List)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)Nil$.MODULE$))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba", (List)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", (List)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f", (List)Nil$.MODULE$))))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,2,Hi", (List)new .colon.colon((Object)"1,2,Hello", (List)new .colon.colon((Object)"1,3,I'm fine, thank", (List)new .colon.colon((Object)"1,3,I'm fine, thank you", (List)new .colon.colon((Object)"1,3,I'm fine, thank you, and you?", (List)Nil$.MODULE$)))))));
    }

    @Test
    public void testInsertWithStaticPartitionAndStarSource() {
        String[] x$5 = (String[])((Object[])new String[]{"b", "c"});
        String x$6 = this.registerTableSink$default$1();
        RowTypeInfo x$7 = this.registerTableSink$default$2();
        boolean x$8 = this.registerTableSink$default$3();
        this.registerTableSink(x$6, x$7, x$8, x$5);
        this.tEnv().executeSql("insert into sinkTable partition(b=1) select * from starTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)new .colon.colon((Object)"3,1,I'm fine, thank you", (List)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba", (List)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", (List)Nil$.MODULE$))))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f", (List)Nil$.MODULE$))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"2,1,Hello", (List)new .colon.colon((Object)"1,1,Hello world", (List)new .colon.colon((Object)"2,1,Hi", (List)new .colon.colon((Object)"3,1,I'm fine, thank", (List)new .colon.colon((Object)"3,1,I'm fine, thank you, and you?", (List)Nil$.MODULE$)))))));
    }

    @Test
    public void testInsertWithStaticPartitionAndValuesSource() {
        String[] x$9 = (String[])((Object[])new String[]{"b", "c"});
        String x$10 = this.registerTableSink$default$1();
        RowTypeInfo x$11 = this.registerTableSink$default$2();
        boolean x$12 = this.registerTableSink$default$3();
        this.registerTableSink(x$10, x$11, x$12, x$9);
        this.tEnv().executeSql("insert into sinkTable partition(b=1)\n(values (1, 'Hello world, how are you?'), (4, '\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f'), (2, 'Hello'))").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)Nil$.MODULE$)));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)Nil$.MODULE$)));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"2,1,Hello", (List)Nil$.MODULE$)));
    }

    @Test
    public void testStaticPartitionNotInPartitionFields() {
        String x$13 = "sinkTable2";
        RowTypeInfo x$14 = PartitionableSinkITCase$.MODULE$.type4();
        String[] x$15 = (String[])((Object[])new String[]{"a", "b"});
        boolean x$16 = this.registerTableSink$default$3();
        this.registerTableSink(x$13, x$14, x$16, x$15);
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("insert into sinkTable2 partition(c=1) select a, b from sortTable").await()).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testInsertStaticPartitionOnNonPartitionedSink() {
        String x$17 = "sinkTable2";
        RowTypeInfo x$18 = PartitionableSinkITCase$.MODULE$.type4();
        String[] x$19 = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        boolean x$20 = this.registerTableSink$default$3();
        this.registerTableSink(x$17, x$18, x$20, x$19);
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("insert into sinkTable2 partition(c=1) select a, b from sortTable").await()).isInstanceOf(TableException.class);
    }

    private void registerTableSink(String tableName, RowTypeInfo rowType, boolean grouping, String[] partitionColumns) {
        PartitionableSinkITCase$.MODULE$.registerTableSink(this.tEnv(), tableName, rowType, grouping, partitionColumns);
    }

    private String registerTableSink$default$1() {
        return "sinkTable";
    }

    private RowTypeInfo registerTableSink$default$2() {
        return TestData$.MODULE$.type3();
    }

    private boolean registerTableSink$default$3() {
        return true;
    }

    private String[] registerTableSink$default$4() {
        return (String[])((Object[])new String[]{"a"});
    }

    public static class UnsafeMemorySinkFunction
    extends RichSinkFunction<Row> {
        private LinkedList<String> resultSet;

        private LinkedList<String> resultSet() {
            return this.resultSet;
        }

        private void resultSet_$eq(LinkedList<String> x$1) {
            this.resultSet = x$1;
        }

        public void open(OpenContext openContext) {
            int taskId = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
            this.resultSet_$eq(PartitionableSinkITCase$.MODULE$.RESULT_QUEUE().get(taskId));
        }

        public void invoke(Row row) throws Exception {
            this.resultSet().add(row.toString());
        }

        public UnsafeMemorySinkFunction(TypeInformation<Row> outputType) {
        }
    }
}

