/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001M\u0011\u0011\u0004U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\u0016g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8t+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#a\u0002\"p_2,\u0017M\u001c\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u0012\u0002-M|WO]2f\r\u0016$8\r\u001b)beRLG/[8og\u0002B#\u0001K\u0016\u0011\u00051*T\"A\u0017\u000b\u00059z\u0013!\u00049be\u0006lW\r^3sSj,GM\u0003\u00021c\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0005I\u001a\u0014!\u00026v]&$(B\u0001\u001b\r\u0003%!Xm\u001d;vi&d7/\u0003\u00027[\tI\u0001+\u0019:b[\u0016$XM\u001d\u0005\bq\u0001\u0011\r\u0011\"\u0001\"\u0003A)8/Z\"bi\u0006dwn\u001a$jYR,'\u000f\u0003\u0004;\u0001\u0001\u0006IAI\u0001\u0012kN,7)\u0019;bY><g)\u001b7uKJ\u0004\u0003\u0006B\u001d,yu\nQA^1mk\u0016l\u0012!\u0001\u0005\u0006\u007f\u0001!\t\u0005Q\u0001\u0007E\u00164wN]3\u0015\u0003\u0005\u0003\"a\t\"\n\u0005\r##\u0001B+oSRD#AP#\u0011\u0005\u0019cU\"A$\u000b\u0005!K\u0015aA1qS*\u0011!jS\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011\u0004#\u0003\u0002N\u000f\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b=\u0003A\u0011\u0001!\u0002EQ,7\u000f^*j[BdW\rU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^32Q\tq\u0015\u000b\u0005\u0002G%&\u00111k\u0012\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0006+\u0002!\t\u0001Q\u0001+i\u0016\u001cH\u000fU1si&\fG\u000eU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^3QkNDGi\\<oQ\t!\u0016\u000bC\u0003Y\u0001\u0011\u0005\u0001)A\ruKN$XK\\2p]Z,'\u000f^3e\u000bb\u0004(/Z:tS>t\u0007FA,R\u0011\u0015Y\u0006\u0001\"\u0001A\u0003M\"Xm\u001d;QkNDGi\\<o!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a$jYR,'o]\"p]R\f\u0017N\u001c)beRLG/[8o\u0017\u0016L8\u000f\u000b\u0002[#\")a\f\u0001C\u0001\u0001\u00069E/Z:u!V\u001c\b\u000eR8x]B\u000b'\u000f^5uS>t\u0017I\u001c3GS2$XM]:D_:$\u0018-\u001b8QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016N\\4mKB\u0013xN[3di&|g\u000e\u000b\u0002^#\")\u0011\r\u0001C\u0001\u0001\u0006)C/Z:u!\u0006\u0014H/\u001b;j_:\u0004&/\u001e8fe\u000e{W\u000e]5mK\u000ec\u0017m]:M_\u0006$WM\u001d\u0015\u0003AFCC\u0001\u00013=UB\u0011Q\r[\u0007\u0002M*\u0011qmR\u0001\nKb$XM\\:j_:L!!\u001b4\u0003\u0015\u0015CH/\u001a8e/&$\b\u000eL\u0001lG\u0005a\u0007C\u0001\u0017n\u0013\tqWF\u0001\u000eQCJ\fW.\u001a;fe&TX\r\u001a+fgR,\u0005\u0010^3og&|gnB\u0003q\u0005!\u0005\u0011/A\rQCJ$\u0018\u000e^5p]\u0006\u0014G.Z*pkJ\u001cW-\u0013+DCN,\u0007C\u0001\u0010s\r\u0015\t!\u0001#\u0001t'\t\u0011H\u000f\u0005\u0002$k&\u0011a\u000f\n\u0002\u0007\u0003:L(+\u001a4\t\u000bm\u0011H\u0011\u0001=\u0015\u0003EDQA\u001f:\u0005\u0002m\f!\u0002]1sC6,G/\u001a:t)\u0005a\b#B?\u0002\u0006\u0005%Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0003vi&d'BAA\u0002\u0003\u0011Q\u0017M^1\n\u0007\u0005\u001daP\u0001\u0006D_2dWm\u0019;j_:\u0004RaIA\u0006\u0003\u001fI1!!\u0004%\u0005\u0015\t%O]1z!\r\u0019\u0013\u0011C\u0005\u0004\u0003'!#aA!os\":\u00110a\u0006\u0002\u001e\u0005}\u0001c\u0001\u0017\u0002\u001a%\u0019\u00111D\u0017\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAA\u0011\u0003=\u001ax.\u001e:dK\u001a+Go\u00195QCJ$\u0018\u000e^5p]Nl4\u0010M?-AU\u001cXmQ1uC2|wMR5mi\u0016\u0014Xh_\u0019~\u0001")
public class PartitionableSourceITCase
extends BatchTestBase {
    @Parameter
    private final boolean sourceFetchPartitions;
    @Parameter(value=1)
    private final boolean useCatalogFilter;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n         |CREATE TABLE PartitionableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s'\n         |)\n         |").toString())).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n         |CREATE TABLE PartitionableAndFilterableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s',\n         |    'filterable-fields' = 'id;part1;part2'\n         |)\n         |").toString())).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(partitionableTable, partitions));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(partitionableTable, ""));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceITCase.$anonfun$before$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        this.checkResult("SELECT * FROM PartitionableTable WHERE part1 = 'A'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.checkResult("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        this.checkResult("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.checkResult("SELECT * FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.checkResult("SELECT name FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"LiSi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testPartitionPrunerCompileClassLoader() {
        String udfJavaCode = new StringOps(Predef$.MODULE$.augmentString("\n         |public class TrimUDF extends org.apache.flink.table.functions.ScalarFunction {\n         |   public String eval(String str) {\n         |     return str.trim();\n         |   }\n         |}\n         |")).stripMargin();
        File tmpJarDir = BatchAbstractTestBase.createTempFolder();
        File udfJarFile = UserClassLoaderJarTestUtils.createJarFile((File)tmpJarDir, (String)"flink-test-udf.jar", (String)"TrimUDF", (String)udfJavaCode);
        ((TestingTableEnvironment)this.tEnv()).getResourceManager().registerJarResources(Collections.singletonList(new ResourceUri(ResourceType.JAR, udfJarFile.toURI().toString())));
        this.tEnv().executeSql("create temporary function trimUDF as 'TrimUDF'");
        this.checkResult("select * from PartitionableTable where trimUDF(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    public static final /* synthetic */ void $anonfun$before$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceITCase() {
        this.sourceFetchPartitions = false;
        this.useCatalogFilter = false;
    }
}

