/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001'\ty1k\u001c:u\u0019&l\u0017\u000e^%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011I\u0011\u0002\r\t,gm\u001c:f)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSRD#aH\u0015\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013aA1qS*\u0011afL\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\u0004#A\u0003kk:LG/\u0003\u00023W\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bQ\u0002A\u0011A\u0011\u0002;Q,7\u000f^(sI\u0016\u0014()_,ji\"|eMZ:fi\u0006sGMR3uG\"D#a\r\u001c\u0011\u0005):\u0014B\u0001\u001d,\u0005\u0011!Vm\u001d;\t\u000bQ\u0002A\u0011\u0002\u001e\u0015\u0005\tZ\u0004\"\u0002\u001f:\u0001\u0004i\u0014!B8sI\u0016\u0014\bCA\u0012?\u0013\tyDEA\u0004C_>dW-\u00198\t\u000b\u0005\u0003A\u0011A\u0011\u0002!Q,7\u000f^(sI\u0016\u0014()\u001f'j[&$\bF\u0001!7\u0011\u0015\t\u0005\u0001\"\u0003E)\r\u0011Si\u0012\u0005\u0006\r\u000e\u0003\r!P\u0001\u0007_J$WM]\u0019\t\u000b!\u001b\u0005\u0019A\u001f\u0002\r=\u0014H-\u001a:3\u0011\u0015Q\u0005\u0001\"\u0001\"\u0003e!Xm\u001d;Pe\u0012,'OQ=MKN\u001cH\u000b[1o\u001f\u001a47/\u001a;)\u0005%3\u0004\"B'\u0001\t\u0003\t\u0013a\u0007;fgR|%\u000fZ3s\u0005fd\u0015.\\5u\u0005\u0016D\u0017N\u001c3GS\u0016dG\r\u000b\u0002Mm!)\u0001\u000b\u0001C\u0001C\u0005!B/Z:u\u001fJ$WM\u001d\"fQ&tGMR5fY\u0012D#a\u0014\u001c\t\u000bM\u0003A\u0011A\u0011\u00023Q,7\u000f^(sI\u0016\u0014()\u001f*fa\u0016\fG/\u001a3GS\u0016dGm\u001d\u0015\u0003%Z\u0002")
public class SortLimitITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        this.registerCollection("Table3", (Iterable<Row>)TestData$.MODULE$.data3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
    }

    @Test
    public void testOrderByWithOffsetAndFetch() {
        this.testOrderByWithOffsetAndFetch(true);
        this.testOrderByWithOffsetAndFetch(false);
    }

    private void testOrderByWithOffsetAndFetch(boolean order) {
        String sqlOrder = order ? "ASC" : "DESC";
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortLimitITCase.$anonfun$testOrderByWithOffsetAndFetch$1(order, x)), (Ordering)Ordering.Int$.MODULE$)).slice(2, 7);
        this.checkResult(new StringBuilder(69).append("SELECT * FROM Table3 ORDER BY a ").append(sqlOrder).append(" OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY").toString(), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLimit() {
        this.testOrderByLimit(true, false);
        this.testOrderByLimit(false, false);
        this.testOrderByLimit(true, true);
        this.testOrderByLimit(false, true);
    }

    private void testOrderByLimit(boolean order1, boolean order2) {
        String sqlOrder1 = order1 ? "ASC" : "DESC";
        String sqlOrder2 = order2 ? "ASC" : "DESC";
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJI.sp(order2 ? BoxesRunTime.unboxToLong((Object)x.getField(1)) : -BoxesRunTime.unboxToLong((Object)x.getField(1)), order1 ? BoxesRunTime.unboxToInt((Object)x.getField(0)) : -BoxesRunTime.unboxToInt((Object)x.getField(0))), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$))).slice(0, 5);
        this.checkResult(new StringBuilder(44).append("SELECT * FROM Table3 ORDER BY b ").append(sqlOrder2).append(", a ").append(sqlOrder1).append(" LIMIT 5").toString(), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLessThanOffset() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortLimitITCase.$anonfun$testOrderByLessThanOffset$1(x)), (Ordering)Ordering.Int$.MODULE$)).slice(2, TestData$.MODULE$.data3().size());
        this.checkResult("SELECT * FROM Table3 ORDER BY a ASC OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLimitBehindField() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> (String)x.getField(2), (Ordering)Ordering.String$.MODULE$)).slice(0, 5);
        this.checkResult("SELECT * FROM Table3 ORDER BY c LIMIT 5", (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderBehindField() {
        this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        Seq expected = (Seq)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> (String)x.getField(2), (Ordering)Ordering.String$.MODULE$);
        this.checkResult("SELECT * FROM Table3 ORDER BY c", (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByRepeatedFields() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortLimitITCase.$anonfun$testOrderByRepeatedFields$1(x)), (Ordering)Ordering.Int$.MODULE$)).slice(0, 5);
        this.checkResult("SELECT * FROM Table3 ORDER BY a, a, a LIMIT 5", (Seq<Row>)expected, true);
    }

    public static final /* synthetic */ int $anonfun$testOrderByWithOffsetAndFetch$1(boolean order$1, Row x) {
        return order$1 ? BoxesRunTime.unboxToInt((Object)x.getField(0)) : -BoxesRunTime.unboxToInt((Object)x.getField(0));
    }

    public static final /* synthetic */ int $anonfun$testOrderByLessThanOffset$1(Row x) {
        return BoxesRunTime.unboxToInt((Object)x.getField(0));
    }

    public static final /* synthetic */ int $anonfun$testOrderByRepeatedFields$1(Row x) {
        return BoxesRunTime.unboxToInt((Object)x.getField(0));
    }
}

