/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001'\tyA+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002\u001dQ,7\u000f\u001e+bE2,\u0007*\u001b8ugR\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0003V]&$\bFA\u0010*!\tQ\u0013'D\u0001,\u0015\taS&A\u0002ba&T!AL\u0018\u0002\u000f),\b/\u001b;fe*\u0011\u0001\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003e-\u0012A\u0001V3ti\")A\u0007\u0001C\u0001C\u0005aB/Z:u\u0007>dG.Z2u'&t7nQ8oM&<WO]1uS>t\u0007FA\u001a*\u0011\u00159\u0004\u0001\"\u0001\"\u0003]!Xm\u001d;De\u0016\fG/\u001a+bE2,\u0017i]*fY\u0016\u001cG\u000f\u000b\u00027S!)!\b\u0001C\u0001C\u0005)C/Z:u\u0007J,\u0017\r^3UC\ndW-Q:TK2,7\r^,ji\"|W\u000f^(qi&|gn\u001d\u0015\u0003s%\u0002")
public class TableSinkITCase
extends BatchTestBase {
    @Test
    public void testTableHints() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(361).append("\n                       |CREATE TABLE MyTable (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n       ").toString())).stripMargin());
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n                       |CREATE TABLE MySink (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'filesystem',\n                       |  'format' = 'testcsv',\n                       |  'path' = '").append(resultPath).append("'\n                       |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        String newPath1 = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        stmtSet.addInsertSql(new StringBuilder(68).append("insert into MySink /*+ OPTIONS('path' = '").append(newPath1).append("') */ select * from MyTable").toString());
        String newPath2 = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        stmtSet.addInsertSql(new StringBuilder(68).append("insert into MySink /*+ OPTIONS('path' = '").append(newPath2).append("') */ select * from MyTable").toString());
        stmtSet.execute().await();
        Assertions.assertThat((boolean)TableTestUtil$.MODULE$.readFromFile(resultPath).isEmpty()).isTrue();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "3,2,Hello world"}));
        Seq<String> result1 = TableTestUtil$.MODULE$.readFromFile(newPath1);
        Assertions.assertThat((Object)expected.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(result1.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<String> result2 = TableTestUtil$.MODULE$.readFromFile(newPath2);
        Assertions.assertThat((Object)expected.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(result2.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCollectSinkConfiguration() {
        this.tEnv().getConfig().set(CollectSinkOperatorFactory.MAX_BATCH_SIZE, (Object)MemorySize.parse((String)"1b"));
        Assertions.assertThatThrownBy(() -> this.checkResult("SELECT 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches((String)"Please consider increasing max bytes per batch value by setting collect-sink.batch-size.max")});
        this.tEnv().getConfig().set(CollectSinkOperatorFactory.MAX_BATCH_SIZE, (Object)MemorySize.parse((String)"1kb"));
        this.checkResult("SELECT 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCreateTableAsSelect() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(361).append("\n                       |CREATE TABLE MyTable (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n       ").toString())).stripMargin());
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                     |CREATE TABLE MyCtasTable\n                     | WITH (\n                     |  'connector' = 'filesystem',\n                     |  'format' = 'testcsv',\n                     |  'path' = '").append(resultPath).append("'\n                     |) AS\n                     | SELECT * FROM MyTable\n       ").toString())).stripMargin()).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "3,2,Hello world"}));
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Assertions.assertThat((Object)result.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        StatementSet statementSet = this.tEnv().createStatementSet();
        String useStatementResultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n                                 |CREATE TABLE MyCtasTableUseStatement\n                                 | WITH (\n                                 |  'connector' = 'filesystem',\n                                 |  'format' = 'testcsv',\n                                 |  'path' = '").append(useStatementResultPath).append("'\n                                 |) AS\n                                 | SELECT * FROM MyTable\n                                 |").toString())).stripMargin());
        statementSet.execute().await();
        Seq<String> useStatementResult = TableTestUtil$.MODULE$.readFromFile(useStatementResultPath);
        Assertions.assertThat((Object)useStatementResult.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCreateTableAsSelectWithoutOptions() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(361).append("\n                       |CREATE TABLE MyTable (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n       ").toString())).stripMargin());
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE MyCtasTable\n                        | AS\n                        | SELECT * FROM MyTable\n                        |")).stripMargin()).await()).hasRootCauseMessage("\nExpecting actual not to be null");
    }
}

