/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.types.Row;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001'\t\tB+\u00192mKN{WO]2f\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C!C\u00051!-\u001a4pe\u0016$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!&M\u0007\u0002W)\u0011A&L\u0001\u0004CBL'B\u0001\u00180\u0003\u001dQW\u000f]5uKJT!\u0001\r\t\u0002\u000b),h.\u001b;\n\u0005IZ#A\u0003\"fM>\u0014X-R1dQ\")A\u0007\u0001C\u0001C\u0005\tB/Z:u'&l\u0007\u000f\\3Qe>TWm\u0019;)\u0005M2\u0004C\u0001\u00168\u0013\tA4F\u0001\u0003UKN$\b\"\u0002\u001e\u0001\t\u0003\t\u0013!\b;fgR\u001c\u0016.\u001c9mKB\u0013xN[3di^KG\u000f\u001b)s_\u000e$\u0016.\\3)\u0005e2\u0004\"B\u001f\u0001\t\u0003\t\u0013A\u0007;fgR\u0004&o\u001c6fGR<\u0016\u000e\u001e5pkRLe\u000e];u%\u00164\u0007F\u0001\u001f7\u0011\u0015\u0001\u0005\u0001\"\u0001\"\u0003E!Xm\u001d;OKN$X\r\u001a)s_*,7\r\u001e\u0015\u0003\u007fYBQa\u0011\u0001\u0005\u0002\u0005\n\u0011\u0004^3ti:+7\u000f^3e!J|'.Z2u/&$\b.\u0013;f[\"\u0012!I\u000e\u0005\u0006\r\u0002!\t!I\u0001\u001ei\u0016\u001cH\u000fV1cY\u0016\u001cv.\u001e:dK^KG\u000f\u001b$jYR,'/\u00192mK\"\u0012QI\u000e\u0005\u0006\u0013\u0002!\t!I\u0001&i\u0016\u001cH\u000fV1cY\u0016\u001cv.\u001e:dK^KG\u000f\u001b$v]\u000e$\u0018n\u001c8GS2$XM]1cY\u0016D#\u0001\u0013\u001c\t\u000b1\u0003A\u0011A\u0011\u0002+Q,7\u000f^%oaV$hi\u001c:nCR\u001cv.\u001e:dK\"\u00121J\u000e\u0005\u0006\u001f\u0002!\t!I\u0001\u0015i\u0016\u001cH\u000fR1uCN#(/Z1n'>,(oY3)\u000593\u0004\"\u0002*\u0001\t\u0003\t\u0013\u0001\u0005;fgR\fE\u000e\u001c#bi\u0006$\u0016\u0010]3tQ\t\tf\u0007C\u0003V\u0001\u0011\u0005\u0011%\u0001\nuKN$8k\\;sG\u0016\u0004&o\u001c<jI\u0016\u0014\bF\u0001+7\u0011\u0015A\u0006\u0001\"\u0001\"\u00035!Xm\u001d;UC\ndW\rS5oi\"\u0012qK\u000e\u0005\u00067\u0002!\t!I\u0001'i\u0016\u001cH\u000fV1cY\u0016D\u0015N\u001c;XSRDGj\\4jG\u0006dG+\u00192mKN\u001b\u0017M\u001c*fkN,\u0007F\u0001.7\u0011\u0015q\u0006\u0001\"\u0001\"\u0003Y!Xm\u001d;TS6\u0004H.\u001a(fgR,GMR5mi\u0016\u0014\bFA/7\u0011\u0015\t\u0007\u0001\"\u0001\"\u0003]!Xm\u001d;OKN$X\r\u001a$jYR,'o\u00148BeJ\f\u0017\u0010\u000b\u0002am!)A\r\u0001C\u0001C\u0005)B/Z:u\u001d\u0016\u001cH/\u001a3GS2$XM](o\u001b\u0006\u0004\bFA27\u0001")
public class TableSourceITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(378).append("\n                       |CREATE TABLE MyTable (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(myTableDataId).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String filterableTableDataId = TestValuesTableFactory.registerData(TestLegacyFilterableTableSource$.MODULE$.defaultRows());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(487).append("\n                       |CREATE TABLE FilterableTable (\n                       |  name STRING,\n                       |  id BIGINT,\n                       |  amount INT,\n                       |  price DOUBLE\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(filterableTableDataId).append("',\n                       |  'filterable-fields' = 'amount',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String nestedTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.deepNestedRow());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(684).append("\n         |CREATE TABLE NestedTable (\n         |  id BIGINT,\n         |  deepNested ROW<\n         |     nested1 ROW<name STRING, `value.` INT>,\n         |     `nested2.` ROW<num INT, flag BOOLEAN>>,\n         |  nested ROW<name STRING, `value` INT>,\n         |  name STRING,\n         |  nestedItem ROW<deepArray ROW<`value` INT> ARRAY, deepMap MAP<STRING, INT>>,\n         |  lower_name AS LOWER(name)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'filterable-fields' = '`nested.value`;`nestedItem.deepMap`;`nestedItem.deepArray`',\n         |  'data-id' = '").append(nestedTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
    }

    @Test
    public void testSimpleProject() {
        this.checkResult("SELECT a, c FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSimpleProjectWithProcTime() {
        this.checkResult("SELECT a, c, CHAR_LENGTH(DATE_FORMAT(PROCTIME(), 'yyyy-MM-dd HH:mm')) FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world", BoxesRunTime.boxToInteger((int)16)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.checkResult("SELECT COUNT(*) FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedProject() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.`nested2.`.flag AS nestedFlag,\n        |    deepNested.`nested2.`.num + deepNested.nested1.`value.` AS nestedNum,\n        |    lower_name\n        |FROM NestedTable\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Sarah", BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)1100), "mary"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Rob", BoxesRunTime.boxToInteger((int)20000), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)2200), "bob"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike", BoxesRunTime.boxToInteger((int)30000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)3300), "liz"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedProjectWithItem() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT nestedItem.deepArray[nestedItem.deepMap['Monday']] FROM  NestedTable\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFilterable() {
        this.checkResult("SELECT id, amount, name FROM FilterableTable WHERE amount > 4 AND price < 9", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5), "Record_5"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), "Record_6"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)7), "Record_7"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)8), "Record_8"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFunctionFilterable() {
        this.checkResult("SELECT id, amount, name FROM FilterableTable WHERE amount > 4 AND price < 9 AND upper(name) = 'RECORD_5'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5), "Record_5"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInputFormatSource() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(295).append("\n         |CREATE TABLE MyInputFormatTable (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true',\n         |  'runtime-source' = 'InputFormat'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT a, c FROM MyInputFormatTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testDataStreamSource() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(293).append("\n         |CREATE TABLE MyDataStreamTable (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true',\n         |  'runtime-source' = 'DataStream'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT a, c FROM MyDataStreamTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAllDataTypes() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.fullDataTypesData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(695).append("\n         |CREATE TABLE T (\n         |  `a` BOOLEAN,\n         |  `b` TINYINT,\n         |  `c` SMALLINT,\n         |  `d` INT,\n         |  `e` BIGINT,\n         |  `f` FLOAT,\n         |  `g` DOUBLE,\n         |  `h` DECIMAL(5, 2),\n         |  `x` DECIMAL(30, 10),\n         |  `i` VARCHAR(5),\n         |  `j` CHAR(5),\n         |  `k` DATE,\n         |  `l` TIME(0),\n         |  `m` TIMESTAMP(9),\n         |  `n` TIMESTAMP(9) WITH LOCAL TIME ZONE,\n         |  `o` ARRAY<BIGINT>,\n         |  `p` ROW<f1 BIGINT, f2 STRING, f3 DOUBLE>,\n         |  `q` MAP<STRING, INT>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT * FROM T", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)127), BoxesRunTime.boxToInteger((int)Short.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), "-1.123", "-1.123", "5.10", "1234567891012345.1000000000", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "1969-01-01", "00:00:00.123", "1969-01-01T00:00:00.123456789", "1969-01-01T00:00:00.123456789Z", "[1, 2, 3]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "2.3"})), "{k1=1}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)-128), BoxesRunTime.boxToInteger((int)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), "3.4", "3.4", "6.10", "61234567891012345.1000000000", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)12), "1970-09-30", "01:01:01.123", "1970-09-30T01:01:01.123456", "1970-09-30T01:01:01.123456Z", "[4, 5]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "b", "4.56"})), "{k2=2, k4=4}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), "0.12", "0.12", "7.10", "71234567891012345.1000000000", BoxesRunTime.boxToInteger((int)123), BoxesRunTime.boxToInteger((int)123), "1990-12-24", "08:10:24.123", "1990-12-24T08:10:24.123", "1990-12-24T08:10:24.123Z", "[6, null, 7]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "7.86"})), "{k3=null}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)123), BoxesRunTime.boxToInteger((int)1234), "1.2345", "1.2345", "8.12", "812345678910123451.0123456789", BoxesRunTime.boxToInteger((int)1234), BoxesRunTime.boxToInteger((int)1234), "2020-05-01", "23:23:23", "2020-05-01T23:23:23", "2020-05-01T23:23:23Z", "[8]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "c", null})), "{null=3}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSourceProvider() {
        File file = BatchAbstractTestBase.createTempFile();
        file.delete();
        file.createNewFile();
        FileUtils.writeFileUtf8((File)file, (String)"1\n5\n6");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(171).append("\n         |CREATE TABLE MyFileSourceTable (\n         |  `a` STRING\n         |) WITH (\n         |  'connector' = 'test-file',\n         |  'path' = '").append(file.toURI()).append("'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT a FROM MyFileSourceTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"5"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"6"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableHint() {
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n                       |CREATE TABLE MySink (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'filesystem',\n                       |  'format' = 'testcsv',\n                       |  'path' = '").append(resultPath).append("'\n                       |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n                           |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n                           |")).stripMargin());
        stmtSet.execute().await();
        Seq result = (Seq)TableTestUtil$.MODULE$.readFromFile(resultPath).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
    }

    @Test
    public void testTableHintWithLogicalTableScanReuse() {
        this.tEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n                       |CREATE TABLE MySink (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'filesystem',\n                       |  'format' = 'testcsv',\n                       |  'path' = '").append(resultPath).append("'\n                       |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='0') */\n        |union all\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n                           |")).stripMargin());
        stmtSet.execute().await();
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "2,2,Hello", "3,2,Hello world", "3,2,Hello world", "3,2,Hello world"}));
        Assertions.assertThat((Object)expected.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(result.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleNestedFilter() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id, deepNested.nested1.name AS nestedName FROM NestedTable\n        |   WHERE nested.`value` > 20000\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedFilterOnArray() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |   deepNested.nested1.name AS nestedName,\n        |   nestedItem.deepArray[2].`value` FROM NestedTable\n        |WHERE nestedItem.deepArray[2].`value` > 1\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Sarah", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Rob", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike", BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedFilterOnMap() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |   deepNested.nested1.name AS nestedName,\n        |   nestedItem.deepMap['Monday'] FROM NestedTable\n        |WHERE nestedItem.deepMap['Monday'] = 1\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Sarah", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Rob", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike", BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }
}

