/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001'\tYQK\\5p]&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%A\u0003usB,g'F\u0001#!\r\u0019s%K\u0007\u0002I)\u0011QEJ\u0001\nif\u0004X-\u001e;jYNT!a\u0002\u0006\n\u0005!\"#\u0001E%oi\u0016\u0014h.\u00197UsB,\u0017J\u001c4p!\tQS&D\u0001,\u0015\ta#\"\u0001\u0003eCR\f\u0017B\u0001\u0018,\u0005\u001d\u0011vn\u001e#bi\u0006Da\u0001\r\u0001!\u0002\u0013\u0011\u0013A\u0002;za\u00164\u0004\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\u0002\u000b\u0011\fG/\u0019\u001c\u0016\u0003Q\u00022!\u000e\u001e=\u001b\u00051$BA\u001c9\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002s\u0005)1oY1mC&\u00111H\u000e\u0002\u0004'\u0016\f\bCA\u001fA\u001b\u0005q$BA ,\u0003\u0019\u0011\u0017N\\1ss&\u0011\u0011I\u0010\u0002\u000e\u0005&t\u0017M]=S_^$\u0015\r^1\t\r\r\u0003\u0001\u0015!\u00035\u0003\u0019!\u0017\r^17A!)Q\t\u0001C!\r\u00061!-\u001a4pe\u0016$\u0012a\u0012\t\u0003\u0011&k\u0011\u0001O\u0005\u0003\u0015b\u0012A!\u00168ji\"\u0012A\t\u0014\t\u0003\u001bRk\u0011A\u0014\u0006\u0003\u001fB\u000b1!\u00199j\u0015\t\t&+A\u0004kkBLG/\u001a:\u000b\u0005M\u0003\u0012!\u00026v]&$\u0018BA+O\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006/\u0002!\tAR\u0001\u001ei\u0016\u001cH/\u00168j_:<\u0016\u000e\u001e5ES\u001a4WM]3oiJ{w\u000f^=qK\"\u0012a+\u0017\t\u0003\u001bjK!a\u0017(\u0003\tQ+7\u000f\u001e\u0005\u0006;\u0002!\tAR\u0001\ri\u0016\u001cH/\u00168j_:\fE\u000e\u001c\u0015\u00039fCQ\u0001\u0019\u0001\u0005\u0002\u0019\u000b\u0011\u0002^3tiVs\u0017n\u001c8)\u0005}K\u0006\"B2\u0001\t\u00031\u0015a\u0005;fgR,f.[8o/&$\bNR5mi\u0016\u0014\bF\u00012Z\u0011\u00151\u0007\u0001\"\u0001G\u0003a!Xm\u001d;V]&|gnV5uQ\u0006;wM]3hCRLwN\u001c\u0015\u0003KfCQ!\u001b\u0001\u0005\u0002\u0019\u000b!\u0005^3ti*{\u0017N\\!gi\u0016\u0014H)\u001b4gKJ,g\u000e\u001e+za\u0016,f.[8o\u00032d\u0007F\u00015Z\u0011\u0015a\u0007\u0001\"\u0001G\u0003Y!Xm\u001d;V]&|gn\u00144Nk2$\u0018.\u00138qkR\u001c\bFA6Z\u0001")
public class UnionITCase
extends BatchTestBase {
    private final InternalTypeInfo<RowData> type6 = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BigIntType(), VarCharType.STRING_TYPE});
    private final Seq<BinaryRowData> data6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryRowData[]{BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), StringData.fromString((String)"Hi")})), BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), StringData.fromString((String)"Hello")})), BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), StringData.fromString((String)"Hello world")})), BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)3L), StringData.fromString((String)"Hello world, how are you?")}))}));

    public InternalTypeInfo<RowData> type6() {
        return this.type6;
    }

    public Seq<BinaryRowData> data6() {
        return this.data6;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("Table3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
        this.registerCollection("Table5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
        this.registerCollection("Table6", this.data6(), this.type6(), "a, b, c", new boolean[]{false, false, false});
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
    }

    @Test
    public void testUnionWithDifferentRowtype() {
        this.checkResult("SELECT a FROM (SELECT * FROM Table3 t1 UNION ALL (SELECT * FROM Table6 t2))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnionAll() {
        this.checkResult("SELECT t1.c FROM Table3 t1 UNION ALL (SELECT t2.c FROM Table3 t2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnion() {
        this.checkResult("SELECT t1.c FROM Table3 t1 UNION (SELECT t2.c FROM Table3 t2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnionWithFilter() {
        this.checkResult("SELECT c FROM (SELECT * FROM Table3 UNION ALL (SELECT d, e, g FROM Table5))WHERE b < 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnionWithAggregation() {
        this.checkResult("SELECT count(c) FROM (SELECT * FROM Table3 UNION ALL (SELECT d, e, g FROM Table5))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinAfterDifferentTypeUnionAll() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L)).set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, NestedLoopJoin");
        this.checkResult("SELECT a, c, g FROM (SELECT t1.a, t1.b, t1.c FROM Table3 t1 UNION ALL(SELECT a, b, c FROM Table3 ORDER BY a, b, c)), Table5 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnionOfMultiInputs() {
        this.checkResult("select max(v) as x, min(v) as n from \n(values cast(-86.4 as double), cast(-100 as double), cast(2 as double)) as t(v)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToDouble((double)-100.0)}))}))), this.checkResult$default$3());
    }
}

