/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple1;
import scala.Tuple1$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\teh!B\u0001\u0003\u0003\u0003)\"aE!hOJ,w-\u0019;f\u0013R\u001b\u0015m]3CCN,'BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003cCR\u001c\u0007N\u0003\u0002\n\u0015\u00059!/\u001e8uS6,'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011\u0004C\u0001\u0006kRLGn]\u0005\u00037a\u0011QBQ1uG\"$Vm\u001d;CCN,\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0011Q,7\u000f\u001e(b[\u0016\u0004\"a\b\u0015\u000f\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0015\u0003\u0019a$o\\8u})\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9C\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0003]A\u0002\"a\f\u0001\u000e\u0003\tAQ!H\u0016A\u0002yAQA\r\u0001\u0007\u0002M\nA\u0002\u001d:fa\u0006\u0014X-Q4h\u001fB$\u0012\u0001\u000e\t\u0003kYj\u0011\u0001J\u0005\u0003o\u0011\u0012A!\u00168ji\")\u0011\b\u0001C!g\u00051!-\u001a4pe\u0016D#\u0001O\u001e\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014aA1qS*\u0011\u0001)Q\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011%#A\u0003kk:LG/\u0003\u0002E{\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b\u0019\u0003A\u0011A\u001a\u0002'Q,7\u000f\u001e+za\u0016$wI]8va\nK8*Z=)\u0005\u0015C\u0005C\u0001\u001fJ\u0013\tQUH\u0001\u0003UKN$\b\"\u0002'\u0001\t\u0003\u0019\u0014a\u0003;fgR\u0014\u0015n\u001a#bi\u0006D#a\u0013%\t\u000b=\u0003A\u0011A\u001a\u0002\u001fQ,7\u000f^$s_V\u0004()_(oYfD#A\u0014%\t\u000bI\u0003A\u0011A\u001a\u0002QQ,7\u000f^*j[BdW-\u00118e\t&\u001cH/\u001b8di\u0006;wmV5uQ\u000e{W.\\8o\r&dG/\u001a:)\u0005EC\u0005\"B+\u0001\t\u0003\u0019\u0014\u0001\u0007;fgR$vo\u001c)iCN,7/Q4he\u0016<\u0017\r^5p]\"\u0012A\u000b\u0013\u0005\u00061\u0002!\taM\u0001\u0015i\u0016\u001cH\u000f\u00155bg\u0016\fum\u001a:fO\u0006$\u0018n\u001c8)\u0005]C\u0005\"B.\u0001\t\u0003\u0019\u0014!\u0007;fgR,U\u000e\u001d;z\u0013:\u0004X\u000f^!hOJ,w-\u0019;j_:D#A\u0017%\t\u000by\u0003A\u0011A\u001a\u00027Q,7\u000f\u001e(vY2<%o\\;q\u0017\u0016L\u0018iZ4sK\u001e\fG/[8oQ\ti\u0006\nC\u0003b\u0001\u0011\u00051'A\u000fuKN$\u0018iZ4sK\u001e\fG/[8o/&$\bn\\;u\u000fJ|W\u000f\u001d2zQ\t\u0001\u0007\nC\u0003e\u0001\u0011\u00051'A\u0014uKN$X)\u001c9us&s\u0007/\u001e;BO\u001e\u0014XmZ1uS>tw+\u001b;i_V$xI]8va\nL\bFA2I\u0011\u00159\u0007\u0001\"\u00014\u0003y!Xm\u001d;BO\u001e\u0014XmZ1uS>t\u0017I\u001a;feB\u0013xN[3di&|g\u000e\u000b\u0002g\u0011\")!\u000e\u0001C\u0001g\u0005iB/Z:u\u0003\u001e<'/Z4bi&|gnV5uQ\u0006\u0013\u0018\u000e\u001e5nKRL7\r\u000b\u0002j\u0011\")Q\u000e\u0001C\u0001g\u0005aB/Z:u\u000fJ|W\u000f]3e\t&\u001cH/\u001b8di\u0006;wM]3hCR,\u0007F\u00017I\u0011\u0015\u0001\b\u0001\"\u00014\u0003U!Xm\u001d;ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016D#a\u001c%\t\u000bM\u0004A\u0011A\u001a\u0002\rQ,7\u000f^+WQ\t\u0011\b\nC\u0004w\u0001\u0001\u0007I\u0011B<\u0002\u00159,w\u000fV1cY\u0016LE-F\u0001y!\t)\u00140\u0003\u0002{I\t\u0019\u0011J\u001c;\t\u000fq\u0004\u0001\u0019!C\u0005{\u0006qa.Z<UC\ndW-\u00133`I\u0015\fHC\u0001\u001b\u007f\u0011\u001dy80!AA\u0002a\f1\u0001\u001f\u00132\u0011\u001d\t\u0019\u0001\u0001Q!\na\f1B\\3x)\u0006\u0014G.Z%eA!9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011AC2iK\u000e\\\u0017+^3ssV!\u00111BA\u0015))\ti!a\u000f\u0002R\u0005U\u00131\r\u000b\u0004i\u0005=\u0001BCA\t\u0003\u000b\t\t\u0011q\u0001\u0002\u0014\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005U\u0011\u0011EA\u0013\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u0003;za\u0016LgNZ8\u000b\t\u0005u\u0011qD\u0001\u0007G>lWn\u001c8\u000b\u0005yr\u0011\u0002BA\u0012\u0003/\u0011q\u0002V=qK&sgm\u001c:nCRLwN\u001c\t\u0005\u0003O\tI\u0003\u0004\u0001\u0005\u0011\u0005-\u0012Q\u0001b\u0001\u0003[\u0011\u0011\u0001V\t\u0005\u0003_\t)\u0004E\u00026\u0003cI1!a\r%\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!NA\u001c\u0013\r\tI\u0004\n\u0002\b!J|G-^2u\u0011!\ti$!\u0002A\u0002\u0005}\u0012!\u0003;bE2,G)\u0019;b!\u0019\t\t%a\u0013\u0002&9!\u00111IA$\u001d\r\t\u0013QI\u0005\u0002K%\u0019\u0011\u0011\n\u0013\u0002\u000fA\f7m[1hK&!\u0011QJA(\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0013\"\u0003bBA*\u0003\u000b\u0001\rAH\u0001\tgFd\u0017+^3ss\"A\u0011qKA\u0003\u0001\u0004\tI&\u0001\u0005fqB,7\r^3ea\u0011\tY&a\u0018\u0011\r\u0005\u0005\u00131JA/!\u0011\t9#a\u0018\u0005\u0019\u0005\u0005\u0014QKA\u0001\u0002\u0003\u0015\t!!\f\u0003\u0007}#\u0013\u0007C\u0005\u0002f\u0005\u0015\u0001\u0013!a\u0001=\u0005IA/\u00192mK:\u000bW.\u001a\u0005\b\u0003S\u0002A\u0011AA6\u0003\r\u0011\u0017n\u001a\u000b\u0005\u0003[\ni\b\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\t5\fG\u000f\u001b\u0006\u0003\u0003o\nAA[1wC&!\u00111PA9\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\u001c\u0005\b\u0003\u007f\n9\u00071\u0001y\u0003\u0005I\u0007bBA5\u0001\u0011\u0005\u00111\u0011\u000b\u0005\u0003[\n)\tC\u0004\u0002\b\u0006\u0005\u0005\u0019\u0001\u0010\u0002\u0003MDA\"a#\u0001!\u0003\u0005\u0019\u0011)A\u0005\u0003\u001b\u000b1\u0001\u001f\u00133!%)\u0014qRA7\u0003[\ni'C\u0002\u0002\u0012\u0012\u0012a\u0001V;qY\u0016\u001c\u0004\"CAK\u0001\t\u0007I\u0011AAL\u0003\t\u0011\u0017'\u0006\u0002\u0002n!A\u00111\u0014\u0001!\u0002\u0013\ti'A\u0002cc\u0001B\u0011\"a(\u0001\u0005\u0004%\t!a&\u0002\u0005\t\u0014\u0004\u0002CAR\u0001\u0001\u0006I!!\u001c\u0002\u0007\t\u0014\u0004\u0005C\u0005\u0002(\u0002\u0011\r\u0011\"\u0001\u0002\u0018\u0006\u0011!m\r\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002n\u0005\u0019!m\r\u0011\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\u0006!!-[4Y)\u0011\ti'a-\t\u000f\u0005}\u0014Q\u0016a\u0001q\"a\u0011q\u0017\u0001\u0011\u0002\u0003\r\t\u0015!\u0003\u0002\u000e\u0006\u0019\u0001\u0010J\u001a\t\u0013\u0005m\u0006A1A\u0005\u0002\u0005]\u0015a\u000122q\"A\u0011q\u0018\u0001!\u0002\u0013\ti'\u0001\u0003cca\u0004\u0003\"CAb\u0001\t\u0007I\u0011AAL\u0003\r\u0011'\u0007\u001f\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002n\u0005!!M\r=!\u0011%\tY\r\u0001b\u0001\n\u0003\t9*A\u0002cgaD\u0001\"a4\u0001A\u0003%\u0011QN\u0001\u0005ENB\b\u0005C\u0005\u0002T\u0002\u0011\r\u0011\"\u0001\u0002\u0018\u0006\u0011!M\u0014\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002n\u0005\u0019!M\u0014\u0011\t\r\u0005m\u0007\u0001\"\u00014\u0003-!Xm\u001d;He>,\bOQ=)\u0007\u0005e\u0007\n\u0003\u0004\u0002b\u0002!\taM\u0001\u001di\u0016\u001cHoQ8v]R\u001c\u0015M\u001c8pi\nKX*\u001e7uS\u001aKW\r\u001c3tQ\r\ty\u000e\u0013\u0005\u0007\u0003O\u0004A\u0011A\u001a\u0002\u001dQ,7\u000f^*qCJ\\\u0017gN\u00193i!\u001a\u0011Q\u001d%\t\r\u00055\b\u0001\"\u00014\u0003E!Xm\u001d;He>,\bOQ=SK\u001e,\u0007\u0010\u001d\u0015\u0004\u0003WD\u0005BBAz\u0001\u0011\u00051'\u0001\u0006uKN$(k\u001c7mkBD3!!=I\u0011\u0019\tI\u0010\u0001C\u0001g\u0005AA/Z:u\u0007V\u0014W\rK\u0002\u0002x\"Ca!a@\u0001\t\u0003\u0019\u0014\u0001\u0004;fgR<%o\\;qS:<\u0007fAA\u007f\u0011\"1!Q\u0001\u0001\u0005\u0002M\n\u0001\u0005^3ti\u001e\u0013x.\u001e9j]\u001eLen]5eK^Kg\u000eZ8x\rVt7\r^5p]\"\u001a!1\u0001%\t\r\t-\u0001\u0001\"\u00014\u0003q!Xm\u001d;S_2dW\u000f](wKJd\u0017\r\u001d9j]\u001e\u001cu\u000e\\;n]ND3A!\u0003I\u0011\u0019\u0011\t\u0002\u0001C\u0001g\u0005QB/Z:u\u0007V\u0014Wm\u0014<fe2\f\u0007\u000f]5oO\u000e{G.^7og\"\u001a!q\u0002%\t\r\t]\u0001\u0001\"\u00014\u0003Q!Xm\u001d;BO\u001e<\u0016\u000e\u001e5pkR<%o\\;qg\"\u001a!Q\u0003%\t\r\tu\u0001\u0001\"\u00014\u0003\u0001\"Xm\u001d;BO\u001e<\u0016\u000e\u001e5pkR<%o\\;qg\u0006sGMR;oGRLwN\\:)\u0007\tm\u0001\n\u0003\u0004\u0003$\u0001!\taM\u0001\fi\u0016\u001cH/\u0011<fe\u0006<W\rK\u0002\u0003\"!CaA!\u000b\u0001\t\u0003\u0019\u0014a\u0006;fgR\fe/\u001a:bO\u0016<\u0016\u000e\u001e5ESN$\u0018N\\2uQ\r\u00119\u0003\u0013\u0005\u0007\u0005_\u0001A\u0011A\u001a\u0002\u001fQ,7\u000f\u001e(vY2\fe/\u001a:bO\u0016D3A!\fI\u0011\u0019\u0011)\u0004\u0001C\u0001g\u0005YB/Z:u\u001dVdG.\u0011<fe\u0006<WmV5uQ\u0012K7\u000f^5oGRD3Aa\rI\u0011\u0019\u0011Y\u0004\u0001C\u0001g\u0005YA/Z:u5\u0016\u0014x.\u0011<hQ\r\u0011I\u0004\u0013\u0005\u0007\u0005\u0003\u0002A\u0011A\u001a\u0002/Q,7\u000f\u001e.fe>\feoZ,ji\"$\u0015n\u001d;j]\u000e$\bf\u0001B \u0011\"1!q\t\u0001\u0005\u0002M\n\u0011\u0002^3ti\u000e{WO\u001c;)\u0007\t\u0015\u0003\n\u0003\u0004\u0003N\u0001!\taM\u0001\u000ei\u0016\u001cHOT;mY\u000e{WO\u001c;)\u0007\t-\u0003\n\u0003\u0004\u0003T\u0001!\taM\u0001\u001ai\u0016\u001cHOT;mY\u000e{WO\u001c;XSRDG)[:uS:\u001cG\u000fK\u0002\u0003R!CaA!\u0017\u0001\t\u0003\u0019\u0014a\b;fgRlU\u000f\u001c;ja2,7i\u001c7v[:$\u0015n\u001d;j]\u000e$8i\\;oi\"\u001a!q\u000b%\t\r\t}\u0003\u0001\"\u00014\u00035!Xm\u001d;[KJ|7i\\;oi\"\u001a!Q\f%\t\r\t\u0015\u0004\u0001\"\u00014\u0003)!Xm\u001d;Ti\u0012$UM\u001e\u0015\u0004\u0005GB\u0005B\u0002B6\u0001\u0011\u00051'\u0001\buKN$\u0018GU8x'R$G)\u001a<)\u0007\t%\u0004\n\u0003\u0004\u0003r\u0001!\taM\u0001\ri\u0016\u001cHOV1sS\u0006t7-\u001a\u0015\u0004\u0005_B\u0005B\u0002B<\u0001\u0011\u00051'\u0001\tuKN$\u0018GU8x-\u0006\u0014\u0018.\u00198dK\"\u001a!Q\u000f%\t\r\tu\u0004\u0001\"\u00014\u00039!Xm\u001d;[KJ|7\u000b\u001e3EKZD3Aa\u001fI\u0011\u0019\u0011\u0019\t\u0001C\u0001g\u0005YA/Z:u5\u0016\u0014xnU;nQ\r\u0011\t\t\u0013\u0005\u0007\u0005\u0013\u0003A\u0011A\u001a\u0002'Q,7\u000f\u001e.fe>\u001cV/\u001c#jgRLgn\u0019;)\u0007\t\u001d\u0005\n\u0003\u0004\u0003\u0010\u0002!\taM\u0001\fi\u0016\u001cH/T8nK:$8\u000fK\u0002\u0003\u000e\"CaA!&\u0001\t\u0003\u0019\u0014a\u0004;fgRTVM]8N_6,g\u000e^:)\u0007\tM\u0005\n\u0003\u0004\u0003\u001c\u0002!\taM\u0001\u0010i\u0016\u001cHOT;mY6{W.\u001a8ug\"\u001a!\u0011\u0014%\t\r\t\u0005\u0006\u0001\"\u00014\u0003m!Xm\u001d;EK\u000eLW.\u00197Tk6\feoZ(wKJ<\u0016N\u001c3po\"\u001a!q\u0014%\t\r\t\u001d\u0006\u0001\"\u00014\u00031!Xm\u001d;EK\u000eLW.\u00197tQ\r\u0011)\u000b\u0013\u0005\u0007\u0005[\u0003A\u0011A\u001a\u0002!Q,7\u000f\u001e'j[&$\b\u000b\\;t\u0003\u001e<\u0007f\u0001BV\u0011\"1!1\u0017\u0001\u0005\u0002M\n!\u0003^3ti\u001e\u0013x.\u001e9Cs2KG/\u001a:bY\"\u001a!\u0011\u0017%\t\r\te\u0006\u0001\"\u00014\u0003-!Xm\u001d;MK\u0006$G*Y4)\u0007\t]\u0006\n\u0003\u0004\u0003@\u0002!\taM\u0001\u0015i\u0016\u001cHo\u0012:pkB\u0014\u00150\u0011:sCf$\u0016\u0010]3)\u0007\tu\u0006\n\u0003\u0004\u0003F\u0002!\taM\u0001\u0016i\u0016\u001cH\u000fR5ti&t7\r^!se\u0006LH+\u001f9fQ\r\u0011\u0019\r\u0013\u0005\u0007\u0005\u0017\u0004A\u0011A\u001a\u00025Q,7\u000f^\"pk:$H)[:uS:\u001cG/\u0011:sCf$\u0016\u0010]3)\u0007\t%\u0007\n\u0003\u0004\u0003R\u0002!\taM\u0001\u000ei\u0016\u001cHoQ8v]R\u001cF/\u0019:)\u0007\t=\u0007\n\u0003\u0004\u0003X\u0002!\taM\u0001\u0014i\u0016\u001cH\u000fT3bI\u0006;wMR;oGRLwN\u001c\u0015\u0004\u0005+D\u0005\"\u0003Bo\u0001E\u0005I\u0011\u0001Bp\u0003Q\u0019\u0007.Z2l#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU!!\u0011\u001dB|+\t\u0011\u0019OK\u0002\u001f\u0005K\\#Aa:\u0011\t\t%(1_\u0007\u0003\u0005WTAA!<\u0003p\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005c$\u0013AC1o]>$\u0018\r^5p]&!!Q\u001fBv\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\t\u0003W\u0011YN1\u0001\u0002.\u0001")
public abstract class AggregateITCaseBase
extends BatchTestBase {
    private int newTableId = 0;
    private final /* synthetic */ Tuple3 x$2;
    private final BigDecimal b1;
    private final BigDecimal b2;
    private final BigDecimal b3;
    private final /* synthetic */ Tuple3 x$3;
    private final BigDecimal b1x;
    private final BigDecimal b2x;
    private final BigDecimal b3x;
    private final BigDecimal bN;

    public abstract void prepareAggOp();

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("SmallTable3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        this.registerCollection("Table5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
        this.registerCollection("EmptyTable5", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (TypeInformation<Row>)TestData$.MODULE$.type5(), "d, e, f, g, h");
        this.registerCollection("NullTable3", TestData$.MODULE$.nullData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfNullData3());
        this.registerCollection("AllNullTable3", TestData$.MODULE$.allNullData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.allNullablesOfNullData3());
        this.registerCollection("NullTable5", TestData$.MODULE$.nullData5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfNullData5());
        this.registerCollection("DuplicateTable5", TestData$.MODULE$.duplicateData5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfDuplicateData5());
        this.registerCollection("GenericTypedTable3", TestData$.MODULE$.genericData3(), TestData$.MODULE$.genericType3(), "i, j, k", TestData$.MODULE$.nullablesOfData3());
        this.prepareAggOp();
    }

    @Test
    public void testTypedGroupByKey() {
        this.checkResult("SELECT j, sum(k) FROM GenericTypedTable3 GROUP BY i, j", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1)})), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
        this.checkResult("SELECT k, count(j) FROM GenericTypedTable3 GROUP BY i, k", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testBigData() {
        IndexedSeq largeData5 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1 & Serializable & scala.Serializable)i -> BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)10), "Hallo", BoxesRunTime.boxToLong((long)1L)})), IndexedSeq$.MODULE$.canBuildFrom());
        this.registerCollection("LargeTable5", (Iterable<Row>)largeData5, (TypeInformation<Row>)TestData$.MODULE$.type5(), "d, e, f, g, h");
        IndexedSeq expected = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1 & Serializable & scala.Serializable)i -> BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "Hallo", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToLong((long)1L)})), IndexedSeq$.MODULE$.canBuildFrom());
        this.checkResult("SELECT d, g, sum(e), avg(f), min(h) FROM LargeTable5 GROUP BY d, g", (Seq<Row>)expected, this.checkResult$default$3());
        IndexedSeq largeTypedData5 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1 & Serializable & scala.Serializable)i -> BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)10), "Hallo", BoxesRunTime.boxToLong((long)1L)})), IndexedSeq$.MODULE$.canBuildFrom());
        this.registerCollection("LargeTypedTable5", (Iterable<Row>)largeTypedData5, (TypeInformation<Row>)TestData$.MODULE$.genericType5(), "d, e, f, g, h");
        IndexedSeq expectedTypedData5 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1 & Serializable & scala.Serializable)i -> BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), "Hallo", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToLong((long)1L)})), IndexedSeq$.MODULE$.canBuildFrom());
        this.checkResult("SELECT d, g, sum(e), avg(f), min(h) FROM LargeTypedTable5 GROUP BY d, g", (Seq<Row>)expectedTypedData5, this.checkResult$default$3());
        IndexedSeq singleGrouplargeData5 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1 & Serializable & scala.Serializable)i -> BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)999), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)10), "Hallo", BoxesRunTime.boxToLong((long)1L)})), IndexedSeq$.MODULE$.canBuildFrom());
        this.registerCollection("SingleGroupLargeTable5", (Iterable<Row>)singleGrouplargeData5, (TypeInformation<Row>)TestData$.MODULE$.type5(), "d, e, f, g, h");
        this.checkResult("SELECT d, g, sum(e), avg(f), min(h) FROM SingleGroupLargeTable5 GROUP BY d, g", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)999), "Hallo", BoxesRunTime.boxToLong((long)100000L), BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToLong((long)1L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testGroupByOnly() {
        this.checkResult("SELECT h FROM Table5 GROUP BY h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSimpleAndDistinctAggWithCommonFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   h,\n        |   COUNT(1) FILTER(WHERE d > 1),\n        |   COUNT(1) FILTER(WHERE d < 2),\n        |   COUNT(DISTINCT e) FILTER(WHERE d > 1)\n        |FROM Table5\n        |GROUP BY h\n        |")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)7)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTwoPhasesAggregation() {
        this.checkResult("SELECT sum(d), avg(d), count(g), min(e), h FROM Table5 GROUP BY h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)26), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)6L), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPhaseAggregation() {
    }

    @Test
    public void testEmptyInputAggregation() {
        this.checkResult("SELECT sum(d), avg(d), count(g), min(e) FROM EmptyTable5 GROUP BY h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testNullGroupKeyAggregation() {
        this.checkResult("SELECT sum(d), d, count(d) FROM NullTable5 GROUP BY d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)25), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAggregationWithoutGroupby() {
        this.checkResult("SELECT sum(d), avg(d), count(g), min(e) FROM Table5", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)55), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToLong((long)1L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testEmptyInputAggregationWithoutGroupby() {
        this.checkResult("SELECT sum(d), avg(d), count(g), min(e) FROM EmptyTable5", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)0), null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAggregationAfterProjection() {
        this.checkResult("SELECT c, count(a) FROM (SELECT d as a, f as b, h as c FROM Table5) GROUP BY c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)7)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAggregationWithArithmetic() {
        this.checkResult("SELECT avg(d + 2) + 2 FROM Table5", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testGroupedDistinctAggregate() {
        this.checkResult("SELECT count(distinct g), h FROM DuplicateTable5 GROUP BY h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testDistinctAggregate() {
        this.checkResult("SELECT count(distinct h) FROM DuplicateTable5", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUV() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "1", String.valueOf(BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)i) % 10))), "1"})), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        RowTypeInfo type4 = new RowTypeInfo(new TypeInformation[]{Types.STRING(), Types.STRING(), Types.STRING(), Types.STRING()});
        this.registerCollection("src", (Iterable<Row>)data, (TypeInformation<Row>)type4, "a, b, c, d");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  b,\n         |  COUNT(distinct c) as uv\n         |FROM (\n         |  SELECT\n         |    a, b, c, d\n         |  FROM\n         |    src where b <> ''\n         |  UNION ALL\n         |  SELECT\n         |    a, 'ALL' as b, c, d\n         |  FROM\n         |    src where b <> ''\n         |) t\n         |GROUP BY\n         |  a, b\n     ")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "1", BoxesRunTime.boxToInteger((int)10)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "ALL", BoxesRunTime.boxToInteger((int)10)}))}))), this.checkResult$default$3());
    }

    private int newTableId() {
        return this.newTableId;
    }

    private void newTableId_$eq(int x$1) {
        this.newTableId = x$1;
    }

    public <T extends Product> void checkQuery(Seq<T> tableData, String sqlQuery, Seq<? extends Product> expected, String tableName, TypeInformation<T> evidence$1) {
        RowTypeInfo rowTypeInfo;
        Function1 & Serializable & scala.Serializable toRow = (Function1 & Serializable & scala.Serializable)p -> Row.of((Object[])((Object[])p.productIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).toArray(ClassTag$.MODULE$.AnyRef())));
        Seq tableRows = (Seq)tableData.map((Function1)toRow, Seq$.MODULE$.canBuildFrom());
        TypeInformation tupleTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        if (tupleTypeInfo.isTupleType()) {
            rowTypeInfo = new RowTypeInfo(((TupleTypeInfoBase)tupleTypeInfo).getFieldTypes());
        } else {
            Collection fieldInfos = tupleTypeInfo.getGenericParameters().values();
            rowTypeInfo = new RowTypeInfo((TypeInformation[])((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(fieldInfos).asScala()).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
        }
        RowTypeInfo rowTypeInfo2 = rowTypeInfo;
        this.newTableId_$eq(this.newTableId() + 1);
        String tableName2 = new StringBuilder(10).append("TestTableX").append(this.newTableId()).toString();
        String fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowTypeInfo2.getFieldNames())).mkString(",");
        this.registerCollection(tableName2, (Iterable<Row>)tableRows, (TypeInformation<Row>)rowTypeInfo2, fields);
        String sqlQueryX = sqlQuery.replace("TableName", tableName2);
        this.checkResult(sqlQueryX, (Seq<Row>)((Seq)expected.map((Function1)toRow, Seq$.MODULE$.canBuildFrom())), this.checkResult$default$3());
    }

    public <T extends Product> String checkQuery$default$4() {
        return "t";
    }

    public BigDecimal big(int i) {
        return new BigDecimal(i);
    }

    public BigDecimal big(String s) {
        return new BigDecimal(s);
    }

    public BigDecimal b1() {
        return this.b1;
    }

    public BigDecimal b2() {
        return this.b2;
    }

    public BigDecimal b3() {
        return this.b3;
    }

    public BigDecimal bigX(int i) {
        return this.big(i).setScale(DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getScale());
    }

    public BigDecimal b1x() {
        return this.b1x;
    }

    public BigDecimal b2x() {
        return this.b2x;
    }

    public BigDecimal b3x() {
        return this.b3x;
    }

    public BigDecimal bN() {
        return this.bN;
    }

    @Test
    public void testGroupBy() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select f0, sum(f1) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 3), new Tuple2.mcII.sp(2, 3), new Tuple2.mcII.sp(3, 3)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$56 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$56 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select sum(totB) from (select f0, sum(f1) as totB from TableName group by f0)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcI.sp(9)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$57 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$57 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select f0, count(*) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcIJ.sp(1, 2L), new Tuple2.mcIJ.sp(2, 2L), new Tuple2.mcIJ.sp(3, 2L)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$58 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$58 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3))}))), "select f0, min(f1), min(f2) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)4))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$59 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$59 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.b2()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.b2()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2())}))), "select f0, sum(f1) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1x(), (Object)this.b3x()), new scala.Tuple2((Object)this.b2x(), (Object)this.b3x()), new scala.Tuple2((Object)this.b3x(), (Object)this.b3x())}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$60 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$60 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.bN()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.bN()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2()), new scala.Tuple2((Object)this.bN(), (Object)this.b2())}))), "select f0, sum(f1) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1x(), (Object)this.b1x()), new scala.Tuple2((Object)this.b2x(), (Object)this.b1x()), new scala.Tuple2((Object)this.b3x(), (Object)this.b3x()), new scala.Tuple2((Object)this.bN(), (Object)this.b2x())}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$61 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$61 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testCountCannotByMultiFields() {
        Assertions.assertThatThrownBy(() -> this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select count(distinct f0, f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$62 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$62 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).hasCauseInstanceOf(TableException.class);
    }

    @Test
    public void testSpark17124() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcJ.sp(0L), new Tuple1.mcJ.sp(1L)}))), "select f0, sum(f0), count(f0), min(f0) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)0L)), new Tuple4((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)1L))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$63 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$63 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testGroupByRegexp() {
        String expr = "regexp_extract(f0, '([a-z]+)\\[', 1)";
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)"some[thing]", (Object)"random-string")}))), new StringBuilder(42).append("select ").append(expr).append(", count(*) from TableName group by ").append(expr).toString(), (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)"some", (Object)BoxesRunTime.boxToLong((long)1L))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$64 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<String, String>> unused = new ScalaCaseClassSerializer<scala.Tuple2<String, String>>(this, fieldSerializers){

                    public scala.Tuple2<String, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$64 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testRollup() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)10000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)5000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0))}))), "select f0, f1, sum(f2) from TableName group by rollup(f0, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0)), new Tuple3((Object)"Java", null, (Object)BoxesRunTime.boxToDouble((double)50000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)15000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0)), new Tuple3((Object)"dotNET", null, (Object)BoxesRunTime.boxToDouble((double)63000.0)), new Tuple3(null, null, (Object)BoxesRunTime.boxToDouble((double)113000.0))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$65 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$65 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testCube() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)10000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)5000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0))}))), "select f0, f1, sum(f2) from TableName group by cube(f0, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0)), new Tuple3((Object)"Java", null, (Object)BoxesRunTime.boxToDouble((double)50000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)15000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0)), new Tuple3((Object)"dotNET", null, (Object)BoxesRunTime.boxToDouble((double)63000.0)), new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)35000.0)), new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)78000.0)), new Tuple3(null, null, (Object)BoxesRunTime.boxToDouble((double)113000.0))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$66 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$66 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testGrouping() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)10000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)5000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0))}))), "select f0, f1, grouping(f0), grouping(f1), grouping_id(f0,f1) from TableName group by cube(f0, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple5((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple5((Object)"Java", null, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple5((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple5((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple5((Object)"dotNET", null, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple5(null, (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple5(null, (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple5(null, null, (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$67 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$67 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testGroupingInsideWindowFunction() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)10000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)5000.0)), new Tuple3((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0)), new Tuple3((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0))}))), "select f0, f1, sum(f2), grouping_id(f0, f1), rank() over (partition by grouping_id(f0, f1) order by sum(f2)) from TableName group by cube(f0, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)20000.0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple5((Object)"Java", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)30000.0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple5((Object)"Java", null, (Object)BoxesRunTime.boxToDouble((double)50000.0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple5((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)15000.0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple5((Object)"dotNET", (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)48000.0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple5((Object)"dotNET", null, (Object)BoxesRunTime.boxToDouble((double)63000.0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple5(null, (Object)BoxesRunTime.boxToInteger((int)2012), (Object)BoxesRunTime.boxToDouble((double)35000.0), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple5(null, (Object)BoxesRunTime.boxToInteger((int)2013), (Object)BoxesRunTime.boxToDouble((double)78000.0), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple5(null, null, (Object)BoxesRunTime.boxToDouble((double)113000.0), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$68 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$68 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testRollupOverlappingColumns() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select f0+f1, f1, sum(f0-f1) from TableName group by rollup(f0+f1, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)-1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), null, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), null, (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), null, (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3(null, null, (Object)BoxesRunTime.boxToInteger((int)3))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$69 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$14[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$14(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$69 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select f0, f1, sum(f1) from TableName group by rollup(f0, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), null, (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), null, (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3(null, null, (Object)BoxesRunTime.boxToInteger((int)9))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$70 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$15[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$15(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$70 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testCubeOverlappingColumns() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select f0+f1, f1, sum(f0-f1) from TableName group by cube(f0+f1, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)-1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), null, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), null, (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), null, (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3(null, null, (Object)BoxesRunTime.boxToInteger((int)3))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$71 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$16[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$16(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$71 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select f0, f1, sum(f1) from TableName group by cube(f0, f1)", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), null, (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), null, (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple3(null, null, (Object)BoxesRunTime.boxToInteger((int)9))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$72 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$17[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$17(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$72 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testAggWithoutGroups() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select sum(f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcI.sp(9)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$73 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$18[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$18(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$73 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testAggWithoutGroupsAndFunctions() {
        Tuple1$ one = Tuple1$.MODULE$;
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select 1 from TableName", (Seq<? extends Product>)((Seq)List$.MODULE$.fill(6, (Function0 & Serializable & scala.Serializable)() -> new Tuple1.mcI.sp(1))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$74 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$19[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$19(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$74 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testAverage() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.int2Integer(1)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.int2Integer(2)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(1)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(3), (Object)Predef$.MODULE$.int2Integer(1)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(3), (Object)Predef$.MODULE$.int2Integer(2))}))), "select avg(f0), avg(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(2, 2)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$75 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$20[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$20(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$75 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.b2()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.b2()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2())}))), "select avg(f0), sum(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.bigX(2), (Object)this.bigX(12))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$76 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$21[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$21(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$76 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.b2()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.b2()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2())}))), "select avg(cast (f0 as decimal(10,2))) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1((Object)this.big("2.000000"))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$77 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$22[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$22(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$77 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testAverageWithDistinct() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.int2Integer(1)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.int2Integer(2)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(1)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(3), (Object)Predef$.MODULE$.int2Integer(1)), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(3), (Object)Predef$.MODULE$.int2Integer(2))}))), "select avg(f0), sum(distinct f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(2, 6)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$78 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$23[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$23(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$78 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.b2()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.b2()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2())}))), "select avg(f0), sum(distinct f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.bigX(2), (Object)this.bigX(6))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$79 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$24[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$24(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$79 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.b2()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.b2()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2())}))), "select avg(f0), sum(distinct cast (f0 as decimal(10,2))) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.bigX(2), (Object)this.big(6).setScale(2))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$80 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$25[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$25(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$80 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testNullAverage() {
        Seq testData3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), null), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.checkQuery((Seq)testData3, "select avg(f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcI.sp(2)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$81 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$26[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$26(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$81 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testNullAverageWithDistinct() {
        Seq testData3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), null), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.checkQuery((Seq)testData3, "select avg(f1), count(distinct f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcIJ.sp(2, 1L)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$82 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$27[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$27(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$82 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)testData3, "select avg(f1), sum(distinct f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(2, 2)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$83 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$28[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$28(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$83 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testZeroAvg() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "select avg(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1(null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$84 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$29[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$29(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$84 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testZeroAvgWithDistinct() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "select avg(f0), sum(distinct f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2(null, null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$85 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$30[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$30(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$85 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testCount() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select count(f0), sum(distinct f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcJI.sp(6L, 6)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$86 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$31[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$31(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$86 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testNullCount() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), null), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2))}))), "select f0, count(f1) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcIJ.sp(1, 0L), new Tuple2.mcIJ.sp(2, 1L)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$87 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$32[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$32(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$87 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), null), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2))}))), "select f0, count(f0+f1) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcIJ.sp(1, 0L), new Tuple2.mcIJ.sp(2, 1L)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$88 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$33[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$33(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$88 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testNullCountWithDistinct() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), null), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2))}))), "select count(f0), count(f1), count(1), count(distinct f0), count(distinct f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)1L))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$89 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$34[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$34(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$89 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(1), null), new scala.Tuple2((Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(2))}))), "select count(f1), count(distinct f1), sum(distinct f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)2))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Integer, Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$90 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$35[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Integer, Integer>>(this, fieldSerializers){

                    public scala.Tuple2<Integer, Integer> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((Integer)fields[0]), (Object)((Integer)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Integer, Integer>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$35(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$90 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testMultipleColumnDistinctCount() {
        Seq testData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"a", (Object)"b", (Object)"c"), new Tuple3((Object)"a", (Object)"b", (Object)"c"), new Tuple3((Object)"a", (Object)"b", (Object)"d"), new Tuple3((Object)"x", (Object)"y", (Object)"z"), new Tuple3((Object)"x", (Object)"q", null)}));
        Assertions.assertThatThrownBy(() -> this.checkQuery((Seq)testData, "select count(distinct f0, f1) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcJ.sp(3L)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$91 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$36[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$36(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$91 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).hasCauseInstanceOf(TableException.class);
        Assertions.assertThatThrownBy(() -> this.checkQuery((Seq)testData, "select count(distinct f0, f1, f2) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcJ.sp(4L)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$92 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$37[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$37(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$92 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).hasCauseInstanceOf(TableException.class);
        Assertions.assertThatThrownBy(() -> this.checkQuery((Seq)testData, "select f0, count(distinct f1, f2) from TableName group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)2L)), new scala.Tuple2((Object)"x", (Object)BoxesRunTime.boxToLong((long)2L))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$93 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$38[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$38(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$93 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).hasCauseInstanceOf(TableException.class);
    }

    @Test
    public void testZeroCount() {
        Seq emptyTable = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkQuery((Seq)emptyTable, "select count(f0), sum(distinct f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToLong((long)0L), null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$94 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$39[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$39(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$94 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testStdDev() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDI.sp(1.0, 1), new Tuple2.mcDI.sp(1.0, 2), new Tuple2.mcDI.sp(2.0, 1), new Tuple2.mcDI.sp(2.0, 2), new Tuple2.mcDI.sp(3.0, 1), new Tuple2.mcDI.sp(3.0, 2)}))), "select stddev_pop(f0), stddev_samp(f0), stddev(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(0.6666666666666666)), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(0.8)), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(0.8)))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$95 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$40[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$40(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$95 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void test1RowStdDev() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDI.sp(1.0, 1)}))), "select stddev_pop(f0), stddev_samp(f0), stddev(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), null, null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$96 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$41[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$41(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$96 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testVariance() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDI.sp(1.0, 1), new Tuple2.mcDI.sp(2.0, 1)}))), "select var_pop(f0), var_samp(f0), variance(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.25), (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)0.5))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$97 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$42[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$42(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$97 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void test1RowVariance() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDI.sp(1.0, 1)}))), "select var_pop(f0), var_samp(f0), variance(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), null, null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$98 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$43[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$43(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$98 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testZeroStdDev() {
        Seq emptyTable = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkQuery((Seq)emptyTable, "select stddev_pop(f0), stddev_samp(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2(null, null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$99 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$44[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$44(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$99 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testZeroSum() {
        Seq emptyTable = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkQuery((Seq)emptyTable, "select sum(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1(null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$100 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$45[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$45(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$100 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testZeroSumDistinct() {
        Seq emptyTable = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkQuery((Seq)emptyTable, "select sum(distinct f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1(null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$101 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$46[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$46(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$101 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testMoments() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDI.sp(1.0, 1), new Tuple2.mcDI.sp(1.0, 2), new Tuple2.mcDI.sp(2.0, 1), new Tuple2.mcDI.sp(2.0, 2), new Tuple2.mcDI.sp(3.0, 1), new Tuple2.mcDI.sp(3.0, 2)}))), "select var_pop(f0), var_samp(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDD.sp(0.6666666666666666, 0.8)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$102 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$47[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$47(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$102 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testZeroMoments() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcDD.sp(1.0, 2.0)}))), "select stddev_samp(f0), stddev_pop(f0), var_samp(f0), var_pop(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4(null, (Object)BoxesRunTime.boxToDouble((double)0.0), null, (Object)BoxesRunTime.boxToDouble((double)0.0))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$103 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$48[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$48(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$103 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testNullMoments() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "select stddev_samp(f0), stddev_pop(f0), var_samp(f0), var_pop(f0) from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4(null, null, null, null)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$104 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$49[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$49(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$104 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testDecimalSumAvgOverWindow() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcD.sp(1.0), new Tuple1.mcD.sp(2.0), new Tuple1.mcD.sp(3.0)}))), "select sum(f0) over () from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcD.sp(6.0), new Tuple1.mcD.sp(6.0), new Tuple1.mcD.sp(6.0)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$105 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$50[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcD.sp(BoxesRunTime.unboxToDouble((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$50(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$105 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcD.sp(1.0), new Tuple1.mcD.sp(2.0), new Tuple1.mcD.sp(3.0)}))), "select avg(f0) over () from TableName", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple1[]{new Tuple1.mcD.sp(2.0), new Tuple1.mcD.sp(2.0), new Tuple1.mcD.sp(2.0)}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$106 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$51[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcD.sp(BoxesRunTime.unboxToDouble((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$51(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$106 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testDecimals() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.b1(), (Object)this.b1()), new scala.Tuple2((Object)this.b1(), (Object)this.b2()), new scala.Tuple2((Object)this.b2(), (Object)this.b1()), new scala.Tuple2((Object)this.b2(), (Object)this.b2()), new scala.Tuple2((Object)this.b3(), (Object)this.b1()), new scala.Tuple2((Object)this.b3(), (Object)this.b2())}))), "select cast (f0 as decimal(10,2)), avg(cast (f1 as decimal(10,2)))  from TableName group by cast (f0 as decimal(10,2))", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)this.big("1.00"), (Object)this.big("1.500000")), new scala.Tuple2((Object)this.big("2.00"), (Object)this.big("1.500000")), new scala.Tuple2((Object)this.big("3.00"), (Object)this.big("1.500000"))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<BigDecimal, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$107 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$52[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>> unused = new ScalaCaseClassSerializer<scala.Tuple2<BigDecimal, BigDecimal>>(this, fieldSerializers){

                    public scala.Tuple2<BigDecimal, BigDecimal> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<BigDecimal, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$52(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$107 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLimitPlusAgg() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new scala.Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new scala.Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1)), new scala.Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)5))}))), "select f0, count(*) from (select * from TableName limit 2) group by f0", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)), new scala.Tuple2((Object)"b", (Object)BoxesRunTime.boxToLong((long)1L))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$108 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$53[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<String, Object>>(this, fieldSerializers){

                    public scala.Tuple2<String, Object> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$53(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$108 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testGroupByLiteral() {
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "select 3, 4, sum(f1) from TableName group by 1, 2", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)9))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$109 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$54[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$54(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$109 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.checkQuery((Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2), new Tuple2.mcII.sp(3, 1), new Tuple2.mcII.sp(3, 2)}))), "SELECT 3, 4, SUM(f1) from TableName GROUP BY 3, 4", (Seq<? extends Product>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)9))}))), this.checkQuery$default$4(), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$110 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$55[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$55(org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase$$anon$110 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLeadLag() {
        this.tEnv().getConfig().set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Default);
        this.tEnv().getConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        Table testAllDataTypeCardinality = this.tEnv().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"c", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"d", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"e", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"g", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"h", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"i", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"j", (DataType)DataTypes.CHAR((int)20)), DataTypes.FIELD((String)"k", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"l", (DataType)DataTypes.TIME()), DataTypes.FIELD((String)"m", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"n", (DataType)DataTypes.DECIMAL((int)3, (int)2))}), new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Alice", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)9223), BoxesRunTime.boxToFloat((float)-2.3f), BoxesRunTime.boxToDouble((double)9.9), "true", "varchar", "char", "2021-8-3", "20:8:17", "2021-8-3 20:8:29", BoxesRunTime.boxToDouble((double)9.99)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Alice", null, null, null, null, null, null, null, null, null, null, null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Alice", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)9223), BoxesRunTime.boxToFloat((float)-2.3f), BoxesRunTime.boxToDouble((double)9.9), "true", "varchar", "char", "2021-8-3", "20:8:17", "2021-8-3 20:8:29", BoxesRunTime.boxToDouble((double)9.99)}))});
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1299).append("\n         |SELECT\n         |  a,\n         |  b, LEAD(b, 1) over (order by a)  AS bLead, LAG(b, 1) over (order by a)  AS bLag,\n         |  c, LEAD(c, 1) over (order by a)  AS cLead, LAG(c, 1) over (order by a)  AS cLag,\n         |  d, LEAD(d, 1) over (order by a)  AS dLead, LAG(d, 1) over (order by a)  AS dLag,\n         |  e, LEAD(e, 1) over (order by a)  AS eLead, LAG(e, 1) over (order by a)  AS eLag,\n         |  f, LEAD(f, 1) over (order by a)  AS fLead, LAG(f, 1) over (order by a)  AS fLag,\n         |  g, LEAD(g, 1) over (order by a)  AS gLead, LAG(g, 1) over (order by a)  AS gLag,\n         |  h, LEAD(h, 1) over (order by a)  AS hLead, LAG(h, 1) over (order by a)  AS hLag,\n         |  i, LEAD(i, 1) over (order by a)  AS iLead, LAG(i, 1) over (order by a)  AS iLag,\n         |  j, LEAD(j, 1) over (order by a)  AS jLead, LAG(j, 1) over (order by a)  AS jLag,\n         |  k, LEAD(k, 1) over (order by a)  AS kLead, LAG(k, 1) over (order by a)  AS kLag,\n         |  l, LEAD(l, 1) over (order by a)  AS lLead, LAG(l, 1) over (order by a)  AS lLag,\n         |  m, LEAD(m, 1) over (order by a)  AS mLead, LAG(m, 1) over (order by a)  AS mLag,\n         |  n, LEAD(n, 1) over (order by a)  AS nLead, LAG(n, 1) over (order by a)  AS nLag\n         |\n         |FROM ").append(testAllDataTypeCardinality).append("\n         |order by a\n         |").toString())).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Alice", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)9223), BoxesRunTime.boxToInteger((int)9223), null, BoxesRunTime.boxToDouble((double)-2.3), BoxesRunTime.boxToDouble((double)-2.3), null, BoxesRunTime.boxToDouble((double)9.9), BoxesRunTime.boxToDouble((double)9.9), null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true), null, "varchar", "varchar", null, "char                ", "char                ", null, "2021-08-03", "2021-08-03", null, "20:08:17", "20:08:17", null, "2021-08-03T20:08:29", "2021-08-03T20:08:29", null, BoxesRunTime.boxToDouble((double)9.99), BoxesRunTime.boxToDouble((double)9.99), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Alice", BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)9223), null, BoxesRunTime.boxToInteger((int)9223), BoxesRunTime.boxToDouble((double)-2.3), null, BoxesRunTime.boxToDouble((double)-2.3), BoxesRunTime.boxToDouble((double)9.9), null, BoxesRunTime.boxToDouble((double)9.9), BoxesRunTime.boxToBoolean((boolean)true), null, BoxesRunTime.boxToBoolean((boolean)true), "varchar", null, "varchar", "char                ", null, "char                ", "2021-08-03", null, "2021-08-03", "20:08:17", null, "20:08:17", "2021-08-03T20:08:29", null, "2021-08-03T20:08:29", BoxesRunTime.boxToDouble((double)9.99), null, BoxesRunTime.boxToDouble((double)9.99)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Alice", null, null, BoxesRunTime.boxToInteger((int)1), null, null, BoxesRunTime.boxToInteger((int)1), null, null, BoxesRunTime.boxToInteger((int)2), null, null, BoxesRunTime.boxToInteger((int)9223), null, null, BoxesRunTime.boxToDouble((double)-2.3), null, null, BoxesRunTime.boxToDouble((double)9.9), null, null, BoxesRunTime.boxToBoolean((boolean)true), null, null, "varchar", null, null, "char                ", null, null, "2021-08-03", null, null, "20:08:17", null, null, "2021-08-03T20:08:29", null, null, BoxesRunTime.boxToDouble((double)9.99)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testGroupByArrayType() {
        this.checkResult("SELECT sum(a) FROM (VALUES (1, array[1, 2]), (2, array[1, 2]), (5, array[3, 4])) T(a, b) GROUP BY b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testDistinctArrayType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT DISTINCT b FROM (\n         |VALUES (2, array[1, 2]), (2, array[2, 3]), (2, array[1, 2]), (5, array[3, 4])) T(a, b)\n         |")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[1, 2]"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2, 3]"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[3, 4]"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCountDistinctArrayType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT a, COUNT(DISTINCT b) FROM (\n         |VALUES (2, array[1, 2]), (2, array[2, 3]), (2, array[1, 2]), (5, array[3, 4])) T(a, b)\n         |GROUP BY a\n         |")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCountStar() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(434).append("\n                       |CREATE TABLE src(\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("select count(*) from src", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeadAggFunction() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(443).append("\n                       |CREATE TABLE src(\n                       |  `id` BIGINT,\n                       |  `len` INT NOT NULL,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select\n         |  LEAD(len) OVER w AS prev_quantity,\n         |  LEAD(len, 1, cast(null as int)) OVER w AS prev_quantity\n         |from src\n         |WINDOW w AS (ORDER BY proctime)\n         |")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11, 11"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"12, 12"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"null, null"}))}))), this.checkResult$default$3());
    }

    public AggregateITCaseBase(String testName) {
        Tuple3 tuple3 = new Tuple3((Object)this.big(1), (Object)this.big(2), (Object)this.big(3));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BigDecimal b1 = (BigDecimal)tuple3._1();
        BigDecimal b2 = (BigDecimal)tuple3._2();
        BigDecimal b3 = (BigDecimal)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)b1, (Object)b2, (Object)b3);
        this.x$2 = tuple32;
        this.b1 = (BigDecimal)this.x$2._1();
        this.b2 = (BigDecimal)this.x$2._2();
        this.b3 = (BigDecimal)this.x$2._3();
        Tuple3 tuple33 = new Tuple3((Object)this.bigX(1), (Object)this.bigX(2), (Object)this.bigX(3));
        if (tuple33 == null) {
            throw new MatchError((Object)tuple33);
        }
        BigDecimal b1x = (BigDecimal)tuple33._1();
        BigDecimal b2x = (BigDecimal)tuple33._2();
        BigDecimal b3x = (BigDecimal)tuple33._3();
        Tuple3 tuple34 = new Tuple3((Object)b1x, (Object)b2x, (Object)b3x);
        this.x$3 = tuple34;
        this.b1x = (BigDecimal)this.x$3._1();
        this.b2x = (BigDecimal)this.x$3._2();
        this.b3x = (BigDecimal)this.x$3._3();
        this.bN = null;
    }
}

