/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.agg;

import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.runtime.batch.sql.agg.DistinctAggregateITCaseBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.IntSumAggFunction;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001+\tY2k\u001c:u\t&\u001cH/\u001b8di\u0006;wM]3hCR,\u0017\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007\u0005<wM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!\u00022bi\u000eD'BA\u0005\u000b\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\u000eESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016LEkQ1tK\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"a\u0006\u0001\t\u000b}\u0001A\u0011\t\u0011\u0002\u0019A\u0014X\r]1sK\u0006;wm\u00149\u0015\u0003\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012A!\u00168ji\")\u0001\u0006\u0001C\u0001A\u0005yB/Z:u\t&\u001cH/\u001b8diV#\u0015iR$XSRDw.\u001e;He>,\bOQ=)\u0005\u001dR\u0003CA\u00163\u001b\u0005a#BA\u0017/\u0003\r\t\u0007/\u001b\u0006\u0003_A\nqA[;qSR,'O\u0003\u00022%\u0005)!.\u001e8ji&\u00111\u0007\f\u0002\u0005)\u0016\u001cH\u000fC\u00036\u0001\u0011\u0005\u0001%\u0001\u000fuKN$H)[:uS:\u001cG/\u0016#B\u000f\u001e;\u0016\u000e\u001e5He>,\bOQ=)\u0005QR\u0003\"\u0002\u001d\u0001\t\u0003\u0001\u0013\u0001\t;fgR,F)Q$H\u001dVdGn\u0012:pkB\\U-_!hOJ,w-\u0019;j_:D#a\u000e\u0016\t\u000bm\u0002A\u0011\u0001\u0011\u00027Q,7\u000f^\"p[BdW\r_+E\u0003\u001e;u+\u001b;i\u000fJ|W\u000f\u001d\"zQ\tQ$\u0006")
public class SortDistinctAggregateITCase
extends DistinctAggregateITCaseBase {
    @Override
    public void prepareAggOp() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.HashAgg.toString());
        this.tEnv().createTemporarySystemFunction("countFun", (UserDefinedFunction)new CountAggFunction());
        this.tEnv().createTemporarySystemFunction("intSumFun", (UserDefinedFunction)new IntSumAggFunction());
        this.tEnv().createTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset());
    }

    @Test
    public void testDistinctUDAGGWithoutGroupBy() {
        this.checkResult("SELECT countFun(DISTINCT c), SUM(a) FROM NullTable3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)231)}))}))), this.checkResult$default$3());
        this.checkResult("SELECT countFun(DISTINCT c), SUM(a) FROM EmptyTable3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), null}))}))), this.checkResult$default$3());
        this.checkResult("SELECT countFun(DISTINCT b), intSumFun(DISTINCT a), countFun(c) FROM NullTable3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)231), BoxesRunTime.boxToInteger((int)18)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testDistinctUDAGGWithGroupBy() {
        this.checkResult("SELECT b, countFun(b), intSumFun(DISTINCT a), countFun(DISTINCT c) FROM SmallTable3 GROUP BY b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUDAGGNullGroupKeyAggregation() {
        this.checkResult("SELECT c, countFun(b), intSumFun(DISTINCT a) FROM NullTable3 WHERE a < 6 GROUP BY c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)9)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)5)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testComplexUDAGGWithGroupBy() {
        this.checkResult("SELECT e, countFun(d), weightedAvg(DISTINCT c, a) FROM Table5 GROUP BY e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)7)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)8)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)10)}))}))), this.checkResult$default$3());
    }
}

