/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.join.InnerJoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001U\u0011q\"\u00138oKJTu.\u001b8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"A\u0004sk:$\u0018.\\3\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005)Q\u000f^5mg&\u00111\u0004\u0007\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0003\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0001$\u0003A)\u0007\u0010]3di\u0016$'j\\5o)f\u0004X-F\u0001%!\t)SH\u0004\u0002'w9\u0011qE\u000f\b\u0003Qer!!\u000b\u001d\u000f\u0005):dBA\u00167\u001d\taSG\u0004\u0002.i9\u0011af\r\b\u0003_Ij\u0011\u0001\r\u0006\u0003cQ\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0005E\u0011\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011B\u0001\u001f\u0003\u0003!Qu.\u001b8UsB,\u0017B\u0001 @\u0005!Qu.\u001b8UsB,'B\u0001\u001f\u0003\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!)\u0001\u000bfqB,7\r^3e\u0015>Lg\u000eV=qK~#S-\u001d\u000b\u0003\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013A!\u00168ji\"9!\nQA\u0001\u0002\u0004!\u0013a\u0001=%c!IA\n\u0001a\u0001\u0002\u0003\u0006K\u0001J\u0001\u0012Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016\u0004\u0003FA&O!\ty\u0005,D\u0001Q\u0015\t\t&+A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003'R\u000b!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\t)f+A\u0003kk:LGO\u0003\u0002X\u001d\u0005IA/Z:ukRLGn]\u0005\u00033B\u0013\u0011\u0002U1sC6,G/\u001a:\t\u0011m\u0003\u0001R1A\u0005\nq\u000bq\"\\=VaB,'oQ1tK\u0012\u000bG/Y\u000b\u0002;B\u0019a,Y2\u000e\u0003}S!\u0001Y#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002c?\n\u00191+Z9\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019t\u0011!\u0002;za\u0016\u001c\u0018B\u00015f\u0005\r\u0011vn\u001e\u0005\tU\u0002A)\u0019!C\u00059\u0006yQ.\u001f'po\u0016\u00148)Y:f\t\u0006$\u0018\r\u0003\u0005m\u0001!\u0015\r\u0011\"\u0003]\u0003-i\u0017\u0010V3ti\u0012\u000bG/Y\u0019\t\u00119\u0004\u0001R1A\u0005\nq\u000b1\"\\=UKN$H)\u0019;be!)\u0001\u000f\u0001C!c\u00061!-\u001a4pe\u0016$\u0012a\u0011\u0015\u0003_N\u0004\"\u0001\u001e>\u000e\u0003UT!A^<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ys\u00069!.\u001e9ji\u0016\u0014(BA+\u0013\u0013\tYXO\u0001\u0006CK\u001a|'/Z#bG\"DQ! \u0001\u0005\u0002E\f!\u0003^3ti>sW-T1uG\"\u0004VM\u001d*po\"\u0012Ap \t\u0004i\u0006\u0005\u0011bAA\u0002k\naA+Z:u)\u0016l\u0007\u000f\\1uK\"1\u0011q\u0001\u0001\u0005\u0002E\f1\u0003^3ti6+H\u000e^5qY\u0016l\u0015\r^2iKND3!!\u0002\u0000\u0011\u0019\ti\u0001\u0001C\u0001c\u0006iA/Z:u\u001d>l\u0015\r^2iKND3!a\u0003\u0000\u0011\u0019\t\u0019\u0002\u0001C\u0001c\u0006\u0001B/Z:u\t\u0016\u001c\u0017.\\1m\u0003N\\U-\u001f\u0015\u0004\u0003#y\bBBA\r\u0001\u0011\u0005\u0011/A\buKN$()[4G_J\u001c\u0006/\u001b7mQ\r\t9b \u0005\u0007\u0003?\u0001A\u0011A9\u00029Q,7\u000f^*peRlUM]4f\u0015>LgnT;uaV$xJ\u001d3fe\"\u001a\u0011QD@)\u000f\u0001\t)#!\r\u00024A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,U\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005=\u0012\u0011\u0006\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAA\u001bG\t\t9\u0004E\u0002P\u0003sI1!a\u000fQ\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u001d\tyD\u0001E\u0001\u0003\u0003\nq\"\u00138oKJTu.\u001b8J)\u000e\u000b7/\u001a\t\u0004A\u0005\rcAB\u0001\u0003\u0011\u0003\t)e\u0005\u0003\u0002D\u0005\u001d\u0003c\u0001#\u0002J%\u0019\u00111J#\u0003\r\u0005s\u0017PU3g\u0011\u001di\u00121\tC\u0001\u0003\u001f\"\"!!\u0011\t\u0011\u0005M\u00131\tC\u0001\u0003+\n!\u0002]1sC6,G/\u001a:t)\t\t9\u0006\u0005\u0004\u0002Z\u0005\r\u0014qM\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!Q\u000f^5m\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012!bQ8mY\u0016\u001cG/[8oa\u0011\tI'a\u001d\u0011\u000b\u0011\u000bY'a\u001c\n\u0007\u00055TIA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002r\u0005MD\u0002\u0001\u0003\r\u0003k\n\t&!A\u0001\u0002\u000b\u0005\u0011q\u000f\u0002\u0004?\u0012\n\u0014\u0003BA=\u0003\u007f\u00022\u0001RA>\u0013\r\ti(\u0012\u0002\b\u001d>$\b.\u001b8h!\r!\u0015\u0011Q\u0005\u0004\u0003\u0007+%aA!os\"B\u0011\u0011KAD\u0003\u001b\u000by\tE\u0002P\u0003\u0013K1!a#Q\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002\u0012\u0006\u00191\u0010M?")
public class InnerJoinITCase
extends BatchTestBase {
    private Seq<Row> myUpperCaseData;
    private Seq<Row> myLowerCaseData;
    private Seq<Row> myTestData1;
    private Seq<Row> myTestData2;
    @Parameter
    private Enumeration.Value expectedJoinType;
    private volatile byte bitmap$0;

    @Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return InnerJoinITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    private Seq<Row> myUpperCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.myUpperCaseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "E"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "F"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "G"}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.myUpperCaseData;
    }

    private Seq<Row> myUpperCaseData() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.myUpperCaseData$lzycompute() : this.myUpperCaseData;
    }

    private Seq<Row> myLowerCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.myLowerCaseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "d"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "e"}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.myLowerCaseData;
    }

    private Seq<Row> myLowerCaseData() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.myLowerCaseData$lzycompute() : this.myLowerCaseData;
    }

    private Seq<Row> myTestData1$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.myTestData1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.myTestData1;
    }

    private Seq<Row> myTestData1() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.myTestData1$lzycompute() : this.myTestData1;
    }

    private Seq<Row> myTestData2$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.myTestData2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.myTestData2;
    }

    private Seq<Row> myTestData2() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.myTestData2$lzycompute() : this.myTestData2;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("myUpperCaseData", this.myUpperCaseData(), TestData$.MODULE$.INT_STRING(), "N, L", new boolean[]{true, true});
        this.registerCollection("myLowerCaseData", this.myLowerCaseData(), TestData$.MODULE$.INT_STRING(), "n, l", new boolean[]{true, true});
        this.registerCollection("myTestData1", this.myTestData1(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        this.registerCollection("myTestData2", this.myTestData2(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testOneMatchPerRow() {
        this.checkResult("SELECT * FROM myUpperCaseData u, myLowerCaseData l WHERE u.N = l.n", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)1), "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)2), "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)3), "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D", BoxesRunTime.boxToInteger((int)4), "d"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testMultipleMatches() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @TestTemplate
    public void testNoMatches() {
        this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1 and B.a = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testDecimalAsKey() {
        RowTypeInfo DEC_INT = new RowTypeInfo(new TypeInformation[]{BigDecimalTypeInfo.of((int)9, (int)0), BasicTypeInfo.INT_TYPE_INFO});
        this.registerCollection("leftTable", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(2), BoxesRunTime.boxToInteger((int)2)}))}))), (TypeInformation<Row>)DEC_INT, "a, b");
        this.registerCollection("rightTable", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)}))}))), (TypeInformation<Row>)DEC_INT, "c, d");
        this.checkResult("SELECT * FROM leftTable, rightTable WHERE a = c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testBigForSpill() {
        this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
        this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
        this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.fill(16, (Function0 & Serializable & scala.Serializable)() -> row), Seq$.MODULE$.canBuildFrom())), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSortMergeJoinOutputOrder() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
            this.env().getConfig().setParallelism(1);
            Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
            this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
            this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.fill(16, (Function0 & Serializable & scala.Serializable)() -> row), Seq$.MODULE$.canBuildFrom())), true);
        }
    }
}

