/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.sinks.CollectRowTableSink;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001U\u0011!BS8j]&#6)Y:f\u0015\t\u0019A!\u0001\u0003k_&t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQAY1uG\"T!!\u0003\u0006\u0002\u000fI,h\u000e^5nK*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\nE\u0001\u0001\r\u00111A\u0005\u0002\r\n\u0001#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3\u0016\u0003\u0011\u0002\"!J\u001f\u000f\u0005\u0019ZdBA\u0014;\u001d\tA\u0013H\u0004\u0002*q9\u0011!f\u000e\b\u0003WYr!\u0001L\u001b\u000f\u00055\"dB\u0001\u00184\u001d\ty#'D\u00011\u0015\t\tD#\u0001\u0004=e>|GOP\u0005\u0002'%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003y\t\t\u0001BS8j]RK\b/Z\u0005\u0003}}\u0012\u0001BS8j]RK\b/\u001a\u0006\u0003y\tA\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001\"\u0002)\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,w\fJ3r)\t\u0019\u0015\n\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0003V]&$\bb\u0002&A\u0003\u0003\u0005\r\u0001J\u0001\u0004q\u0012\n\u0004\"\u0003'\u0001\u0001\u0004\u0005\t\u0015)\u0003%\u0003E)\u0007\u0010]3di\u0016$'j\\5o)f\u0004X\r\t\u0015\u0003\u0017:\u0003\"a\u0014-\u000e\u0003AS!!\u0015*\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\t\u0019F+\u0001\u0006fqR,gn]5p]NT!!\u0016,\u0002\u000b),h.\u001b;\u000b\u0005]s\u0011!\u0003;fgR,H/\u001b7t\u0013\tI\u0006KA\u0005QCJ\fW.\u001a;fe\")1\f\u0001C!9\u00061!-\u001a4pe\u0016$\u0012a\u0011\u0015\u00035z\u0003\"aX3\u000e\u0003\u0001T!!\u00192\u0002\u0007\u0005\u0004\u0018N\u0003\u0002dI\u00069!.\u001e9ji\u0016\u0014(BA+\u0013\u0013\t1\u0007M\u0001\u0006CK\u001a|'/Z#bG\"DQ\u0001\u001b\u0001\u0005\u0002q\u000b\u0001\u0002^3ti*{\u0017N\u001c\u0015\u0003O*\u0004\"aX6\n\u00051\u0004'\u0001\u0004+fgR$V-\u001c9mCR,\u0007\"\u00028\u0001\t\u0003a\u0016\u0001\u0007;fgRduN\\4K_&tw+\u001b;i\u0005&<'+\u00198hK\"\u0012QN\u001b\u0005\u0006c\u0002!\t\u0001X\u0001\u001ai\u0016\u001cH\u000fT8oO\"\u000b7\u000f\u001b&pS:<UM\\3sCR|'\u000f\u000b\u0002qU\")A\u000f\u0001C\u00019\u0006AB/Z:u\u001f:,7+\u001b3f'6Tg)[3mI\u0016\u0013(o\u001c:)\u0005MT\u0007\"B<\u0001\t\u0003a\u0016A\u0006;fgRTu.\u001b8TC6,g)[3mI\u0016\u000bX/\u00197)\u0005YT\u0007\"\u0002>\u0001\t\u0003a\u0016A\u0003;fgRTu.\u001b8P]\"\u0012\u0011P\u001b\u0005\u0006{\u0002!\t\u0001X\u0001\u0012i\u0016\u001cHOS8j]:{W*\u0019;dQ\u0016\u001c\bF\u0001?k\u0011\u0019\t\t\u0001\u0001C\u00019\u0006iB/Z:u\u0015>LgNT8NCR\u001c\u0007.Z:XSRD7+\u001e2rk\u0016\u0014\u0018\u0010\u000b\u0002\u0000U\"1\u0011q\u0001\u0001\u0005\u0002q\u000b!\u0003^3ti*{\u0017N\\,ji\"4\u0015\u000e\u001c;fe\"\u001a\u0011Q\u00016\t\r\u00055\u0001\u0001\"\u0001]\u0003Y!Xm\u001d;K_&tw+\u001b;i\u0015>LgNR5mi\u0016\u0014\bfAA\u0006U\"1\u00111\u0003\u0001\u0005\u0002q\u000bq\u0005^3ti&sg.\u001a:K_&tw+\u001b;i\u0005>|G.Z1o\r&dG/\u001a:D_:$\u0017\u000e^5p]\"\u001a\u0011\u0011\u00036\t\r\u0005e\u0001\u0001\"\u0001]\u0003\u0015\"Xm\u001d;J]:,'OS8j]^KG\u000f\u001b(p]\u0016\u000bX/\u001b&pS:\u0004&/\u001a3jG\u0006$X\rK\u0002\u0002\u0018)Da!a\b\u0001\t\u0003a\u0016\u0001\u0007;fgRTu.\u001b8XSRDW*\u001e7uSBdWmS3zg\"\u001a\u0011Q\u00046\t\r\u0005\u0015\u0002\u0001\"\u0001]\u0003E!Xm\u001d;K_&tw+\u001b;i\u00032L\u0017m\u001d\u0015\u0004\u0003GQ\u0007BBA\u0016\u0001\u0011\u0005A,\u0001\u000fuKN$H*\u001a4u\u0015>LgnV5uQ6+H\u000e^5qY\u0016\\U-_:)\u0007\u0005%\"\u000e\u0003\u0004\u00022\u0001!\t\u0001X\u0001 i\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\"tuN\\#rk&Tu.\u001b8Qe\u0016$\u0007fAA\u0018U\"1\u0011q\u0007\u0001\u0005\u0002q\u000bQ\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5MK\u001a$Hj\\2bYB\u0013X\r\u001a\u0015\u0004\u0003kQ\u0007BBA\u001f\u0001\u0011\u0005A,A\u000fuKN$(+[4ii*{\u0017N\\,ji\"lU\u000f\u001c;ja2,7*Z=tQ\r\tYD\u001b\u0005\u0007\u0003\u0007\u0002A\u0011\u0001/\u0002AQ,7\u000f\u001e*jO\"$(j\\5o/&$\bNT8o\u000bF,\u0018NS8j]B\u0013X\r\u001a\u0015\u0004\u0003\u0003R\u0007BBA%\u0001\u0011\u0005A,\u0001\u0010uKN$(+[4ii*{\u0017N\\,ji\"dUM\u001a;M_\u000e\fG\u000e\u0015:fI\"\u001a\u0011q\t6\t\r\u0005=\u0003\u0001\"\u0001]\u0003\u0005\"Xm\u001d;Gk2dw*\u001e;fe*{\u0017N\\,ji\"lU\u000f\u001c;ja2,7*Z=tQ\r\tiE\u001b\u0005\u0007\u0003+\u0002A\u0011\u0001/\u0002?Q,7\u000f\u001e$vY2Tu.\u001b8XSRDgj\u001c8FcVL'j\\5o!J,G\rK\u0002\u0002T)Da!a\u0017\u0001\t\u0003a\u0016!\b;fgR4U\u000f\u001c7K_&tw+\u001b;i\u0019\u00164G\u000fT8dC2\u0004&/\u001a3)\u0007\u0005e#\u000e\u0003\u0004\u0002b\u0001!\t\u0001X\u0001\u0012i\u0016\u001cHOR;mY>+H/\u001a:K_&t\u0007fAA0U\"1\u0011q\r\u0001\u0005\u0002q\u000b\u0011\u0005^3ti\u001a+H\u000e\\(vi\u0016\u0014(j\\5o/&$\bn\\;u\u000bF,\u0018\r\\\"p]\u0012D3!!\u001ak\u0011\u0019\ti\u0007\u0001C\u00019\u0006QC/Z:u'&tw\r\\3S_^4U\u000f\u001c7PkR,'OS8j]^KG\u000f[8vi\u0016\u000bX/\u00197D_:$\u0007fAA6U\"1\u00111\u000f\u0001\u0005\u0002q\u000b\u0011\u0007^3tiNKgn\u001a7f%><h)\u001e7m\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5pkR,\u0015/^1m\u0007>tGMT8NCR\u001c\u0007\u000eK\u0002\u0002r)Da!!\u001f\u0001\t\u0003a\u0016!\u0005;fgRdUM\u001a;PkR,'OS8j]\"\u001a\u0011q\u000f6\t\r\u0005}\u0004\u0001\"\u0001]\u0003I!Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8)\u0007\u0005u$\u000e\u0003\u0004\u0002\u0006\u0002!\t\u0001X\u0001\u0018i\u0016\u001cHOS8j]^KG\u000f[!hOJ,w-\u0019;j_:D3!a!k\u0011\u0019\tY\t\u0001C\u00019\u0006iB/Z:u\u0015>LgnQ8oI&$\u0018n\u001c8OK\u0016$7+[7qY&4\u0017\u0010K\u0002\u0002\n*Da!!%\u0001\t\u0003a\u0016A\u000f;fgRTu.\u001b8D_:$\u0017\u000e^5p]\u0012+'/\u001b<fI\u001a\u0013x.\\\"peJ,G.\u0019;fIN+(-U;feftU-\u001a3TS6\u0004H.\u001b4zQ\r\tyI\u001b\u0005\u0007\u0003/\u0003A\u0011\u0001/\u0002\u0015Q,7\u000f^*j[BdW\rK\u0002\u0002\u0016*Da!!(\u0001\t\u0003a\u0016A\u0003;fgR\u001cV\r\\3di\"\u001a\u00111\u00146\t\r\u0005\r\u0006\u0001\"\u0001]\u00039!Xm\u001d;D_J\u0014X\r\\1uK\u0012D3!!)k\u0011\u0019\tI\u000b\u0001C\u00019\u0006\u0019B/Z:u\u0007>\u0014(/\u001a7bi\u0016$W\t_5ti\"\u001a\u0011q\u00156\t\r\u0005=\u0006\u0001\"\u0001]\u0003Q!Xm\u001d;D_J\u0014X\r\\1uK\u0012,\u00050[:ue!\u001a\u0011Q\u00166\t\r\u0005U\u0006\u0001\"\u0001]\u0003Y!Xm\u001d;D_J\u0014X\r\\1uK\u0012tu\u000e^#ySN$\bfAAZU\"1\u00111\u0018\u0001\u0005\u0002q\u000ba\u0003^3tiVs7m\u001c:sK2\fG/\u001a3TG\u0006d\u0017M\u001d\u0015\u0004\u0003sS\u0007BBAa\u0001\u0011\u0005A,\u0001\fuKN$X)];bY^KG\u000f[!hON\u001b\u0017\r\\1sQ\r\tyL\u001b\u0005\u0007\u0003\u000f\u0004A\u0011\u0001/\u0002+Q,7\u000f^\"p[B\f'/[:p]N\u001c6-\u00197be\"\u001a\u0011Q\u00196\t\r\u00055\u0007\u0001\"\u0001]\u0003A!Xm\u001d;K_&tw+\u001b;i\u001dVdG\u000eK\u0002\u0002L*Da!a5\u0001\t\u0003a\u0016!\u0005;fgR\u001c\u0016N\\4mKJ{wOS8j]\"\u001a\u0011\u0011\u001b6\t\r\u0005e\u0007\u0001\"\u0001]\u0003}!Xm\u001d;O_:,U\u000e\u001d;z)\u0006\u0014G.\u001a&pS:,U\u000e\u001d;z)\u0006\u0014G.\u001a\u0015\u0004\u0003/T\u0007BBAp\u0001\u0011\u0005A,\u0001\u000fuKN$X)\u001c9usR\u000b'\r\\3K_&tW)\u001c9usR\u000b'\r\\3)\u0007\u0005u'\u000e\u0003\u0004\u0002f\u0002!\t\u0001X\u0001\u0012i\u0016\u001cHOS8j]\u000e{G\u000e\\1uS>t\u0007fAArU\"1\u00111\u001e\u0001\u0005\u0002q\u000bQ\u0003^3ti*{\u0017N\\,ji\",FI\u0012$jYR,'\u000fK\u0002\u0002j*Da!!=\u0001\t\u0003a\u0016A\u0007;fgRTu.\u001b8XSRDg)\u001b7uKJ\u0004Vo\u001d5E_^t\u0007fAAxU\"1\u0011q\u001f\u0001\u0005\u0002q\u000b\u0011\u0005^3ti*{\u0017N\\,ji\"Tu.\u001b8D_:$\u0017\u000e^5p]B+8\u000f\u001b#po:D3!!>kQ\u001d\u0001\u0011Q B\u0005\u0005\u0017\u0001B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0004\u0005\u0007\u0001\u0017!C3yi\u0016t7/[8o\u0013\u0011\u00119A!\u0001\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0003\u000e\r\u0012!q\u0002\t\u0004\u001f\nE\u0011b\u0001B\n!\nQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u001e9!q\u0003\u0002\t\u0002\te\u0011A\u0003&pS:LEkQ1tKB\u0019\u0001Ea\u0007\u0007\r\u0005\u0011\u0001\u0012\u0001B\u000f'\u0011\u0011YBa\b\u0011\u0007\u0011\u0013\t#C\u0002\u0003$\u0015\u0013a!\u00118z%\u00164\u0007bB\u000f\u0003\u001c\u0011\u0005!q\u0005\u000b\u0003\u00053A\u0001Ba\u000b\u0003\u001c\u0011\u0005!QF\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHC\u0001B\u0018!\u0019\u0011\tDa\u000f\u0003@5\u0011!1\u0007\u0006\u0005\u0005k\u00119$\u0001\u0003vi&d'B\u0001B\u001d\u0003\u0011Q\u0017M^1\n\t\tu\"1\u0007\u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001#\u0003B%\u0019!1I#\u0003\u0007\u0005s\u0017\u0010\u000b\u0005\u0003*\t\u001d#Q\nB(!\ry%\u0011J\u0005\u0004\u0005\u0017\u0002&A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\u0011\t&\u0001\u000bfqB,7\r^3e\u0015>Lg\u000eV=qKvZ\b' ")
public class JoinITCase
extends BatchTestBase {
    @Parameter
    private Enumeration.Value expectedJoinType;

    @Parameters(name="expectedJoinType={0}")
    public static Collection<Object> parameters() {
        return JoinITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String smallData3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String data3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data3());
        String nullData3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.nullData3());
        String data5Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data5());
        String nullData5Id = TestValuesTableFactory.registerData(TestData$.MODULE$.nullData5());
        String data21Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data2_1());
        String data22Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data2_2());
        String data23Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data2_3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("CREATE TEMPORARY TABLE SmallTable3 (\n                       | a int,\n                       | b bigint,\n                       | c string\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(smallData3Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("CREATE TEMPORARY TABLE Table3 (\n                       | a int,\n                       | b bigint,\n                       | c string\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data3Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(355).append("CREATE TEMPORARY TABLE NullTable3 (\n                       | a int,\n                       | b bigint,\n                       | c string\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(nullData3Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(417).append("CREATE TEMPORARY TABLE Table5(\n                       | d int,\n                       | e bigint,\n                       | f int,\n                       | g string,\n                       | h bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data5Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(421).append("CREATE TEMPORARY TABLE NullTable5(\n                       | d int,\n                       | e bigint,\n                       | f int,\n                       | g string,\n                       | h bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(nullData5Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("CREATE TEMPORARY TABLE l(\n                       | a int,\n                       | b double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data21Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("CREATE TEMPORARY TABLE r(\n                       | c int,\n                       | d double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data22Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("CREATE TEMPORARY TABLE t(\n                       | c int,\n                       | d double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data23Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLongJoinWithBigRange() {
        Seq data1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}));
        Seq data2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}));
        String inputDataId1 = TestValuesTableFactory.registerData((Seq<Row>)data1);
        String inputDataId2 = TestValuesTableFactory.registerData((Seq<Row>)data2);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("CREATE TEMPORARY TABLE inputT1(\n                       | a bigint,\n                       | b double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(inputDataId1).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("CREATE TEMPORARY TABLE inputT2(\n                       | c bigint,\n                       | d double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(inputDataId2).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("SELECT a, b, c, d FROM inputT1, inputT2 WHERE a = c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLongHashJoinGenerator() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.HashJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            TableSink sink = new CollectRowTableSink().configure((String[])((Object[])new String[]{"c"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING}));
            ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("outputTable", sink);
            StatementSet stmtSet = this.tEnv().createStatementSet();
            Table table = this.tEnv().sqlQuery("SELECT c FROM SmallTable3, Table5 WHERE b = e");
            stmtSet.addInsert("outputTable", table);
            TestingTableEnvironment testingTEnv = (TestingTableEnvironment)this.tEnv();
            StatementSetImpl testingStmtSet = (StatementSetImpl)stmtSet;
            List transforms = ((PlannerBase)testingTEnv.getPlanner()).translate(testingStmtSet.getOperations());
            BooleanRef haveTwoOp = BooleanRef.create((boolean)false);
            ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(transforms).map((Function1 & Serializable & scala.Serializable)t -> this.findTwoInputTransform$1((Transformation)t), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)transform -> {
                JoinITCase.$anonfun$testLongHashJoinGenerator$2(haveTwoOp, transform);
                return BoxedUnit.UNIT;
            });
            Assertions.assertThat((boolean)haveTwoOp.elem).isTrue();
        }
    }

    @TestTemplate
    public void testOneSideSmjFieldError() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            String smallData3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(377).append("CREATE TEMPORARY TABLE PojoSmallTable3(\n                         | a int,\n                         | b bigint,\n                         | c string\n                         |)WITH(\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(smallData3Id).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            String data5Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data5());
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(443).append("CREATE TEMPORARY TABLE PojoTable5(\n                         | d int,\n                         | e bigint,\n                         | f int,\n                         | g string,\n                         | h bigint\n                         |)WITH(\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(data5Id).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            this.checkResult("SELECT c, g FROM (SELECT h, g, f, e, d FROM PojoSmallTable3, PojoTable5 WHERE b = e), PojoSmallTable3 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testJoinSameFieldEqual() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinOn() {
        this.checkResult("SELECT c, g FROM SmallTable3 JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinNoMatches() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 where c = g", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinNoMatchesWithSubquery() {
        this.checkResult("SELECT c, g FROM (SELECT * FROM SmallTable3 WHERE b>2), (SELECT * FROM Table5 WHERE e>2) WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithFilter() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e AND b < 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithJoinFilter() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInnerJoinWithBooleanFilterCondition() {
        Seq data1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi", BoxesRunTime.boxToBoolean((boolean)true)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello", BoxesRunTime.boxToBoolean((boolean)false)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world", BoxesRunTime.boxToBoolean((boolean)true)}))}));
        String data1Id = TestValuesTableFactory.registerData((Seq<Row>)data1);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(390).append("CREATE TEMPORARY TABLE table5(\n                       | a1 int,\n                       | b1 bigint,\n                       | c1 string,\n                       | d1 boolean\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data1Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(390).append("CREATE TEMPORARY TABLE table6(\n                       | a2 int,\n                       | b2 bigint,\n                       | c2 string,\n                       | d2 boolean\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data1Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("SELECT a1, a1, c2 FROM table5 INNER JOIN table6 ON d1 = d2 where d1 is true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, 1, Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, 1, Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, 3, Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, 3, Hi"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInnerJoinWithNonEquiJoinPredicate() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6 AND h < b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE a = d AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithAlias() {
        String data1Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data5());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(422).append("CREATE TEMPORARY TABLE AliasTable5(\n                       | d int,\n                       | e bigint,\n                       | f int,\n                       | g string,\n                       | c bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data1Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("SELECT AliasTable5.c, T.`1-_./\u00dc` FROM (SELECT a, b, c AS `1-_./\u00dc` FROM Table3) AS T, AliasTable5 WHERE a = d AND a < 4", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "Hello world"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 RIGHT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFullOuterJoinWithMultipleKeys() {
        block1: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @TestTemplate
    public void testFullJoinWithNonEquiJoinPred() {
        block1: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @TestTemplate
    public void testFullJoinWithLeftLocalPred() {
        block1: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b >= 2 and h = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @TestTemplate
    public void testFullOuterJoin() {
        block1: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM SmallTable3 FULL OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
            }
        }
    }

    @TestTemplate
    public void testFullOuterJoinWithoutEqualCond() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT t1.c, t2.c FROM SmallTable3 t1 FULL OUTER JOIN SmallTable3 t2 ON t1.b > t2.b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testSingleRowFullOuterJoinWithoutEqualCond() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT min(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testSingleRowFullOuterJoinWithoutEqualCondNoMatch() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT max(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hi"}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testLeftOuterJoin() {
        this.checkResult("SELECT c, g FROM Table5 LEFT OUTER JOIN SmallTable3 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightOuterJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3 RIGHT OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithAggregation() {
        this.checkResult("SELECT COUNT(g), COUNT(b) FROM SmallTable3, Table5 WHERE a = d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), BoxesRunTime.boxToLong((long)6L)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionNeedSimplify() {
        this.checkResult("SELECT A.d FROM Table5 A JOIN SmallTable3 B ON (A.d=B.a and B.a>2) or (A.d=B.a and B.b=1)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionDerivedFromCorrelatedSubQueryNeedSimplify() {
        this.checkResult("SELECT B.a FROM SmallTable3 B WHERE b = (select count(*) from Table5 A where (A.d=B.a and A.d<3) or (A.d=B.a and B.b=5))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSimple() {
        this.checkResult("select a, b from l where a in (select c from r where c > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSelect() {
        this.checkResult("select t.a from (select 1 as a)t", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testCorrelated() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("select t.a from (select l.a from l, r where l.a = r.c and l.a = 6)t", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))}))), this.checkResult$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @TestTemplate
    public void testCorrelatedExist() {
        this.checkResult("select * from l where exists (select * from r where l.a = r.c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
        this.checkResult("select * from l where exists (select * from r where l.a = r.c) and l.a <= 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testCorrelatedExist2() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123456L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-123456L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Integer.MAX_VALUE)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-2147483647L)}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(280).append("CREATE TEMPORARY TABLE t1(\n                       | f1 bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("select * from t1 o where exists (select 1 from t1 i where i.f1=o.f1 limit 0)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testCorrelatedNotExist() {
        this.checkResult("select * from l where not exists (select * from r where l.a = r.c and l.b <> r.d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testUncorrelatedScalar() {
        this.checkResult("select (select 1) as b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult("select (select 1 as b)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult("select (select 1 as a) as b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testEqualWithAggScalar() {
        this.checkResult("select a, b from l where a = (select distinct (c) from r where c = 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComparisonsScalar() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkEmptyResult("select a, b from l where a = (select c from r where 1 = 2)");
            Row row = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row2 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row3 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}));
            Row row4 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}));
            this.checkResult("select a, b from l where a >= 1.0 * (select avg(d) from r where c > 2)", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row), this.checkResult$default$3());
        }
        Row row = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        Row row5 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        this.checkResult("select a, b from l where a * b < 2.0 * (select avg(d) from r where l.a = r.c and c < 6 )", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithNull() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) and c = 'NullTuple'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "c"}))}))));
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(367).append("CREATE TEMPORARY TABLE NullT(\n                         | a int,\n                         | b bigint,\n                         | c string\n                         |)WITH(\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            this.checkResult("SELECT T1.a, T1.b, T1.c FROM NullT T1, NullT T2 WHERE (T1.a = T2.a OR (T1.a IS NULL AND T2.a IS NULL)) AND (T1.b = T2.b OR (T1.b IS NULL AND T2.b IS NULL)) AND T1.c = T2.c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"null", "null", "c"}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testSingleRowJoin() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON s <> b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON s <> b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testNonEmptyTableJoinEmptyTable() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 FULL JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testEmptyTableJoinEmptyTable() {
        block0: {
            Enumeration.Value value = this.expectedJoinType();
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testJoinCollation() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.a AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.b AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.b = t2.b\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithUDFFilter() {
        this.tEnv().createTemporarySystemFunction("funcWithOpen", (UserDefinedFunction)new FuncWithOpen());
        this.checkResult("SELECT c, g FROM SmallTable3 join Table5 on funcWithOpen(a + d) where b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithFilterPushDown() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l inner join r on a = c where c IS NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l inner join r on a = c where c = NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n          |select * from\n          | l inner join r on a = c where c = 3\n          |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)}))}))), this.checkResult$default$3());
            this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n          |select * from\n          | l left join r on a = c where c = 3\n          |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)}))}))), this.checkResult$default$3());
        }
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c IS NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c IS NULL AND a <= 1\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c = NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c < 3 AND a <= 3\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c <> 3 AND a <= 3\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithJoinConditionPushDown() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2), null, null, null}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2), null, null, null}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    private final TwoInputTransformation findTwoInputTransform$1(Transformation t) {
        TwoInputTransformation twoInputTransformation;
        Transformation transformation;
        while (true) {
            if ((transformation = t) instanceof LegacySinkTransformation) {
                LegacySinkTransformation legacySinkTransformation = (LegacySinkTransformation)transformation;
                t = (Transformation)legacySinkTransformation.getInputs().get(0);
                continue;
            }
            if (!(transformation instanceof OneInputTransformation)) break;
            OneInputTransformation oneInputTransformation = (OneInputTransformation)transformation;
            t = (Transformation)oneInputTransformation.getInputs().get(0);
        }
        if (!(transformation instanceof TwoInputTransformation)) {
            throw new MatchError((Object)transformation);
        }
        TwoInputTransformation twoInputTransformation2 = twoInputTransformation = (TwoInputTransformation)transformation;
        return twoInputTransformation2;
    }

    public static final /* synthetic */ void $anonfun$testLongHashJoinGenerator$2(BooleanRef haveTwoOp$1, TwoInputTransformation transform) {
        StreamOperatorFactory streamOperatorFactory = transform.getOperatorFactory();
        if (streamOperatorFactory instanceof CodeGenOperatorFactory) {
            BoxedUnit boxedUnit;
            CodeGenOperatorFactory codeGenOperatorFactory = (CodeGenOperatorFactory)streamOperatorFactory;
            if (codeGenOperatorFactory.getGeneratedClass().getCode().contains("LongHashJoinOperator")) {
                haveTwoOp$1.elem = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }
}

