/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.join.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.runtime.functions.table.fullcache.inputformat.FullCacheTestInputFormat;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u0001\u0003\u0001U\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\beVtG/[7f\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033!\tQ!\u001e;jYNL!a\u0007\r\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0005#\u0001\u0001\u0007\t\u0019!C\u0001G\u0005\tB.Z4bGf$\u0016M\u00197f'>,(oY3\u0016\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012qAQ8pY\u0016\fg\u000eC\u0005,\u0001\u0001\u0007\t\u0019!C\u0001Y\u0005)B.Z4bGf$\u0016M\u00197f'>,(oY3`I\u0015\fHCA\u00171!\t)c&\u0003\u00020M\t!QK\\5u\u0011\u001d\t$&!AA\u0002\u0011\n1\u0001\u001f\u00132\u0011%\u0019\u0004\u00011A\u0001B\u0003&A%\u0001\nmK\u001e\f7-\u001f+bE2,7k\\;sG\u0016\u0004\u0003F\u0001\u001a6!\t1t(D\u00018\u0015\tA\u0014(A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003um\n!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\taT(A\u0003kk:LGO\u0003\u0002?\u001d\u0005IA/Z:ukRLGn]\u0005\u0003\u0001^\u0012\u0011\u0002U1sC6,G/\u001a:\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0013aC5t\u0003NLhnY'pI\u0016D\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011A#\u0002\u001f%\u001c\u0018i]=oG6{G-Z0%KF$\"!\f$\t\u000fE\u001a\u0015\u0011!a\u0001I!I\u0001\n\u0001a\u0001\u0002\u0003\u0006K\u0001J\u0001\rSN\f5/\u001f8d\u001b>$W\r\t\u0015\u0005\u000fVR5*A\u0003wC2,X-H\u0001\u0002\u0011%i\u0005\u00011AA\u0002\u0013\u0005a*A\u0005dC\u000eDW\rV=qKV\tq\n\u0005\u0002QU:\u0011\u0011k\u001a\b\u0003%\u0012t!aU1\u000f\u0005Q{fBA+_\u001d\t1VL\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!\fF\u0001\u0007yI|w\u000e\u001e \n\u0003MI!!\u0005\n\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\t\u0001G\"A\u0005d_:tWm\u0019;pe&\u0011!mY\u0001\u0007g>,(oY3\u000b\u0005\u0001d\u0011BA3g\u0003\u0019awn\\6va*\u0011!mY\u0005\u0003Q&\fQ\u0002T8pWV\u0004x\n\u001d;j_:\u001c(BA3g\u0013\tYGNA\bM_>\\W\u000f]\"bG\",G+\u001f9f\u0015\tA\u0017\u000eC\u0005o\u0001\u0001\u0007\t\u0019!C\u0001_\u0006i1-Y2iKRK\b/Z0%KF$\"!\f9\t\u000fEj\u0017\u0011!a\u0001\u001f\"I!\u000f\u0001a\u0001\u0002\u0003\u0006KaT\u0001\u000bG\u0006\u001c\u0007.\u001a+za\u0016\u0004\u0003\u0006B96\u0015Rl\u0012A\u0001\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0003\u0011!\u0017\r^1\u0016\u0003a\u0004B!\u001f@\u0002\u00025\t!P\u0003\u0002|y\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003{\u001a\n!bY8mY\u0016\u001cG/[8o\u0013\ty(P\u0001\u0003MSN$\b\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da\"A\u0003usB,7/\u0003\u0003\u0002\f\u0005\u0015!a\u0001*po\"9\u0011q\u0002\u0001!\u0002\u0013A\u0018!\u00023bi\u0006\u0004\u0003\u0002CA\n\u0001\t\u0007I\u0011A<\u0002\u0019\u0011\fG/Y,ji\"tU\u000f\u001c7\t\u000f\u0005]\u0001\u0001)A\u0005q\u0006iA-\u0019;b/&$\bNT;mY\u0002B\u0001\"a\u0007\u0001\u0005\u0004%\ta^\u0001\tkN,'\u000fR1uC\"9\u0011q\u0004\u0001!\u0002\u0013A\u0018!C;tKJ$\u0015\r^1!\u0011!\t\u0019\u0003\u0001b\u0001\n\u00039\u0018\u0001E;tKJ$\u0015\r^1XSRDg*\u001e7m\u0011\u001d\t9\u0003\u0001Q\u0001\na\f\u0011#^:fe\u0012\u000bG/Y,ji\"tU\u000f\u001c7!\u0011\u001d\tY\u0003\u0001C!\u0003[\taAY3g_J,G#A\u0017)\t\u0005%\u0012\u0011\u0007\t\u0005\u0003g\ty$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\r\t\u0007/\u001b\u0006\u0005\u0003w\ti$A\u0004kkBLG/\u001a:\u000b\u0005q\u0012\u0012\u0002BA!\u0003k\u0011!BQ3g_J,W)Y2i\u0011\u001d\t)\u0005\u0001C!\u0003[\tQ!\u00194uKJDC!a\u0011\u0002JA!\u00111GA&\u0013\u0011\ti%!\u000e\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007bBA)\u0001\u0011%\u00111K\u0001\u0012GJ,\u0017\r^3M_>\\W\u000f\u001d+bE2,G#B\u0017\u0002V\u0005%\u0004\u0002CA,\u0003\u001f\u0002\r!!\u0017\u0002\u0013Q\f'\r\\3OC6,\u0007\u0003BA.\u0003GrA!!\u0018\u0002`A\u0011\u0001LJ\u0005\u0004\u0003C2\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002f\u0005\u001d$AB*ue&twMC\u0002\u0002b\u0019BqA^A(\u0001\u0004\tY\u0007\u0005\u0004\u0002n\u0005]\u0014\u0011\u0001\b\u0005\u0003_\n\u0019HD\u0002Y\u0003cJ\u0011aJ\u0005\u0004\u0003k2\u0013a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006e$bAA;M!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0014aI2sK\u0006$X\rT8pWV\u0004H+\u00192mK^KG\u000f[\"p[B,H/\u001a3D_2,XN\u001c\u000b\u0006[\u0005\u0005\u00151\u0011\u0005\t\u0003/\nY\b1\u0001\u0002Z!9a/a\u001fA\u0002\u0005-\u0004bBAD\u0001\u0011%\u0011\u0011R\u0001\u0010GJ,\u0017\r^3TG\u0006tG+\u00192mKR)Q&a#\u0002\u000e\"A\u0011qKAC\u0001\u0004\tI\u0006C\u0004w\u0003\u000b\u0003\r!a\u001b\t\u000f\u0005E\u0005\u0001\"\u0001\u0002.\u0005YC/Z:u\u0019\u00164GOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8dC2\u0004&/\u001a3jG\u0006$X\r\u000b\u0003\u0002\u0010\u0006U\u0005\u0003BA\u001a\u0003/KA!!'\u00026\taA+Z:u)\u0016l\u0007\u000f\\1uK\"9\u0011Q\u0014\u0001\u0005\u0002\u00055\u0012!\u0006;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0005\u00037\u000b)\nC\u0004\u0002$\u0002!\t!!\f\u0002CQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b)vg\"$un\u001e8)\t\u0005\u0005\u0016Q\u0013\u0005\b\u0003S\u0003A\u0011AA\u0017\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5O_:,\u0015/^1m\r&dG/\u001a:)\t\u0005\u001d\u0016Q\u0013\u0005\b\u0003_\u0003A\u0011AA\u0017\u0003\t\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&4\u0015.\u001a7eg\"\"\u0011QVAK\u0011\u001d\t)\f\u0001C\u0001\u0003[\t\u0011\u0006^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018NR5fY\u0012\u001cx+\u001b;i+\u00124\u0007\u0006BAZ\u0003+Cq!a/\u0001\t\u0003\ti#A\u0013uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg\"\"\u0011\u0011XAK\u0011\u001d\t\t\r\u0001C\u0001\u0003[\t\u0011\u0004^3ti2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011qXAK\u0011\u001d\t9\r\u0001C\u0001\u0003[\t\u0011\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018nS3z\r&,G\u000eZ:XSRDg*\u001e7m\t\u0006$\u0018\r\u000b\u0003\u0002F\u0006U\u0005bBAg\u0001\u0011\u0005\u0011QF\u00016i\u0016\u001cH\u000fT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018nS3z\r&,G\u000eZ:XSRDg*\u001e7m\t\u0006$\u0018\r\u000b\u0003\u0002L\u0006U\u0005bBAj\u0001\u0011\u0005\u0011QF\u0001'i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:tU\u000f\u001c7D_:\u001cH/\u00198u\u0017\u0016L\b\u0006BAi\u0003+Cq!!7\u0001\t\u0003\ti#\u0001\u001duKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2\u001cuN\\:uC:$8*Z=)\t\u0005]\u0017Q\u0013\u0005\b\u0003?\u0004A\u0011AA\u0017\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8)\t\u0005u\u0017Q\u0013\u0005\b\u0003K\u0004A\u0011AA\u0017\u0003I\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8B]\u0012\u0004Vo\u001d5E_^t\u0007\u0006BAr\u0003+Cq!a;\u0001\t\u0003\ti#\u0001\u0013uKN$Hj\\8lkB\u001c\u0015m\u00195f'\"\f'/\u001b8h\u0003\u000e\u0014xn]:Tk\n$\u0018m]6tQ\u0011\tI/!&\t\u000f\u0005E\b\u0001\"\u0001\u0002t\u0006\u0011!.\u001b\u000b\u0005\u0003k\u0014)\u0001\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\fAA[1wC&!!1AA}\u0005\u001dIe\u000e^3hKJD\u0001Ba\u0002\u0002p\u0002\u0007!\u0011B\u0001\u0002SB\u0019QEa\u0003\n\u0007\t5aEA\u0002J]RDqA!\u0005\u0001\t\u0003\u0011\u0019\"\u0001\u0002kYR!!Q\u0003B\u000e!\u0011\t9Pa\u0006\n\t\te\u0011\u0011 \u0002\u0005\u0019>tw\r\u0003\u0005\u0003\u001e\t=\u0001\u0019\u0001B\u0010\u0003\u0005a\u0007cA\u0013\u0003\"%\u0019!\u0011\u0004\u0014)\r\u0001\u0011)C\u0013B\u0019!\u0011\u00119C!\f\u000e\u0005\t%\"\u0002\u0002B\u0016\u0003k\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\t=\"\u0011\u0006\u0002\u000b\u000bb$XM\u001c3XSRDGF\u0001B\u001aG\t\u0011)\u0004E\u00027\u0005oI1A!\u000f8\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u001d\u0011iD\u0001E\u0001\u0005\u007f\t\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u0011\u0007\u0001\u0012\tE\u0002\u0004\u0002\u0005!\u0005!1I\n\u0005\u0005\u0003\u0012)\u0005E\u0002&\u0005\u000fJ1A!\u0013'\u0005\u0019\te.\u001f*fM\"9QD!\u0011\u0005\u0002\t5CC\u0001B \u0011)\u0011\tF!\u0011C\u0002\u0013\u0005!1K\u0001\u0014\u0019\u0016;\u0015iQ-`)\u0006\u0013E*R0T\u001fV\u00136)R\u000b\u0003\u0005+\u0002B!a>\u0003X%\u0019\u0011&!?\t\u0013\tm#\u0011\tQ\u0001\n\tU\u0013\u0001\u0006'F\u000f\u0006\u001b\u0015l\u0018+B\u00052+ulU(V%\u000e+\u0005\u0005\u0003\u0006\u0003`\t\u0005#\u0019!C\u0001\u0005'\nA\u0003R-O\u00036K5i\u0018+B\u00052+ulU(V%\u000e+\u0005\"\u0003B2\u0005\u0003\u0002\u000b\u0011\u0002B+\u0003U!\u0015LT!N\u0013\u000e{F+\u0011\"M\u000b~\u001bv*\u0016*D\u000b\u0002B!Ba\u001a\u0003B\t\u0007I\u0011\u0001B*\u0003)\t5+\u0017(D?6{E)\u0012\u0005\n\u0005W\u0012\t\u0005)A\u0005\u0005+\n1\"Q*Z\u001d\u000e{Vj\u0014#FA!Q!q\u000eB!\u0005\u0004%\tAa\u0015\u0002\u0013MKfjQ0N\u001f\u0012+\u0005\"\u0003B:\u0005\u0003\u0002\u000b\u0011\u0002B+\u0003)\u0019\u0016LT\"`\u001b>#U\t\t\u0005\t\u0005o\u0012\t\u0005\"\u0001\u0003z\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\tm\u0004C\u0002B?\u0005\u0007\u00139)\u0004\u0002\u0003\u0000)!!\u0011QA\u007f\u0003\u0011)H/\u001b7\n\t\t\u0015%q\u0010\u0002\u000b\u0007>dG.Z2uS>t\u0007#B\u0013\u0003\n\n5\u0015b\u0001BFM\t)\u0011I\u001d:bsB!\u0011q\u001fBH\u0013\u0011\u0011\t*!?\u0003\r=\u0013'.Z2uQ!\u0011)H!&\u0003\u001c\nu\u0005c\u0001\u001c\u0003\u0018&\u0019!\u0011T\u001c\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017E\u0001BP\u0003ebUmZ1dsR\u000b'\r\\3T_V\u00148-Z\u001f|aud\u0003%[:Bgft7-T8eK\u0002j\u0004e_\u0019~Y\u0001\u001a\u0017m\u00195f)f\u0004X\rI\u001f!wJj\b")
public class LookupJoinITCase
extends BatchTestBase {
    @Parameter
    private boolean legacyTableSource;
    @Parameter(value=1)
    private boolean isAsyncMode;
    @Parameter(value=2)
    private LookupOptions.LookupCacheType cacheType;
    private final List<Row> data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)12L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$)))));
    private final List<Row> dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$))));
    private final List<Row> userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
    private final List<Row> userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));

    @Parameters(name="LegacyTableSource={0}, isAsyncMode = {1}, cacheType = {2}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean SYNC_MODE() {
        return LookupJoinITCase$.MODULE$.SYNC_MODE();
    }

    public static Boolean ASYNC_MODE() {
        return LookupJoinITCase$.MODULE$.ASYNC_MODE();
    }

    public static Boolean DYNAMIC_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.DYNAMIC_TABLE_SOURCE();
    }

    public static Boolean LEGACY_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.LEGACY_TABLE_SOURCE();
    }

    public boolean legacyTableSource() {
        return this.legacyTableSource;
    }

    public void legacyTableSource_$eq(boolean x$1) {
        this.legacyTableSource = x$1;
    }

    public boolean isAsyncMode() {
        return this.isAsyncMode;
    }

    public void isAsyncMode_$eq(boolean x$1) {
        this.isAsyncMode = x$1;
    }

    public LookupOptions.LookupCacheType cacheType() {
        return this.cacheType;
    }

    public void cacheType_$eq(LookupOptions.LookupCacheType x$1) {
        this.cacheType = x$1;
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        if (this.legacyTableSource()) {
            InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().set(0);
        } else {
            TestValuesTableFactory.RESOURCE_COUNTER.set(0);
            FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.set(0);
        }
        this.createScanTable("T", this.data());
        this.createScanTable("nullableT", this.dataWithNull());
        this.createLookupTable("userTable", this.userData());
        this.createLookupTable("userTableWithNull", this.userDataWithNull());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
        this.env().getConfig().disableObjectReuse();
    }

    @Override
    @AfterEach
    public void after() {
        if (this.legacyTableSource()) {
            Assertions.assertThat((int)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get()).isEqualTo(0);
        } else {
            Assertions.assertThat((int)TestValuesTableFactory.RESOURCE_COUNTER.get()).isEqualTo(0);
            Assertions.assertThat((int)FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.get()).isEqualTo(0);
        }
    }

    private void createLookupTable(String tableName, List<Row> data) {
        if (this.legacyTableSource()) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), this.isAsyncMode(), data, userSchema, tableName, true);
        } else {
            String string;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType();
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType();
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode()).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        block2: {
            String string;
            if (this.legacyTableSource()) break block2;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType();
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType();
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(522).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING,\n                         |  `nominal_age` as age + 1\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode()).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(435).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` BIGINT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testLeftJoinTemporalTableWithLocalPredicate() {
        String sql = new StringBuilder(190).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id ").append("AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' ").append("WHERE T.id > 1").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), "Hello world", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), "Hello world!", null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTable() {
        String sql = new StringBuilder(112).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithPushDown() {
        String sql = new StringBuilder(127).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = new StringBuilder(140).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiFieldsWithUdf() {
        String sql = new StringBuilder(132).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON mod(T.id, 4) = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinTemporalTable() {
        String sql = new StringBuilder(113).append("SELECT T.id, T.len, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(142).append("SELECT T.id, T.len, D.name FROM nullableT T JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(147).append("SELECT D.id, T.len, D.name FROM nullableT T LEFT JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)12), null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = new StringBuilder(104).append("SELECT T.id, T.len, T.content FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON D.id = null").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumn() {
        Assumptions.assumeThat((boolean)this.legacyTableSource()).isFalse();
        String sql = new StringBuilder(152).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assumptions.assumeThat((boolean)this.legacyTableSource()).isFalse();
        String sql = new StringBuilder(175).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testLookupCacheSharingAcrossSubtasks() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType();
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.NONE;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE datagen_source (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6',\n           |  'number-of-rows' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM datagen_source as T \n          |LEFT JOIN userTable FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            this.executeQuery(this.parseQuery(sql));
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType();
            LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.PARTIAL;
            int numEntries = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? 6 : this.userData().size();
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo((long)numEntries);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }
}

