/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.batch.sql.join.SemiJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001U\u0011abU3nS*{\u0017N\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000b\t\fGo\u00195\u000b\u0005%Q\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"BA\r\t\u0003\u0015)H/\u001b7t\u0013\tY\u0002DA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tA\u0011B\t\u0001A\u0002\u0003\u0007I\u0011A\u0012\u0002!\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,W#\u0001\u0013\u0011\u0005\u0015jdB\u0001\u0014<\u001d\t9#H\u0004\u0002)s9\u0011\u0011\u0006\u000f\b\u0003U]r!a\u000b\u001c\u000f\u00051*dBA\u00175\u001d\tq3G\u0004\u00020e5\t\u0001G\u0003\u00022)\u00051AH]8pizJ\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u0010\u0002\u0002\u0011){\u0017N\u001c+za\u0016L!AP \u0003\u0011){\u0017N\u001c+za\u0016T!\u0001\u0010\u0002\t\u0013\u0005\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0015\u0001F3ya\u0016\u001cG/\u001a3K_&tG+\u001f9f?\u0012*\u0017\u000f\u0006\u0002D\u0013B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n!QK\\5u\u0011\u001dQ\u0005)!AA\u0002\u0011\n1\u0001\u001f\u00132\u0011%a\u0005\u00011A\u0001B\u0003&A%A\tfqB,7\r^3e\u0015>Lg\u000eV=qK\u0002B#a\u0013(\u0011\u0005=CV\"\u0001)\u000b\u0005E\u0013\u0016!\u00049be\u0006lW\r^3sSj,GM\u0003\u0002T)\u0006QQ\r\u001f;f]NLwN\\:\u000b\u0005U3\u0016!\u00026v]&$(BA,\u000f\u0003%!Xm\u001d;vi&d7/\u0003\u0002Z!\nI\u0001+\u0019:b[\u0016$XM\u001d\u0005\u00067\u0002!\t\u0005X\u0001\u0007E\u00164wN]3\u0015\u0003\rC#A\u00170\u0011\u0005}+W\"\u00011\u000b\u0005\u0005\u0014\u0017aA1qS*\u00111\rZ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)&#\u0003\u0002gA\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b!\u0004A\u0011\u0001/\u00027Q,7\u000f^*j]\u001edWmQ8oI&$\u0018n\u001c8MK\u001a$8+Z7jQ\t9'\u000e\u0005\u0002`W&\u0011A\u000e\u0019\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0006]\u0002!\t\u0001X\u0001\u001ei\u0016\u001cHoQ8na>\u001cX\rZ\"p]\u0012LG/[8o\u0019\u00164GoU3nS\"\u0012QN\u001b\u0005\u0006c\u0002!\t\u0001X\u0001\u001ci\u0016\u001cHoU5oO2,7i\u001c8eSRLwN\u001c'fMR\fe\u000e^5)\u0005AT\u0007\"\u0002;\u0001\t\u0003a\u0016!\t;fgR\u001c\u0016N\\4mKVs\u0017.];f\u0007>tG-\u001b;j_:dUM\u001a;B]RL\u0007FA:k\u0011\u00159\b\u0001\"\u0001]\u0003u!Xm\u001d;D_6\u0004xn]3e\u0007>tG-\u001b;j_:dUM\u001a;B]RL\u0007F\u0001<k\u0011\u0015Q\b\u0001\"\u0001]\u0003\r\"Xm\u001d;D_6\u0004xn]3e+:L\u0017/^3D_:$\u0017\u000e^5p]2+g\r^!oi&D#!\u001f6\t\u000bu\u0004A\u0011\u0001/\u0002+Q,7\u000f^*f[&Tu.\u001b8Ue\u0006t7\u000f]8tK\"\u0012AP\u001b\u0005\u0007\u0003\u0003\u0001A\u0011\u0001/\u00027Q,7\u000f\u001e$jYR,'\u000fU;tQ\u0012{wO\u001c'fMR\u001cV-\\52Q\ty(\u000e\u0003\u0004\u0002\b\u0001!\t\u0001X\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3giN+W.\u001b\u001a)\u0007\u0005\u0015!\u000e\u0003\u0004\u0002\u000e\u0001!\t\u0001X\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3giN+W.[\u001a)\u0007\u0005-!\u000e\u0003\u0004\u0002\u0014\u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3giN+W.[\u0019)\u0007\u0005E!\u000e\u0003\u0004\u0002\u001a\u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3giN+W.\u001b\u001a)\u0007\u0005]!\u000e\u0003\u0004\u0002 \u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3giN+W.[\u001a)\u0007\u0005u!\u000e\u0003\u0004\u0002&\u0001!\t\u0001X\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3gi\u0006sG/[\u0019)\u0007\u0005\r\"\u000e\u0003\u0004\u0002,\u0001!\t\u0001X\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3gi\u0006sG/\u001b\u001a)\u0007\u0005%\"\u000e\u0003\u0004\u00022\u0001!\t\u0001X\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3gi\u0006sG/[\u001a)\u0007\u0005=\"\u000e\u0003\u0004\u00028\u0001!\t\u0001X\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3gi\u0006sG/\u001b\u001b)\u0007\u0005U\"\u000e\u0003\u0004\u0002>\u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3gi\u0006sG/[\u0019)\u0007\u0005m\"\u000e\u0003\u0004\u0002D\u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3gi\u0006sG/\u001b\u001a)\u0007\u0005\u0005#\u000e\u0003\u0004\u0002J\u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3gi\u0006sG/[\u001a)\u0007\u0005\u001d#\u000e\u0003\u0004\u0002P\u0001!\t\u0001X\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3gi\u0006sG/\u001b\u001b)\u0007\u00055#\u000e\u0003\u0004\u0002V\u0001!\t\u0001X\u0001\u0015i\u0016\u001cH/\u00138XSRD\u0017iZ4sK\u001e\fG/Z\u0019)\u0007\u0005M#\u000e\u0003\u0004\u0002\\\u0001!\t\u0001X\u0001\u0015i\u0016\u001cH/\u00138XSRD\u0017iZ4sK\u001e\fG/\u001a\u001a)\u0007\u0005e#\u000e\u0003\u0004\u0002b\u0001!\t\u0001X\u0001\u0015i\u0016\u001cH/\u00138XSRD\u0017iZ4sK\u001e\fG/Z\u001a)\u0007\u0005}#\u000e\u0003\u0004\u0002h\u0001!\t\u0001X\u0001\u0010i\u0016\u001cH/\u00138XSRDwJ^3sc!\u001a\u0011Q\r6\t\r\u00055\u0004\u0001\"\u0001]\u0003=!Xm\u001d;J]^KG\u000f[(wKJ\u0014\u0004fAA6U\"1\u00111\u000f\u0001\u0005\u0002q\u000bq\u0002^3ti&sw+\u001b;i\u001fZ,'o\r\u0015\u0004\u0003cR\u0007BBA=\u0001\u0011\u0005A,A\buKN$\u0018J\\,ji\"|e/\u001a:5Q\r\t9H\u001b\u0005\u0007\u0003\u007f\u0002A\u0011\u0001/\u0002'Q,7\u000f^#ySN$8oV5uQ>3XM]\u0019)\u0007\u0005u$\u000e\u0003\u0004\u0002\u0006\u0002!\t\u0001X\u0001\u0014i\u0016\u001cH/\u0012=jgR\u001cx+\u001b;i\u001fZ,'O\r\u0015\u0004\u0003\u0007S\u0007BBAF\u0001\u0011\u0005A,A\nuKN$X\t_5tiN<\u0016\u000e\u001e5Pm\u0016\u00148\u0007K\u0002\u0002\n*Da!!%\u0001\t\u0003a\u0016a\u0005;fgR,\u00050[:ug^KG\u000f[(wKJ$\u0004fAAHU\"1\u0011q\u0013\u0001\u0005\u0002q\u000b!\u0006^3ti&sw+\u001b;i\u001d>tW)];bY&$\u0018pQ8se\u0016d\u0017\r^5p]\u000e{g\u000eZ5uS>t\u0017\u0007K\u0002\u0002\u0016*Da!!(\u0001\t\u0003a\u0016A\u000b;fgRLenV5uQ:{g.R9vC2LG/_\"peJ,G.\u0019;j_:\u001cuN\u001c3ji&|gN\r\u0015\u0004\u00037S\u0007BBAR\u0001\u0011\u0005A,\u0001\u0016uKN$\u0018J\\,ji\"tuN\\#rk\u0006d\u0017\u000e^=D_J\u0014X\r\\1uS>t7i\u001c8eSRLwN\\\u001a)\u0007\u0005\u0005&\u000e\u0003\u0004\u0002*\u0002!\t\u0001X\u0001+i\u0016\u001cH/\u00138XSRDgj\u001c8FcV\fG.\u001b;z\u0007>\u0014(/\u001a7bi&|gnQ8oI&$\u0018n\u001c85Q\r\t9K\u001b\u0005\u0007\u0003_\u0003A\u0011\u0001/\u0002[Q,7\u000f^#ySN$8oV5uQ:{g.R9vC2LG/_\"peJ,G.\u0019;j_:\u001cuN\u001c3ji&|g\u000eK\u0002\u0002.*Da!!.\u0001\t\u0003a\u0016!\u000b;fgR\u0014Vm\u001e:ji\u0016\u001c6-\u00197beF+XM]=XSRDw.\u001e;D_J\u0014X\r\\1uS>t\u0017\u0007K\u0002\u00024*Da!a/\u0001\t\u0003a\u0016!\u000b;fgR\u0014Vm\u001e:ji\u0016\u001c6-\u00197beF+XM]=XSRDw.\u001e;D_J\u0014X\r\\1uS>t'\u0007K\u0002\u0002:*Da!!1\u0001\t\u0003a\u0016!\u000b;fgR\u0014Vm\u001e:ji\u0016\u001c6-\u00197beF+XM]=XSRDw.\u001e;D_J\u0014X\r\\1uS>t7\u0007K\u0002\u0002@*Da!a2\u0001\t\u0003a\u0016A\n;fgR\u0014Vm\u001e:ji\u0016\u001c6-\u00197beF+XM]=XSRD7i\u001c:sK2\fG/[8oc!\u001a\u0011Q\u00196\t\r\u00055\u0007\u0001\"\u0001]\u0003\u0019\"Xm\u001d;SK^\u0014\u0018\u000e^3TG\u0006d\u0017M])vKJLx+\u001b;i\u0007>\u0014(/\u001a7bi&|gN\r\u0015\u0004\u0003\u0017T\u0007BBAj\u0001\u0011\u0005A,\u0001\u0014uKN$(+Z<sSR,7kY1mCJ\fV/\u001a:z/&$\bnQ8se\u0016d\u0017\r^5p]NB3!!5kQ\u001d\u0001\u0011\u0011\\As\u0003O\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?\u0004\u0017!C3yi\u0016t7/[8o\u0013\u0011\t\u0019/!8\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0002j\u000e\u0012\u00111\u001e\t\u0004\u001f\u00065\u0018bAAx!\nQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u001e9\u00111\u001f\u0002\t\u0002\u0005U\u0018AD*f[&Tu.\u001b8J)\u000e\u000b7/\u001a\t\u0004A\u0005]hAB\u0001\u0003\u0011\u0003\tIp\u0005\u0003\u0002x\u0006m\bc\u0001#\u0002~&\u0019\u0011q`#\u0003\r\u0005s\u0017PU3g\u0011\u001di\u0012q\u001fC\u0001\u0005\u0007!\"!!>\t\u0011\t\u001d\u0011q\u001fC\u0001\u0005\u0013\t!\u0002]1sC6,G/\u001a:t)\t\u0011Y\u0001\u0005\u0004\u0003\u000e\t]!1D\u0007\u0003\u0005\u001fQAA!\u0005\u0003\u0014\u0005!Q\u000f^5m\u0015\t\u0011)\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\r\u0005\u001f\u0011!bQ8mY\u0016\u001cG/[8o!\r!%QD\u0005\u0004\u0005?)%aA!os\"B!Q\u0001B\u0012\u0005S\u0011Y\u0003E\u0002P\u0005KI1Aa\nQ\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0003.\u0005!R\r\u001f9fGR,GMS8j]RK\b/Z\u001f|auD1B!\r\u0002x\"\u0015\r\u0011\"\u0001\u00034\u0005)A.\u001a4u)V\u0011!Q\u0007\t\u0007\u0005o\u0011iD!\u0011\u000e\u0005\te\"b\u0001B\u001e\u000b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t}\"\u0011\b\u0002\u0004'\u0016\f\b\u0003\u0002B\"\u0005\u0013j!A!\u0012\u000b\u0007\t\u001dc\"A\u0003usB,7/\u0003\u0003\u0003L\t\u0015#a\u0001*po\"Y!qJA|\u0011\u000b\u0007I\u0011\u0001B\u001a\u0003\u0019\u0011\u0018n\u001a5u)\"Y!1KA|\u0011\u000b\u0007I\u0011\u0001B\u001a\u0003=\u0011\u0018n\u001a5u+:L\u0017/^3LKf$\u0006")
public class SemiJoinITCase
extends BatchTestBase {
    @Parameter
    private Enumeration.Value expectedJoinType;

    public static Seq<Row> rightUniqueKeyT() {
        return SemiJoinITCase$.MODULE$.rightUniqueKeyT();
    }

    public static Seq<Row> rightT() {
        return SemiJoinITCase$.MODULE$.rightT();
    }

    public static Seq<Row> leftT() {
        return SemiJoinITCase$.MODULE$.leftT();
    }

    @Parameters(name="expectedJoinType={0}")
    public static Collection<Object> parameters() {
        return SemiJoinITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("leftT", (Iterable<Row>)SemiJoinITCase$.MODULE$.leftT(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "a, b");
        this.registerCollection("rightT", (Iterable<Row>)SemiJoinITCase$.MODULE$.rightT(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "c, d");
        this.registerCollection("rightUniqueKeyT", (Iterable<Row>)SemiJoinITCase$.MODULE$.rightUniqueKeyT(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "c, d");
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testSingleConditionLeftSemi() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComposedConditionLeftSemi() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT WHERE b < d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSingleConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSingleUniqueConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM (SELECT DISTINCT c FROM rightT) WHERE a = c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComposedConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c AND b < d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComposedUniqueConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightUniqueKeyT WHERE a = c AND b < d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSemiJoinTranspose() {
        this.checkResult("SELECT a, b FROM (SELECT a, b, c FROM leftT, rightT WHERE a = c) lr WHERE lr.a > 0 AND lr.c IN (SELECT c FROM rightUniqueKeyT WHERE d > 1)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftSemi1() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftSemi2() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testFilterPushDownLeftSemi3() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftSemi1() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftSemi2() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftSemi3() {
        this.checkResult("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti1() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE c < 3)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti2() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT where c > 10)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti3() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND c < 3)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti4() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti1() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti2() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti3() {
        this.checkResult("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND b > 1)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti4() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithAggregate1() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) FROM leftT WHERE b = d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithAggregate2() {
        this.checkResult("SELECT * FROM leftT t1 WHERE a IN (SELECT DISTINCT a FROM leftT t2 WHERE t1.b = t2.b)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithAggregate3() {
        this.checkResult("SELECT * FROM rightT WHERE CAST(c/2 AS BIGINT) IN (SELECT COUNT(*) FROM leftT WHERE b = d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver1() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER (PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver2() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER(PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT GROUP BY a, b)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver3() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER (PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT WHERE b = d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver4() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER(PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT WHERE b = d GROUP BY a, b)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testExistsWithOver1() {
        this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b = d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testExistsWithOver2() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b > d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testExistsWithOver3() {
        this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b = d GROUP BY a)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testExistsWithOver4() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b>d GROUP BY a)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition1() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT a FROM leftT WHERE b > d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition2() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM (SELECT MAX(c) AS c, d FROM rightT GROUP BY d) r WHERE leftT.b > r.d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition3() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM (SELECT MIN(c) OVER() AS c, d FROM rightT) r WHERE leftT.b <> r.d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition4() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM (SELECT MIN(c) OVER() AS c, d FROM rightT GROUP BY c, d) r WHERE leftT.b <> r.d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testExistsWithNonEqualityCorrelationCondition() {
        block0: {
            if (this.expectedJoinType() != JoinType$.MODULE$.NestedLoopJoin()) break block0;
            this.checkResult("SELECT * FROM leftT WHERE EXISTS (SELECT c FROM rightT WHERE b > d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)}))}))), this.checkResult$default$3());
        }
    }

    @TestTemplate
    public void testRewriteScalarQueryWithoutCorrelation1() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT)"}))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.checkResult(x$1, SemiJoinITCase$.MODULE$.leftT(), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithoutCorrelation2() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE c > 5)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE c > 5)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE c > 5)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE c > 5)"}))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.checkResult(x$2, SemiJoinITCase$.MODULE$.leftT(), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithoutCorrelation3() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE c > 15)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE c > 15)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE c > 15)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE c > 15)"}))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            this.checkResult(x$3, (Seq<Row>)((Seq)Seq$.MODULE$.empty()), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithCorrelation1() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE a = c)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE a = c)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE a = c)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE a = c)"}))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            this.checkResult(x$4, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithCorrelation2() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)"}))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            this.checkResult(x$5, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithCorrelation3() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)"}))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            this.checkResult(x$6, (Seq<Row>)((Seq)Seq$.MODULE$.empty()), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }
}

