/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func13;
import org.apache.flink.table.planner.expressions.utils.RichFunc1;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.expressions.utils.RichFunc3;
import org.apache.flink.table.planner.expressions.utils.SplitUDF;
import org.apache.flink.table.planner.runtime.batch.table.CalcITCase$;
import org.apache.flink.table.planner.runtime.batch.table.HashCode$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple8;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001I\u0011!bQ1mG&#6)Y:f\u0015\t\u0019A!A\u0003uC\ndWM\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005\rY!B\u0001\u0007\u000e\u0003\u00151G.\u001b8l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\tQ!\u001e;jYNL!\u0001G\u000b\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002\u0003}+\u0012!\t\t\u0004E\u001dJS\"A\u0012\u000b\u0005\u0011*\u0013!\u0003;fgR,H/\u001b7t\u0015\t13\"\u0001\u0003d_J,\u0017B\u0001\u0015$\u0005M)\u0015m\u00195DC2d'-Y2l/J\f\u0007\u000f]3s!\tQC&D\u0001,\u0015\t1\"\"\u0003\u0002.W\t\u0011B*Z4bGf\u0014vn^#yi\u0016t7/[8o\u0011\u0019y\u0003\u0001)A\u0005C\u0005\u0011q\f\t\u0015\u0003]E\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\u0013\u0015DH/\u001a8tS>t'B\u0001\u001c8\u0003\r\t\u0007/\u001b\u0006\u0003qe\nqA[;qSR,'O\u0003\u0002;\u001f\u0005)!.\u001e8ji&\u0011Ah\r\u0002\u0012%\u0016<\u0017n\u001d;fe\u0016CH/\u001a8tS>t\u0007\"\u0002 \u0001\t\u0003z\u0014A\u00022fM>\u0014X\rF\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011)f.\u001b;)\u0005u:\u0005C\u0001%J\u001b\u0005)\u0014B\u0001&6\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006\u0019\u0002!\taP\u0001\u0014i\u0016\u001cHoU5na2,7+\u001a7fGR\fE\u000e\u001c\u0015\u0003\u0017:\u0003\"\u0001S(\n\u0005A+$\u0001\u0002+fgRDQA\u0015\u0001\u0005\u0002}\n\u0011\u0004^3tiNKW\u000e\u001d7f'\u0016dWm\u0019;BY2<\u0016\u000e\u001e5Bg\"\u0012\u0011K\u0014\u0005\u0006+\u0002!\taP\u0001\u001bi\u0016\u001cHoU5na2,7+\u001a7fGR<\u0016\u000e\u001e5OC6Lgn\u001a\u0015\u0003):CQ\u0001\u0017\u0001\u0005\u0002}\n\u0011\u0004^3tiNKW\u000e\u001d7f'\u0016dWm\u0019;SK:\fW.Z!mY\"\u0012qK\u0014\u0005\u00067\u0002!\taP\u0001\u000fi\u0016\u001cHoU3mK\u000e$8\u000b^1sQ\tQf\nC\u0003_\u0001\u0011\u0005q(\u0001\fuKN$\u0018\t\u001c7SK*,7\r^5oO\u001aKG\u000e^3sQ\tif\nC\u0003b\u0001\u0011\u0005q(\u0001\u000buKN$\u0018\t\u001c7QCN\u001c\u0018N\\4GS2$XM\u001d\u0015\u0003A:CQ\u0001\u001a\u0001\u0005\u0002}\nA\u0004^3ti\u001aKG\u000e^3s\u001f:\u001cFO]5oOR+\b\u000f\\3GS\u0016dG\r\u000b\u0002d\u001d\")q\r\u0001C\u0001\u007f\u0005iB/Z:u\r&dG/\u001a:P]&sG/Z4feR+\b\u000f\\3GS\u0016dG\r\u000b\u0002g\u001d\")!\u000e\u0001C\u0001\u007f\u0005iA/Z:u\u001d>$X)];bYND#!\u001b(\t\u000b5\u0004A\u0011A \u00021Q,7\u000f\u001e#jg*,hn\u0019;jm\u0016\u0004&/\u001a3jG\u0006$X\r\u000b\u0002m\u001d\")\u0001\u000f\u0001C\u0001\u007f\u00051B/Z:u\u0007>t7/Z2vi&4XMR5mi\u0016\u00148\u000f\u000b\u0002p\u001d\")1\u000f\u0001C\u0001\u007f\u0005\u0019B/Z:u\r&dG/\u001a:CCNL7\rV=qK\"\u0012!O\u0014\u0005\u0006m\u0002!\taP\u0001\u0017i\u0016\u001cHOR5mi\u0016\u0014xJ\\\"vgR|W\u000eV=qK\"\u0012QO\u0014\u0005\u0006s\u0002!\taP\u0001\u000fi\u0016\u001cHoU5na2,7)\u00197dQ\tAh\nC\u0003}\u0001\u0011\u0005q(\u0001\fuKN$8)\u00197d/&$\b\u000eV<p\r&dG/\u001a:tQ\tYh\nC\u0003\u0000\u0001\u0011\u0005q(A\fuKN$8)\u00197d/&$\b.Q4he\u0016<\u0017\r^5p]\"\u0012aP\u0014\u0005\u0007\u0003\u000b\u0001A\u0011A \u0002\u0019Q,7\u000f^\"bY\u000eTu.\u001b8)\u0007\u0005\ra\n\u0003\u0004\u0002\f\u0001!\taP\u0001\u0016i\u0016\u001cH/\u00113wC:\u001cW\r\u001a#bi\u0006$\u0016\u0010]3tQ\r\tIA\u0014\u0005\u0007\u0003#\u0001A\u0011A \u0002;Q,7\u000f^+tKJ$UMZ5oK\u0012\u001c6-\u00197be\u001a+hn\u0019;j_:D3!a\u0004O\u0011\u0019\t9\u0002\u0001C\u0001\u007f\u0005yB/Z:u\u001dVlWM]5d\u0003V$xnY1ti&s\u0017I]5uQ6,G/[2)\u0007\u0005Ua\n\u0003\u0004\u0002\u001e\u0001!\taP\u0001 i\u0016\u001cHOT;nKJL7-Q;u_\u000e\f7\u000f^%o\u0007>l\u0007/\u0019:jg>t\u0007fAA\u000e\u001d\"1\u00111\u0005\u0001\u0005\u0002}\n!\u0006^3tiV\u001bXM\u001d#fM&tW\rZ*dC2\f'OR;oGRLwN\\,ji\"\u0004\u0016M]1nKR,'\u000fK\u0002\u0002\"9Ca!!\u000b\u0001\t\u0003y\u0014!\r;fgR,6/\u001a:EK\u001aLg.\u001a3TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8XSRDG)[:ue&\u0014W\u000f^3e\u0007\u0006\u001c\u0007.\u001a\u0015\u0004\u0003Oq\u0005BBA\u0018\u0001\u0011\u0005q(\u0001\u0014uKN$X*\u001e7uSBdW-V:fe\u0012+g-\u001b8fIN\u001b\u0017\r\\1s\rVt7\r^5p]ND3!!\fO\u0011\u0019\t)\u0004\u0001C\u0001\u007f\u00059C/Z:u'\u000e\fG.\u0019:Gk:\u001cG/[8o\u0007>t7\u000f\u001e:vGR|'oV5uQB\u000b'/Y7tQ\r\t\u0019D\u0014\u0005\u0007\u0003w\u0001A\u0011A \u0002\u0017Q,7\u000f\u001e*poRK\b/\u001a\u0015\u0004\u0003sq\u0005BBA!\u0001\u0011\u0005q(A\u0007uKN$\u0018I\u001d:bsRK\b/\u001a\u0015\u0004\u0003\u007fq\u0005BBA$\u0001\u0011\u0005q(A\u0006uKN$X*\u00199UsB,\u0007fAA#\u001d\"1\u0011Q\n\u0001\u0005\u0002}\nA\u0003^3tiZ\u000bG.^3D_:\u001cHO];di>\u0014\bfAA&\u001d\"1\u00111\u000b\u0001\u0005\u0002}\nQ\u0004^3tiN+G.Z2u'R\f'O\u0012:p[:+7\u000f^3e)\u0006\u0014G.\u001a\u0015\u0004\u0003#r\u0005BBA-\u0001\u0011\u0005q(A\u0011uKN$h)\u001e8di&|gnV5uQVs\u0017nY8eKB\u000b'/Y7fi\u0016\u00148\u000fK\u0002\u0002X9Ca!a\u0018\u0001\t\u0003y\u0014a\u0007;fgR\u001c\u0006\u000f\\5u\r&,G\u000eZ:P]\u000e+8\u000f^8n)f\u0004X\rK\u0002\u0002^9Ca!!\u001a\u0001\t\u0003y\u0014a\u0005;fgR\u001cUO\u001d:f]R$\u0015\r^1cCN,\u0007fAA2\u001d\u0002")
public class CalcITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
    }

    @Test
    public void testSimpleSelectAll() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))});
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectAllWithAs() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectWithNaming() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).as((Symbol)SymbolLiteral.bootstrap("apply", "b"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectRenameAll() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).as((Symbol)SymbolLiteral.bootstrap("apply", "b"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSelectStar() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "*"))});
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAllRejectingFilter() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.boolean2Literal(false));
        String expected = "\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAllPassingFilter() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true));
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnStringTupleField() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%world%")));
        String expected = "3,2,Hello world\n4,3,Hello world, how are you?\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnIntegerTupleField() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)));
        String expected = "2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNotEquals() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)));
        String expected = "1,1,Hi\n3,2,Hello world\n5,3,I am fine.\n7,4,Comment#1\n9,4,Comment#3\n11,5,Comment#5\n13,5,Comment#7\n15,5,Comment#9\n17,6,Comment#11\n19,6,Comment#13\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDisjunctivePredicate() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$bar$bar(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(20))));
        String expected = "1,1,Hi\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testConsecutiveFilters() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0))).filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)));
        String expected = "3,2,Hello world\n7,4,Comment#1\n9,4,Comment#3\n17,6,Comment#11\n19,6,Comment#13\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterBasicType() {
        Table ds = CollectionBatchExecTable$.MODULE$.getStringDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getStringDataSet$default$2());
        Table filterDs = ds.filter((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("H%")));
        String expected = "Hi\nHello\nHello world\nHello world, how are you?\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnCustomType() {
        Table filterDs = CollectionBatchExecTable$.MODULE$.getCustomTypeDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getCustomTypeDataSet$default$2()).filter((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "myString")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%a%")));
        String expected = "3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleCalc() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(7))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))});
        String expected = "1,Hi\n2,Hello\n3,Hello world\n4,Hello world, how are you?\n5,I am fine.\n6,Luke Skywalker\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCalcWithTwoFilters() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}).where(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(7))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(3)))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(4))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1"))});
        String expected = "4\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCalcWithAggregation() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(15))).groupBy(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}).select(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).min(), org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(3)));
        String expected = "7,4\n11,4\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCalcJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).join(ds2).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(2)));
        String expected = "2,2\n3,2\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAdvancedDataTypes() {
        BigDecimal bd1 = package$.MODULE$.BigDecimal().apply("78.454654654654654").bigDecimal();
        BigDecimal bd2 = package$.MODULE$.BigDecimal().apply("4E+16").bigDecimal();
        Table t = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)bd1, (Object)bd2, (Object)Date.valueOf("1984-07-12"), (Object)Time.valueOf("14:34:24"), (Object)Timestamp.valueOf("1984-07-12 14:34:24"))})), "_1, _2, _3, _4, _5", ClassTag$.MODULE$.apply(Tuple5.class), new CaseClassTypeInfo<Tuple5<BigDecimal, BigDecimal, Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<BigDecimal, BigDecimal, Date, Time, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<BigDecimal, BigDecimal, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<BigDecimal, BigDecimal, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple5<BigDecimal, BigDecimal, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)((BigDecimal)fields[0]), (Object)((BigDecimal)fields[1]), (Object)((Date)fields[2]), (Object)((Time)fields[3]), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<BigDecimal, BigDecimal, Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")), org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("11.2")), org.apache.flink.table.api.package$.MODULE$.javaDec2Literal(package$.MODULE$.BigDecimal().apply("11.2").bigDecimal()), org.apache.flink.table.api.package$.MODULE$.sqlDate2Literal(Date.valueOf("1984-07-12")), org.apache.flink.table.api.package$.MODULE$.sqlTime2Literal(Time.valueOf("14:34:24")), org.apache.flink.table.api.package$.MODULE$.sqlTimestamp2Literal(Timestamp.valueOf("1984-07-12 14:34:24"))});
        BigDecimal bd1x = bd1.setScale(DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getScale());
        BigDecimal bd2x = bd2.setScale(DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getScale());
        String expected = new StringBuilder(91).append(bd1x).append(",").append(bd2x).append(",1984-07-12,14:34:24,1984-07-12T14:34:24,").append("11.2,11.2,1984-07-12,14:34:24,1984-07-12T14:34:24").toString();
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedScalarFunction() {
        Table table = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}), ClassTag$.MODULE$.apply(String.class), BasicTypeInfo.getInfoFor(String.class));
        Table result = table.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)HashCode$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)}))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "97\n98\n99";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNumericAutocastInArithmetic() {
        Table table = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple8[]{new Tuple8((Object)BoxesRunTime.boxToByte((byte)((byte)1)), (Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1001.1))}), ClassTag$.MODULE$.apply(Tuple8.class), new CaseClassTypeInfo<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, Object, Object, Object, Object, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[6])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).$plus(org.apache.flink.table.api.package$.MODULE$.long2Literal(1L)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).$plus(org.apache.flink.table.api.package$.MODULE$.float2Literal(1.0f)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).$plus(org.apache.flink.table.api.package$.MODULE$.double2Literal(1.0)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).$plus(org.apache.flink.table.api.package$.MODULE$.double2Literal(1.0)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_8")).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")))});
        Seq<Row> results = this.executeQuery(table);
        String expected = "2,2,2,2.0,2.0,2.0,2.0,1002.1";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNumericAutocastInComparison() {
        Table table = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToByte((byte)((byte)1)), (Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple6((Object)BoxesRunTime.boxToByte((byte)((byte)2)), (Object)BoxesRunTime.boxToShort((short)((short)2)), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0))})), "a, b, c, d, e, f", ClassTag$.MODULE$.apply(Tuple6.class), new CaseClassTypeInfo<Tuple6<Object, Object, Object, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple6<Object, Object, Object, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple6<Object, Object, Object, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple6<Object, Object, Object, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple6<Object, Object, Object, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple6((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple6<Object, Object, Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).$greater(org.apache.flink.table.api.package$.MODULE$.long2Literal(1L)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$greater(org.apache.flink.table.api.package$.MODULE$.float2Literal(1.0f)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$greater(org.apache.flink.table.api.package$.MODULE$.double2Literal(1.0)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))));
        Seq<Row> results = this.executeQuery(table);
        String expected = "2,2,2,2,2.0,2.0";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedScalarFunctionWithParameter() {
        this.tEnv().createTemporarySystemFunction("RichFunc2", (UserDefinedFunction)new RichFunc2());
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"ABC")}))));
        Table ds = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        this.tEnv().createTemporaryView("t1", ds);
        String sqlQuery = "SELECT c FROM t1 where RichFunc2(c)='ABC#Hello'";
        Table result = this.tEnv().sqlQuery(sqlQuery);
        String expected = "Hello";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedScalarFunctionWithDistributedCache() {
        String words = "Hello\nWord";
        String filePath = UserDefinedFunctionTestUtils$.MODULE$.writeCacheFile("test_words", words);
        this.env().registerCachedFile(filePath, "words");
        this.tEnv().createTemporarySystemFunction("RichFunc3", (UserDefinedFunction)new RichFunc3());
        Table ds = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        this.tEnv().createTemporaryView("t1", ds);
        String sqlQuery = "SELECT c FROM t1 where RichFunc3(c)=true";
        Table result = this.tEnv().sqlQuery(sqlQuery);
        String expected = "Hello";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMultipleUserDefinedScalarFunctions() {
        this.tEnv().createTemporarySystemFunction("RichFunc1", (UserDefinedFunction)new RichFunc1());
        this.tEnv().createTemporarySystemFunction("RichFunc2", (UserDefinedFunction)new RichFunc2());
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"Abc")}))));
        Table ds = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        this.tEnv().createTemporaryView("t1", ds);
        String sqlQuery = "SELECT c FROM t1 where RichFunc2(c)='Abc#Hello' or RichFunc1(a)=3 and b=2";
        Table result = this.tEnv().sqlQuery(sqlQuery);
        String expected = "Hello\nHello world";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testScalarFunctionConstructorWithParams() {
        .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"), (List)Nil$.MODULE$))));
        Table in = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Func13 func0 = new Func13("default");
        Func13 func1 = new Func13("Sunny");
        Func13 func2 = new Func13("kevin2");
        Table result = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "default-Anna#44,Sunny-Anna#44,kevin2-Anna#44\ndefault-Jack#22,Sunny-Jack#22,kevin2-Jack#22\ndefault-John#19,Sunny-John#19,kevin2-John#19\ndefault-nosharp,Sunny-nosharp,kevin2-nosharp";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowType() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        Table in = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table result1 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("Hi"), org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true)}))});
        this.executeQuery(result1).foreach((Function1 & Serializable & scala.Serializable)record -> {
            Row row = (Row)record.getField(0);
            Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)BoxesRunTime.boxToInteger((int)1));
            Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)"Hi");
            return (ObjectAssert)Assertions.assertThat((Object)row.getField(2)).isEqualTo((Object)BoxesRunTime.boxToBoolean((boolean)true));
        });
        Table result2 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))});
        ((IterableLike)this.executeQuery(result2).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Row record = (Row)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            Row row = (Row)record.getField(0);
            Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)BoxesRunTime.boxToInteger((int)1));
            Assertions.assertThat((Object)row.getField(1)).isEqualTo(((Tuple3)data.apply(idx))._1());
            ObjectAssert objectAssert = (ObjectAssert)Assertions.assertThat((Object)row.getField(2)).isEqualTo(((Tuple3)data.apply(idx))._2());
            return objectAssert;
        });
        DecimalData d = DecimalDataUtils.castFrom((double)2.0002, (int)5, (int)4);
        Table result3 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply(2.0002)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))});
        ((IterableLike)this.executeQuery(result3).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Row record = (Row)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            Row row = (Row)record.getField(0);
            Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)d.toBigDecimal());
            Assertions.assertThat((Object)row.getField(1)).isEqualTo(((Tuple3)data.apply(idx))._1());
            ObjectAssert objectAssert = (ObjectAssert)Assertions.assertThat((Object)row.getField(2)).isEqualTo(((Tuple3)data.apply(idx))._3());
            return objectAssert;
        });
    }

    @Test
    public void testArrayType() {
        Table in = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table t1 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.string2Literal("Hi"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("Hello"), org.apache.flink.table.api.package$.MODULE$.string2Literal("How are you")}))});
        Seq<Row> result1 = this.executeQuery(t1);
        String expected1 = "[Hi, Hello, How are you]\n[Hi, Hello, How are you]\n[Hi, Hello, How are you]\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result1).asJava()), (String)expected1);
        Table t2 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(30), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.int2Literal(10)}))});
        Seq<Row> result2 = this.executeQuery(t2);
        String expected2 = "[30, 1, 10]\n[30, 2, 10]\n[30, 3, 10]\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result2).asJava()), (String)expected2);
        Table t3 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.string2Literal("Test"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}))});
        Seq<Row> result3 = this.executeQuery(t3);
        String expected3 = "[Test, Hi]\n[Test, Hello]\n[Test, Hello world]\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result3).asJava()), (String)expected3);
    }

    @Test
    public void testMapType() {
        Table in = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table t1 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), org.apache.flink.table.api.package$.MODULE$.string2Literal("Hello"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(2), org.apache.flink.table.api.package$.MODULE$.string2Literal("Hi")}))});
        Seq<Row> result1 = this.executeQuery(t1);
        String expected1 = "{1=Hello, 2=Hi}\n{1=Hello, 2=Hi}\n{1=Hello, 2=Hi}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result1).asJava()), (String)expected1);
        Table t2 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), org.apache.flink.table.api.package$.MODULE$.int2Literal(30), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.long2Literal(10L), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1"))}))});
        Seq<Row> result2 = this.executeQuery(t2);
        String expected2 = "{1=30, 10=1}\n{2=30, 10=2}\n{2=30, 10=3}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result2).asJava()), (String)expected2);
        Table t3 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))});
        Seq<Row> result3 = this.executeQuery(t3);
        String expected3 = "{1=Hi}\n{2=Hello}\n{3=Hello world}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result3).asJava()), (String)expected3);
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"AAA", (Object)package$.MODULE$.BigDecimal().valueOf(123.45), (Object)"BBB", (Object)package$.MODULE$.BigDecimal().valueOf(234.56)));
        data.$plus$eq((Object)new Tuple4((Object)"CCC", (Object)package$.MODULE$.BigDecimal().valueOf(345.67), (Object)"DDD", (Object)package$.MODULE$.BigDecimal().valueOf(456.78)));
        data.$plus$eq((Object)new Tuple4((Object)"EEE", (Object)package$.MODULE$.BigDecimal().valueOf(567.89), (Object)"FFF", (Object)package$.MODULE$.BigDecimal().valueOf(678.99)));
        Table t4 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c, d", ClassTag$.MODULE$.apply(Tuple4.class), new CaseClassTypeInfo<Tuple4<String, scala.math.BigDecimal, String, scala.math.BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, scala.math.BigDecimal, String, scala.math.BigDecimal>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, scala.math.BigDecimal, String, scala.math.BigDecimal>> unused = new ScalaCaseClassSerializer<Tuple4<String, scala.math.BigDecimal, String, scala.math.BigDecimal>>(this, fieldSerializers){

                    public Tuple4<String, scala.math.BigDecimal, String, scala.math.BigDecimal> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((scala.math.BigDecimal)fields[1]), (Object)((String)fields[2]), (Object)((scala.math.BigDecimal)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<String, scala.math.BigDecimal, String, scala.math.BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$17 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))});
        Seq<Row> result4 = this.executeQuery(t4);
        String expected4 = "{AAA=123.45, BBB=234.56}\n{CCC=345.67, DDD=456.78}\n{EEE=567.89, FFF=678.99}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result4).asJava()), (String)expected4);
    }

    @Test
    public void testValueConstructor() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)"foo", (Object)BoxesRunTime.boxToInteger((int)12), (Object)DateTimeTestUtil$.MODULE$.localDateTime("1984-07-12 14:34:24")));
        Table t = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<String, Object, LocalDateTime>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, LocalDateTime>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, LocalDateTime>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, LocalDateTime>>(this, fieldSerializers){

                    public Tuple3<String, Object, LocalDateTime> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((LocalDateTime)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, LocalDateTime>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$18 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(12), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))});
        Seq<Row> result = this.executeQuery(t);
        Row nestedRow = (Row)((Row)result.head()).getField(0);
        Assertions.assertThat((Object)nestedRow.getField(0)).isEqualTo(((Tuple3)data.head())._1());
        Assertions.assertThat((Object)nestedRow.getField(1)).isEqualTo(((Tuple3)data.head())._2());
        Assertions.assertThat((Object)nestedRow.getField(2)).isEqualTo(((Tuple3)data.head())._3());
        Integer[] arr = (Integer[])((Row)result.head()).getField(1);
        Assertions.assertThat((Integer)arr[0]).isEqualTo(12);
        Assertions.assertThat((Integer)arr[1]).isEqualTo(BoxesRunTime.unboxToInt((Object)((Tuple3)data.head())._2()));
        HashMap hashMap = (HashMap)((Row)result.head()).getField(2);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)((Tuple3)data.head())._3())).isEqualTo(hashMap.get((String)((Tuple3)data.head())._1()));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        Table table = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2")})), ClassTag$.MODULE$.apply(Tuple2.class), new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$19 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "*"))});
        Seq<Row> results = this.executeQuery(table);
        ((IterableLike)results.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Row row = (Row)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 nestedRow = (Tuple2)row.getField(0);
            Assertions.assertThat((int)nestedRow._1$mcI$sp()).isEqualTo(i);
            Assertions.assertThat((int)nestedRow._2$mcI$sp()).isEqualTo(i);
            ObjectAssert objectAssert = (ObjectAssert)Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString());
            return objectAssert;
        });
    }

    @Test
    public void testFunctionWithUnicodeParameters() {
        .colon.colon data = new .colon.colon((Object)new Tuple3((Object)"a\u0001b", (Object)"c\"d", (Object)"e\\\"\u0004f"), (List)new .colon.colon((Object)new Tuple3((Object)"x\u0001y", (Object)"y\"z", (Object)"z\\\"\u0004z"), (List)Nil$.MODULE$));
        SplitUDF splitUDF0 = new SplitUDF(true);
        SplitUDF splitUDF1 = new SplitUDF(false);
        Table ds = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.planner.runtime.batch.table.CalcITCase$$anon$22 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.string2Literal("\u0001"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as((Symbol)SymbolLiteral.bootstrap("apply", "a0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.string2Literal("\u0001"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as((Symbol)SymbolLiteral.bootstrap("apply", "a1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.string2Literal("\""), org.apache.flink.table.api.package$.MODULE$.int2Literal(1)}))).as((Symbol)SymbolLiteral.bootstrap("apply", "b0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.string2Literal("\""), org.apache.flink.table.api.package$.MODULE$.int2Literal(1)}))).as((Symbol)SymbolLiteral.bootstrap("apply", "b1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), org.apache.flink.table.api.package$.MODULE$.string2Literal("\\\"\u0004"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as((Symbol)SymbolLiteral.bootstrap("apply", "c0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), org.apache.flink.table.api.package$.MODULE$.string2Literal("\\\"\u0004"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        Seq<Row> results = this.executeQuery(ds);
        String expected = new .colon.colon((Object)"a,a,d,d,e,e", (List)new .colon.colon((Object)"x,x,z,z,z,z", (List)Nil$.MODULE$)).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSplitFieldsOnCustomType() {
        this.tEnv().getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        Table ds = CollectionBatchExecTable$.MODULE$.getCustomTypeDataSet(this.tEnv(), "myInt, myLong, myString").filter(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "myString")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%a%"))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "myString")).charLength()).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(12)))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "myInt")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "myLong")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "myString")).charLength()});
        String expected = "3,3,25\n3,5,14\n";
        Seq<Row> results = this.executeQuery(ds);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCurrentDatabase() {
        Seq<Row> result1 = this.executeQuery(this.tEnv().from("Table3").limit(1).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.currentDatabase()}));
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result1).asJava()), (String)"default_database");
        ((Catalog)this.tEnv().getCatalog(this.tEnv().getCurrentCatalog()).get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1"), false);
        this.tEnv().useDatabase("db1");
        Seq<Row> result2 = this.executeQuery(this.tEnv().from("default_database.Table3").limit(1).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.currentDatabase()}));
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result1).asJava()), (String)"default_database");
    }
}

