/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.Func18$;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.runtime.batch.table.CorrelateITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.HierarchyTableFunction;
import org.apache.flink.table.planner.utils.PojoTableFunc;
import org.apache.flink.table.planner.utils.RichTableFunc1;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableFunc3;
import org.apache.flink.table.planner.utils.TableFunc4;
import org.apache.flink.table.planner.utils.VarArgsFunc0;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001I\u0011qbQ8se\u0016d\u0017\r^3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\u0004\u0017)\u0011A\"D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003\u0015)H/\u001b7t\u0013\tARCA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAqa\b\u0001C\u0002\u0013%\u0001%A\u0001`+\u0005\t\u0003c\u0001\u0012(S5\t1E\u0003\u0002%K\u0005IA/Z:ukRLGn\u001d\u0006\u0003M-\tAaY8sK&\u0011\u0001f\t\u0002\u0014\u000b\u0006\u001c\u0007nQ1mY\n\f7m[,sCB\u0004XM\u001d\t\u0003U1j\u0011a\u000b\u0006\u0003-)I!!L\u0016\u0003%1+w-Y2z%><X\t\u001f;f]NLwN\u001c\u0005\u0007_\u0001\u0001\u000b\u0011B\u0011\u0002\u0005}\u0003\u0003F\u0001\u00182!\t\u00114(D\u00014\u0015\t!T'A\u0005fqR,gn]5p]*\u0011agN\u0001\u0004CBL'B\u0001\u001d:\u0003\u001dQW\u000f]5uKJT!AO\b\u0002\u000b),h.\u001b;\n\u0005q\u001a$!\u0005*fO&\u001cH/\u001a:FqR,gn]5p]\")a\b\u0001C\u0001\u007f\u0005iA/Z:u\u0007J|7o\u001d&pS:$\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0005+:LG\u000f\u000b\u0002>\u000fB\u0011\u0001*S\u0007\u0002k%\u0011!*\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003M\u0001\u0011\u0005q(\u0001\u0012uKN$H*\u001a4u\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5pkR\u0004&/\u001a3jG\u0006$Xm\u001d\u0015\u0003\u0017\u001eCQa\u0014\u0001\u0005\u0002}\n!\u0004^3ti2+g\r^(vi\u0016\u0014(j\\5o/&$\bn\u00159mSRD#AT$\t\u000bI\u0003A\u0011A \u0002?Q,7\u000f\u001e'fMR|U\u000f^3s\u0015>LgnV5uQB\u0013X\rZ5dCR,7\u000f\u000b\u0002R\u000f\")Q\u000b\u0001C\u0001\u007f\u0005qA/Z:u/&$\bNR5mi\u0016\u0014\bF\u0001+H\u0011\u0015A\u0006\u0001\"\u0001@\u0003Q!Xm\u001d;DkN$x.\u001c*fiV\u0014h\u000eV=qK\"\u0012qk\u0012\u0005\u00067\u0002!\taP\u0001\u0012i\u0016\u001cH\u000fS5fe\u0006\u00148\r[=UsB,\u0007F\u0001.H\u0011\u0015q\u0006\u0001\"\u0001@\u00031!Xm\u001d;Q_*|G+\u001f9fQ\tiv\tC\u0003b\u0001\u0011\u0005q(\u0001\u0018uKN$Xk]3s\t\u00164\u0017N\\3e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8XSRD7kY1mCJ4UO\\2uS>t\u0007F\u00011H\u0011\u0015!\u0007\u0001\"\u0001@\u0003e\"Xm\u001d;Vg\u0016\u0014H)\u001a4j]\u0016$G+\u00192mK\u001a+hn\u0019;j_:<\u0016\u000e\u001e5TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8J]\u000e{g\u000eZ5uS>t\u0007FA2H\u0011\u00159\u0007\u0001\"\u0001@\u0003a!Xm\u001d;M_:<\u0017I\u001c3UK6\u0004xN]1m)f\u0004Xm\u001d\u0015\u0003M\u001eCQA\u001b\u0001\u0005\u0002}\n1\u0004^3ti\nKH/Z*i_J$h\t\\8bi\u0006\u0013x-^7f]R\u001c\bFA5H\u0011\u0015i\u0007\u0001\"\u0001@\u0003%\"Xm\u001d;Vg\u0016\u0014H)\u001a4j]\u0016$G+\u00192mK\u001a+hn\u0019;j_:<\u0016\u000e\u001e5QCJ\fW.\u001a;fe\"\u0012An\u0012\u0005\u0006a\u0002!\taP\u0001=i\u0016\u001cH/V:fe\u0012+g-\u001b8fIR\u000b'\r\\3Gk:\u001cG/[8o/&$\bnU2bY\u0006\u0014h)\u001e8di&|gnV5uQB\u000b'/Y7fi\u0016\u00148\u000f\u000b\u0002p\u000f\")1\u000f\u0001C\u0001\u007f\u00051C/Z:u)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8D_:\u001cHO];di>\u0014x+\u001b;i!\u0006\u0014\u0018-\\:)\u0005I<\u0005\"\u0002<\u0001\t\u0003y\u0014A\n;fgR$\u0016M\u00197f\rVt7\r^5p]^KG\u000f\u001b,be&\f'\r\\3Be\u001e,X.\u001a8ug\"\u0012Qo\u0012\u0005\u0006s\u0002!\taP\u0001\u0019i\u0016\u001cHoQ8v]R\u001cF/\u0019:P]\u000e{'O]3mCR,\u0007F\u0001=H\u0011\u0015a\b\u0001\"\u0001@\u0003q!Xm\u001d;D_VtGo\u0015;be>sG*\u001a4u\u0007>\u0014(/\u001a7bi\u0016D#a_$\t\u000b}\u0004A\u0011A \u0002GQ,7\u000f\u001e+bE2,g)\u001e8di&|gnQ8mY\u0016\u001cGo\u001c:Pa\u0016t7\t\\8tK\"\u0012ap\u0012\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0003!!Xm\u001d;ECR\fWCAA\u0005!\u0011\tY!a\u0004\u000e\u0005\u00055!B\u0001\u001c\u000b\u0013\u0011\t\t\"!\u0004\u0003\u000bQ\u000b'\r\\3")
public class CorrelateITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testCrossJoin() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc1 func1 = new TableFunc1();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack\nJack#22,22\nJohn#19,John\nJohn#19,19\nAnna#44,Anna\nAnna#44,44\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        Table result2 = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.string2Literal("$")}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results2 = this.executeQuery(result2);
        String expected2 = "Jack#22,$Jack\nJack#22,$22\nJohn#19,$John\nJohn#19,$19\nAnna#44,$Anna\nAnna#44,$44\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results2).asJava()), (String)expected2);
    }

    @Test
    public void testLeftOuterJoinWithoutPredicates() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,4\nJack#22,22,2\nJohn#19,John,4\nJohn#19,19,2\nAnna#44,Anna,4\nAnna#44,44,2\nnosharp,null,null";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftOuterJoinWithSplit() {
        this.tEnv().getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,4\nJack#22,22,2\nJohn#19,John,4\nJohn#19,19,2\nAnna#44,Anna,4\nAnna#44,44,2\nnosharp,null,null";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftOuterJoinWithPredicates() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Assertions.assertThatThrownBy(() -> {
            Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
            Seq<Row> results = this.executeQuery(result);
            String expected = "John#19,19,2\nnosharp,null,null";
            TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testWithFilter() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "age")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}).filter(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")).$greater(package$.MODULE$.int2Literal(20)));
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,22\nAnna#44,Anna,44\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCustomReturnType() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "len")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,4\nJack#22,22,2\nJohn#19,John,4\nJohn#19,19,2\nAnna#44,Anna,4\nAnna#44,44,2\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testHierarchyType() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        HierarchyTableFunction hierarchy = new HierarchyTableFunction();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)hierarchy).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "adult"), SymbolLiteral.bootstrap("apply", "len")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "adult")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,true,22\nJohn#19,John,false,19\nAnna#44,Anna,true,44\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testPojoType() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        PojoTableFunc pojo = new PojoTableFunc();
        Table result = in.joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)pojo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,22\nAnna#44,Anna,44\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunction() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc1 func1 = new TableFunc1();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).substring((Object)package$.MODULE$.int2Literal(2))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,ack\nJack#22,22\nJohn#19,ohn\nJohn#19,19\nAnna#44,nna\nAnna#44,44\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionInCondition() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).where(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func18$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.string2Literal("J")}))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func1$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).$less(package$.MODULE$.int2Literal(3)))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func1$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}))).$greater(package$.MODULE$.int2Literal(20)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,22";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLongAndTemporalTypes() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        JavaUserDefinedTableFunctions.JavaTableFunc0 func0 = new JavaUserDefinedTableFunctions.JavaTableFunc0();
        Table result = in.where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.int2Literal(1))).select(new Expression[]{package$.MODULE$.LiteralSqlDateExpression(Date.valueOf("1990-10-14")).as((Symbol)SymbolLiteral.bootstrap("apply", "x"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.LiteralLongExpression(1000L).as((Symbol)SymbolLiteral.bootstrap("apply", "y"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.LiteralSqlTimestampExpression(Timestamp.valueOf("1990-10-14 12:10:10")).as((Symbol)SymbolLiteral.bootstrap("apply", "z"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "1000\n655906210000\n7591\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testByteShortFloatArguments() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc4 tFunc = new TableFunc4();
        Table result = in.select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.TINYINT())).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.SMALLINT())).as((Symbol)SymbolLiteral.bootstrap("apply", "b"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast(DataTypes.FLOAT())).as((Symbol)SymbolLiteral.bootstrap("apply", "c"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tFunc).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).ifNull((Object)package$.MODULE$.byte2Literal((byte)0)), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).ifNull((Object)package$.MODULE$.short2Literal((short)0)), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).ifNull((Object)package$.MODULE$.float2Literal(0.0f))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "a2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "b2"), SymbolLiteral.bootstrap("apply", "c2")})));
        Seq<Row> results = this.executeQuery(result);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1.0,Byte=1,Short=1,Float=1.0", "2,2,2.0,Byte=2,Short=2,Float=2.0", "3,3,2.0,Byte=3,Short=3,Float=2.0", "4,4,3.0,Byte=4,Short=4,Float=3.0"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithParameter() {
        RichTableFunc1 richTableFunc1 = new RichTableFunc1();
        this.tEnv().createTemporarySystemFunction("RichTableFunc1", (UserDefinedFunction)richTableFunc1);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)"#")}))));
        Table result = this.testData().joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)richTableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        String expected = "1,Jack\n1,22\n2,John\n2,19\n3,Anna\n3,44";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionWithParameters() {
        RichTableFunc1 richTableFunc1 = new RichTableFunc1();
        this.tEnv().createTemporarySystemFunction("RichTableFunc1", (UserDefinedFunction)richTableFunc1);
        RichFunc2 richFunc2 = new RichFunc2();
        this.tEnv().createTemporarySystemFunction("RichFunc2", (UserDefinedFunction)richFunc2);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)"#"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"test")}))));
        Table result = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c").joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)richTableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.ScalarFunctionCall((ScalarFunction)richFunc2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        String expected = "1,Hi\n1,test\n2,Hello\n2,test\n3,Hello world\n3,test";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableFunctionConstructorWithParams() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc3 func30 = new TableFunc3(null);
        TableFunc3 func31 = new TableFunc3("OneConf_");
        TableFunc3 func32 = new TableFunc3("TwoConf_");
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func30).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func31).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "f"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "g")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func32).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "h"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "i")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Anna#44,Anna,OneConf_Anna,TwoConf_Anna,44,44,44\nJack#22,Jack,OneConf_Jack,TwoConf_Jack,22,22,22\nJohn#19,John,OneConf_John,TwoConf_John,19,19,19\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableFunctionWithVariableArguments() {
        VarArgsFunc0 varArgsFunc0 = new VarArgsFunc0();
        this.tEnv().createTemporarySystemFunction("VarArgsFunc0", (UserDefinedFunction)varArgsFunc0);
        Table result = this.testData().select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("1"), package$.MODULE$.string2Literal("2"), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
        String expected = "Anna#44,1\nAnna#44,2\nAnna#44,Anna#44\nJack#22,1\nJack#22,2\nJack#22,Jack#22\nJohn#19,1\nJohn#19,2\nJohn#19,John#19\nnosharp,1\nnosharp,2\nnosharp,nosharp";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        Table result0 = this.testData().select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Nil$.MODULE$));
        Seq<Row> results0 = this.executeQuery(result0);
        Assertions.assertThat((boolean)results0.isEmpty()).isTrue();
    }

    @Test
    public void testCountStarOnCorrelate() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "age")}))).select(new Expression[]{(Expression)package$.MODULE$.LiteralIntExpression(0).count()});
        Seq<Row> results = this.executeQuery(result);
        String expected = "3";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCountStarOnLeftCorrelate() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "age")}))).select(new Expression[]{(Expression)package$.MODULE$.LiteralIntExpression(0).count()});
        Seq<Row> results = this.executeQuery(result);
        String expected = "4";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableFunctionCollectorOpenClose() {
        Table t = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        FuncWithOpen func = new FuncWithOpen();
        Table result = t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)func).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))});
        Seq<Row> results = this.executeQuery(result);
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack#22,Jack,22", "John#19,John,19", "Anna#44,Anna,44"}));
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    private Table testData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        return BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.CorrelateITCase$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

