/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Enumeration;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001I\u0011!BS8j]&#6)Y:f\u0015\t\u0019A!A\u0003uC\ndWM\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005\rY!B\u0001\u0007\u000e\u0003\u00151G.\u001b8l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\tQ!\u001e;jYNL!\u0001G\u000b\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002\u0003}+\u0012!\t\t\u0004E\u001dJS\"A\u0012\u000b\u0005\u0011*\u0013!\u0003;fgR,H/\u001b7t\u0015\t13\"\u0001\u0003d_J,\u0017B\u0001\u0015$\u0005M)\u0015m\u00195DC2d'-Y2l/J\f\u0007\u000f]3s!\tQC&D\u0001,\u0015\t1\"\"\u0003\u0002.W\t\u0011B*Z4bGf\u0014vn^#yi\u0016t7/[8o\u0011\u0019y\u0003\u0001)A\u0005C\u0005\u0011q\f\t\u0015\u0003]E\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\u0013\u0015DH/\u001a8tS>t'B\u0001\u001c8\u0003\r\t\u0007/\u001b\u0006\u0003qe\nqA[;qSR,'O\u0003\u0002;\u001f\u0005)!.\u001e8ji&\u0011Ah\r\u0002\u0012%\u0016<\u0017n\u001d;fe\u0016CH/\u001a8tS>t\u0007b\u0002 \u0001\u0005\u0004%\taP\u0001\u0011Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016,\u0012\u0001\u0011\t\u0003\u0003vs!A\u0011.\u000f\u0005\r;fB\u0001#V\u001d\t)EK\u0004\u0002G':\u0011qI\u0015\b\u0003\u0011Fs!!\u0013)\u000f\u0005){eBA&O\u001b\u0005a%BA'\u0012\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002\u000f\u001f%\u0011A\"D\u0005\u0003\u0007-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t1F!A\u0002tc2L!\u0001W-\u0002\t)|\u0017N\u001c\u0006\u0003-\u0012I!a\u0017/\u0002\u0011){\u0017N\u001c+za\u0016T!\u0001W-\n\u0005y{&\u0001\u0003&pS:$\u0016\u0010]3\u000b\u0005mc\u0006BB1\u0001A\u0003%\u0001)A\tfqB,7\r^3e\u0015>Lg\u000eV=qK\u0002BQa\u0019\u0001\u0005B\u0011\faAY3g_J,G#A3\u0011\u0005\u0019LW\"A4\u000b\u0003!\fQa]2bY\u0006L!A[4\u0003\tUs\u0017\u000e\u001e\u0015\u0003E2\u0004\"!\u001c8\u000e\u0003UJ!a\\\u001b\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003r\u0001\u0011\u0005A-\u0001\u0005uKN$(j\\5oQ\t\u00018\u000f\u0005\u0002ni&\u0011Q/\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003x\u0001\u0011\u0005A-A\u0005uKN$(j\\5oc!\u0012ao\u001d\u0005\u0006u\u0002!\t\u0001Z\u0001\u0013i\u0016\u001cHOS8j]^KG\u000f\u001b$jYR,'\u000f\u000b\u0002zg\")Q\u0010\u0001C\u0001I\u00061B/Z:u\u0015>LgnV5uQ*{\u0017N\u001c$jYR,'\u000f\u000b\u0002}g\"1\u0011\u0011\u0001\u0001\u0005\u0002\u0011\fQ\u0005^3ti&sg.\u001a:K_&tw+\u001b;i\u001d>tW)];j\u0015>Lg\u000e\u0015:fI&\u001c\u0017\r^3)\u0005}\u001c\bBBA\u0004\u0001\u0011\u0005A-\u0001\ruKN$(j\\5o/&$\b.T;mi&\u0004H.Z&fsND3!!\u0002t\u0011\u0019\ti\u0001\u0001C\u0001I\u00069B/Z:u\u0015>LgnV5uQ\u0006;wM]3hCRLwN\u001c\u0015\u0004\u0003\u0017\u0019\bBBA\n\u0001\u0011\u0005A-\u0001\u0010uKN$(j\\5o/&$\bn\u0012:pkB,G-Q4he\u0016<\u0017\r^5p]\"\u001a\u0011\u0011C:\t\r\u0005e\u0001\u0001\"\u0001e\u0003]!Xm\u001d;K_&t\u0007+^:i)\"\u0014x.^4i\u0015>Lg\u000eK\u0002\u0002\u0018MDa!a\b\u0001\t\u0003!\u0017a\u0007;fgRTu.\u001b8XSRDG)[:kk:\u001cG/\u001b<f!J,G\rK\u0002\u0002\u001eMDa!!\n\u0001\t\u0003!\u0017a\u0007;fgRTu.\u001b8XSRDW\t\u001f9sKN\u001c\u0018n\u001c8Qe\u0016$7\u000fK\u0002\u0002$MDa!a\u000b\u0001\t\u0003!\u0017\u0001\b;fgRdUM\u001a;K_&tw+\u001b;i\u001bVdG/\u001b9mK.+\u0017p\u001d\u0015\u0004\u0003S\u0019\bBBA\u0019\u0001\u0011\u0005A-A\u0010uKN$H*\u001a4u\u0015>LgnV5uQ:{g.R9vS*{\u0017N\u001c)sK\u0012D3!a\ft\u0011\u0019\t9\u0004\u0001C\u0001I\u0006iB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b'fMRdunY1m!J,G\rK\u0002\u00026MDa!!\u0010\u0001\t\u0003!\u0017!\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ6+H\u000e^5qY\u0016\\U-_:)\u0007\u0005m2\u000f\u0003\u0004\u0002D\u0001!\t\u0001Z\u0001!i\u0016\u001cHOU5hQRTu.\u001b8XSRDgj\u001c8FcVL'j\\5o!J,G\rK\u0002\u0002BMDa!!\u0013\u0001\t\u0003!\u0017A\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ2+g\r\u001e'pG\u0006d\u0007K]3eQ\r\t9e\u001d\u0005\u0007\u0003\u001f\u0002A\u0011\u00013\u0002CQ,7\u000f\u001e$vY2|U\u000f^3s\u0015>LgnV5uQ6+H\u000e^5qY\u0016\\U-_:)\u0007\u000553\u000f\u0003\u0004\u0002V\u0001!\t\u0001Z\u0001 i\u0016\u001cHOR;mY*{\u0017N\\,ji\"tuN\\#rk&Tu.\u001b8Qe\u0016$\u0007fAA*g\"1\u00111\f\u0001\u0005\u0002\u0011\fQ\u0004^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5MK\u001a$Hj\\2bYB\u0013X\r\u001a\u0015\u0004\u00033\u001a\bBBA1\u0001\u0011\u0005A-\u0001\u000buKN$X\u000b\u0012+G\u0015>Lgn\u00148UkBdWm\u001d\u0015\u0004\u0003?\u001a\b")
public class JoinITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    private final Enumeration.Value expectedJoinType = JoinType$.MODULE$.SortMergeJoin();

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @Test
    public void testJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoin1() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        FuncWithOpen testOpenCall = new FuncWithOpen();
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)testOpenCall).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithFilter() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2()).as("a", new String[]{"b", "c"});
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get5TupleDataSet$default$2()).as("d", new String[]{"e", "f", "g", "h"});
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithJoinFilter() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(6)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\nHello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithNonEquiJoinPredicate() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(6)))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq<Row> results = this.executeQuery(joinT);
        String expected = "Hello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nI am fine.,HIJ\nI am fine.,IJK\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithAggregation() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).count()});
        String expected = "6";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithGroupedAggregation() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).count()});
        String expected = "6,3\n4,2\n1,1";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinPushThroughJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "j, k, l");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.boolean2Literal(true)).join(ds3).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        String expected = "2,1,Hello\n2,1,Hello world\n1,0,Hi";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithDisjunctivePred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$bar$bar(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$minus(package$.MODULE$.int2Literal(10)))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nI am fine.,IJK";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithExpressionPreds() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$plus(package$.MODULE$.int2Literal(1)))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus(package$.MODULE$.int2Literal(1))).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$plus(package$.MODULE$.int2Literal(2))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "I am fine.,Hallo Welt\nLuke Skywalker,Hallo Welt wie gehts?\nLuke Skywalker,ABC\nComment#2,HIJ\nComment#2,IJK";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nHello world, how are you?,null\nI am fine.,HIJ\nI am fine.,IJK\nLuke Skywalker,null\nComment#1,null\nComment#2,null\nComment#3,null\nComment#4,null\nComment#5,null\nComment#6,null\nComment#7,null\nComment#8,null\nComment#9,null\nComment#10,null\nComment#11,null\nComment#12,null\nComment#13,null\nComment#14,null\nComment#15,null\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testLeftJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt", "Hello,Hallo Welt wie", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "Hi,null", "Hello world, how are you?,null", "I am fine.,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testRightJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nI am fine.,HIJ\nI am fine.,IJK\nnull,JKL\nnull,KLM\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testRightJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt", "Hello,Hallo Welt wie", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "Hi,null", "Hello world, how are you?,null", "I am fine.,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testFullOuterJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nI am fine.,HIJ\nI am fine.,IJK\nnull,JKL\nnull,KLM\nLuke Skywalker,null\nComment#1,null\nComment#2,null\nComment#3,null\nComment#4,null\nComment#5,null\nComment#6,null\nComment#7,null\nComment#8,null\nComment#9,null\nComment#10,null\nComment#11,null\nComment#12,null\nComment#13,null\nComment#14,null\nComment#15,null\nHello world, how are you?,null\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFullJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null", "null,Hallo Welt wie", "null,CDE", "null,DEF", "null,EFG", "null,FGH", "null,GHI", "null,JKL", "null,KLM"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testFullJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater$eq(package$.MODULE$.int2Literal(2)))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$eq$eq$eq(package$.MODULE$.int2Literal(1)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt wie", "Hello world, how are you?,DEF", "Hello world, how are you?,EFG", "I am fine.,GHI", "Hi,null", "Hello world,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null", "null,Hallo", "null,Hallo Welt", "null,Hallo Welt wie gehts?", "null,ABC", "null,BCD", "null,CDE", "null,FGH", "null,HIJ", "null,IJK", "null,JKL", "null,KLM"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testUDTFJoinOnTuples() {
        .colon.colon data = new .colon.colon((Object)"hi#world", (List)new .colon.colon((Object)"how#are#you", (List)Nil$.MODULE$));
        Table ds1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a", ClassTag$.MODULE$.apply(String.class), BasicTypeInfo.getInfoFor(String.class));
        TableFunc2 func2 = new TableFunc2();
        Table joinDs = ds1.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "len")})));
        Seq<Row> results = this.executeQuery(joinDs);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hi#world,hi,2", "hi#world,world,5", "how#are#you,how,3", "how#are#you,are,3", "how#are#you,you,3"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

