/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.util.TimeZone;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001%\t)B*Z4bGf$\u0016M\u00197f'&t7.\u0013+DCN,'BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!aA\u0006\u000b\u00051i\u0011!\u00024mS:\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\u0011aCB\u0001\u0006kRLGn]\u0005\u00031U\u0011QBQ1uG\"$Vm\u001d;CCN,\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u0003\u0011\u001dy\u0002A1A\u0005\n\u0001\n\u0011aX\u000b\u0002CA\u0019!eJ\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\u0013Q,7\u000f^;uS2\u001c(B\u0001\u0014\f\u0003\u0011\u0019wN]3\n\u0005!\u001a#aE#bG\"\u001c\u0015\r\u001c7cC\u000e\\wK]1qa\u0016\u0014\bC\u0001\u0016-\u001b\u0005Y#B\u0001\f\u000b\u0013\ti3F\u0001\nMK\u001e\f7-\u001f*po\u0016CH/\u001a8tS>t\u0007BB\u0018\u0001A\u0003%\u0011%\u0001\u0002`A!\u0012a&\r\t\u0003emj\u0011a\r\u0006\u0003iU\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0005Y:\u0014aA1qS*\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQt\"A\u0003kk:LG/\u0003\u0002=g\t\t\"+Z4jgR,'/\u0012=uK:\u001c\u0018n\u001c8\t\u000by\u0002A\u0011A \u0002AQ,7\u000f\u001e#fG&l\u0017\r\\(viB,HOR8s[\u0006$H+\u00192mKNKgn\u001b\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n!QK\\5uQ\tit\t\u0005\u0002I\u00136\tQ'\u0003\u0002Kk\t!A+Z:u\u0011\u0015a\u0005\u0001\"\u0001@\u0003\u0001\"Xm\u001d;EK\u000eLW.\u00197BaB,g\u000eZ*ue\u0016\fW\u000eV1cY\u0016\u001c\u0016N\\6)\u0005-;\u0005\"B(\u0001\t\u0003y\u0014!\t;fgR$UmY5nC24uN\u001d'fO\u0006\u001c\u0017\u0010V=qKR\u000b'\r\\3TS:\\\u0007F\u0001(HQ\tq%\u000b\u0005\u0002I'&\u0011A+\u000e\u0002\t\t&\u001c\u0018M\u00197fI\")a\u000b\u0001C\u0005/\u0006!\u0002O]3qCJ,gi\u001c:VaN,'\u000f^*j].$\u0012\u0001\u0017\t\u0003)eK!AW\u000b\u0003-Q+7\u000f^5oOV\u00038/\u001a:u)\u0006\u0014G.Z*j].DQ\u0001\u0018\u0001\u0005\u0002}\na\u0002^3tiV\u00038/\u001a:u'&t7\u000e\u000b\u0002\\\u000f\")q\f\u0001C\u0001\u007f\u0005AB/Z:u+B\u001cXM\u001d;TS:\\w+\u001b;i\u0003B\u0004XM\u001c3)\u0005y;\u0005\"\u00022\u0001\t\u0013\u0019\u0017!\u00069sKB\f'/\u001a$peJ+GO]1diNKgn\u001b\u000b\u0002IB\u0011A#Z\u0005\u0003MV\u0011q\u0003V3ti&twMU3ue\u0006\u001cG\u000fV1cY\u0016\u001c\u0016N\\6\t\u000b!\u0004A\u0011A \u0002\u001fQ,7\u000f\u001e*fiJ\f7\r^*j].D#aZ$")
public class LegacyTableSinkITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testDecimalOutputFormatTableSink() {
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeOutputFormatTable(this.tEnv(), schema, "testSink");
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("Table3").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    @Test
    public void testDecimalAppendStreamTableSink() {
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeAppendStreamTable(this.tEnv(), schema, "testSink");
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("Table3").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    @Disabled
    @Test
    public void testDecimalForLegacyTypeTableSink() {
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("a", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createLegacyUnsafeMemoryAppendTable(this.tEnv(), schema, "testSink");
        this.registerCollection("Table3", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("Table3").select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.STRING()), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast(DataTypes.DECIMAL((int)10, (int)2))}).distinct();
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,0.100000000000000000", "2,0.200000000000000000", "3,0.300000000000000000", "3,0.400000000000000000", "4,0.500000000000000000", "4,0.600000000000000000", "5,0.700000000000000000", "5,0.800000000000000000", "5,0.900000000000000000"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    /*
     * WARNING - void declaration
     */
    private TestingUpsertTableSink prepareForUpsertSink() {
        void var2_2;
        TableSchema schema = TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.DOUBLE()).build();
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("testSink", (TableSink)sink.configure(schema.getFieldNames(), (TypeInformation<?>[])schema.getFieldTypes()));
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        return var2_2;
    }

    @Test
    public void testUpsertSink() {
        TestingUpsertTableSink sink = this.prepareForUpsertSink();
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"a"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        List result = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
    }

    @Test
    public void testUpsertSinkWithAppend() {
        TestingUpsertTableSink sink = this.prepareForUpsertSink();
        sink.expectedKeys_$eq((Option<String[]>)None$.MODULE$);
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Table table = this.tEnv().from("MyTable").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(3)));
        table.executeInsert("testSink").await();
        List result = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"(true,1,0.1)", (List)new .colon.colon((Object)"(true,2,0.2)", (List)new .colon.colon((Object)"(true,2,0.2)", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
    }

    /*
     * WARNING - void declaration
     */
    private TestingRetractTableSink prepareForRetractSink() {
        void var2_2;
        TableSchema schema = TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.DOUBLE()).build();
        TestingRetractTableSink sink = new TestingRetractTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("testSink", (TableSink)sink.configure(schema.getFieldNames(), (TypeInformation<?>[])schema.getFieldTypes()));
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        return var2_2;
    }

    @Test
    public void testRetractSink() {
        TestingRetractTableSink sink = this.prepareForRetractSink();
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        List result = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"(true,1,0.1)", (List)new .colon.colon((Object)"(true,2,0.4)", (List)new .colon.colon((Object)"(true,3,1.0)", (List)new .colon.colon((Object)"(true,4,2.2)", (List)new .colon.colon((Object)"(true,5,3.9)", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
    }
}

