/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001I\u0011!cU3u\u001fB,'/\u0019;peNLEkQ1tK*\u00111\u0001B\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\u000fI,h\u000e^5nK*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\t\u00191B\u0003\u0002\r\u001b\u0005)a\r\\5oW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005Y1\u0011!B;uS2\u001c\u0018B\u0001\r\u0016\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\b?\u0001\u0011\r\u0011\"\u0003!\u0003\u0005yV#A\u0011\u0011\u0007\t:\u0013&D\u0001$\u0015\t!S%A\u0005uKN$X\u000f^5mg*\u0011aeC\u0001\u0005G>\u0014X-\u0003\u0002)G\t\u0019R)Y2i\u0007\u0006dGNY1dW^\u0013\u0018\r\u001d9feB\u0011!\u0006L\u0007\u0002W)\u0011aCC\u0005\u0003[-\u0012!\u0003T3hC\u000eL(k\\<FqR,gn]5p]\"1q\u0006\u0001Q\u0001\n\u0005\n!a\u0018\u0011)\u00059\n\u0004C\u0001\u001a<\u001b\u0005\u0019$B\u0001\u001b6\u0003%)\u0007\u0010^3og&|gN\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014a\u00026va&$XM\u001d\u0006\u0003u=\tQA[;oSRL!\u0001P\u001a\u0003#I+w-[:uKJ,\u0005\u0010^3og&|g\u000eC\u0004?\u0001\t\u0007I\u0011A \u0002!\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,W#\u0001!\u0011\u0005\u0005kfB\u0001\"[\u001d\t\u0019uK\u0004\u0002E+:\u0011Q\t\u0016\b\u0003\rNs!a\u0012*\u000f\u0005!\u000bfBA%Q\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N#\u00051AH]8pizJ\u0011\u0001E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005\rY\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011a\u000bB\u0001\u0004gFd\u0017B\u0001-Z\u0003\u0011Qw.\u001b8\u000b\u0005Y#\u0011BA.]\u0003!Qu.\u001b8UsB,'B\u0001-Z\u0013\tqvL\u0001\u0005K_&tG+\u001f9f\u0015\tYF\f\u0003\u0004b\u0001\u0001\u0006I\u0001Q\u0001\u0012Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016\u0004\u0003\"B2\u0001\t\u0003\"\u0017A\u00022fM>\u0014X\rF\u0001f!\t1\u0017.D\u0001h\u0015\u0005A\u0017!B:dC2\f\u0017B\u00016h\u0005\u0011)f.\u001b;)\u0005\td\u0007CA7o\u001b\u0005)\u0014BA86\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006c\u0002!\t\u0001Z\u0001\ri\u0016\u001cH/\u00168j_:\fE\u000e\u001c\u0015\u0003aN\u0004\"!\u001c;\n\u0005U,$\u0001\u0002+fgRDQa\u001e\u0001\u0005\u0002\u0011\f!\u0004^3tiVs\u0017n\u001c8BY2<\u0016\u000e\u001e5D_6lwN\u001c+za\u0016D#A^:\t\u000bi\u0004A\u0011\u00013\u0002\u0013Q,7\u000f^+oS>t\u0007FA=t\u0011\u0015i\b\u0001\"\u0001e\u0003M!Xm\u001d;UKJt\u0017M]=V]&|g.\u00117mQ\ta8\u000f\u0003\u0004\u0002\u0002\u0001!\t\u0001Z\u0001\u0011i\u0016\u001cH\u000fV3s]\u0006\u0014\u00180\u00168j_:D#a`:\t\r\u0005\u001d\u0001\u0001\"\u0001e\u00031!Xm\u001d;NS:,8/\u00117mQ\r\t)a\u001d\u0005\u0007\u0003\u001b\u0001A\u0011\u00013\u0002\u0013Q,7\u000f^'j]V\u001c\bfAA\u0006g\"1\u00111\u0003\u0001\u0005\u0002\u0011\fA\u0004^3ti6Kg.^:ES\u001a4WM]3oi\u001aKW\r\u001c3OC6,7\u000fK\u0002\u0002\u0012MDa!!\u0007\u0001\t\u0003!\u0017!\u0004;fgRLe\u000e^3sg\u0016\u001cG\u000fK\u0002\u0002\u0018MDa!a\b\u0001\t\u0003!\u0017\u0001\u0005;fgRLe\u000e^3sg\u0016\u001cG/\u00117mQ\r\tib\u001d\u0005\u0007\u0003K\u0001A\u0011\u00013\u0002IQ,7\u000f^%oi\u0016\u00148/Z2u/&$\b\u000eR5gM\u0016\u0014XM\u001c;GS\u0016dGMT1nKND3!a\tt\u0011\u0019\tY\u0003\u0001C\u0001I\u0006\tC/Z:u\u0013:$XM]:fGR<\u0016\u000e\u001e5TG\u0006d\u0017M]#yaJ,7o]5p]\"\u001a\u0011\u0011F:")
public class SetOperatorsITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    private final Enumeration.Value expectedJoinType = JoinType$.MODULE$.SortMergeJoin();

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @Test
    public void testUnionAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "d, e, f");
        Table unionDs = ds1.unionAll(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnionAllWithCommonType() {
        Table table1 = this.tEnv().fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.int2Literal(12), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("")}))});
        Table table2 = this.tEnv().fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.javaDec2Literal(new BigDecimal("1234.123")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("ABC")}))});
        Table unionTable = table1.unionAll(table2);
        List schema = unionTable.getResolvedSchema().getColumnDataTypes();
        Assertions.assertThat(schema.get(0)).isEqualTo((Object)DataTypes.DECIMAL((int)13, (int)3).notNull());
        Assertions.assertThat(schema.get(1)).isEqualTo((Object)DataTypes.VARCHAR((int)3).notNull());
        Seq<Row> results = this.executeQuery(unionTable);
        String expected = "12.000,\n1234.123,ABC\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnion() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "d, e, f");
        Table unionDs = ds1.union(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTernaryUnionAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table unionDs = ds1.unionAll(ds2).unionAll(ds3).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\nHi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTernaryUnion() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table unionDs = ds1.union(ds2).union(ds3).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinusAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minusAll(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hi\nHello\nHello world\nHello\nHello world\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinus() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minus(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinusDifferentFieldNames() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minus(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersect() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello world!"));
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom()), "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table intersectDS = ds1.intersect(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(intersectDS);
        String expected = "Hi\nHello\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectAll() {
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2}));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2, 3}));
        Table ds1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data1, "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data2, "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table intersectDS = ds1.intersectAll(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        String expected = "1\n2\n2";
        Seq<Row> results = this.executeQuery(intersectDS);
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithDifferentFieldNames() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "e, f, g");
        Table intersectDs = ds1.intersect(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(intersectDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithScalarExpression() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Table intersectDs = ds1.intersect(ds2);
        Seq<Row> results = this.executeQuery(intersectDs);
        String expected = "2,1,Hi\n3,2,Hello\n4,2,Hello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

