/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001%\tyA+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005)A/\u00192mK*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0002\f\u0015\taQ\"A\u0003gY&t7N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005a)\"!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!9q\u0004\u0001b\u0001\n\u0013\u0001\u0013!A0\u0016\u0003\u0005\u00022AI\u0014*\u001b\u0005\u0019#B\u0001\u0013&\u0003%!Xm\u001d;vi&d7O\u0003\u0002'\u0017\u0005!1m\u001c:f\u0013\tA3EA\nFC\u000eD7)\u00197mE\u0006\u001c7n\u0016:baB,'\u000f\u0005\u0002+Y5\t1F\u0003\u0002\u0017\u0015%\u0011Qf\u000b\u0002\u0013\u0019\u0016<\u0017mY=S_^,\u0005\u0010^3og&|g\u000e\u0003\u00040\u0001\u0001\u0006I!I\u0001\u0003?\u0002B#AL\u0019\u0011\u0005IZT\"A\u001a\u000b\u0005Q*\u0014!C3yi\u0016t7/[8o\u0015\t1t'A\u0002ba&T!\u0001O\u001d\u0002\u000f),\b/\u001b;fe*\u0011!hD\u0001\u0006UVt\u0017\u000e^\u0005\u0003yM\u0012\u0011CU3hSN$XM]#yi\u0016t7/[8o\u0011\u0015q\u0004\u0001\"\u0001@\u0003\t\"Xm\u001d;EK\u000eLW.\u00197P]>+H\u000f];u\r>\u0014X.\u0019;UC\ndWmU5oWR\t\u0001\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%I\u0001\u0003V]&$\bFA\u001fH!\tA\u0015*D\u00016\u0013\tQUG\u0001\u0003UKN$\b\"\u0002'\u0001\t\u0003y\u0014A\t;fgR$UmY5nC2|enU5oW\u001a+hn\u0019;j_:$\u0016M\u00197f'&t7\u000e\u000b\u0002L\u000f\")q\n\u0001C\u0001\u007f\u0005yA/Z:u'&t7nV5uQ.+\u0017\u0010\u000b\u0002O\u000f\")!\u000b\u0001C\u0001\u007f\u0005\u0011B/Z:u'&t7nV5uQ>,HoS3zQ\t\tv\tC\u0003V\u0001\u0011\u0005q(\u0001\u0014uKN$8+\u001b8l/&$\b\u000eU1si&$\u0018n\u001c8B]\u0012\u001cu.\u001c9vi\u0016$7i\u001c7v[:D#\u0001V$\t\u000ba\u0003A\u0011A \u0002#Q,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014H\u000f\u000b\u0002X\u000f\")1\f\u0001C\u0001\u007f\u0005yC/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRD\u0007+\u0019:uSRLwN\\!oI\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012!l\u0012\u0005\u0006=\u0002!\taP\u0001-i\u0016\u001cHOR;mY&s7/\u001a:u/&$\b\u000eU1si&$\u0018n\u001c8B]\u0012\u001cu.\u001c9vi\u0016$7i\u001c7v[:D#!X$\t\u000b\u0005\u0004A\u0011A \u0002oQ,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ\u0012Kh.Y7jGB\u000b'\u000f^5uS>t\u0017I\u001c3D_6\u0004X\u000f^3e\u0007>dW/\u001c82Q\t\u0001w\tC\u0003e\u0001\u0011\u0005q(A\u001cuKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5Es:\fW.[2QCJ$\u0018\u000e^5p]\u0006sGmQ8naV$X\rZ\"pYVlgN\r\u0015\u0003G\u001eCQa\u001a\u0001\u0005\u0002}\nA\u0004^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\bNU3pe\u0012,'\u000f\u000b\u0002g\u000f\")!\u000e\u0001C\u0001\u007f\u0005yC/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRDG)\u001f8b[&\u001c\u0017I\u001c3Ti\u0006$\u0018n\u0019)beRLG/[8oc!\u0012\u0011n\u0012\u0005\u0006[\u0002!\taP\u00010i\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i\tft\u0017-\\5d\u0003:$7\u000b^1uS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0015\u0003Y\u001eCQ\u0001\u001d\u0001\u0005\u0002}\nq\u0006^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\b\u000eR=oC6L7-\u00118e'R\fG/[2QCJ$\u0018\u000e^5p]NB#a\\$")
public class TableSinkITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testDecimalOnOutputFormatTableSink() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE sink (\n                       |  `c` VARCHAR(5),\n                       |  `b` DECIMAL(10, 0),\n                       |  `d` CHAR(5)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true',\n                       |  'runtime-sink' = 'OutputFormat'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("MyTable").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("sink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("sink");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalOnSinkFunctionTableSink() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE sink (\n                       |  `c` VARCHAR(5),\n                       |  `b` DECIMAL(10, 0),\n                       |  `d` CHAR(5)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("MyTable").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("sink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("sink");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithKey() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` DOUBLE,\n                       |  PRIMARY KEY (a) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        .colon.colon expected = new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithoutKey() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` DOUBLE\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        .colon.colon expected = new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021', `d`=1)\n                     |SELECT x, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"1,2021,1,0.1", (List)new .colon.colon((Object)"2,2021,1,0.4", (List)new .colon.colon((Object)"3,2021,1,1.0", (List)new .colon.colon((Object)"4,2021,1,2.2", (List)new .colon.colon((Object)"5,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsert() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` DOUBLE\n                       |)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (b)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,0.1", (List)new .colon.colon((Object)"null,0.4", (List)new .colon.colon((Object)"null,1.0", (List)new .colon.colon((Object)"null,2.2", (List)new .colon.colon((Object)"null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021', `d`=1) (e)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFullInsertWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021', `d`=1) (a, e)\n                     |SELECT x, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"1,2021,1,0.1", (List)new .colon.colon((Object)"2,2021,1,0.4", (List)new .colon.colon((Object)"3,2021,1,1.0", (List)new .colon.colon((Object)"4,2021,1,2.2", (List)new .colon.colon((Object)"5,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicPartitionAndComputedColumn1() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (e)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,null,null,0.1", (List)new .colon.colon((Object)"null,null,null,0.4", (List)new .colon.colon((Object)"null,null,null,1.0", (List)new .colon.colon((Object)"null,null,null,2.2", (List)new .colon.colon((Object)"null,null,null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicPartitionAndComputedColumn2() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (c, d, e)\n                     |SELECT '2021', 1, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithReorder() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (e, d, c)\n                     |SELECT sum(y), 1, '2021' FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition1() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021') (d, e)\n                     |SELECT 1, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition2() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021') (e)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,null,0.1", (List)new .colon.colon((Object)"null,2021,null,0.4", (List)new .colon.colon((Object)"null,2021,null,1.0", (List)new .colon.colon((Object)"null,2021,null,2.2", (List)new .colon.colon((Object)"null,2021,null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition3() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |INSERT INTO testSink PARTITION(`c`='2021') (e, e)\n                           |SELECT 1, sum(y) FROM MyTable GROUP BY x\n                           |")).stripMargin()).await()).hasMessageContaining("Target column 'e' is assigned more than once");
    }
}

