/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001E\u0011\u0011d\u0012:pkB\fum\u001a:fO\u0006$X\rS1s]\u0016\u001c8\u000fV3ti*\u00111\u0001B\u0001\bQ\u0006\u0014h.Z:t\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ty\u0001*\u0019:oKN\u001cH+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u0011iw\u000eZ3\u0011\u0005eycB\u0001\u000e-\u001d\tY\"F\u0004\u0002\u001dS9\u0011Q\u0004\u000b\b\u0003=\u001dr!a\b\u0014\u000f\u0005\u0001*cBA\u0011%\u001b\u0005\u0011#BA\u0012\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0016\u0005\u0003\u0015)H/\u001b7t\u0013\tic&\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cXM\u0003\u0002,\t%\u0011\u0001'\r\u0002\u0011'R\fG/\u001a\"bG.,g\u000eZ'pI\u0016T!!\f\u0018\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011\"\\5oS\n\u000bGo\u00195\u0011\u0005UBdB\u0001\u000e7\u0013\t9d&\u0001\u0010TiJ,\u0017-\\5oO^KG\u000f['j]&\u0014\u0015\r^2i)\u0016\u001cHOQ1tK&\u0011\u0011H\u000f\u0002\u000e\u001b&t\u0017NQ1uG\"lu\u000eZ3\u000b\u0005]r\u0003\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\bF\u0002?\u007f\u0001\u0003\"a\u0005\u0001\t\u000b]Y\u0004\u0019\u0001\r\t\u000bMZ\u0004\u0019\u0001\u001b\t\u000b\t\u0003A\u0011I\"\u0002\r\t,gm\u001c:f)\u0005!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%\u0001B+oSRD#!Q&\u0011\u00051\u001bV\"A'\u000b\u00059{\u0015aA1qS*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011f\"A\u0003kk:LG/\u0003\u0002U\u001b\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bY\u0003A\u0011A\"\u00027Q,7\u000f^!hOJ,w-\u0019;f/&$\bNU3ue\u0006\u001cG/[8oQ\t)\u0006\f\u0005\u0002M3&\u0011!,\u0014\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u00069\u0002!\taQ\u0001\u001ci\u0016\u001cH/Q4he\u0016<\u0017\r^5p]^KG\u000f\u001b#jgRLgn\u0019;)\u0005mC\u0006\"B0\u0001\t\u0013\u0001\u0017!H2sK\u0006$X-Q4he\u0016<\u0017\r^5p]^KG\u000f\u001b#jgRLgn\u0019;\u0015\u0003\u0005\u0004B!\u00122ee&\u00111M\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0015TG\u000e\u001c7\u000e\u0003\u0019T!a\u001a5\u0002\tU$\u0018\u000e\u001c\u0006\u0003S*\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005-4'AJ&fs\u0016$wJ\\3J]B,Ho\u0015;sK\u0006lw\n]3sCR|'\u000fV3ti\"\u000b'O\\3tgB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eC\u0001\u0005I\u0006$\u0018-\u0003\u0002r]\n9!k\\<ECR\f\u0007cA#tk&\u0011AO\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003mnl\u0011a\u001e\u0006\u0003qf\fq\u0001\\8hS\u000e\fGN\u0003\u0002{\u0011\u0005)A/\u001f9fg&\u0011Ap\u001e\u0002\f\u0019><\u0017nY1m)f\u0004X\rC\u0003\u007f\u0001\u0011\u00051)\u0001\u000buKN$8\t\\8tK^KG\u000f[8vi>\u0003XM\u001c\u0015\u0003{bCs\u0001AA\u0002\u0003\u001f\t\t\u0002\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI!T\u0001\nKb$XM\\:j_:LA!!\u0004\u0002\b\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005M1EAA\u000b!\u0011\t9\"a\n\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA\u0010\u0003C\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r\u0011\u00161\u0005\u0006\u0004\u0003KQ\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\tI#!\u0007\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u00055\"\u0001#\u0001\u00020\u0005IrI]8va\u0006;wM]3hCR,\u0007*\u0019:oKN\u001cH+Z:u!\r\u0019\u0012\u0011\u0007\u0004\u0007\u0003\tA\t!a\r\u0014\t\u0005E\u0012Q\u0007\t\u0004\u000b\u0006]\u0012bAA\u001d\r\n1\u0011I\\=SK\u001aDq\u0001PA\u0019\t\u0003\ti\u0004\u0006\u0002\u00020!A\u0011\u0011IA\u0019\t\u0003\t\u0019%\u0001\u0006qCJ\fW.\u001a;feN$\"!!\u0012\u0011\r\u0005\u001d\u0013qJA*\u001b\t\tIEC\u0002h\u0003\u0017R!!!\u0014\u0002\t)\fg/Y\u0005\u0005\u0003#\nIE\u0001\u0006D_2dWm\u0019;j_:\u0004B!R:\u0002VA!\u0011qKA/\u001b\t\tIF\u0003\u0003\u0002\\\u0005-\u0013\u0001\u00027b]\u001eLA!a\u0018\u0002Z\t1qJ\u00196fGRD\u0003\"a\u0010\u0002d\u0005%\u00141\u000e\t\u0005\u0003/\t)'\u0003\u0003\u0002h\u0005e!A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\ti'A\u0010Ti\u0006$XMQ1dW\u0016tG-P>1{2\u0002S*\u001b8j\u0005\u0006$8\r[\u001f|cu\u0004")
public class GroupAggregateHarnessTest
extends HarnessTestBase {
    private final StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch;

    @Parameters(name="StateBackend={0}, MiniBatch={1}")
    public static Collection<Object[]> parameters() {
        return GroupAggregateHarnessTest$.MODULE$.parameters();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
        TableConfig tableConfig = this.tEnv().getConfig();
        StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode = this.miniBatch;
        StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode2 = StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOn();
        StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode3 = miniBatchMode;
        if (!(miniBatchMode2 != null ? !((Object)miniBatchMode2).equals(miniBatchMode3) : miniBatchMode3 != null)) {
            tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
            tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)1L));
            tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"ONE_PHASE");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode4 = StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOff();
            StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode5 = miniBatchMode;
            if (!(miniBatchMode4 != null ? !((Object)miniBatchMode4).equals(miniBatchMode5) : miniBatchMode5 != null)) {
                tableConfig.getConfiguration().removeConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)miniBatchMode);
            }
        }
    }

    @TestTemplate
    public void testAggregateWithRetraction() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(c)\n        |FROM (\n        |  SELECT a, b, SUM(c) as c\n        |  FROM T GROUP BY a, b\n        |)GROUP BY a\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "GroupAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(3L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}));
        testHarness.setStateTtlProcessingTime(3002L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(4L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(2L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(9L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"eee", Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"eee", Predef$.MODULE$.long2Long(6L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(7L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(9L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(16L)}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(5L)}));
        ConcurrentLinkedQueue result = testHarness.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness.close();
    }

    @TestTemplate
    public void testAggregationWithDistinct() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createAggregationWithDistinct();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness2.setStateTtlProcessingTime(1L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", "b1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)}));
        testHarness2.setStateTtlProcessingTime(1000L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a2", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)}));
        testHarness2.setStateTtlProcessingTime(2001L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", "b3", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a2", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", null, Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|1", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(10L)}));
        testHarness2.setStateTtlProcessingTime(5001L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", null, Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L), "0|1", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a2", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L), "0|1", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L), "1|1", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(6L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", "b4", Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)}));
        ConcurrentLinkedQueue result = testHarness2.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness2.close();
    }

    private Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createAggregationWithDistinct() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("CntNullNonNull", (UserDefinedFunction)new UserDefinedFunctionTestUtils.CountNullNonNull());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), CntNullNonNull(DISTINCT b), COUNT(*), SUM(c)\n        |FROM T\n        |GROUP BY a\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "GroupAggregate");
        LogicalType[] outputTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
        return new Tuple2(testHarness, (Object)outputTypes);
    }

    @TestTemplate
    public void testCloseWithoutOpen() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createAggregationWithDistinct();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputType2 = (LogicalType[])tuple23._2();
        testHarness2.setup((TypeSerializer)new RowDataSerializer(outputType2));
        testHarness2.close();
    }

    public GroupAggregateHarnessTest(StreamingWithStateTestBase.StateBackendMode mode, StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch) {
        this.miniBatch = miniBatch;
        super(mode);
    }
}

