/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001E\u0011\u0001d\u0014<fe\u0006;wM]3hCR,\u0007*\u0019:oKN\u001cH+Z:u\u0015\t\u0019A!A\u0004iCJtWm]:\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tq\u0001\u001d7b]:,'O\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005=A\u0015M\u001d8fgN$Vm\u001d;CCN,\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t5|G-\u001a\t\u00033=r!A\u0007\u0017\u000f\u0005mQcB\u0001\u000f*\u001d\ti\u0002F\u0004\u0002\u001fO9\u0011qD\n\b\u0003A\u0015r!!\t\u0013\u000e\u0003\tR!a\t\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u000b\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055r\u0013AG*ue\u0016\fW.\u001b8h/&$\bn\u0015;bi\u0016$Vm\u001d;CCN,'BA\u0016\u0005\u0013\t\u0001\u0014G\u0001\tTi\u0006$XMQ1dW\u0016tG-T8eK*\u0011QF\f\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U2\u0004CA\n\u0001\u0011\u00159\"\u00071\u0001\u0019\u0011\u0015A\u0004\u0001\"\u0011:\u0003\u0019\u0011WMZ8sKR\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0003V]&$\bFA\u001cB!\t\u0011\u0015*D\u0001D\u0015\t!U)A\u0002ba&T!AR$\u0002\u000f),\b/\u001b;fe*\u0011\u0001JD\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0015\u000e\u0013!BQ3g_J,W)Y2i\u0011\u0015a\u0005\u0001\"\u0001:\u0003m!Xm\u001d;Qe>\u001cG+[7f\u0005>,h\u000eZ3e%><8o\u0014<fe\"\u00121J\u0014\t\u0003\u0005>K!\u0001U\"\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000bI\u0003A\u0011B*\u0002;\r\u0014X-\u0019;f!J|7\rV5nK\n{WO\u001c3fIJ{wo](wKJ$\u0012\u0001\u0016\t\u0005wU;V-\u0003\u0002Wy\t1A+\u001e9mKJ\u0002R\u0001W/`?~k\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\u0011ALC\u0001\ngR\u0014X-Y7j]\u001eL!AX-\u0003M-+\u00170\u001a3P]\u0016Le\u000e];u'R\u0014X-Y7Pa\u0016\u0014\u0018\r^8s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0011\u0005!A-\u0019;b\u0013\t!\u0017MA\u0004S_^$\u0015\r^1\u0011\u0007m2\u0007.\u0003\u0002hy\t)\u0011I\u001d:bsB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\bY><\u0017nY1m\u0015\ti\u0007\"A\u0003usB,7/\u0003\u0002pU\nYAj\\4jG\u0006dG+\u001f9f\u0011\u0015\t\b\u0001\"\u0001:\u0003q!Xm\u001d;Qe>\u001cG+[7f\u0005>,h\u000eZ3e%\u0006tw-Z(wKJD#\u0001\u001d(\t\u000bQ\u0004A\u0011A\u001d\u00023Q,7\u000f\u001e)s_\u000e$\u0016.\\3V]\n|WO\u001c3fI>3XM\u001d\u0015\u0003g:CQa\u001e\u0001\u0005\u0002e\n1\u0004^3tiJ{w\u000fV5nK\n{WO\u001c3fIJ\u000bgnZ3Pm\u0016\u0014\bF\u0001<O\u0011\u0015Q\b\u0001\"\u0001:\u0003i!Xm\u001d;S_^$\u0016.\\3C_VtG-\u001a3S_^\u001cxJ^3sQ\tIh\nC\u0003~\u0001\u0011\u0005\u0011(A\u000fuKN$(k\\<US6,WK\u001c2pk:$W\r\u001a*b]\u001e,wJ^3sQ\tah\n\u0003\u0004\u0002\u0002\u0001!\t!O\u0001\u001di\u0016\u001cHOU8x)&lW-\u00168c_VtG-\u001a3S_^\u001cxJ^3sQ\tyh\n\u0003\u0004\u0002\b\u0001!\t!O\u0001\u0015i\u0016\u001cHo\u00117pg\u0016<\u0016\u000e\u001e5pkR|\u0005/\u001a8)\u0007\u0005\u0015a\nK\u0004\u0001\u0003\u001b\tI\"a\u0007\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005D\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002\u0018\u0005E!AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\u0012\u0011QD\u0012\u0003\u0003?\u0001B!!\t\u000225\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u0003S\tY#\u0001\u0006fqR,gn]5p]NT1\u0001SA\u0017\u0015\r\tyCC\u0001\ni\u0016\u001cH/\u001e;jYNLA!a\r\u0002$\tQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u0002")
public class OverAggregateHarnessTest
extends HarnessTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
    }

    @TestTemplate
    public void testProcTimeBoundedRowsOver() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcTimeBoundedRowsOver();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputType2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputType2);
        testHarness2.open();
        testHarness2.setProcessingTime(1L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(1L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(10L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(2L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(3L), null})));
        testHarness2.setProcessingTime(1100L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(20L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(4L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(5L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(6L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(30L), null})));
        testHarness2.setProcessingTime(3001L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(7L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(8L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(9L), null})));
        testHarness2.setProcessingTime(6002L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(10L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "bbb", Predef$.MODULE$.long2Long(40L), null})));
        ConcurrentLinkedQueue result = testHarness2.getOutput();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(1L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(2L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(3L), null, Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(20L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(4L), null, Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(5L), null, Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(6L), null, Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(30L), null, Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(7L), null, Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(8L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(9L), null, Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "bbb", Predef$.MODULE$.long2Long(40L), null, Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness2.close();
    }

    private Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createProcTimeBoundedRowsOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT currtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN 1 PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN 1 PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        LogicalType[] outputType = (LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
        return new Tuple2(testHarness, (Object)outputType);
    }

    @TestTemplate
    public void testProcTimeBoundedRangeOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT currtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY proctime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY proctime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setProcessingTime(3L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.setProcessingTime(4L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null})));
        testHarness.setProcessingTime(3003L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null})));
        testHarness.setProcessingTime(5L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null})));
        testHarness.setProcessingTime(6002L);
        testHarness.setProcessingTime(7002L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null})));
        testHarness.setProcessingTime(11002L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null})));
        testHarness.setProcessingTime(11004L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null})));
        testHarness.setProcessingTime(11006L);
        ConcurrentLinkedQueue result = testHarness.getOutput();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null, Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null, Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null, Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null, Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null, Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness.close();
    }

    @TestTemplate
    public void testProcTimeUnboundedOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT currtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1003L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null})));
        testHarness.setStateTtlProcessingTime(5003L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null})));
        ConcurrentLinkedQueue result = testHarness.getOutput();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null, Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null, Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeBoundedRangeOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.processWatermark(1L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(3L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processWatermark(4001L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4002L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processWatermark(4002L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4003L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "bbb", Predef$.MODULE$.long2Long(25L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(3L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4002L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4003L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "bbb", Predef$.MODULE$.long2Long(25L), Predef$.MODULE$.long2Long(25L), Predef$.MODULE$.long2Long(25L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(25L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeBoundedRowsOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN 2 PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.processWatermark(800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        testHarness.setProcessingTime(1000L);
        testHarness.processWatermark(20000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.setProcessingTime(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processWatermark(20010L);
        testHarness.setProcessingTime(4499L);
        testHarness.setProcessingTime(4500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20011L), "ccc", Predef$.MODULE$.long2Long(3L)})));
        testHarness.setProcessingTime(6500L);
        testHarness.processWatermark(20020L);
        testHarness.setProcessingTime(8499L);
        testHarness.setProcessingTime(8500L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(40L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20011L), "ccc", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(3L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeUnboundedRangeOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN UNBOUNDED preceding AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN UNBOUNDED preceding AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setProcessingTime(1000L);
        testHarness.processWatermark(800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        testHarness.setProcessingTime(2999L);
        testHarness.setProcessingTime(3000L);
        testHarness.processWatermark(20000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20000L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.setProcessingTime(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.setProcessingTime(5000L);
        testHarness.processWatermark(20010L);
        testHarness.setProcessingTime(6999L);
        testHarness.setProcessingTime(7000L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(40L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeUnboundedRowsOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setProcessingTime(1000L);
        testHarness.processWatermark(800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        testHarness.setProcessingTime(2999L);
        testHarness.setProcessingTime(3000L);
        testHarness.processWatermark(20000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20000L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.setProcessingTime(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.setProcessingTime(5000L);
        testHarness.processWatermark(20010L);
        testHarness.setProcessingTime(6999L);
        testHarness.setProcessingTime(7000L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(40L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testCloseWithoutOpen() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcTimeBoundedRowsOver();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputType2 = (LogicalType[])tuple23._2();
        testHarness2.setup((TypeSerializer)new RowDataSerializer(outputType2));
        testHarness2.open();
    }

    public OverAggregateHarnessTest(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

