/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.RankHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001E\u0011qBU1oW\"\u000b'O\\3tgR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001[1s]\u0016\u001c8O\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0010\u0011\u0006\u0014h.Z:t)\u0016\u001cHOQ1tK\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0003n_\u0012,\u0007CA\r0\u001d\tQBF\u0004\u0002\u001cU9\u0011A$\u000b\b\u0003;!r!AH\u0014\u000f\u0005}1cB\u0001\u0011&\u001d\t\tC%D\u0001#\u0015\t\u0019\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tYC!A\u0003vi&d7/\u0003\u0002.]\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK*\u00111\u0006B\u0005\u0003aE\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u00055r\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u00026mA\u00111\u0003\u0001\u0005\u0006/I\u0002\r\u0001\u0007\u0005\u0006q\u0001!\t%O\u0001\u0007E\u00164wN]3\u0015\u0003i\u0002\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012A!\u00168ji\"\u0012q'\u0011\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000b1!\u00199j\u0015\t1u)A\u0004kkBLG/\u001a:\u000b\u0005!s\u0011!\u00026v]&$\u0018B\u0001&D\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006\u0019\u0002!\t!O\u0001\u001di\u0016\u001cHOU3ue\u0006\u001cGOU1oW^KG\u000f\u001b*po:+XNY3sQ\tYe\n\u0005\u0002C\u001f&\u0011\u0001k\u0011\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0006%\u0002!\t!O\u0001 i\u0016\u001cHOU3ue\u0006\u001cGOU1oW^KG\u000f[8viJ{wOT;nE\u0016\u0014\bFA)O\u0011\u0015)\u0006\u0001\"\u0001W\u0003\u0011\u0002(/\u001a9be\u0016,\u0006\u000fZ1uKJ\u000bgn[,ji\"\u0014vn\u001e(v[\n,'\u000fV3ti\u0016\u0014H#A,\u0011\tmB&\f[\u0005\u00033r\u0012a\u0001V;qY\u0016\u0014\u0004#B.aE\n\u0014W\"\u0001/\u000b\u0005us\u0016\u0001B;uS2T!a\u0018\u0006\u0002\u0013M$(/Z1nS:<\u0017BA1]\u0005\u0019ZU-_3e\u001f:,\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peR+7\u000f\u001e%be:,7o\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\"\tA\u0001Z1uC&\u0011q\r\u001a\u0002\b%><H)\u0019;b!\tIG.D\u0001k\u0015\ti6N\u0003\u0002\u0006\u0011%\u0011QN\u001b\u0002\u0017%><H)\u0019;b\u0011\u0006\u0014h.Z:t\u0003N\u001cXM\u001d;pe\")q\u000e\u0001C\u0001s\u0005iC/Z:u+B$\u0017\r^3SC:\\w+\u001b;i%><h*^7cKJ\u001cvN\u001d;LKf$%o\u001c9t)>d\u0015m\u001d;)\u00059t\u0005\"\u0002:\u0001\t\u0003I\u0014A\u000e;fgR,\u0006\u000fZ1uKJ\u000bgn[,ji\"\u0014vn\u001e(v[\n,'oU8si.+\u0017\u0010\u0012:paN\u0014U\u000f\u001e*b].,fn\u00195b]\u001e,\u0007FA9O\u0011\u0015)\b\u0001\"\u0001:\u0003A\"Xm\u001d;Va\u0012\fG/\u001a*b].<\u0016\u000e\u001e5S_^tU/\u001c2feN{'\u000f^&fs\u0012\u0013x\u000e]:U_:{G\u000fT1ti\"\u0012AO\u0014\u0005\u0006q\u0002!\t!O\u00017i\u0016\u001cH/\u00169eCR,'+\u00198l/&$\bNU8x\u001dVl'-\u001a:DC:$\u0017\u000eZ1uKNd\u0015M]4feRC\u0017M\u001c*b].,e\u000e\u001a\u0015\u0003o:CQa\u001f\u0001\u0005\u0002e\n1\u0007^3tiV\u0003H-\u0019;f%\u0006t7nV5uQJ{wOT;nE\u0016\u00148k\u001c:u\u0017\u0016LHI]8qg>+Ho\u00144SC:$WI\u001c3)\u0005it\u0005F\u0002\u0001\u007f\u0003\u0013\tY\u0001E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r1)A\u0005fqR,gn]5p]&!\u0011qAA\u0001\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u001b\u0019#!a\u0004\u0011\t\u0005E\u0011\u0011E\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!!\u0007\u0002\u001c\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007!\u000biBC\u0002\u0002 )\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005\r\u00121\u0003\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\u001c")
public class RankHarnessTest
extends HarnessTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
    }

    @TestTemplate
    public void testRetractRankWithRowNumber() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c, id, rn1\n        |FROM (\n        |   SELECT a, b, c, t3.id id,\n        |    ROW_NUMBER() OVER (PARTITION BY a, t3.id ORDER BY c DESC) AS rn1\n        |   FROM (\n        |       SELECT a, b, c, rn\n        |       FROM\n        |       (\n        |           -- append rank\n        |           SELECT a, b, c,\n        |               ROW_NUMBER() OVER (PARTITION BY a ORDER BY c DESC) AS rn\n        |           FROM T\n        |       ) t1\n        |       WHERE rn = 1\n        |   ) t2, LATERAL TABLE(STRING_SPLIT(b, '#')) AS t3(id)\n        |) WHERE rn1 <= 2\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[RetractStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(1L), "1"}));
        testHarness.setStateTtlProcessingTime(1000L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.setStateTtlProcessingTime(1001L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRetractRankWithoutRowNumber() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c, id\n        |FROM (\n        |   SELECT a, b, c, t3.id id,\n        |    ROW_NUMBER() OVER (PARTITION BY a, t3.id ORDER BY c DESC) AS rn1\n        |   FROM (\n        |       SELECT a, b, c, rn\n        |       FROM\n        |       (\n        |           -- append rank\n        |           SELECT a, b, c,\n        |               ROW_NUMBER() OVER (PARTITION BY a ORDER BY c DESC) AS rn\n        |           FROM T\n        |       ) t1\n        |       WHERE rn = 1\n        |   ) t2, LATERAL TABLE(STRING_SPLIT(b, '#')) AS t3(id)\n        |) WHERE rn1 = 1\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[RetractStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType()}));
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(1L), "1"}));
        testHarness.setStateTtlProcessingTime(1000L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.setStateTtlProcessingTime(1001L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    public Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> prepareUpdateRankWithRowNumberTester() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "type"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT word, cnt, rank_num\n        |FROM (\n        |  SELECT word, cnt,\n        |      ROW_NUMBER() OVER (PARTITION BY type ORDER BY cnt DESC) as rank_num\n        |  FROM (\n        |     select word, type, sum(cnt) filter (where cnt > 0) cnt from T group by word, type\n        |   )\n        |  )\n        |WHERE rank_num <= 6\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[UpdateFastStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        return new Tuple2(testHarness, (Object)assertor);
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsToLast() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(10)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.long2Long(6L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsButRankUnchange() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(88)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(88), Predef$.MODULE$.long2Long(3L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsToNotLast() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberCandidatesLargerThanRankEnd() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"g", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(60)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"h", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(50)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsOutOfRandEnd() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"g", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(60)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"h", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(50)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(55)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(55), Predef$.MODULE$.long2Long(6L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    public RankHarnessTest(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

