/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowAggregateHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u0001E\u0011!dV5oI><\u0018iZ4sK\u001e\fG/\u001a%be:,7o\u001d+fgRT!a\u0001\u0003\u0002\u000f!\f'O\\3tg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0004qY\u0006tg.\u001a:\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011q\u0002S1s]\u0016\u001c8\u000fV3ti\n\u000b7/\u001a\u0005\t/\u0001\u0011\t\u0011)A\u00051\u00059!-Y2lK:$\u0007CA\r0\u001d\tQBF\u0004\u0002\u001cU9\u0011A$\u000b\b\u0003;!r!AH\u0014\u000f\u0005}1cB\u0001\u0011&\u001d\t\tC%D\u0001#\u0015\t\u0019\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tYC!A\u0003vi&d7/\u0003\u0002.]\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK*\u00111\u0006B\u0005\u0003aE\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u00055r\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u001bMD\u0017N\u001a;US6,'l\u001c8f!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003uS6,'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aAW8oK&#\u0007\"B\u001f\u0001\t\u0003q\u0014A\u0002\u001fj]&$h\bF\u0002@\u0001\u0006\u0003\"a\u0005\u0001\t\u000b]a\u0004\u0019\u0001\r\t\u000bMb\u0004\u0019\u0001\u001b\t\u000f\r\u0003!\u0019!C\u0005\t\u0006YQ\u000bV\"`5>sUiX%E+\u0005!\u0004B\u0002$\u0001A\u0003%A'\u0001\u0007V)\u000e{&l\u0014(F?&#\u0005\u0005C\u0003I\u0001\u0011\u0005\u0013*\u0001\u0004cK\u001a|'/\u001a\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n!QK\\5uQ\t9\u0015\u000b\u0005\u0002S36\t1K\u0003\u0002U+\u0006\u0019\u0011\r]5\u000b\u0005Y;\u0016a\u00026va&$XM\u001d\u0006\u00031:\tQA[;oSRL!AW*\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003]\u0001\u0011\u0005\u0011*\u0001\u0010uKN$\bK]8dKN\u001c\u0018N\\4US6,G+^7cY\u0016<\u0016N\u001c3po\"\u00121L\u0018\t\u0003%~K!\u0001Y*\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000b\t\u0004A\u0011A%\u0002WQ,7\u000f\u001e)s_\u000e,7o]5oORKW.\u001a+v[\ndWmV5oI><x+\u001b;i\u0007\u0012\u001b5k\\;sG\u0016D#!\u00190\t\u000b\u0015\u0004A\u0011A%\u00027Q,7\u000f\u001e)s_\u000e,7o]5oORKW.\u001a%pa^Kg\u000eZ8xQ\t!g\fC\u0003i\u0001\u0011\u0005\u0011*\u0001\u0015uKN$\bK]8dKN\u001c\u0018N\\4US6,\u0007j\u001c9XS:$wn^,ji\"\u001cEiQ*pkJ\u001cW\r\u000b\u0002h=\")1\u000e\u0001C\u0001\u0013\u0006\u0001C/Z:u!J|7-Z:tS:<G+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8xQ\tQg\fC\u0003o\u0001\u0011\u0005\u0011*A\u0017uKN$\bK]8dKN\u001c\u0018N\\4US6,7)^7vY\u0006$XmV5oI><x+\u001b;i\u0007\u0012\u001b5k\\;sG\u0016D#!\u001c0\t\u000bE\u0004A\u0011A%\u0002)Q,7\u000f^\"m_N,w+\u001b;i_V$x\n]3oQ\t\u0001h\fC\u0003u\u0001\u0011\u0005\u0011*A\u0016uKN$Hk^8QQ\u0006\u001cXmV5oI><\u0018iZ4sK\u001e\fG/Z\"m_N,w+\u001b;i_V$x\n]3oQ\t\u0019h\fC\u0003x\u0001\u0011%\u00010\u0001\u0012de\u0016\fG/\u001a)s_\u000e,7o]5oORKW.Z,j]\u0012|wo\u00149fe\u0006$xN\u001d\u000b\u0006s\u0006-\u0012q\b\t\u0006\u0017jd\u0018QC\u0005\u0003w2\u0013a\u0001V;qY\u0016\u0014\u0004#C?\u0002\u0006\u0005%\u0011\u0011BA\u0005\u001b\u0005q(bA@\u0002\u0002\u0005!Q\u000f^5m\u0015\r\t\u0019AC\u0001\ngR\u0014X-Y7j]\u001eL1!a\u0002\u007f\u0005\u0019ZU-_3e\u001f:,\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peR+7\u000f\u001e%be:,7o\u001d\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0005\u0002\t\u0011\fG/Y\u0005\u0005\u0003'\tiAA\u0004S_^$\u0015\r^1\u0011\u000b-\u000b9\"a\u0007\n\u0007\u0005eAJA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000f1|w-[2bY*\u0019\u0011Q\u0005\u0005\u0002\u000bQL\b/Z:\n\t\u0005%\u0012q\u0004\u0002\f\u0019><\u0017nY1m)f\u0004X\rC\u0004\u0002.Y\u0004\r!a\f\u0002\u0015Q,7\u000f^,j]\u0012|w\u000f\u0005\u0003\u00022\u0005eb\u0002BA\u001a\u0003k\u0001\"!\t'\n\u0007\u0005]B*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\tiD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003oa\u0005bBA!m\u0002\u0007\u00111I\u0001\fSN\u001cEiQ*pkJ\u001cW\rE\u0002L\u0003\u000bJ1!a\u0012M\u0005\u001d\u0011un\u001c7fC:Dq!a\u0013\u0001\t\u0013\ti%\u0001\u0006j]\u001e,7\u000f\u001e#bi\u0006$RASA(\u0003'Bq!!\u0015\u0002J\u0001\u0007A0A\u0006uKN$\b*\u0019:oKN\u001c\b\u0002CA!\u0003\u0013\u0002\r!a\u0011\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005a\u0011N\\:feR\u0014VmY8sIR!\u00111LA5!\u0019\ti&!\u001a\u0002\n5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0007tiJ,\u0017-\u001c:fG>\u0014HMC\u0002\u0006\u0003\u0003IA!a\u001a\u0002`\ta1\u000b\u001e:fC6\u0014VmY8sI\"A\u00111NA+\u0001\u0004\ti'\u0001\u0003be\u001e\u001c\b#B&\u0002p\u0005M\u0014bAA9\u0019\nQAH]3qK\u0006$X\r\u001a \u0011\u0007-\u000b)(C\u0002\u0002x1\u00131!\u00118z\u0011\u001d\tY\b\u0001C\u0005\u0003{\nqb\u00195b]\u001e,Gn\\4SK\u000e|'\u000f\u001a\u000b\u0007\u00037\ny(!$\t\u0011\u0005\u0005\u0015\u0011\u0010a\u0001\u0003\u0007\u000bqA]8x\u0017&tG\r\u0005\u0003\u0002\u0006\u0006%UBAAD\u0015\r\t)CC\u0005\u0005\u0003\u0017\u000b9IA\u0004S_^\\\u0015N\u001c3\t\u0011\u0005-\u0014\u0011\u0010a\u0001\u0003[Bq!!%\u0001\t\u0013\t\u0019*\u0001\u0006m_\u000e\fG.T5mYN$B!!&\u0002\u001cB!\u00111BAL\u0013\u0011\tI*!\u0004\u0003\u001bQKW.Z:uC6\u0004H)\u0019;b\u0011!\ti*a$A\u0002\u0005=\u0012\u0001\u00033bi\u0016$\u0016.\\3)\u000f\u0001\t\t+!,\u00020B!\u00111UAU\u001b\t\t)KC\u0002\u0002(N\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005-\u0016Q\u0015\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAAYG\t\t\u0019\f\u0005\u0003\u00026\u0006\u0015WBAA\\\u0015\u0011\tI,a/\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\ti,a0\u0002\u0015\u0015DH/\u001a8tS>t7OC\u0002Y\u0003\u0003T1!a1\u000b\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0002H\u0006]&A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>twaBAf\u0005!\u0005\u0011QZ\u0001\u001b/&tGm\\<BO\u001e\u0014XmZ1uK\"\u000b'O\\3tgR+7\u000f\u001e\t\u0004'\u0005=gAB\u0001\u0003\u0011\u0003\t\tn\u0005\u0003\u0002P\u0006M\u0007cA&\u0002V&\u0019\u0011q\u001b'\u0003\r\u0005s\u0017PU3g\u0011\u001di\u0014q\u001aC\u0001\u00037$\"!!4\t\u0011\u0005}\u0017q\u001aC\u0001\u0003C\f!\u0002]1sC6,G/\u001a:t)\t\t\u0019\u000f\u0005\u0004\u0002f\u0006%\u0018Q^\u0007\u0003\u0003OT!a \u001d\n\t\u0005-\u0018q\u001d\u0002\u000b\u0007>dG.Z2uS>t\u0007#B&\u0002\u0018\u0005=\b\u0003BAy\u0003ol!!a=\u000b\u0007\u0005U\b(\u0001\u0003mC:<\u0017\u0002BA}\u0003g\u0014aa\u00142kK\u000e$\b\u0006CAo\u0003{\u0014\u0019A!\u0002\u0011\t\u0005U\u0016q`\u0005\u0005\u0005\u0003\t9L\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012!qA\u0001\u001f'R\fG/\u001a\"bG.,g\u000eZ\u001f|aud\u0003\u0005V5nKj{g.Z\u001f|cuD!Ba\u0003\u0002P\n\u0007I\u0011\u0001B\u0007\u0003\u0019!V+\u0014\"M\u000bV\u0011\u0011q\u0006\u0005\n\u0005#\ty\r)A\u0005\u0003_\tq\u0001V+N\u00052+\u0005\u0005\u0003\u0006\u0003\u0016\u0005='\u0019!C\u0001\u0005\u001b\t1\u0001S(Q\u0011%\u0011I\"a4!\u0002\u0013\ty#\u0001\u0003I\u001fB\u0003\u0003B\u0003B\u000f\u0003\u001f\u0014\r\u0011\"\u0001\u0003\u000e\u0005A1)V'V\u0019\u0006#V\tC\u0005\u0003\"\u0005=\u0007\u0015!\u0003\u00020\u0005I1)V'V\u0019\u0006#V\t\t")
public class WindowAggregateHarnessTest
extends HarnessTestBase {
    private final ZoneId shiftTimeZone;
    private final ZoneId UTC_ZONE_ID;

    public static String CUMULATE() {
        return WindowAggregateHarnessTest$.MODULE$.CUMULATE();
    }

    public static String HOP() {
        return WindowAggregateHarnessTest$.MODULE$.HOP();
    }

    public static String TUMBLE() {
        return WindowAggregateHarnessTest$.MODULE$.TUMBLE();
    }

    @Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateHarnessTest$.MODULE$.parameters();
    }

    private ZoneId UTC_ZONE_ID() {
        return this.UTC_ZONE_ID;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.tEnv().getConfig().setLocalTimeZone(this.shiftTimeZone);
        String insertOnlyDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(551).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(insertOnlyDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String changelogDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowChangelogDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(612).append("\n                       |CREATE TABLE T1_CDC (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(changelogDataId).append("',\n                       | 'changelog-mode' = 'I,UA,UB,D'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testProcessingTimeTumbleWindow() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.TUMBLE(), false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        this.ingestData((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2, false);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness2.getOutput());
        testHarness2.close();
    }

    @TestTemplate
    public void testProcessingTimeTumbleWindowWithCDCSource() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.TUMBLE(), true);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        this.ingestData((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2, true);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness2.getOutput());
        testHarness2.close();
    }

    @TestTemplate
    public void testProcessingTimeHopWindow() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.HOP(), false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        this.ingestData((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2, false);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:10"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness2.getOutput());
        testHarness2.close();
    }

    @TestTemplate
    public void testProcessingTimeHopWindowWithCDCSource() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.HOP(), true);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        this.ingestData((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2, true);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:10"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness2.getOutput());
        testHarness2.close();
    }

    @TestTemplate
    public void testProcessingTimeCumulateWindow() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.CUMULATE(), false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        this.ingestData((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2, false);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:30")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness2.getOutput());
        testHarness2.close();
    }

    @TestTemplate
    public void testProcessingTimeCumulateWindowWithCDCSource() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.CUMULATE(), true);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        this.ingestData((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2, true);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25")})));
        expected.add(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:30")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness2.getOutput());
        testHarness2.close();
    }

    @TestTemplate
    public void testCloseWithoutOpen() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcessingTimeWindowOperator(WindowAggregateHarnessTest$.MODULE$.TUMBLE(), false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple23._2();
        testHarness2.setup((TypeSerializer)new RowDataSerializer(outputTypes2));
        testHarness2.close();
    }

    @TestTemplate
    public void testTwoPhaseWindowAggregateCloseWithoutOpen() {
        String timestampDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(723).append("\n                       |CREATE TABLE T2 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | `rowtime` AS\n                       | TO_TIMESTAMP(`ts`),\n                       | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(timestampDataId).append("',\n                       | 'failing-source' = 'false'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T2, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        DataStream stream = package$.MODULE$.tableConversions(t1).toDataStream();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(stream, "LocalWindowAggregate");
        LogicalType[] outputTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()});
        testHarness.setup((TypeSerializer)new RowDataSerializer(outputTypes));
        testHarness.close();
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness1 = this.createHarnessTester(stream, "GlobalWindowAggregate");
        testHarness1.setup((TypeSerializer)new RowDataSerializer(outputTypes));
        testHarness1.close();
    }

    private Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createProcessingTimeWindowOperator(String testWindow, boolean isCDCSource) {
        String string;
        String string2 = testWindow;
        String string3 = WindowAggregateHarnessTest$.MODULE$.TUMBLE();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n           |TUMBLE(\n           |      TABLE ").append((Object)(isCDCSource ? "T1_CDC" : "T1")).append(",\n           |      DESCRIPTOR(proctime),\n           |      INTERVAL '5' SECOND)\n           |").toString())).stripMargin();
        } else {
            String string5 = WindowAggregateHarnessTest$.MODULE$.HOP();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(175).append("\n           |HOP(\n           |      TABLE ").append((Object)(isCDCSource ? "T1_CDC" : "T1")).append(",\n           |      DESCRIPTOR(proctime),\n           |      INTERVAL '5' SECOND,\n           |      INTERVAL '10' SECOND)\n           |").toString())).stripMargin();
            } else {
                String string7 = WindowAggregateHarnessTest$.MODULE$.CUMULATE();
                String string8 = string2;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("\n           |CUMULATE(\n           |      TABLE ").append((Object)(isCDCSource ? "T1_CDC" : "T1")).append(",\n           |      DESCRIPTOR(proctime),\n           |      INTERVAL '5' SECOND,\n           |      INTERVAL '15' SECOND)\n           |").toString())).stripMargin();
                } else {
                    throw new MatchError((Object)string2);
                }
            }
        }
        String windowDDL = string;
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(255).append("\n         |SELECT\n         |  `name`,\n         |  window_start,\n         |  window_end,\n         |  COUNT(*),\n         |  MAX(`double`),\n         |  COUNT(DISTINCT `string`)\n         |FROM TABLE(").append(windowDDL).append(")\n         |GROUP BY `name`, window_start, window_end\n      ").toString())).stripMargin();
        Table table = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(table).toDataStream(), "WindowAggregate");
        LogicalType[] outputTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()});
        return new Tuple2(testHarness, (Object)outputTypes);
    }

    private void ingestData(KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness, boolean isCDCSource) {
        if (isCDCSource) {
            testHarness.setProcessingTime(1000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
            testHarness.setProcessingTime(2000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
            testHarness.setProcessingTime(3000L);
            testHarness.processElement(this.changelogRecord(RowKind.DELETE, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
            testHarness.setProcessingTime(4000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
            testHarness.processElement(this.changelogRecord(RowKind.UPDATE_BEFORE, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
            testHarness.processElement(this.changelogRecord(RowKind.UPDATE_AFTER, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)22.0), "Comment#22", null})));
            testHarness.setProcessingTime(6000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null})));
            testHarness.setProcessingTime(7000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null})));
            testHarness.setProcessingTime(8000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null})));
            testHarness.setProcessingTime(16000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null})));
            testHarness.setProcessingTime(38000L);
            testHarness.processElement(this.changelogRecord(RowKind.INSERT, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)8.0), "Comment#4", null})));
            testHarness.setProcessingTime(39000L);
            testHarness.processElement(this.changelogRecord(RowKind.DELETE, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)8.0), "Comment#4", null})));
        } else {
            testHarness.setProcessingTime(1000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
            testHarness.setProcessingTime(2000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
            testHarness.setProcessingTime(3000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
            testHarness.setProcessingTime(4000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
            testHarness.setProcessingTime(6000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null})));
            testHarness.setProcessingTime(7000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null})));
            testHarness.setProcessingTime(8000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null})));
            testHarness.setProcessingTime(16000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null})));
            testHarness.setProcessingTime(32000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null})));
            testHarness.setProcessingTime(34000L);
            testHarness.processElement(this.insertRecord((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
            testHarness.setProcessingTime(50000L);
        }
    }

    private StreamRecord<RowData> insertRecord(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object2;
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    private StreamRecord<RowData> changelogRecord(RowKind rowKind, Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object object;
            Object object2 = x0$2;
            if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object2;
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)rowKind, (Object[])objs);
    }

    private TimestampData localMills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)TimeWindowUtil.toUtcTimestampMills((long)windowDateTime.toInstant().toEpochMilli(), (ZoneId)this.shiftTimeZone));
    }

    public WindowAggregateHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        super(backend);
        this.UTC_ZONE_ID = ZoneId.of("UTC");
    }
}

