/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowAggregateUseDaylightTimeHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001E\u0011\u0011fV5oI><\u0018iZ4sK\u001e\fG/Z+tK\u0012\u000b\u0017\u0010\\5hQR$\u0016.\\3ICJtWm]:UKN$(BA\u0002\u0005\u0003\u001dA\u0017M\u001d8fgNT!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!a\u0004%be:,7o\u001d+fgR\u0014\u0015m]3\t\u0011]\u0001!\u0011!Q\u0001\na\tqAY1dW\u0016tG\r\u0005\u0002\u001a_9\u0011!\u0004\f\b\u00037)r!\u0001H\u0015\u000f\u0005uAcB\u0001\u0010(\u001d\tybE\u0004\u0002!K9\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005E\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0006B\u0001\u0006kRLGn]\u0005\u0003[9\n!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016T!a\u000b\u0003\n\u0005A\n$\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\tic\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003!!\u0018.\\3[_:,\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0011)H/\u001b7\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\t)&lWMW8oK\")Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"2a\u0010!B!\t\u0019\u0002\u0001C\u0003\u0018y\u0001\u0007\u0001\u0004C\u00034y\u0001\u0007A\u0007C\u0003D\u0001\u0011\u0005C)\u0001\u0004cK\u001a|'/\u001a\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n!QK\\5uQ\t\u0011E\n\u0005\u0002N)6\taJ\u0003\u0002P!\u0006\u0019\u0011\r]5\u000b\u0005E\u0013\u0016a\u00026va&$XM\u001d\u0006\u0003':\tQA[;oSRL!!\u0016(\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003X\u0001\u0011\u0005A)\u0001\ruKN$\bK]8dKN\u001c\u0018N\\4US6,w+\u001b8e_^D#AV-\u0011\u00055S\u0016BA.O\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u0015i\u0006\u0001\"\u0003_\u0003)IgnZ3ti\u0012\u000bG/\u0019\u000b\u0003\u000b~CQ\u0001\u0019/A\u0002\u0005\f1\u0002^3ti\"\u000b'O\\3tgB)!M\u001a5iQ6\t1M\u0003\u00028I*\u0011QMC\u0001\ngR\u0014X-Y7j]\u001eL!aZ2\u0003M-+\u00170\u001a3P]\u0016Le\u000e];u'R\u0014X-Y7Pa\u0016\u0014\u0018\r^8s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002jY6\t!N\u0003\u0002l\u0011\u0005!A-\u0019;b\u0013\ti'NA\u0004S_^$\u0015\r^1\t\u000b=\u0004A\u0011\u00029\u0002\u0005Q\u001cHCA9u!\tI'/\u0003\u0002tU\niA+[7fgR\fW\u000e\u001d#bi\u0006DQ!\u001e8A\u0002Y\f!\u0001\u001a;\u0011\u0005]\\hB\u0001=z!\t\ts)\u0003\u0002{\u000f\u00061\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQx\t\u0003\u0004\u0000\u0001\u0011%\u0011\u0011A\u0001\u0007e\u0016\u001cwN\u001d3\u0015\t\u0005\r\u0011\u0011\u0003\t\u0006\u0003\u000b\ti\u0001[\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005a1\u000f\u001e:fC6\u0014XmY8sI*\u0011Q\u0001Z\u0005\u0005\u0003\u001f\t9A\u0001\u0007TiJ,\u0017-\u001c*fG>\u0014H\rC\u0004\u0002\u0014y\u0004\r!!\u0006\u0002\t\u0005\u0014xm\u001d\t\u0006\r\u0006]\u00111D\u0005\u0004\u000339%A\u0003\u001fsKB,\u0017\r^3e}A\u0019a)!\b\n\u0007\u0005}qIA\u0002B]fDs\u0001AA\u0012\u0003_\t\t\u0004\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICT\u0001\nKb$XM\\:j_:LA!!\f\u0002(\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005M2EAA\u001b!\u0011\t9$a\u0012\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA \u0003\u0003\n!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r\u0019\u00161\t\u0006\u0004\u0003\u000bR\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\tI%!\u000f\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u00055#\u0001#\u0001\u0002P\u0005Is+\u001b8e_^\fum\u001a:fO\u0006$X-V:f\t\u0006LH.[4iiRKW.\u001a%be:,7o\u001d+fgR\u00042aEA)\r\u0019\t!\u0001#\u0001\u0002TM!\u0011\u0011KA+!\r1\u0015qK\u0005\u0004\u00033:%AB!osJ+g\rC\u0004>\u0003#\"\t!!\u0018\u0015\u0005\u0005=\u0003\u0002CA1\u0003#\"\t!a\u0019\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002fA)Q'a\u001a\u0002l%\u0019\u0011\u0011\u000e\u001c\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003G\u0003[\n\t(C\u0002\u0002p\u001d\u0013Q!\u0011:sCf\u0004B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003oB\u0014\u0001\u00027b]\u001eLA!a\u001f\u0002v\t1qJ\u00196fGRD\u0003\"a\u0018\u0002\u0000\u0005\u0015\u0015q\u0011\t\u0005\u0003o\t\t)\u0003\u0003\u0002\u0004\u0006e\"A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\tI)\u0001\u0010Ti\u0006$XMQ1dW\u0016tG-P>1{2\u0002C+[7f5>tW-P>2{\u0002")
public class WindowAggregateUseDaylightTimeHarnessTest
extends HarnessTestBase {
    private final TimeZone timeZone;

    @Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateUseDaylightTimeHarnessTest$.MODULE$.parameters();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.timeZone.toZoneId());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(551).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testProcessingTimeWindow() {
        boolean bl;
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(proctime),\n        |     INTERVAL '1' HOUR,\n        |     INTERVAL '3' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        if (this.timeZone.useDaylightTime()) {
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T01:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T02:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T03:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T04:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T05:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T06:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T01:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T02:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T03:00:00")})));
            bl = expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T03:00:00"), this.ts("2021-11-07T04:00:00")})));
        } else {
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T06:00:00"), this.ts("2021-03-14T09:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T10:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T11:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T12:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T13:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T14:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T15:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T06:00:00"), this.ts("2021-11-07T08:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T06:00:00"), this.ts("2021-11-07T09:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T10:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T11:00:00")})));
            bl = expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T12:00:00")})));
        }
        assertor.assertOutputEquals("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1615708800000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(1615712400000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(1615716000000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(1615719600000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(1615723200000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(1636268400000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Hi", null})));
        testHarness.setProcessingTime(1636272000000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), null, null})));
        testHarness.setProcessingTime(1636275600000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636279200000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636282800000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636286400000L);
    }

    private TimestampData ts(String dt) {
        return TimestampData.fromEpochMillis((long)LocalDateTime.parse(dt).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli());
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object2;
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    public WindowAggregateUseDaylightTimeHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, TimeZone timeZone) {
        this.timeZone = timeZone;
        super(backend);
    }
}

